BEGIN
  DBMS_XMLSCHEMA.registerSchema(
    SCHEMAURL => 'http://xmlns.oracle.com/xml/invoice/partytype.xsd',
    SCHEMADOC => '<?xml version="1.0" encoding="UTF-8"?>
<!-- 

  Schma pro fakturu ISDOC
  Schema for ISDOC invoice
  
  (c) 2010 ICT UNIE o.s., http://www.ictu.cz/
  (c) 2010 ICT UNIE o.s. (Association for Information Technologies and Telecommunications), http://www.ictu.cz/ 
  
  (c) 2009 Sdruen pro informan spolenost, http://www.spis.cz/
  (c) 2009 Association for Information Society, http://www.spis.cz/

  $Id: isdoc-invoice-5.2.1.xsd,v 1.2 2010/03/17 17:30:11 jkj Exp $

-->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified" version="5.2.1" xml:lang="cs">

<xs:element name="Party" type="PartyType" >
      <xs:annotation>
          <xs:documentation xml:lang="cs">Identifikace subjektu</xs:documentation>
          <xs:documentation xml:lang="en">Information about an organization, sub-organization, or individual fulfilling a role in a business process.</xs:documentation>
      </xs:annotation>
</xs:element>


<xs:complexType name="PartyType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Identifikace subjektu</xs:documentation>
      <xs:documentation xml:lang="en">Information about an organization, sub-organization, or individual fulfilling a role in a business process.</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="PartyIdentification" type="PartyIdentificationType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Element identifikanch poloek subjektu (firmy)</xs:documentation>
          <xs:documentation xml:lang="en">Information about a party|s identification.</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="PartyName" type="PartyNameType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Nzev subjektu</xs:documentation>
          <xs:documentation xml:lang="en">Information about a party|s name.</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="PostalAddress" type="PostalAddressType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Potovn adresa</xs:documentation>
          <xs:documentation xml:lang="en">Postal address</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="PartyTaxScheme" type="PartyTaxSchemeType" minOccurs="0">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Daov daje</xs:documentation>
          <xs:documentation xml:lang="en">Information about a party|s tax scheme</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element minOccurs="0" name="RegisterIdentification" type="RegisterIdentificationType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Identifikace zpisu v rejstku</xs:documentation>
          <xs:documentation xml:lang="en">Commercial Register record identification (in the Czech Republic)</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="Contact" type="ContactType" minOccurs="0">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Kontaktn osoba</xs:documentation>
          <xs:documentation xml:lang="en">Information about a contactable person or organization department</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>
  
  <xs:simpleType name="IDType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Uniktn identifiktor</xs:documentation>
      <xs:documentation xml:lang="en">Unique identifier</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>
  
   <xs:complexType name="PartyIdentificationType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Element identifikanch poloek subjektu (firmy)</xs:documentation>
      <xs:documentation xml:lang="en">Information about a party|s identification.</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="UserID" type="UserIDType" minOccurs="0">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Uivatelsk slo firmy/provozovny</xs:documentation>
          <xs:documentation xml:lang="en">User defined company/workplace number</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="CatalogFirmIdentification" type="CatalogFirmIdentificationType" minOccurs="0">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Mezinrodn slo firmy/provozovny, nap. EAN</xs:documentation>
          <xs:documentation xml:lang="en">International company/workplace number, e.g. EAN</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="ID" type="IDType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">I</xs:documentation>
          <xs:documentation xml:lang="en">Company identification number</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>

   <xs:simpleType name="UserIDType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Uivatelsk slo firmy/provozovny</xs:documentation>
      <xs:documentation xml:lang="en">User defined company/workplace number</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="CatalogFirmIdentificationType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Mezinrodn slo firmy/provozovny, nap. EAN</xs:documentation>
      <xs:documentation xml:lang="en">International company/workplace number, e.g. EAN</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:complexType name="PartyNameType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Nzev subjektu</xs:documentation>
      <xs:documentation xml:lang="en">Information about a party|s name.</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="Name" type="NameType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Nzev</xs:documentation>
          <xs:documentation xml:lang="en">A character string that constitutes the distinctive designation of a person, place, thing or concept</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>

  <xs:simpleType name="NameType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Nzev</xs:documentation>
      <xs:documentation xml:lang="en">A character string that constitutes the distinctive designation of a person, place, thing or concept</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:complexType name="PostalAddressType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Potovn adresa</xs:documentation>
      <xs:documentation xml:lang="en">Postal address</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="StreetName" type="StreetNameType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Ulice</xs:documentation>
          <xs:documentation xml:lang="en">Street</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="BuildingNumber" type="BuildingNumberType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">slo popisn/orientan</xs:documentation>
          <xs:documentation xml:lang="en">Building number</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="CityName" type="CityNameType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Msto</xs:documentation>
          <xs:documentation xml:lang="en">City</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="PostalZone" type="PostalZoneType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">PS</xs:documentation>
          <xs:documentation xml:lang="en">ZIP/postal zone</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="Country" type="CountryType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Zem</xs:documentation>
          <xs:documentation xml:lang="en">Country</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>

  <xs:simpleType name="StreetNameType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Ulice</xs:documentation>
      <xs:documentation xml:lang="en">Street</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="BuildingNumberType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">slo popisn/orientan</xs:documentation>
      <xs:documentation xml:lang="en">Building number</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="CityNameType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Msto</xs:documentation>
      <xs:documentation xml:lang="en">City</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="PostalZoneType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">PS</xs:documentation>
      <xs:documentation xml:lang="en">ZIP/postal zone</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:complexType name="CountryType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Zem</xs:documentation>
      <xs:documentation xml:lang="en">Country</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificationCode" type="IdentificationCodeType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Kd zem podle ISO 3166</xs:documentation>
          <xs:documentation xml:lang="en">ISO 3166 country code</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="Name" type="NameType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Nzev zem</xs:documentation>
          <xs:documentation xml:lang="en">Country name</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>

  <xs:simpleType name="IdentificationCodeType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Kd zem podle ISO 3166</xs:documentation>
      <xs:documentation xml:lang="en">ISO 3166 country code</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>
  
   <xs:complexType name="PartyTaxSchemeType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Daov daje</xs:documentation>
      <xs:documentation xml:lang="en">Information about a party|s tax scheme</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="CompanyID" type="CompanyIDType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">DI</xs:documentation>
          <xs:documentation xml:lang="en">VAT number</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="TaxScheme" type="TaxSchemeType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Daov schma</xs:documentation>
          <xs:documentation xml:lang="en">Information about a tax scheme</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>

  <xs:simpleType name="CompanyIDType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">DI</xs:documentation>
      <xs:documentation xml:lang="en">VAT number</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="TaxSchemeType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Daov schma</xs:documentation>
      <xs:documentation xml:lang="en">Information about a tax scheme</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:complexType name="RegisterIdentificationType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Identifikace zpisu v rejstku</xs:documentation>
      <xs:documentation xml:lang="en">Commercial Register record identification (in the Czech Republic)</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="RegisterKeptAt" type="RegisterKeptAtType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Sprvce rejstku</xs:documentation>
          <xs:documentation xml:lang="en">Commercial Register administrator</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="RegisterFileRef" type="RegisterFileRefType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">slo registrace</xs:documentation>
          <xs:documentation xml:lang="en">Commercial Register number</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="RegisterDate" type="RegisterDateType">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Datum registrace</xs:documentation>
          <xs:documentation xml:lang="en">Registration date</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>

  <xs:simpleType name="RegisterKeptAtType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Sprvce rejstku</xs:documentation>
      <xs:documentation xml:lang="en">Commercial Register administrator</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="RegisterFileRefType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">slo registrace</xs:documentation>
      <xs:documentation xml:lang="en">Commercial Register number</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="RegisterDateType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Datum registrace</xs:documentation>
      <xs:documentation xml:lang="en">Registration date</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:date"/>
  </xs:simpleType>
  
  <xs:complexType name="ContactType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Kontaktn osoba</xs:documentation>
      <xs:documentation xml:lang="en">Information about a contactable person or organization department</xs:documentation>
    </xs:annotation>
    <xs:sequence>
      <xs:element name="Name" type="NameType" minOccurs="0">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Jmno kontaktu</xs:documentation>
          <xs:documentation xml:lang="en">Contact name</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="Telephone" type="TelephoneType" minOccurs="0">
        <xs:annotation>
          <xs:documentation xml:lang="cs">Telefonn slo</xs:documentation>
          <xs:documentation xml:lang="en">Phone number</xs:documentation>
        </xs:annotation>
      </xs:element>
      <xs:element name="ElectronicMail" type="ElectronicMailType" minOccurs="0">
        <xs:annotation>
          <xs:documentation xml:lang="cs">E-mailov adresa</xs:documentation>
          <xs:documentation xml:lang="en">E-mail address</xs:documentation>
        </xs:annotation>
      </xs:element>
    </xs:sequence>
  </xs:complexType>

  <xs:simpleType name="TelephoneType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">Telefonn slo</xs:documentation>
      <xs:documentation xml:lang="en">Phone number</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>

  <xs:simpleType name="ElectronicMailType">
    <xs:annotation>
      <xs:documentation xml:lang="cs">E-mailov adresa</xs:documentation>
      <xs:documentation xml:lang="en">E-mail address</xs:documentation>
    </xs:annotation>
    <xs:restriction base="xs:string"/>
  </xs:simpleType>


</xs:schema>',
    LOCAL => TRUE,
    GENTYPES => TRUE, 
    GENTABLES => FALSE);
END;
