BEGIN
  DBMS_XMLSCHEMA.registerSchema(
    SCHEMAURL => 'http://xmlns.oracle.com/xml/invoice/invoiceline.xsd',
    SCHEMADOC => '<?xml version="1.0" encoding="UTF-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xdb="http://xmlns.oracle.com/xdb" elementFormDefault="qualified" version="5.2.1" xml:lang="cs">
	<xs:element name="InvoiceLines" type="InvoiceLinesType" xdb:defaultTable="INVOICEBODY">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Kolekce jednotlivch dk faktury</xs:documentation>
			<xs:documentation xml:lang="en">Invoice lines collection</xs:documentation>
		</xs:annotation>
	</xs:element>
	<xs:simpleType name="IDType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Uniktn identifiktor</xs:documentation>
			<xs:documentation xml:lang="en">Unique identifier</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string"/>
	</xs:simpleType>
	<xs:simpleType name="ID36Type">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Uniktn identifiktor s maximln dlkou 36 znak</xs:documentation>
			<xs:documentation xml:lang="en">Unique identifier limited to 36 characters</xs:documentation>
		</xs:annotation>
		<xs:restriction base="IDType">
			<xs:maxLength value="36"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="UUIDType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Uniktn identifiktor GUID</xs:documentation>
			<xs:documentation xml:lang="en">Unique GUID identifier</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:pattern value="[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="IssueDateType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Datum vystaven</xs:documentation>
			<xs:documentation xml:lang="en">Issue date</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:date"/>
	</xs:simpleType>
	<xs:complexType name="NoteType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Poznmka</xs:documentation>
			<xs:documentation xml:lang="en">Note</xs:documentation>
		</xs:annotation>
		<xs:simpleContent>
			<xs:extension base="xs:string">
				<xs:attribute name="languageID" type="xs:language" use="optional">
					<xs:annotation>
						<xs:documentation xml:lang="cs">Identifiktor pouitho jazyka (nap. "cs" pro etinu)</xs:documentation>
						<xs:documentation xml:lang="en">Language identifier (e.g. "en" for English)</xs:documentation>
					</xs:annotation>
				</xs:attribute>
			</xs:extension>
		</xs:simpleContent>
	</xs:complexType>
	<xs:complexType name="OrderLineReferenceType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Odkaz na dku souvisejc objednvky</xs:documentation>
			<xs:documentation xml:lang="en">Reference to line on a related purchase order</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="SalesOrderID" type="SalesOrderIDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Vlastn identifiktor objednvky pijat u dodavatele</xs:documentation>
					<xs:documentation xml:lang="en">Private identifier of purchase order received at supplier</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="ExternalOrderID" type="IDType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Extern slo objednvky pijat, typicky objednvka vydan u odbratele</xs:documentation>
					<xs:documentation xml:lang="en">External number of accepted purchase order, usually purchase order issued at purchaser</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="IssueDate" type="IssueDateType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Datum vystaven objednvky pijat u dodavatele</xs:documentation>
					<xs:documentation xml:lang="en">Issue date of purchase order received at supplier</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineID" type="LineIDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">slo dky na dokladu</xs:documentation>
					<xs:documentation xml:lang="en">Line number</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:simpleType name="SalesOrderIDType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Vlastn identifiktor objednvky pijat u dodavatele</xs:documentation>
			<xs:documentation xml:lang="en">Private identifier of purchase order received at supplier</xs:documentation>
		</xs:annotation>
		<xs:restriction base="IDType"/>
	</xs:simpleType>
	<xs:simpleType name="LineIDType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">slo dky na dokladu</xs:documentation>
			<xs:documentation xml:lang="en">Line number</xs:documentation>
		</xs:annotation>
		<xs:restriction base="IDType"/>
	</xs:simpleType>
	<xs:complexType name="DeliveryNoteLineReferenceType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Odkaz na souvisejc dodac list</xs:documentation>
			<xs:documentation xml:lang="en">Information about referenced line on delivery note</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="IDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Vlastn identifiktor dodacho listu u dodavatele</xs:documentation>
					<xs:documentation xml:lang="en">Private identifier of delivery note at supplier</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="IssueDate" type="IssueDateType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Datum vystaven</xs:documentation>
					<xs:documentation xml:lang="en">Issue date</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineID" type="LineIDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">slo dky na dokladu</xs:documentation>
					<xs:documentation xml:lang="en">Line number</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="OriginalDocumentLineReferenceType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Odkaz na pvodn doklad, kter tento aktuln doklad opravuje (jen pro typy dokument 2, 3 a 6)</xs:documentation>
			<xs:documentation xml:lang="en">Line reference to an original document which is being corrected by this document (only for document types 2, 3 and 6)</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="IDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Lidsky iteln slo pvodnho dokladu</xs:documentation>
					<xs:documentation xml:lang="en">Human readable number of original document</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="IssueDate" type="IssueDateType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Datum vystaven pvodnho dokladu</xs:documentation>
					<xs:documentation xml:lang="en">Issue date of original document</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="UUID" type="UUIDType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Uniktn identifiktor GUID</xs:documentation>
					<xs:documentation xml:lang="en">Unique GUID identifier</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineID" type="LineIDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">slo dky na dokladu</xs:documentation>
					<xs:documentation xml:lang="en">Line number</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="ExtensionsType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Jakkoliv struktura uivatelskch element. Elementy mus pouvat vlastn jmenn prostor.</xs:documentation>
			<xs:documentation xml:lang="en">Arbitrary fragment of user-defined elements. Elements must use their own namespace.</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:any namespace="##other" processContents="lax" maxOccurs="unbounded"/>
		</xs:sequence>
	</xs:complexType>
	<xs:simpleType name="NameType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Nzev</xs:documentation>
			<xs:documentation xml:lang="en">A character string that constitutes the distinctive designation of a person, place, thing or concept</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string"/>
	</xs:simpleType>
	<xs:complexType name="InvoiceLinesType" xdb:SQLType="INVOICELINES_TYPE" xdb:maintainDOM="false">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Kolekce jednotlivch dk faktury</xs:documentation>
			<xs:documentation xml:lang="en">Invoice lines collection</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="InvoiceLine" type="InvoiceLineType" maxOccurs="unbounded" xdb:SQLName="INVOICELINE" xdb:SQLInline="false" xdb:defaultTable="INVOICELINE">
				<xs:annotation>
					<xs:documentation xml:lang="cs">dek faktury</xs:documentation>
					<xs:documentation xml:lang="en">Information about an invoice line</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="InvoiceLineType" xdb:SQLType="INVOICELINE_TYPE">
		<xs:annotation>
			<xs:documentation xml:lang="cs">dek faktury</xs:documentation>
			<xs:documentation xml:lang="en">Information about an invoice line</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="ID36Type" xdb:SQLName="ID_LINE" xdb:SQLType="VARCHAR2">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Uniktn alfanumerick identifiktor dku dokladu</xs:documentation>
					<xs:documentation xml:lang="en">Unique alphanumeric line identifier</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="OrderReference" type="OrderLineReferenceType" minOccurs="0" xdb:SQLName="ORDERLINEREF_TYPE">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Odkaz na dku souvisejc objednvky</xs:documentation>
					<xs:documentation xml:lang="en">Reference to line on a related purchase order</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="DeliveryNoteReference" type="DeliveryNoteLineReferenceType" minOccurs="0" xdb:SQLName="DELIVERYNOTELINEREF_TYPE">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Odkaz na souvisejc dodac list</xs:documentation>
					<xs:documentation xml:lang="en">Information about referenced line on delivery note</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="OriginalDocumentReference" type="OriginalDocumentLineReferenceType" minOccurs="0" xdb:SQLName="ORIGDOCLINEREF_TYPE">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Odkaz na pvodn doklad, kter tento aktuln doklad opravuje (jen pro typy dokument 2, 3 a 6)</xs:documentation>
					<xs:documentation xml:lang="en">Line reference to an original document which is being corrected by this document (only for document types 2, 3 and 6)</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="InvoicedQuantity" type="QuantityType" minOccurs="0" xdb:SQLName="QUANTITY">
				<xs:annotation>
					<xs:documentation xml:lang="cs">tovan mnostv</xs:documentation>
					<xs:documentation xml:lang="en">Invoiced quantity</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineExtensionAmountCurr" type="AmountType" minOccurs="0" xdb:SQLName="PRICE_WITHOUT_VAT_FG" xdb:SQLType="DECIMAL">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Celkov cena bez dan na dku v ciz mn</xs:documentation>
					<xs:documentation xml:lang="en">Total line amount without tax in a foreign currency</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineExtensionAmount" type="AmountType" xdb:SQLName="PRICE_WITHOUT_VAT" xdb:SQLType="DECIMAL">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Celkov cena bez dan na dku v tuzemsk mn</xs:documentation>
					<xs:documentation xml:lang="en">Total line amount without tax in a local currency</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineExtensionAmountTaxInclusiveCurr" type="AmountType" minOccurs="0" xdb:SQLName="PRICE_WITH_VAT_FG" xdb:SQLType="DECIMAL">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Celkov cena vetn dan na dku v ciz mn</xs:documentation>
					<xs:documentation xml:lang="en">Total line amount including tax in a foreign currency</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineExtensionAmountTaxInclusive" type="AmountType" xdb:SQLName="PRICE_WITH_VAT" xdb:SQLType="DECIMAL">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Celkov cena vetn dan na dku v tuzemsk mn</xs:documentation>
					<xs:documentation xml:lang="en">Total line amount including tax in a local currency</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="LineExtensionTaxAmount" type="AmountType" xdb:SQLName="VAT" xdb:SQLType="DECIMAL">
				<xs:annotation>
					<xs:documentation xml:lang="cs">stka dan na dku v tuzemsk mn</xs:documentation>
					<xs:documentation xml:lang="en">Line tax amount in a local currency</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="UnitPrice" type="AmountType" xdb:SQLName="UNIT_PRICE_WITHOUT_VAT" xdb:SQLType="DECIMAL">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Jednotkov cena bez dan na dku v tuzemsk mn</xs:documentation>
					<xs:documentation xml:lang="en">Unit price without tax in a local currency</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="UnitPriceTaxInclusive" type="AmountType" xdb:SQLName="UNIT_PRICE_WITH_VAT" xdb:SQLType="DECIMAL">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Jednotkov cena s dan na dku v tuzemsk mn</xs:documentation>
					<xs:documentation xml:lang="en">Unit price including tax in a local currency</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="ClassifiedTaxCategory" type="ClassifiedTaxCategoryType" xdb:SQLName="VAT_TAX">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Daov sazba</xs:documentation>
					<xs:documentation xml:lang="en">Tax rate</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="Note" type="NoteType" minOccurs="0" xdb:SQLName="NOTE">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Poznmka</xs:documentation>
					<xs:documentation xml:lang="en">Note</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="Item" type="ItemType" xdb:SQLName="ITEM">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Informace o poloce faktury</xs:documentation>
					<xs:documentation xml:lang="en">Information directly relating to an item</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="Extensions" type="ExtensionsType" minOccurs="0" xdb:SQLName="EXTENSION">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Jakkoliv struktura uivatelskch element. Elementy mus pouvat vlastn jmenn prostor.</xs:documentation>
					<xs:documentation xml:lang="en">Arbitrary fragment of user-defined elements. Elements must use their own namespace.</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="QuantityType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Mnostv</xs:documentation>
			<xs:documentation xml:lang="en">Amount</xs:documentation>
		</xs:annotation>
		<xs:simpleContent>
			<xs:extension base="xs:decimal">
				<xs:attribute name="unitCode" type="xs:string" use="optional" xdb:SQLName="QUANTITY_UNIT">
					<xs:annotation>
						<xs:documentation xml:lang="cs">Jednotka</xs:documentation>
						<xs:documentation xml:lang="en">Unit</xs:documentation>
					</xs:annotation>
				</xs:attribute>
			</xs:extension>
		</xs:simpleContent>
	</xs:complexType>
	<xs:simpleType name="AmountType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">stka</xs:documentation>
			<xs:documentation xml:lang="en">Amount</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:decimal"/>
	</xs:simpleType>
	<xs:complexType name="ClassifiedTaxCategoryType" xdb:SQLType="VATTAX_TYPE">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Daov sazba</xs:documentation>
			<xs:documentation xml:lang="en">Tax rate</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="Percent" type="PercentType" xdb:SQLName="PERCENT">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Procentn sazba DPH</xs:documentation>
					<xs:documentation xml:lang="en">Percentage VAT rate</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="VATCalculationMethod" type="VATCalculationMethodType" xdb:SQLName="METHOD">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Zpsob vpotu DPH</xs:documentation>
					<xs:documentation xml:lang="en">VAT calculation method (there are two types in the Czech Republic)</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:simpleType name="PercentType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Procenta</xs:documentation>
			<xs:documentation xml:lang="en">Percentage</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:decimal"/>
	</xs:simpleType>
	<xs:simpleType name="VATCalculationMethodType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Zpsob vpotu DPH</xs:documentation>
			<xs:documentation xml:lang="en">VAT calculation method (there are two types in the Czech Republic)</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:integer">
			<xs:enumeration value="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Zdola</xs:documentation>
					<xs:documentation xml:lang="en">From the bottom</xs:documentation>
				</xs:annotation>
			</xs:enumeration>
			<xs:enumeration value="1">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Shora</xs:documentation>
					<xs:documentation xml:lang="en">From the top</xs:documentation>
				</xs:annotation>
			</xs:enumeration>
		</xs:restriction>
	</xs:simpleType>
	<xs:complexType name="ItemType" xdb:SQLType="ITEM_TYPE">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Informace o poloce faktury</xs:documentation>
			<xs:documentation xml:lang="en">Information directly relating to an item</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="Description" type="DescriptionType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Popis poloky</xs:documentation>
					<xs:documentation xml:lang="en">Item description</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="CatalogueItemIdentification" type="CatalogueItemIdentificationType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Kd EAN</xs:documentation>
					<xs:documentation xml:lang="en">EAN code</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="SellersItemIdentification" type="SellersItemIdentificationType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Identifikace zbo dle prodejce</xs:documentation>
					<xs:documentation xml:lang="en">Sellers item identification</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="SecondarySellersItemIdentification" type="SecondarySellersItemIdentificationType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Sekundrn identifikace zbo dle prodejce</xs:documentation>
					<xs:documentation xml:lang="en">Secondary sellers item identification</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="TertiarySellersItemIdentification" type="TertiarySellersItemIdentificationType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Terciln identifikace zbo dle prodejce</xs:documentation>
					<xs:documentation xml:lang="en">Tertiary sellers item identification</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="BuyersItemIdentification" type="BuyersItemIdentificationType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Identifikace zbo dle kupujcho</xs:documentation>
					<xs:documentation xml:lang="en">Buyers item identification</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="StoreBatches" type="StoreBatchesType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Kolekce ar nebo sriovch sel</xs:documentation>
					<xs:documentation xml:lang="en">Batch or serial number collection</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:simpleType name="DescriptionType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Popis poloky</xs:documentation>
			<xs:documentation xml:lang="en">Item description</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string"/>
	</xs:simpleType>
	<xs:complexType name="CatalogueItemIdentificationType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Kd EAN</xs:documentation>
			<xs:documentation xml:lang="en">EAN code</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="IDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Uniktn identifiktor</xs:documentation>
					<xs:documentation xml:lang="en">Unique identifier</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="SellersItemIdentificationType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Identifikace zbo dle prodejce</xs:documentation>
			<xs:documentation xml:lang="en">Sellers item identification</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="IDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Uniktn identifiktor</xs:documentation>
					<xs:documentation xml:lang="en">Unique identifier</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="SecondarySellersItemIdentificationType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Sekundrn identifikace zbo dle prodejce</xs:documentation>
			<xs:documentation xml:lang="en">Secondary sellers item identification</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="IDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Uniktn identifiktor</xs:documentation>
					<xs:documentation xml:lang="en">Unique identifier</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="TertiarySellersItemIdentificationType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Terciln identifikace zbo dle prodejce</xs:documentation>
			<xs:documentation xml:lang="en">Tertiary sellers item identification</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="IDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Uniktn identifiktor</xs:documentation>
					<xs:documentation xml:lang="en">Unique identifier</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="BuyersItemIdentificationType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Identifikace zbo dle kupujcho</xs:documentation>
			<xs:documentation xml:lang="en">Buyers item identification</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="ID" type="IDType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Uniktn identifiktor</xs:documentation>
					<xs:documentation xml:lang="en">Unique identifier</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="StoreBatchesType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Kolekce ar nebo sriovch sel</xs:documentation>
			<xs:documentation xml:lang="en">Batch or serial number collection</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="StoreBatch" type="StoreBatchType" maxOccurs="unbounded">
				<xs:annotation>
					<xs:documentation xml:lang="cs">are/sriov slo</xs:documentation>
					<xs:documentation xml:lang="en">Batch/serial number</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="StoreBatchType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">are/sriov slo</xs:documentation>
			<xs:documentation xml:lang="en">Batch/serial number</xs:documentation>
		</xs:annotation>
		<xs:sequence>
			<xs:element name="Name" type="NameType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Nzev are/Sriov slo</xs:documentation>
					<xs:documentation xml:lang="en">Batch name/serial number</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="Note" type="NoteType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Poznmka</xs:documentation>
					<xs:documentation xml:lang="en">Note</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="ExpirationDate" type="ExpirationDateType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Datum expirace</xs:documentation>
					<xs:documentation xml:lang="en">Expiration date</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="Specification" type="SpecificationType" minOccurs="0">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Specifikace</xs:documentation>
					<xs:documentation xml:lang="en">Specification</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="Quantity" type="QuantityType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Mnostv</xs:documentation>
					<xs:documentation xml:lang="en">Amount</xs:documentation>
				</xs:annotation>
			</xs:element>
			<xs:element name="BatchOrSerialNumber" type="BatchOrSerialNumberType">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Rozlien mezi ar a sriovm slem</xs:documentation>
					<xs:documentation xml:lang="en">Differentiation between batch and serial number</xs:documentation>
				</xs:annotation>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:simpleType name="ExpirationDateType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Datum expirace</xs:documentation>
			<xs:documentation xml:lang="en">Expiration date</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:date"/>
	</xs:simpleType>
	<xs:simpleType name="SpecificationType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Specifikace</xs:documentation>
			<xs:documentation xml:lang="en">Specification</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string"/>
	</xs:simpleType>
	<xs:simpleType name="BatchOrSerialNumberType">
		<xs:annotation>
			<xs:documentation xml:lang="cs">Rozlien mezi ar a sriovm slem</xs:documentation>
			<xs:documentation xml:lang="en">Differentiation between batch and serial number</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:enumeration value="B">
				<xs:annotation>
					<xs:documentation xml:lang="cs">are</xs:documentation>
					<xs:documentation xml:lang="en">Batch</xs:documentation>
				</xs:annotation>
			</xs:enumeration>
			<xs:enumeration value="S">
				<xs:annotation>
					<xs:documentation xml:lang="cs">Sriov slo</xs:documentation>
					<xs:documentation xml:lang="en">Serial number</xs:documentation>
				</xs:annotation>
			</xs:enumeration>
		</xs:restriction>
	</xs:simpleType>
</xs:schema>
',
    LOCAL => TRUE,
    GENTYPES => TRUE, 
    GENTABLES => TRUE);
END;