--------------------------------------------------------
--  File created - Ptek-jen-22-2010   
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Table GROUPS
--------------------------------------------------------

  CREATE TABLE "GROUPS" 
   (	"PRODGROUP" VARCHAR2(20 BYTE), 
	"DESCRIPTION" VARCHAR2(100 BYTE), 
	"GROUPNAME" VARCHAR2(30 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PRICES
--------------------------------------------------------

  CREATE TABLE "PRICES" 
   (	"ID" NUMBER, 
	"VALID_FROM" DATE, 
	"PRICE" NUMBER, 
	"CURRENCY" VARCHAR2(3 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PRODTXT
--------------------------------------------------------

  CREATE TABLE "PRODTXT" 
   (	"LANG" VARCHAR2(3 BYTE), 
	"ID" NUMBER, 
	"TKT1" VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table PRODUCT
--------------------------------------------------------

  CREATE TABLE "PRODUCT" 
   (	"ID" NUMBER, 
	"PRODGROUP" VARCHAR2(20 BYTE), 
	"UNITCODE" VARCHAR2(20 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Table STORE
--------------------------------------------------------

  CREATE TABLE "STORE" 
   (	"ID" NUMBER, 
	"BATCHORSERIALNUMBER" VARCHAR2(20 BYTE), 
	"QUANTITY" NUMBER(10,2)
   ) SEGMENT CREATION IMMEDIATE 
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for View STOCK
--------------------------------------------------------

  CREATE OR REPLACE FORCE VIEW "STOCK" ("ID", "BATCH", "QUANTITY", "UNITCODE") AS 
  SELECT 
    P.ID,S.BATCHORSERIALNUMBER,S.QUANTITY, P.UNITCODE
FROM PRODUCT P INNER JOIN  STORE S ON P.ID=S.ID;
REM INSERTING into DEMBS7AM.GROUPS
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('1','Soft drinks, coffees, teas, beers, and ales','Beverages');
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('2','Sweet and savory sauces, relishes, spreads, and seasonings','Condiments');
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('3','Desserts, candies, and sweet breads','Confections');
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('4','Cheeses','Dairy Products');
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('5','Breads, crackers, pasta, and cereal','Grains/Cereals');
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('6','Prepared meats','Meat/Poultry');
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('7','Dried fruit and bean curd','Produce');
Insert into DEMBS7AM.GROUPS (PRODGROUP,DESCRIPTION,GROUPNAME) values ('8','Seaweed and fish','Seafood');
REM INSERTING into DEMBS7AM.PRICES
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (1,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),18,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (2,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),19,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (3,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),10,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (4,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),22,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (5,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),21,35,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (6,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),25,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (7,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),30,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (8,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),40,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (9,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),97,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (10,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),31,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (11,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),21,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (12,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),38,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (13,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),6,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (14,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),23,25,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (15,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (16,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),17,45,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (17,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),39,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (18,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),62,5,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (19,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (20,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),81,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (21,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),10,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (22,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),21,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (23,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),9,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (24,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (25,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),14,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (26,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),31,23,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (27,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),43,9,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (28,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),45,6,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (29,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),123,79,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (30,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),25,89,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (31,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (32,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),32,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (33,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (34,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),14,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (35,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),18,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (36,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),19,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (37,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),26,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (38,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),263,5,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (39,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),18,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (40,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (41,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (42,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),14,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (43,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),46,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (44,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),19,45,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (46,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),12,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (47,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),2,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (48,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),3,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (49,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),20,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (50,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),16,25,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (51,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),53,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (52,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),7,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (53,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),32,8,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (54,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),16,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (55,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),24,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (56,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),38,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (57,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),4,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (58,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),13,25,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (59,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),55,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (60,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),34,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (61,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),2,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (62,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),49,3,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (63,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),43,9,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (64,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),33,25,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (65,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),40,3,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (66,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),17,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (67,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),14,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (68,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),40,5,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (69,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),36,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (70,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (71,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),22,22,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (72,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),34,8,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (73,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),15,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (74,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),10,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (75,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),27,27,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (76,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),18,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (77,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),13,'CZK');
Insert into DEMBS7AM.PRICES (ID,VALID_FROM,PRICE,CURRENCY) values (45,to_timestamp('25.05.10 00:00:00,000000000','DD.MM.RR HH24:MI:SS,FF'),3,5,'CZK');
REM INSERTING into DEMBS7AM.PRODTXT
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',1,'Chai');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',2,'Chang');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',3,'Aniseed Syrup');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',4,'Chef Antons Cajun Seasoning');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',5,'Chef Antons Gumbo Mix');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',6,'Grandmas Boysenberry Spread');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',7,'Uncle Bobs Organic Dried Pears');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',8,'Northwoods Cranberry Sauce');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',9,'Mishi Kobe Niku');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',10,'Ikura');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',11,'Queso Cabrales');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',12,'Queso Manchego La Pastora');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',13,'Konbu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',14,'Tofu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',15,'Genen Shouyu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',16,'Pavlova');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',17,'Alice Mutton');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',18,'Carnarvon Tigers');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',19,'Teatime Chocolate Biscuits');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',20,'Sir Rodneys Marmalade');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',21,'Sir Rodneys Scones');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',22,'Gustafs Knckebrd');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',23,'Tunnbrd');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',24,'Guaran Fantstica');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',25,'NuNuCa Nu-Nougat-Creme');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',26,'Gumbr Gummibrchen');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',27,'Schoggi Schokolade');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',28,'Rssle Sauerkraut');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',29,'Thringer Rostbratwurst');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',30,'Nord-Ost Matjeshering');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',31,'Gorgonzola Telino');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',32,'Mascarpone Fabioli');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',33,'Geitost');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',34,'Sasquatch Ale');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',35,'Steeleye Stout');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',36,'Inlagd Sill');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',37,'Gravad lax');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',38,'Cte de Blaye');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',39,'Chartreuse verte');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',40,'Boston Crab Meat');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',41,'Jacks New England Clam Chowder');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',42,'Singaporean Hokkien Fried Mee');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',43,'Ipoh Coffee');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',44,'Gula Malacca');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',45,'Rogede sild');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',46,'Spegesild');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',47,'Zaanse koeken');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',48,'Chocolade');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',49,'Maxilaku');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',50,'Valkoinen suklaa');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',51,'Manjimup Dried Apples');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',52,'Filo Mix');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',53,'Perth Pasties');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',54,'Tourti?re');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',55,'Pt chinois');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',56,'Gnocchi di nonna Alice');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',57,'Ravioli Angelo');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',58,'Escargots de Bourgogne');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',59,'Raclette Courdavault');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',60,'Camembert Pierrot');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',61,'Sirop drable');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',62,'Tarte au sucre');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',63,'Vegie-spread');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',64,'Wimmers gute Semmelkndel');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',65,'Louisiana Fiery Hot Pepper Sauce');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',66,'Louisiana Hot Spiced Okra');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',67,'Laughing Lumberjack Lager');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',68,'Scottish Longbreads');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',69,'Gudbrandsdalsost');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',70,'Outback Lager');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',71,'Flotemysost');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',72,'Mozzarella di Giovanni');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',73,'Rd Kaviar');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',74,'Longlife Tofu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',75,'Rhnbru Klosterbier');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',76,'Lakkalikri');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('EN',77,'Original Frankfurter grne Soe');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',1,'Chai');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',2,'Chang');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',3,'Anzov Sirup');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',4,'Chef Anton Cajun koen');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',5,'Chef Anton Gumbo Mix');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',6,'Babiina ostruinov pomaznka');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',7,'Ekologickho suen hruky strce Boba');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',8,'Brusinkov omka Northwood');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',9,'Mishi Kobe NIKU');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',10,'Ikura');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',11,'Queso Cabrales');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',12,'Queso Manchego La Pastora');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',13,'Konbu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',14,'Tofu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',15,'Genen Shouyu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',16,'Pavlova');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',17,'Skopov maso Alice');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',18,'Carnarvon tigi');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',19,'Suenky v okold');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',20,'Pan Rodney marmelda');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',21,'Pan Rodney kolky');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',22,'Gustaf je knekebrod');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',23,'Tukov chleba');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',24,'Guarana Fantastica');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',25,'NuNuCa Oko-nugtov-krm');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',26,'Gumov medvdci el dti');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',27,'Schoggi okolda');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',28,'Rssle zel');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',29,'Durynsk klobsy');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',30,'Nord-Ost sled');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',31,'Gorgonzola Telino');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',32,'Mascarpone Fabioli');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',33,'Geitost');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',34,'Ale Sasquatch');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',35,'Steeleye Stout');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',36,'Inlagd Sill');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',37,'Gravad laxn');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',38,'Cte de Blaye');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',39,'Chartreuse verte');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',40,'Boston krab maso');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',41,'Jackovypolvkov keble z  Nov Anglie');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',42,'Singapursk Hokkien Smaen Mee');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',43,'Ipoh Kva');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',44,'Gula Malacca');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',45,'Rogede Sild');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',46,'Spegesild');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',47,'Zaanse koeken');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',48,'okolda');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',49,'Maxilaku');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',50,'Bl finsk okolda');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',51,'Manjimup suen jablka');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',52,'Filo Mix');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',53,'Perth tatiky');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',54,'Francouzsk kol');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',55,'nsk kol');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',56,'Gnocchi di Nonna Alice');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',57,'Ravioli Angelo');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',58,'Burgunt neci');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',59,'Raclette Courdavault');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',60,'Camembert Pierrot');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',61,'Syrup rable');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',62,'Tarte au sucre');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',63,'Vegie-pomaznka');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',64,'Wimmers gute Semmelkndel');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',65,'Peperonkov omka Louisiana Fiery');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',66,'Svaen Ibiek Louisiana ');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',67,'smv devorubce Lager');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',68,'Skotsk Longbreads');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',69,'Gudbrandsdalsost');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',70,'Outback Lager');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',71,'Flotemysost');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',72,'Mozzarella di Giovanni');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',73,'Rd kaviar');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',74,'Longlife Tofu');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',75,'Rhnbru kltern pivo');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',76,'Lakkalikri');
Insert into DEMBS7AM.PRODTXT (LANG,ID,TKT1) values ('CS',77,'Pvodn frankfurtsk zelen omka');
REM INSERTING into DEMBS7AM.PRODUCT
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (1,'1','10 boxes x 20 bags');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (2,'1','24 - 12 oz bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (3,'2','12 - 550 ml bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (4,'2','48 - 6 oz jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (5,'2','36 boxes');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (6,'2','12 - 8 oz jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (7,'7','12 - 1 lb pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (8,'2','12 - 12 oz jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (9,'6','18 - 500 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (10,'8','12 - 200 ml jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (11,'4','1 kg pkg.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (12,'4','10 - 500 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (13,'8','2 kg box');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (14,'7','40 - 100 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (15,'2','24 - 250 ml bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (16,'3','32 - 500 g boxes');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (17,'6','20 - 1 kg tins');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (18,'8','16 kg pkg.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (19,'3','10 boxes x 12 pieces');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (20,'3','30 gift boxes');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (21,'3','24 pkgs. x 4 pieces');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (22,'5','24 - 500 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (23,'5','12 - 250 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (24,'1','12 - 355 ml cans');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (25,'3','20 - 450 g glasses');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (26,'3','100 - 250 g bags');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (27,'3','100 - 100 g pieces');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (28,'7','25 - 825 g cans');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (29,'6','50 bags x 30 sausgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (30,'8','10 - 200 g glasses');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (31,'4','12 - 100 g pkgs');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (32,'4','24 - 200 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (33,'4','500 g');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (34,'1','24 - 12 oz bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (35,'1','24 - 12 oz bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (36,'8','24 - 250 g  jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (37,'8','12 - 500 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (38,'1','12 - 75 cl bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (39,'1','750 cc per bottle');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (40,'8','24 - 4 oz tins');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (41,'8','12 - 12 oz cans');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (42,'5','32 - 1 kg pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (43,'1','16 - 500 g tins');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (44,'2','20 - 2 kg bags');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (45,'8','1k pkg.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (46,'8','4 - 450 g glasses');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (47,'3','10 - 4 oz boxes');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (48,'3','10 pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (49,'3','24 - 50 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (50,'3','12 - 100 g bars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (51,'7','50 - 300 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (52,'5','16 - 2 kg boxes');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (53,'6','48 pieces');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (54,'6','16 pies');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (55,'6','24 boxes x 2 pies');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (56,'5','24 - 250 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (57,'5','24 - 250 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (58,'8','24 pieces');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (59,'4','5 kg pkg.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (60,'4','15 - 300 g rounds');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (61,'2','24 - 500 ml bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (62,'3','48 pies');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (63,'2','15 - 625 g jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (64,'5','20 bags x 4 pieces');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (65,'2','32 - 8 oz bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (66,'2','24 - 8 oz jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (67,'1','24 - 12 oz bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (68,'3','10 boxes x 8 pieces');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (69,'4','10 kg pkg.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (70,'1','24 - 355 ml bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (71,'4','10 - 500 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (72,'4','24 - 200 g pkgs.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (73,'8','24 - 150 g jars');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (74,'7','5 kg pkg.');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (75,'1','24 - 0.5 l bottles');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (76,'1','500 ml');
Insert into DEMBS7AM.PRODUCT (ID,PRODGROUP,UNITCODE) values (77,'2','12 boxes');
REM INSERTING into DEMBS7AM.STORE
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (1,'E',39);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (2,'E',17);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (3,'E',13);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (4,'E',53);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (5,'E',0);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (6,'E',120);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (7,'E',15);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (8,'E',6);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (9,'E',29);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (10,'E',31);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (11,'E',22);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (12,'E',86);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (13,'E',24);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (14,'E',35);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (15,'E',39);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (16,'E',29);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (17,'E',0);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (18,'E',42);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (19,'E',25);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (20,'E',40);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (21,'E',3);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (22,'E',104);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (23,'E',61);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (24,'E',20);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (25,'E',76);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (26,'E',15);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (27,'E',49);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (28,'E',26);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (29,'E',0);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (30,'E',10);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (31,'E',0);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (32,'E',9);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (33,'E',112);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (34,'E',111);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (35,'E',20);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (36,'E',112);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (37,'E',11);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (38,'E',17);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (39,'E',69);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (40,'E',123);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (41,'E',85);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (42,'E',26);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (43,'E',17);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (44,'E',27);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (45,'E',5);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (46,'E',95);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (47,'E',36);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (48,'E',15);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (49,'E',10);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (50,'E',65);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (51,'E',20);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (52,'E',38);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (53,'E',0);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (54,'E',21);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (55,'E',115);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (56,'E',21);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (57,'E',36);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (58,'E',62);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (59,'E',79);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (60,'E',19);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (61,'E',113);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (62,'E',17);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (63,'E',24);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (64,'E',22);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (65,'E',76);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (66,'E',4);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (67,'E',52);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (68,'E',6);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (69,'E',26);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (70,'E',15);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (71,'E',26);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (72,'E',14);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (73,'E',101);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (74,'E',4);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (75,'E',125);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (76,'E',57);
Insert into DEMBS7AM.STORE (ID,BATCHORSERIALNUMBER,QUANTITY) values (77,'E',32);
--------------------------------------------------------
--  DDL for Index GROUPS_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "GROUPS_PK" ON "GROUPS" ("PRODGROUP") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PRICES_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRICES_PK" ON "PRICES" ("ID", "VALID_FROM") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PRODTXT_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRODTXT_PK" ON "PRODTXT" ("LANG", "ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index PRODUCT_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "PRODUCT_PK" ON "PRODUCT" ("ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  DDL for Index STORE_PK
--------------------------------------------------------

  CREATE UNIQUE INDEX "STORE_PK" ON "STORE" ("ID", "BATCHORSERIALNUMBER") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS" ;
--------------------------------------------------------
--  Constraints for Table GROUPS
--------------------------------------------------------

  ALTER TABLE "GROUPS" ADD CONSTRAINT "GROUPS_PK" PRIMARY KEY ("PRODGROUP")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
 
  ALTER TABLE "GROUPS" MODIFY ("PRODGROUP" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PRICES
--------------------------------------------------------

  ALTER TABLE "PRICES" ADD CONSTRAINT "PRICES_PK" PRIMARY KEY ("ID", "VALID_FROM")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
 
  ALTER TABLE "PRICES" MODIFY ("ID" NOT NULL ENABLE);
 
  ALTER TABLE "PRICES" MODIFY ("VALID_FROM" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PRODTXT
--------------------------------------------------------

  ALTER TABLE "PRODTXT" ADD CONSTRAINT "PRODTXT_PK" PRIMARY KEY ("LANG", "ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
 
  ALTER TABLE "PRODTXT" MODIFY ("LANG" NOT NULL ENABLE);
 
  ALTER TABLE "PRODTXT" MODIFY ("ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table PRODUCT
--------------------------------------------------------

  ALTER TABLE "PRODUCT" ADD CONSTRAINT "PRODUCT_PK" PRIMARY KEY ("ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
 
  ALTER TABLE "PRODUCT" MODIFY ("ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table STORE
--------------------------------------------------------

  ALTER TABLE "STORE" ADD CONSTRAINT "STORE_PK" PRIMARY KEY ("ID", "BATCHORSERIALNUMBER")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "USERS"  ENABLE;
 
  ALTER TABLE "STORE" MODIFY ("ID" NOT NULL ENABLE);
 
  ALTER TABLE "STORE" MODIFY ("BATCHORSERIALNUMBER" NOT NULL ENABLE);
--------------------------------------------------------
--  Ref Constraints for Table PRODTXT
--------------------------------------------------------

  ALTER TABLE "PRODTXT" ADD CONSTRAINT "TXT_REL" FOREIGN KEY ("ID")
	  REFERENCES "PRODUCT" ("ID") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table PRODUCT
--------------------------------------------------------

  ALTER TABLE "PRODUCT" ADD CONSTRAINT "GROUP_REL" FOREIGN KEY ("PRODGROUP")
	  REFERENCES "GROUPS" ("PRODGROUP") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table STORE
--------------------------------------------------------

  ALTER TABLE "STORE" ADD CONSTRAINT "STORE_ID" FOREIGN KEY ("ID")
	  REFERENCES "PRODUCT" ("ID") ENABLE;
