﻿using System;
using System.Data;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Data.OracleClient;
using System.Data.Sql;
using System.Linq.Expressions;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Oracle.DataAccess.Client;



namespace Wcf_products
{
	// NOTE: If you change the class name "Service1" here, you must also update the reference to "Service1" in Web.config and in the associated .svc file.
	//[ServiceBehavior(Name="Wcf_products",Namespace="Wcf_products",IncludeExceptionDetailInFaults=true)] 
	public class Catalog : ICatalog
	{
		private DataSet1 _product_ds = new DataSet1();
		private DataSet1TableAdapters.TableAdapterManager _ad=new Wcf_products.DataSet1TableAdapters.TableAdapterManager();
		private DataSet1TableAdapters.STOCKTableAdapter _q_st = new Wcf_products.DataSet1TableAdapters.STOCKTableAdapter();
		private DataSet1TableAdapters.GROUPSTableAdapter _t_groups = new Wcf_products.DataSet1TableAdapters.GROUPSTableAdapter();


		#region ICatalog Members

		public getInvoiceLinesResponse getInvoiceLines(getInvoiceLinesRequest request)
		{

			_q_st.Fill(_product_ds.STOCK);
			int i = 1;

			var q = from p in _product_ds.STOCK
					join r in request.InvoiceLines_query on
						(p.ID.ToString()) equals r.ID
					select (new InvoiceLineType
					{
						ID = (i++).ToString(),
						Item = new ItemType
						{
							Description = p.TKT1,
							StoreBatches = new StoreBatchType[]{
			                            new StoreBatchType{
			                                    BatchOrSerialNumber=BatchOrSerialNumberType.B,
			                                    Name="OnHandStock",
			                                    Quantity=new QuantityType{
			                                            unitCode=p.UNITCODE,
			                                            Value=(decimal)p.QUANTITY}}} ,
							SellersItemIdentification= new SellersItemIdentificationType{
										ID=r.ID.ToString()}
						},
						UnitPrice = p.PRICE,
						UnitPriceTaxInclusive = (r.VAT_Calc == InvoiceLine_queryTypeVAT_Calc.CZ ? 1.2m : 1) *  p.PRICE,
						InvoicedQuantity = new QuantityType { unitCode = p.UNITCODE, Value = r.Quantity.Value },
						LineExtensionAmount = p.PRICE*(decimal)r.Quantity.Value,
						LineExtensionTaxAmount = (r.VAT_Calc == InvoiceLine_queryTypeVAT_Calc.CZ ? 0.2m : 0) * p.PRICE * (decimal)r.Quantity.Value,
						LineExtensionAmountTaxInclusive = (r.VAT_Calc == InvoiceLine_queryTypeVAT_Calc.CZ ? 1.2m : 1) * p.PRICE * (decimal)r.Quantity.Value
						
					});

		

			var resp = new getInvoiceLinesResponse();

			if (resp.InvoiceLines == null) resp.InvoiceLines = q.ToArray<InvoiceLineType>();

			return resp;
			//var line = new InvoiceLineType();
			//var Batch = new StoreBatchType();

			//Batch.BatchOrSerialNumber = BatchOrSerialNumberType.B;
			//Batch.Name = "Onhand stock";
			//Batch.Quantity = new QuantityType();
			//Batch.Quantity.unitCode="PCE";
			//Batch.Quantity.Value = 150;

			//line.ID=request.InvoiceLines_query[0].ID;
			//line.InvoicedQuantity = new QuantityType();
			//line.InvoicedQuantity.unitCode="PCE";
			//line.InvoicedQuantity.Value = 10;

			//line.Item = new ItemType();
			
			//line.Item.Description = "dummyItem";
			//line.Item.StoreBatches = new StoreBatchType[] { Batch };			
			//line.UnitPrice = 100;
			//line.UnitPriceTaxInclusive = 120;

			//var Fault = CreateFault("quantity");
			//if (true) throw new FaultException<LinesQuantity_NAType>(Fault, "Quantity");
			//return new getInvoiceLinesResponse(new InvoiceLineType[] { line });
			//throw new NotImplementedException();
		}

		public getProductGroupsResponse getProductGroups(getProductGroupsRequest request)
		{
			if (_ad.GROUPSTableAdapter == null) _ad.GROUPSTableAdapter = 
				new Wcf_products.DataSet1TableAdapters.GROUPSTableAdapter();


			_ad.GROUPSTableAdapter.Fill(_product_ds.GROUPS);

			var q= from p in _product_ds.GROUPS
				   select (new Group_type{
					   Group_ID=p.PRODGROUP,
					   Group_Name=p.GROUPNAME,
					   Value=p.DESCRIPTION});

			var resp = new getProductGroupsResponse { ProdGroups = q.ToArray<Group_type>() };
			return resp;  
			
		}

		public GetProductByNameResponse GetProductByName(GetProductByNameRequest request)
		{
			
			if (_ad.PRODTXTTableAdapter == null) _ad.PRODTXTTableAdapter =
				   new Wcf_products.DataSet1TableAdapters.PRODTXTTableAdapter();
			_ad.PRODTXTTableAdapter.Fill(_product_ds.PRODTXT);

		//Search term
			System.Text.RegularExpressions.Regex search =new System.Text.RegularExpressions.Regex(request.QString);


			var q = from p in _product_ds.PRODTXT
					where search.IsMatch(p.TKT1)
					select (new ProductInfo_type { 
						ID=(p.ID).ToString(),
						Description=p.TKT1,
						});

			var resp = new GetProductByNameResponse();
			resp.ProductList = q.ToArray<ProductInfo_type>();
			return resp;

		}

		public GetProductByNameResponse GetRpoductsByGroup(GetRpoductsByGroupRequest request)
		{
			if (_ad.PRODUCTTableAdapter == null) _ad.PRODUCTTableAdapter = new Wcf_products.DataSet1TableAdapters.PRODUCTTableAdapter();
			_ad.PRODUCTTableAdapter.Fill(_product_ds.PRODUCT);
			if(_ad.PRODTXTTableAdapter==null) _ad.PRODTXTTableAdapter=
				new Wcf_products.DataSet1TableAdapters.PRODTXTTableAdapter();
			_ad.PRODTXTTableAdapter.Fill(_product_ds.PRODTXT);
			if (_ad.GROUPSTableAdapter == null) _ad.GROUPSTableAdapter =
				new Wcf_products.DataSet1TableAdapters.GROUPSTableAdapter();
			
			_ad.GROUPSTableAdapter.Fill(_product_ds.GROUPS);
			


			var q=from p in _product_ds.PRODUCT 
				  join g in request.ProdGroups on p.PRODGROUP equals g.Group_ID
					join t in _product_ds.PRODTXT on p.ID equals t.ID where t.LANG=="CS"
					  select (new ProductInfo_type{
							ID=(p.ID).ToString(),
							Group_Name=g.Group_Name,
							Description=t.TKT1,
							ProductName=t.TKT1
							});

			var resp = new GetProductByNameResponse();
			resp.ProductList = q.ToArray<ProductInfo_type>();
			return resp;
 
			
		}

		#endregion

		private LinesQuantity_NAType CreateFault(string message)
		{
			var faultLine = new LineQuantity_NAType()   ;
			faultLine.ID = "355003";
			faultLine.Quantity = new QuantityType();
			faultLine.Quantity.unitCode = "KG";
			faultLine.Quantity.Value = 3000;

			faultLine.QuantityAvailable = new QuantityType();
			faultLine.QuantityAvailable.unitCode = "KG";
			faultLine.QuantityAvailable.Value = 4000;

			return new LinesQuantity_NAType(){faultLine};
		}
	}
}
