<?php
class SendByEmailRequest
{
	/**
	 * @var (object)emailList
	 */
	public $recipients;

	/**
	 * @var string
	 */
	public $subject;

	/**
	 * @var string
	 */
	public $text;

	/**
	 * @var (object)data
	 */
	public $data;
}

class Response
{
	/**
	 * @var string
	 *     NOTE: code should follow the following restrictions
	 *     You can have one of the following value
	 *     Ok
	 *     Error
	 */
	public $code;

	/**
	 * @var string
	 */
	public $message;
}

class SendByEmailResponse extends Response {}

class SendByDataboxRequest
{
	/**
	 * @var string
	 *     NOTE: recipientDataboxId should follow the following restrictions
	 *     The value length should be
	 * 7
	 */
	public $recipientDataboxId;

	/**
	 * @var string
	 *     NOTE: text should follow the following restrictions
	 *     Your length of the value should be
	 *     Less than 255
	 */
	public $text;

	/**
	 * @var (object)data
	 */
	public $data;
}

class SendByDataboxResponse extends Response {}

class emailList
{
	/**
	 * @var array[1, unbounded] of string
	 */
	public $emailAddress;
}

class data
{
	/**
	 * @var string
	 */
	public $filename;

	/**
	 * @var stdObject
	 */
	public $any;
}