<?php
/**
 * PostService core class (WS interface)
 *
 * @version $Id$
 * @author Dominik Fier
 * @package PostService
 */

class PostServiceCore
{
	/**
	 * Konfigurace pro odchoz emaily
	 *
	 * @var array
	 */
	protected $_emailConfig = array();

	/**
	 * Konfigurace pro datavou schrnku odeslatele
	 *
	 * @var array
	 */
	protected $_databoxConfig = array();

	/**
	 * Konstruktor
	 *
	 * @return void
	 */
	public function __construct()
	{
		//naten konfigurace
		$this->_emailConfig = PostServiceConfig::getEmailConfig();

		$this->_databoxConfig = PostServiceConfig::getDataboxConfig();
	}

	/**
	 * Operace SendByEmail
	 *
	 * @param SendByEmailRequest $input
	 * @return SendByEmailResponse
	 */
	public function sendByEmail(SendByEmailRequest $input)
	{
		require_once 'lib/phpmailer/class.phpmailer.php';

		//email
		$mail = new PHPMailer(true);

		//odpov
		$response = new SendByEmailResponse();

		try {
			$mail->SetFrom($this->_emailConfig['mailFrom'], $this->_emailConfig['mailFromName']);
			$mail->AddReplyTo($this->_emailConfig['mailFrom'], $this->_emailConfig['mailFromName']);

			//naten a nastaven adrest
			$recipientsAdresses = '';

			foreach((array)$input->recipients->emailAddress as $recipientEmail) {
				if ($recipientsAdresses !== '') {
					$recipientsAdresses .= '; ';
				}
				$recipientsAdresses .= $recipientEmail;

				$mail->AddAddress($recipientEmail);
			}

			//naten a nastaven obsahu zprvy
			$mail->Subject = $input->subject;
		  	$mail->MsgHTML($input->text);

			//naten jmna souboru
			if ($input->data->filename) {
				$attachmentName = $input->data->filename;
			} else {
				$attachmentName = 'attachment.isdoc';
			}

			//uloen dat do doasnho souboru
			$fileName = tempnam('tmp', 'at');
			file_put_contents($fileName, $input->data->any);

		  	//naten a pidn plohy - faktury
		  	$mail->AddAttachment($fileName, $attachmentName);
			$mail->Send();

			//smae doasn soubor
			unlink($fileName);

			//odpov
			$response->code = 'Ok';
			$response->message = 'Email succesfully send to '.$recipientsAdresses;

		} catch (phpmailerException $e) {
		  	$response->code = 'Error';
			$response->message = $e->errorMessage();

		} catch (Exception $e) {
			$response->code = 'Error';
			$response->message = $e->getMessage();
		}

		return $response;
	}

	/**
	 * Operace SendByDatabox
	 *
	 * id testovac schrnky pjemce je hjyaavk
	 *
	 * @param SendByDataboxRequest $input
	 * @return SendByDataboxResponse
	 */
	public function sendByDatabox(SendByDataboxRequest $input)
	{
		//odpov
		$response = new SendByDataboxResponse();

		try {
			//vytvo soap klienta pro ws isds
			if (!($soapClient = $this->_createIsdsSoapClient())) {
				throw new Exception('SOAP client not initialized.');
			}

			//naten jmna souboru
			if ($input->data->filename) {
				$attachmentName = $input->data->filename;
			} else {
				$attachmentName = 'attachment.isdoc';
			}

			//oblka
			$envelope = array(
				'dmSenderOrgUnit' => null,
				'dmSenderOrgUnitNum' => null,
				'dbIDRecipient' => $input->recipientDataboxId, //id datov schrnky pjemce
				'dmRecipientOrgUnit' => null,
				'dmRecipientOrgUnitNum' => null,
				'dmToHands' => null,
				'dmAnnotation' => $input->text, //pedmt zprvy
				'dmRecipientRefNumber' => null,
				'dmSenderRefNumber' => null,
				'dmRecipientIdent' => null,
				'dmSenderIdent' => null,
				'dmLegalTitleLaw' => null,
				'dmLegalTitleYear' => null,
				'dmLegalTitleSect' => null,
				'dmLegalTitlePar' => null,
				'dmLegalTitlePoint' => null,
				'dmPersonalDelivery' => false,
				'dmAllowSubstDelivery' => null,
			);

			//ploha
			$file=array(
				'dmMimeType' => pathinfo($attachmentName, PATHINFO_EXTENSION), //ppona souboru
				'dmFileMetaType' => 'main',
				'dmFileGuid' =>null,
				'dmUpFileGuid' =>null,
				'dmFileDescr' =>$attachmentName, //jmno souboru
				'dmFormat' => null,
				'dmEncodedContent' =>$input->data->any //data souboru
			);

			//plohy
			$files = array();
			$files[] = $file;

			$messageCreateInput = array(
				'dmEnvelope' => $envelope,
				'dmFiles' => $files);

			//odesln zprvy
			$messageCreateOutput = $soapClient->CreateMessage($messageCreateInput);

			if ($messageCreateOutput->dmStatus->dmStatusCode == '0000') {
				$response->code = 'Ok';
				$response->message = 'Databox message (message id: ' . $messageCreateOutput->dmID
					. ') succesfully send to databox with id '
					. $input->recipientDataboxId;
			} else {
				$response->code = 'Error';
				$response->message = $messageCreateOutput->dmStatus->dmStatusMessage;
			}
		}
		catch (Exception $e) {
			$response->code = 'Error';
			$response->message = $e->getMessage();
		}

		return $response;
	}

	/**
	 * Vytvo SOAP klienta pro WS ISDS
	 *
	 * @return SoapClient
	 */
	protected function _createIsdsSoapClient()
	{
		//pihlaovac daje k datov schrnce odeslatele
		$options = array(
			'login' => $this->_databoxConfig['login'],
			'password' => $this->_databoxConfig['password'],
		);

		//url ws: https://ws1.czebox.cz/DS/dz
		$soapClient = new SoapClient($this->_databoxConfig['wsdlFileDmOperations'], $options);

		//operace pro navzn spojen
		$soapClient->DummyOperation();

		return $soapClient;
	}
}