<?php
/**
 * PostService class
 *
 * @version $Id$
 * @author Dominik Fier
 * @package PostService
 */

require_once 'PostServiceConfig.php';
require_once 'PostServiceCore.php';

class PostService
{
	/**
	 * Mapovn element na tdy
	 *
	 * xml element => tda
	 *
	 * @var array
	 */
	protected $_classMap = array(
		'SendByEmailRequest' => 'SendByEmailRequest',
		'SendByEmailResponse' => 'SendByEmailResponse',
		'SendByDataboxRequest' => 'SendByDataboxRequest',
		'SendByDataboxResponse' => 'SendByDataboxResponse',
		'emailList' => 'emailList',
		'data' => 'data',
	);

	/**
	 * SOAP server
	 *
	 * @var SoapServer
	 */
	protected $_soapServer = null;

	/**
	 * WSDL
	 *
	 * @var string
	 */
	protected $_wsdlFile;

	/**
	 * Konstruktor
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->_wsdlFile = PostServiceConfig::getWsdlFile();
	}

	/**
	 * Zpracuje Soap poadavek
	 *
	 * @return void
	 */
	public function proccess()
	{
		//konfigurace
		$options = array (
			'encoding' => 'utf-8',
			'classmap' => $this->_classMap,
		);

		//vytvo WS
		$this->_soapServer = new SoapServer($this->_wsdlFile, $options);
		$this->_soapServer->setClass('PostServiceCore');

		//zpracuje poadavek a odele odpov
		$this->_soapServer->handle();
	}
}