package services;

import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import engine.OperResponse;
import engine.OracleConnector;
import engine.OracleXMLConnector;

public class InvoiceODB {

	public static void main(String[] args) {

		System.out.println("TEST-------------------------------------");
		try {
			Element element=buildDom();
			
			OracleConnector orConn=new OracleConnector();
			orConn.InsertItem(buildDom());

			// new OracleConnector().UpdateXML(2, "/aaa/text()", "New Value");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static Element buildDom() throws SAXException, IOException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		try {
			factory.setNamespaceAware(true); // never forget this!
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse("invoice.xml");
			
//			 InputSource is = new InputSource( new StringReader( "<inv:Invoice xmlns:inv='http://isdoc.cz/namespace/invoice' version='?'>" +
//			 		"<inv:InvoiceLines><inv:InvoiceLine/></inv:InvoiceLines>" +
//			 		"<inv:SellerSupplierParty><inv:Party/></inv:SellerSupplierParty>" +
//			 		" </inv:Invoice>" ) );
//			DocumentBuilder builder = factory.newDocumentBuilder();
//			Document document =
//				builder.parse(is);
			// Create from whole cloth
			Element root = (Element) document.getFirstChild();
//			Element root = (Element) document.createElement("rootElement");
//			document.appendChild(root);
//			root.appendChild(document.createTextNode("Some"));
//			root.appendChild(document.createTextNode(" "));
//			root.appendChild(document.createTextNode("text"));

			return root;
		} catch (ParserConfigurationException pce) {
			// Parser with specified options can't be built
			pce.printStackTrace();
		}
		return null;
	}

	public OMElement getInvoice(int invoiceId) {
		try {
			System.out.println("---------Selecting element------");
			Document domDoc = new OracleConnector().SelectItem(invoiceId);
			OMElement omDoc = null;
			if (domDoc != null) {
				Element el = domDoc.getDocumentElement();
				System.out.println("---------Selected element------");
				System.out.println(el.toString());
				omDoc = XMLUtils.toOM(el);
			}
			return omDoc;
		} catch (Exception ex) {
			System.err.println(ex.getMessage());
		}
		return null;
	}

	public OMElement getParty(int partyId) {
		try {
			System.out.println("---------Selecting element------");
			Document domDoc = new OracleConnector().SelectItemParty(partyId);
			OMElement omDoc = null;
			if (domDoc != null) {
				Element el = domDoc.getDocumentElement();
				System.out.println("---------Selected element------");
				System.out.println(el.toString());
				omDoc = XMLUtils.toOM(el);
			}
			return omDoc;
		} catch (Exception ex) {
			System.err.println(ex.getMessage());
		}
		return null;
	}

	
	public int addInvoice(OMElement invoiceXML) {

		try {
			int resultId = 0;
			resultId = new OracleConnector().InsertItem(createElement(invoiceXML));
			return resultId;
		} catch (Exception ex) {
			System.err.println(ex.getMessage());
		}
		return -1;
	}

	public OperResponse updateInvoice(int invoiceId, OMElement invoiceXML) {
		try {
			Element element = null;
			int result = 0;

			element = XMLUtils.toDOM(invoiceXML.getFirstElement());

			result = new OracleConnector().UpdateItem(invoiceId, element);
			String resultStr;
			switch (result) {
			case 0:
				resultStr = "Item not updated";
				break;
			default:
				resultStr = "Item updated";
				break;
			}
			return new OperResponse(resultStr, result);
		} catch (Exception ex) {
			System.err.println(ex.getMessage());
		}
		return null;
	}

	public OperResponse deleteInvoice(int invoiceId) {
		try {
			int result = new OracleConnector().DeleteItem(invoiceId);
			String resultStr;
			switch (result) {
			case 0:
				resultStr = "Item not deleted";
				break;
			default:
				resultStr = "Item deleted";
				break;
			}
			return new OperResponse(resultStr, result);
		} catch (Exception ex) {
			System.err.println(ex.getMessage());
		}
		return null;
	}

	// Return 1 if successful else 0
	public int UpdateXML(int invoiceId, String xPath, String value) {
		// xPath= "/aaa/text()"
		return new OracleConnector().UpdateXML(invoiceId, xPath, value);
	}

	public int addInvoiceNativeXML(OMElement invoiceXML, int id) {
		try{
		OracleXMLConnector oXMLConn = new OracleXMLConnector();
		return oXMLConn.InsertXML(createElement(invoiceXML), id);
		}catch(Exception ex){
			System.err.println(ex.getMessage());
		}
		return 0;
	}

	public OMElement getInvoiceNativeXML(int invoiceId) {
		OracleXMLConnector oXMLConn = new OracleXMLConnector();
		Document domDoc = null;
		try{
		domDoc = oXMLConn.SelectXML(invoiceId);
		OMElement omDoc = null;
		if (domDoc != null) {
			Element el = domDoc.getDocumentElement();
			System.out.println("---------Selected element------");
			System.out.println(el.toString());
			omDoc = XMLUtils.toOM(el);
		}
		return omDoc;
		}catch(Exception ex){
			System.err.println(ex.getMessage());
		}
		return null;
	}

	
	private Element createElement(OMElement invoiceXML) throws Exception{
		Element element = null;
		System.out.println("---------Getting first element------");
		element = XMLUtils.toDOM(invoiceXML.getFirstElement());	
		return element;
	
	}
}
