/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.lang.reflect.Method;

public class ObjectPool {
    private String className;
    private Object[] objectArr = new Object[MAX_POOL_SIZE];
    private Method resetMthd;
    private Class clazz;
    private int size = 0;
    private static int MAX_POOL_SIZE = 100;

    public synchronized Object alloc() {
        try {
            if (this.size == 0) {
                return this.clazz.newInstance();
            }
            Object object = this.objectArr[--this.size];
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public synchronized void free(Object object) {
        try {
            if (this.size >= MAX_POOL_SIZE) {
                return;
            }
            if (this.resetMthd != null) {
                this.resetMthd.invoke(object, null);
            }
            this.objectArr[this.size++] = object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        try {
            this.className = string;
            this.clazz = Class.forName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void setResetMethod(String string) {
        try {
            if (this.clazz != null) {
                this.resetMthd = this.clazz.getMethod(string, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }
}

