/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.WildCard;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLKey;
import oracle.xml.parser.v2.XSLNamespace;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLSourceContext;
import oracle.xml.parser.v2.XSLSpaceElem;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.util.ObjectPool;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XSLTContext {
    int currentTmpl;
    XSLEventHandler eventHandler;
    Hashtable eventHandlerSet;
    XMLNode contextNode;
    XMLNode currentNode;
    int contextSize;
    int contextPos;
    Hashtable srcSpaceElems;
    boolean noWSElem = true;
    FastVector spaceElems;
    Stack srcSpaceStack;
    FastVector varValues;
    Hashtable globalVariables;
    URL baseUrl = null;
    private Hashtable sourceContext;
    private int numSourceContext;
    private XSLSourceContext onlySourceContext;
    private XMLElement onlySrcRoot;
    private Hashtable documentTable;
    private Hashtable nsTable;
    DOMParser parser;
    XSLStylesheet xsl;
    XMLError err = new XMLError();
    boolean debugFlag = false;
    XSLNode dbgNode;
    boolean warning = false;
    OutputStreamWriter out;
    XSLExprValue[] exprValuePool;
    Hashtable exprHashPool;
    ObjectPool nodeListPool;
    XSLNodeList mpNodeList = new XSLNodeList();
    XSLNodeList mpNodeList2 = new XSLNodeList();
    XSLNodeList curNodeList = new XSLNodeList();
    XSLNodeList altNodeList = new XSLNodeList();

    XSLTContext() {
        this.varValues = new FastVector(16);
        this.globalVariables = new Hashtable(20);
        this.sourceContext = new Hashtable(20);
        this.documentTable = new Hashtable(20);
        this.srcSpaceElems = new Hashtable(20);
        this.srcSpaceStack = new Stack();
        this.nsTable = new Hashtable(20);
    }

    void addDocument(URL uRL, XMLElement xMLElement) throws XSLException {
        this.documentTable.put(uRL, xMLElement);
    }

    void addSourceContext(XMLElement xMLElement, XMLDocument xMLDocument) throws XSLException {
        XSLSourceContext xSLSourceContext = new XSLSourceContext(xMLElement, xMLDocument);
        if (this.numSourceContext == 0) {
            this.onlySourceContext = xSLSourceContext;
            this.onlySrcRoot = xMLElement;
        }
        ++this.numSourceContext;
        this.sourceContext.put(xMLElement, xSLSourceContext);
    }

    boolean checkPreservingWS(XMLElement xMLElement) throws XSLException {
        int n = this.spaceElems.size();
        XSLSpaceElem xSLSpaceElem = null;
        float f = -1000.0f;
        int n2 = -1;
        int n3 = n - 1;
        while (n3 >= 0) {
            XSLSpaceElem xSLSpaceElem2 = (XSLSpaceElem)this.spaceElems.elementAt(n3);
            if (n2 != -1 && xSLSpaceElem2.getImportPriority() != n2) break;
            WildCard wildCard = xSLSpaceElem2.matchWildCard(xMLElement, f);
            if (wildCard != null) {
                xSLSpaceElem = xSLSpaceElem2;
                f = wildCard.getPriority();
                n2 = xSLSpaceElem2.getImportPriority();
            }
            --n3;
        }
        if (xSLSpaceElem != null && xSLSpaceElem.strip()) {
            this.srcSpaceElems.put(xMLElement.getNodeName(), Boolean.FALSE);
            return false;
        }
        this.srcSpaceElems.put(xMLElement.getNodeName(), Boolean.TRUE);
        return true;
    }

    void ensureExprValuePoolCapacity(int n) {
        int n2 = this.exprValuePool.length;
        XSLExprValue[] xSLExprValueArray = new XSLExprValue[n];
        System.arraycopy(this.exprValuePool, 0, xSLExprValueArray, 0, n2);
        this.exprValuePool = xSLExprValueArray;
        int n3 = n2;
        while (n3 < n) {
            this.exprValuePool[n3] = new XSLExprValue(false);
            ++n3;
        }
    }

    URL getBaseURL() {
        return this.baseUrl;
    }

    public XMLNode getContextNode() throws XSLException {
        return this.contextNode;
    }

    public int getContextPosition() throws XSLException {
        return this.contextPos;
    }

    public int getContextSize() throws XSLException {
        return this.contextSize;
    }

    XMLNode getCurrentNode() {
        return this.currentNode;
    }

    int getCurrentTmpl() throws XSLException {
        return this.currentTmpl;
    }

    DecimalFormatSymbols getDecimalFormat(NSNameImpl nSNameImpl) throws XSLException {
        return this.xsl.getDecimalFormat(nSNameImpl);
    }

    XMLElement getDocument(URL uRL) throws XSLException {
        return (XMLElement)this.documentTable.get(uRL);
    }

    public XMLError getError() {
        if (this.err == null) {
            this.err = new XMLError();
        }
        return this.err;
    }

    XSLEventHandler getEventHandler() throws XSLException {
        return this.eventHandler;
    }

    XSLExprValue getExprValueObject(int n, XSLExprBase xSLExprBase) {
        XSLExprValue xSLExprValue;
        if (n != -1) {
            if (n >= this.exprValuePool.length) {
                this.ensureExprValuePoolCapacity(n + 1);
            }
            return this.exprValuePool[n];
        }
        if (this.exprHashPool == null) {
            this.exprHashPool = new Hashtable(20);
        }
        if ((xSLExprValue = (XSLExprValue)this.exprHashPool.get(xSLExprBase)) == null) {
            xSLExprValue = new XSLExprValue(false);
            this.exprHashPool.put(xSLExprBase, xSLExprValue);
        }
        return xSLExprValue;
    }

    XSLNodeList getKeyNodes(NSName nSName, String string, XMLNode xMLNode) throws XSLException {
        XSLKey xSLKey = this.xsl.getKey(nSName);
        if (xSLKey == null) {
            return null;
        }
        return xSLKey.getMatchingNodes(this, string, xMLNode);
    }

    XMLNode[] getNSNodes(XMLElement xMLElement) {
        XMLNode[] xMLNodeArray = (XMLNode[])this.nsTable.get(xMLElement);
        if (xMLNodeArray != null) {
            return xMLNodeArray;
        }
        String string = xMLElement.resolveNamespacePrefix("#default");
        Hashtable hashtable = xMLElement.getAllNamespaceAttrs();
        int n = hashtable.size() + 1;
        int n2 = 0;
        int n3 = xMLElement.docOrderId + 1;
        if (string != null) {
            xMLNodeArray = new XMLNode[n + 1];
            xMLNodeArray[n2++] = new XSLNamespace("", string, xMLElement, n3);
        } else {
            xMLNodeArray = new XMLNode[n];
        }
        xMLNodeArray[n2++] = new XSLNamespace("xml", "http://www.w3.org/XML/1998/namespace", xMLElement, n3);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                xMLNodeArray[n2++] = new XSLNamespace(string2, string3, xMLElement, n3);
            }
        }
        this.nsTable.put(xMLElement, xMLNodeArray);
        return xMLNodeArray;
    }

    XSLSourceContext getSrcContext(XMLNode xMLNode) throws XSLException {
        if (this.numSourceContext == 1) {
            return this.onlySourceContext;
        }
        XMLElement xMLElement = xMLNode.getSrcRoot();
        if (xMLElement == null) {
            return null;
        }
        XSLSourceContext xSLSourceContext = (XSLSourceContext)this.sourceContext.get(xMLElement);
        if (xSLSourceContext != null) {
            return xSLSourceContext;
        }
        XMLDocument xMLDocument = xMLElement.getNodeType() == 9 ? (XMLDocument)xMLElement : (XMLDocument)xMLElement.getOwnerDocument();
        this.addSourceContext(xMLElement, xMLDocument);
        return (XSLSourceContext)this.sourceContext.get(xMLElement);
    }

    XMLElement getSrcRoot() throws XSLException {
        if (this.numSourceContext == 1) {
            return this.onlySrcRoot;
        }
        return this.contextNode.getSrcRoot();
    }

    XMLElement getSrcRoot(XMLNode xMLNode) throws XSLException {
        if (this.numSourceContext == 1) {
            return this.onlySrcRoot;
        }
        return xMLNode.getSrcRoot();
    }

    public XSLExprValue getVariable(NSName nSName, int n) {
        if (n >= 0) {
            return (XSLExprValue)this.varValues.elementAt(this.varValues.size() - n);
        }
        if (n == -2) {
            return (XSLExprValue)this.globalVariables.get(nSName);
        }
        return null;
    }

    void init() {
        this.varValues.setSize(0);
        this.globalVariables.clear();
        this.sourceContext.clear();
        this.documentTable.clear();
        this.srcSpaceElems.clear();
        this.srcSpaceStack.setSize(0);
        this.nsTable.clear();
        this.mpNodeList.reset();
        this.mpNodeList2.reset();
        this.curNodeList.reset();
        this.altNodeList.reset();
        this.onlySrcRoot = null;
        this.onlySourceContext = null;
        this.contextNode = null;
        this.currentNode = null;
        if (this.exprValuePool != null) {
            int n = this.exprValuePool.length;
            int n2 = 0;
            while (n2 < n) {
                this.exprValuePool[n2].reset();
                ++n2;
            }
        }
        if (this.exprHashPool != null) {
            this.exprHashPool.clear();
        }
        if (this.nodeListPool == null) {
            this.nodeListPool = new ObjectPool();
            this.nodeListPool.setClassName("oracle.xml.parser.v2.XSLNodeList");
            this.nodeListPool.setResetMethod("reset");
        }
    }

    boolean isSrcWhiteSpaceMode() throws XSLException {
        return false;
    }

    boolean isSrcWhiteSpacePreserving(XMLElement xMLElement) throws XSLException {
        if (!this.srcSpaceStack.empty()) {
            return (Boolean)this.srcSpaceStack.peek();
        }
        if (this.noWSElem) {
            return true;
        }
        Boolean bl = (Boolean)this.srcSpaceElems.get(xMLElement.getNodeName());
        if (bl == Boolean.TRUE) {
            return true;
        }
        return bl == null && this.checkPreservingWS(xMLElement);
    }

    boolean isStrippedWS(XMLNode xMLNode) throws XSLException {
        return xMLNode.getNodeType() == 3 && ((XMLText)xMLNode).isWhiteSpaceNode() && !this.isSrcWhiteSpacePreserving((XMLElement)xMLNode.getParentNode());
    }

    void popVariable(int n) {
        int n2 = this.varValues.size();
        this.varValues.setSize(n2 -= n);
    }

    void pushVariable(XSLExprValue xSLExprValue) {
        this.varValues.addElement(xSLExprValue);
    }

    public void reportCharacters(String string, boolean bl) throws XSLException {
        if (this.eventHandler != null) {
            this.eventHandler.characters(string, bl);
        }
    }

    public void reportNode(XMLNode xMLNode) throws XSLException {
        if (this.eventHandler == null) {
            return;
        }
        switch (xMLNode.getNodeType()) {
            case 9: 
            case 11: {
                NodeList nodeList = xMLNode.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.reportNode((XMLNode)nodeList.item(n2));
                    ++n2;
                }
                break;
            }
            case 1: {
                NodeList nodeList;
                Hashtable hashtable;
                String string;
                XMLElement xMLElement = (XMLElement)xMLNode;
                this.eventHandler.startElement(xMLElement.getPrefix(), xMLElement.getLocalName(), xMLElement.getNamespace());
                NamedNodeMap namedNodeMap = xMLElement.getAttributes();
                if (namedNodeMap != null) {
                    int n = namedNodeMap.getLength();
                    int n3 = 0;
                    while (n3 < n) {
                        this.reportNode((XMLNode)namedNodeMap.item(n3));
                        ++n3;
                    }
                }
                if ((string = xMLElement.resolveNamespacePrefix("#default")) != null) {
                    this.eventHandler.namespaceAttr("", string);
                }
                if ((hashtable = xMLElement.getAllNamespaceAttrs()) != null) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        String string3 = (String)hashtable.get(string2);
                        this.eventHandler.namespaceAttr(string2, string3);
                    }
                }
                if ((nodeList = xMLElement.getChildNodes()) != null) {
                    int n = nodeList.getLength();
                    int n4 = 0;
                    while (n4 < n) {
                        this.reportNode((XMLNode)nodeList.item(n4));
                        ++n4;
                    }
                }
                this.eventHandler.endElement(xMLElement.getPrefix(), xMLElement.getLocalName(), xMLElement.getNamespace());
                break;
            }
            case 2: {
                XMLAttr xMLAttr = (XMLAttr)xMLNode;
                if (xMLAttr.getPrefix() == "xmlns") {
                    this.eventHandler.namespaceAttr(xMLAttr.getLocalName(), xMLAttr.getNodeValue());
                    break;
                }
                if (xMLAttr.getLocalName() == "xmlns") {
                    this.eventHandler.namespaceAttr("", xMLAttr.getNodeValue());
                    break;
                }
                this.eventHandler.attribute(xMLAttr.getPrefix(), xMLAttr.getLocalName(), xMLAttr.getNamespace(), xMLAttr.getNodeValue());
                break;
            }
            case 7: {
                if (xMLNode instanceof XMLDeclPI) break;
                this.eventHandler.processingInstruction(xMLNode.getNodeName(), xMLNode.getNodeValue());
                break;
            }
            case 8: {
                this.eventHandler.comment(xMLNode.getNodeValue());
                break;
            }
            case 3: {
                boolean bl = false;
                Object object = xMLNode.getProperty("oracle.xml.disable-output-escaping");
                if (object != null) {
                    bl = (Boolean)object;
                }
                this.eventHandler.characters(xMLNode.getNodeValue(), bl);
                break;
            }
        }
    }

    void reset() {
        this.init();
    }

    void resetSrcWhiteSpaceMode() throws XSLException {
        if (!this.srcSpaceStack.empty()) {
            this.srcSpaceStack.pop();
        }
    }

    void setBaseURL(URL uRL) {
        this.baseUrl = uRL;
    }

    void setContextNode(XMLNode xMLNode) {
        this.contextNode = xMLNode;
    }

    void setContextPosition(int n) {
        this.contextPos = n;
    }

    int setContextSize(int n) {
        int n2 = this.contextSize;
        this.contextSize = n;
        return n2;
    }

    void setCurrentNode(XMLNode xMLNode) {
        this.currentNode = xMLNode;
    }

    void setCurrentTmpl(int n) throws XSLException {
        this.currentTmpl = n;
    }

    public void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    void setEventHandler(XSLEventHandler xSLEventHandler) throws XSLException {
        this.eventHandler = xSLEventHandler;
    }

    void setGlobalVariable(NSName nSName, XSLExprValue xSLExprValue) {
        this.globalVariables.put(nSName, xSLExprValue);
    }

    void setParser(DOMParser dOMParser) throws XSLException {
        this.parser = dOMParser;
    }

    void setSpaceInfo(FastVector fastVector) {
        if (fastVector == null || fastVector.size() == 0) {
            return;
        }
        this.spaceElems = fastVector;
        this.noWSElem = false;
    }

    void setSrcWhiteSpaceMode(boolean bl) throws XSLException {
        this.srcSpaceStack.push(new Boolean(bl));
    }

    void setStyleSheet(XSLStylesheet xSLStylesheet) throws XSLException {
        this.xsl = xSLStylesheet;
        int n = this.xsl.exprCount;
        if (this.exprValuePool == null) {
            this.exprValuePool = new XSLExprValue[n];
            int n2 = 0;
            while (n2 < n) {
                this.exprValuePool[n2] = new XSLExprValue(false);
                ++n2;
            }
        } else if (n > this.exprValuePool.length) {
            this.ensureExprValuePoolCapacity(n);
        }
    }
}

