/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.PrintWriter;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprInt;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLNodeList;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;

class XSLSort
extends XSLNode
implements XSLConstants {
    private static final String SELECT_ATTR = "select";
    private static final String ORDER_ATTR = "order";
    private static final String LANG_ATTR = "lang";
    private static final String DATA_TYPE_ATTR = "data-type";
    private static final String CASE_ORDER_ATTR = "case-order";
    private static final String UPPER_FIRST = "upper-first";
    private static final String LOWER_FIRST = "lower-first";
    private static final String ASCENDING_ORDER = "ascending";
    private static final String DESCENDING_ORDER = "descending";
    private static final String TEXT_TYPE = "text";
    private static final String NUMBER_TYPE = "number";
    private XSLSort m_seckey;
    private XSLExprInt m_selectexpr;
    private boolean m_blnTextType = true;
    private String m_strTextType = "text";
    private boolean m_blnAscending = true;
    private String m_strAscending = "ascending";
    private int m_intCaseOrder = 0;
    private String m_strCaseOrder = null;
    private RuleBasedCollator m_usCollator;
    private Collator m_collator;
    private boolean m_blnIsEnglish = true;
    private String m_strLang = "";
    private XSLNode.AttrValueTmpl m_atvText;
    private XSLNode.AttrValueTmpl m_atvAsc;
    private XSLNode.AttrValueTmpl m_atvCaseOrder;
    private boolean m_isATV = false;

    XSLSort(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
    }

    void addSecondaryKey(XSLSort xSLSort) throws XSLException {
        if (this.m_seckey == null) {
            this.m_seckey = xSLSort;
        } else {
            this.m_seckey.addSecondaryKey(xSLSort);
        }
    }

    private int compareAsNumber(String string, String string2) throws XSLException {
        double d;
        double d2;
        try {
            d2 = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 0.0;
        }
        try {
            d = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 == d) {
            return 0;
        }
        return 1;
    }

    private int compareObjects(Object object, Object object2) throws XSLException {
        String string = "";
        String string2 = "";
        if (object != null) {
            string = object.toString();
        }
        if (object2 != null) {
            string2 = object2.toString();
        }
        int n = this.m_blnTextType ? (this.m_blnIsEnglish ? this.m_usCollator.compare(string, string2) : this.m_collator.compare(string, string2)) : this.compareAsNumber(string, string2);
        if (!this.m_blnAscending) {
            n = -n;
        }
        return n;
    }

    private void fillRuleBaseTables(XSLTContext xSLTContext) throws XSLException {
        String string;
        String string2;
        if (this.m_intCaseOrder == 1 && this.m_blnAscending || this.m_intCaseOrder == 2 && !this.m_blnAscending) {
            string2 = "< A < a < B < b < C < c < D < d < E < e < F < f < G < g < H < h < I < i < J < j < K < k < L < l < M < m < N < n < O < o < P < p < Q < q < R < r < S < s < T < t < U < u < V < v < W < w < X < x < Y < y < Z < z";
            string = UPPER_FIRST;
        } else if (this.m_intCaseOrder == 2 && this.m_blnAscending || this.m_intCaseOrder == 1 && !this.m_blnAscending) {
            string2 = "< a < A < b < B < c < C < d < D < e < E < f < F < g < G < h < H < i < I < j < J < k < K < l < L < m < M < n < N < o < O < p < P < q < Q < r < R < s < S < t < T < u < U < v < V < w < W < x < X < y < Y < z < Z ";
            string = LOWER_FIRST;
        } else {
            string2 = "< a < b < c < d < e < f < g < h < i < j < k < l < m < n < o < p < q < r < s < t < u < v < w < x < y < z < A < B < C < D < E < F < G < H < I < J < K < L < M < N < O < P < Q < R < S < T < U < V < W < X < Y < Z";
            string = "no case-order";
        }
        try {
            this.m_usCollator = new RuleBasedCollator(string2);
        }
        catch (ParseException parseException) {
            XMLError xMLError = xSLTContext.getError();
            xMLError.error2(1030, 2, string, CASE_ORDER_ATTR);
        }
    }

    public void finalize() throws XSLException {
        if (this.m_seckey != null) {
            this.m_seckey.finalize();
        }
        super.finalize();
    }

    private Locale getLocale() throws XSLException {
        Locale locale = Locale.getDefault();
        if (this.m_strLang == "") {
            return locale;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_strLang, "-");
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return new Locale(string, string2);
    }

    void handleLanguageCollator() throws XSLException {
        Locale locale = this.getLocale();
        String string = locale.getLanguage();
        if (string == null || string.length() == 0 || string.equals("en")) {
            this.m_blnIsEnglish = true;
        } else {
            this.m_collator = Collator.getInstance(locale);
            this.m_collator.setStrength(2);
            this.m_blnIsEnglish = false;
        }
    }

    private int partitionIt(int n, int n2, Object object, String[] stringArray) throws XSLException {
        int n3 = n - 1;
        int n4 = n2;
        while (true) {
            if (this.compareObjects(stringArray[++n3], object) < 0) {
                continue;
            }
            while (n4 > 0 && this.compareObjects(stringArray[--n4], object) > 0) {
            }
            if (n3 >= n4) break;
            this.swap(n3, n4, stringArray);
        }
        this.swap(n3, n2, stringArray);
        return n3;
    }

    private void prepareAttributeTemplateValue(XSLTContext xSLTContext) throws XSLException {
        String string = null;
        string = this.m_atvText != null ? this.m_atvText.getValue(xSLTContext).intern() : this.m_strTextType;
        this.m_blnTextType = string != NUMBER_TYPE;
        string = this.m_atvAsc != null ? this.m_atvAsc.getValue(xSLTContext).intern() : this.m_strAscending;
        if (string == DESCENDING_ORDER) {
            this.m_blnAscending = false;
        } else if (string == ASCENDING_ORDER) {
            this.m_blnAscending = true;
        }
        string = this.m_atvCaseOrder != null ? this.m_atvCaseOrder.getValue(xSLTContext).intern() : this.m_strCaseOrder;
        if (string == UPPER_FIRST) {
            this.m_intCaseOrder = 1;
        } else if (string == LOWER_FIRST) {
            this.m_intCaseOrder = 2;
        }
        if (this.m_usCollator == null || this.m_isATV) {
            this.fillRuleBaseTables(xSLTContext);
        }
    }

    void printChildren(PrintWriter printWriter, int n) {
        if (this.m_seckey != null) {
            this.m_seckey.printXSLNode(printWriter, n);
        }
        super.printChildren(printWriter, n);
    }

    private void quicksortObjects(int n, int n2, String[] stringArray) throws XSLException {
        if (n2 - n <= 0) {
            return;
        }
        String string = stringArray[n2];
        int n3 = this.partitionIt(n, n2, string, stringArray);
        this.quicksortObjects(n, n3 - 1, stringArray);
        this.quicksortObjects(n3 + 1, n2, stringArray);
    }

    private String[] quicksortObjects(String[] stringArray, int n) throws XSLException {
        this.quicksortObjects(0, n - 1, stringArray);
        return stringArray;
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        XSLSort xSLSort = this;
        xSLSort.getClass();
        XSLNode.AttrValueTmpl attrValueTmpl = xSLSort.new XSLNode.AttrValueTmpl(string4, this);
        boolean bl = this.m_isATV = attrValueTmpl.isAttrValueTmpl() || this.m_isATV;
        if (string == "") {
            if (string3 == SELECT_ATTR) {
                this.m_selectexpr = XSLExprBase.createStringExpr(string4, this, this.xss);
            } else if (string3 == DATA_TYPE_ATTR) {
                this.m_strTextType = string4;
                XSLSort xSLSort2 = this;
                xSLSort2.getClass();
                this.m_atvText = xSLSort2.new XSLNode.AttrValueTmpl(this.m_strTextType, this);
            } else if (string3 == ORDER_ATTR) {
                this.m_strAscending = string4;
                XSLSort xSLSort3 = this;
                xSLSort3.getClass();
                this.m_atvAsc = xSLSort3.new XSLNode.AttrValueTmpl(this.m_strAscending, this);
            } else if (string3 == LANG_ATTR) {
                this.m_strLang = string4.intern();
            } else if (string3 == CASE_ORDER_ATTR) {
                this.m_strCaseOrder = string4;
                XSLSort xSLSort4 = this;
                xSLSort4.getClass();
                this.m_atvCaseOrder = xSLSort4.new XSLNode.AttrValueTmpl(this.m_strCaseOrder, this);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    XSLNodeList sortNodes(XSLTContext xSLTContext, XSLNodeList xSLNodeList) throws XSLException {
        int n = xSLNodeList.getLength();
        if (n == 0) {
            return xSLNodeList;
        }
        xSLTContext.setContextSize(n);
        XMLNode[] xMLNodeArray = new XMLNode[n];
        int n2 = 0;
        while (n2 < n) {
            xMLNodeArray[n2] = (XMLNode)xSLNodeList.item(n2);
            ++n2;
        }
        XMLNode[] xMLNodeArray2 = this.sorting(xSLTContext, xMLNodeArray, n);
        XSLNodeList xSLNodeList2 = new XSLNodeList(n);
        n2 = 0;
        while (n2 < n) {
            xSLNodeList2.addNode(xMLNodeArray2[n2]);
            ++n2;
        }
        return xSLNodeList2;
    }

    private XMLNode[] sorting(XSLTContext xSLTContext, XMLNode[] xMLNodeArray, int n) throws XSLException {
        Vector<XMLNode> vector;
        this.prepareAttributeTemplateValue(xSLTContext);
        Hashtable<String, Vector<XMLNode>> hashtable = new Hashtable<String, Vector<XMLNode>>(20);
        Vector<XMLNode> vector2 = new Vector<XMLNode>();
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            XMLNode xMLNode = xMLNodeArray[n3];
            xSLTContext.setContextPosition(n3 + 1);
            xSLTContext.setContextNode(xMLNode);
            String string = this.m_selectexpr.getStringValue(xSLTContext);
            if (string.length() == 0) {
                vector2.addElement(xMLNode);
            } else {
                vector = (Vector<XMLNode>)hashtable.get(string);
                if (vector == null) {
                    vector = new Vector<XMLNode>();
                    vector.addElement(xMLNode);
                    hashtable.put(string, vector);
                    stringArray[n2++] = string;
                } else {
                    vector.addElement(xMLNode);
                }
            }
            ++n3;
        }
        String[] stringArray2 = this.quicksortObjects(stringArray, n2);
        XMLNode[] xMLNodeArray2 = new XMLNode[n];
        int n4 = 0;
        n3 = 0;
        while (n3 < vector2.size()) {
            xMLNodeArray2[n4++] = (XMLNode)vector2.elementAt(n3);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            int n5;
            vector = (Vector)hashtable.get(stringArray2[n3]);
            int n6 = vector.size();
            if (this.m_seckey != null) {
                if (n6 > 1) {
                    Object[] objectArray = new XMLNode[n6];
                    vector.copyInto(objectArray);
                    objectArray = this.m_seckey.sorting(xSLTContext, (XMLNode[])objectArray, n6);
                    n5 = 0;
                    while (n5 < n6) {
                        xMLNodeArray2[n4++] = objectArray[n5];
                        ++n5;
                    }
                } else {
                    xMLNodeArray2[n4++] = (XMLNode)vector.elementAt(0);
                }
            } else {
                n5 = 0;
                while (n5 < n6) {
                    xMLNodeArray2[n4++] = (XMLNode)vector.elementAt(n5);
                    ++n5;
                }
            }
            ++n3;
        }
        return xMLNodeArray2;
    }

    public void startContent() throws XSLException {
        if (this.m_selectexpr == null) {
            this.m_selectexpr = XSLExprBase.createStringExpr(".", this, this.xss);
        }
        this.handleLanguageCollator();
    }

    private void swap(int n, int n2, String[] stringArray) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
    }
}

