/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XPathException;
import oracle.xml.parser.v2.XSLBuilder;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLDocumentBuilder;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLOutput;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.util.NSNameImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLProcessor
implements XSLConstants {
    URL baseURL;
    SAXParser parser;
    XSLBuilder xslBuilder;
    DocumentBuilder docBuilder;
    LexicalHandler lexHandler;
    XSLEventHandler eventHandler;
    XSLTContext context = new XSLTContext();
    Hashtable params;
    XMLError err;
    OutputStream errOut;
    boolean warnings;
    Locale errLocale;
    boolean extencspecified = false;
    String extEncoding;
    static XMLContentHandler sLexHandler = new XMLContentHandler();
    XSLOutput m_xslOutput = null;

    public XSLProcessor() {
        this.parser = new SAXParser();
        this.xslBuilder = new XSLBuilder();
        this.docBuilder = new DocumentBuilder();
        this.eventHandler = new XSLEventHandler();
        this.lexHandler = sLexHandler;
    }

    public Object getParam(String string) {
        Object var2_2 = null;
        if (this.params != null) {
            NSNameImpl nSNameImpl = new NSNameImpl("", JXUtil.getLocalName(string), JXUtil.getURI(string));
            var2_2 = this.params.get(nSNameImpl);
        }
        return var2_2;
    }

    public Object getParam(String string, String string2) throws XSLException {
        Object var3_3 = null;
        if (this.params != null) {
            NSNameImpl nSNameImpl = new NSNameImpl("", string2, string);
            var3_3 = this.params.get(nSNameImpl);
        }
        return var3_3;
    }

    private XSLSAXPrintDriver getPrintHandler(XSLStylesheet xSLStylesheet, OutputStream outputStream) throws IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.m_xslOutput == null ? new XSLSAXPrintDriver(outputStream, xSLStylesheet.output) : new XSLSAXPrintDriver(outputStream, this.m_xslOutput);
        if (this.extencspecified) {
            xSLSAXPrintDriver.setOutputEncoding(this.extEncoding);
        }
        return xSLSAXPrintDriver;
    }

    private XSLSAXPrintDriver getPrintHandler(XSLStylesheet xSLStylesheet, PrintWriter printWriter) throws IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.m_xslOutput == null ? new XSLSAXPrintDriver(printWriter, xSLStylesheet.output) : new XSLSAXPrintDriver(printWriter, this.m_xslOutput);
        if (this.extencspecified) {
            xSLSAXPrintDriver.setOutputEncoding(this.extEncoding);
        }
        return xSLSAXPrintDriver;
    }

    private void init() {
        if (this.err != null) {
            this.err.reset();
        } else {
            this.err = new XMLError();
            if (this.errOut != null) {
                this.err.setErrorStream(this.errOut);
            }
            if (this.errLocale != null) {
                this.err.setLocale(this.errLocale);
            }
            this.err.showWarnings(this.warnings);
        }
        this.context.init();
        this.context.setError(this.err);
        this.docBuilder.reset();
        this.docBuilder.err = this.err;
        this.docBuilder.retainCDATASection(false);
        this.xslBuilder.reset();
        this.xslBuilder.setError(this.err);
        this.parser.reset();
        this.parser.setError(this.err);
        this.parser.setPreserveWhitespace(true);
    }

    public XSLStylesheet newXSLStylesheet(InputStream inputStream) throws XSLException {
        try {
            this.init();
            this.parser.setContentHandler(this.xslBuilder);
            this.parser.parse(inputStream);
        }
        catch (Exception exception) {
            this.reportException(exception, 1000);
        }
        return this.xslBuilder.getStylesheet();
    }

    public XSLStylesheet newXSLStylesheet(Reader reader) throws XSLException {
        try {
            this.init();
            this.parser.setContentHandler(this.xslBuilder);
            this.parser.parse(reader);
        }
        catch (Exception exception) {
            this.reportException(exception, 1000);
        }
        return this.xslBuilder.getStylesheet();
    }

    public XSLStylesheet newXSLStylesheet(URL uRL) throws XSLException {
        try {
            this.init();
            this.parser.setContentHandler(this.xslBuilder);
            this.parser.parse(uRL);
        }
        catch (Exception exception) {
            this.reportException(exception, 1000);
        }
        return this.xslBuilder.getStylesheet();
    }

    public XSLStylesheet newXSLStylesheet(XMLDocument xMLDocument) throws XSLException {
        try {
            this.init();
            xMLDocument.reportSAXEvents(this.xslBuilder);
        }
        catch (Exception exception) {
            this.reportException(exception, 1900);
        }
        XSLStylesheet xSLStylesheet = this.xslBuilder.getStylesheet();
        xSLStylesheet.setDocument(xMLDocument);
        return xSLStylesheet;
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, InputStream inputStream, URL uRL) throws XSLException {
        try {
            try {
                this.init();
                this.docBuilder.setDebugMode(xSLStylesheet.debugFlag);
                this.parser.setContentHandler(this.docBuilder);
                this.parser.setBaseURL(uRL);
                this.parser.parse(inputStream);
            }
            catch (Exception exception) {
                this.reportException(exception, 1005);
            }
            Object var5_5 = null;
            this.parser.setBaseURL(this.baseURL);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.parser.setBaseURL(this.baseURL);
            throw throwable;
        }
        XMLDocument xMLDocument = this.docBuilder.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, Reader reader, URL uRL) throws XSLException {
        try {
            try {
                this.init();
                this.docBuilder.setDebugMode(xSLStylesheet.debugFlag);
                this.parser.setContentHandler(this.docBuilder);
                this.parser.setBaseURL(uRL);
                this.parser.parse(reader);
            }
            catch (Exception exception) {
                this.reportException(exception, 1007);
            }
            Object var5_5 = null;
            this.parser.setBaseURL(this.baseURL);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.parser.setBaseURL(this.baseURL);
            throw throwable;
        }
        XMLDocument xMLDocument = this.docBuilder.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, URL uRL, URL uRL2) throws XSLException {
        try {
            try {
                this.init();
                this.docBuilder.setDebugMode(xSLStylesheet.debugFlag);
                this.parser.setContentHandler(this.docBuilder);
                this.parser.setBaseURL(uRL2);
                this.parser.parse(uRL);
            }
            catch (Exception exception) {
                this.reportException(exception, 1006);
            }
            Object var5_5 = null;
            this.parser.setBaseURL(this.baseURL);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.parser.setBaseURL(this.baseURL);
            throw throwable;
        }
        XMLDocument xMLDocument = this.docBuilder.getDocument();
        return this.processXSL(xSLStylesheet, xMLDocument);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument) throws XSLException {
        XSLDocumentBuilder xSLDocumentBuilder = new XSLDocumentBuilder();
        XMLDocumentFragment xMLDocumentFragment = null;
        this.lexHandler = xSLDocumentBuilder;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xSLDocumentBuilder);
        xMLDocumentFragment = xSLDocumentBuilder.getResultFragment();
        return xMLDocumentFragment;
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, OutputStream outputStream) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, outputStream);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, PrintWriter printWriter) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, printWriter);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        XMLContentHandler xMLContentHandler = new XMLContentHandler(xMLDocumentHandler);
        this.lexHandler = xMLContentHandler;
        this.processXSL(xSLStylesheet, xMLDocument, (ContentHandler)xMLContentHandler);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocument xMLDocument, ContentHandler contentHandler) throws XSLException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocument, contentHandler);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment) throws XSLException {
        return this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, OutputStream outputStream) throws XSLException, IOException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment, outputStream);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, PrintWriter printWriter) throws XSLException, IOException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment, printWriter);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLDocumentFragment xMLDocumentFragment, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        this.processXSL(xSLStylesheet, (XMLElement)xMLDocumentFragment, xMLDocumentHandler);
    }

    public XMLDocumentFragment processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement) throws XSLException {
        XSLDocumentBuilder xSLDocumentBuilder = new XSLDocumentBuilder();
        XMLDocumentFragment xMLDocumentFragment = null;
        this.lexHandler = xSLDocumentBuilder;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xSLDocumentBuilder);
        xMLDocumentFragment = xSLDocumentBuilder.getResultFragment();
        return xMLDocumentFragment;
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, OutputStream outputStream) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, outputStream);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, PrintWriter printWriter) throws XSLException, IOException {
        XSLSAXPrintDriver xSLSAXPrintDriver = this.getPrintHandler(xSLStylesheet, printWriter);
        this.lexHandler = xSLSAXPrintDriver;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xSLSAXPrintDriver);
        xSLSAXPrintDriver.flush();
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, XMLDocumentHandler xMLDocumentHandler) throws XSLException {
        XMLContentHandler xMLContentHandler = new XMLContentHandler(xMLDocumentHandler);
        this.lexHandler = xMLContentHandler;
        this.processXSL(xSLStylesheet, xMLElement, (ContentHandler)xMLContentHandler);
    }

    public void processXSL(XSLStylesheet xSLStylesheet, XMLElement xMLElement, ContentHandler contentHandler) throws XSLException {
        try {
            block8: {
                try {
                    this.init();
                    this.eventHandler.reset(contentHandler, this.lexHandler, this.context);
                    if (xMLElement instanceof XMLDocument) {
                        this.context.addSourceContext(xMLElement, (XMLDocument)xMLElement);
                    } else {
                        this.context.addSourceContext(xMLElement.getSrcRoot(), (XMLDocument)xMLElement.getOwnerDocument());
                    }
                    this.context.setEventHandler(this.eventHandler);
                    this.context.setContextSize(1);
                    this.context.setContextPosition(1);
                    this.context.setContextNode(xMLElement);
                    this.context.setStyleSheet(xSLStylesheet);
                    if (this.params != null) {
                        xSLStylesheet.execute(this.context, this.params);
                    } else {
                        xSLStylesheet.execute(this.context);
                    }
                }
                catch (XSLException xSLException) {
                    if (xSLException.getMessage().equals("TERMINATE PROCESSING")) break block8;
                    throw xSLException;
                }
            }
            Object var5_5 = null;
            this.context.reset();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.context.reset();
            this.eventHandler.flushEvents();
            this.lexHandler = sLexHandler;
            throw throwable;
        }
        this.eventHandler.flushEvents();
        this.lexHandler = sLexHandler;
    }

    public void removeParam(String string, String string2) throws XSLException {
        if (this.params != null) {
            this.params.remove(new NSNameImpl("", string2, string));
        }
    }

    private void reportException(Exception exception, int n) throws XSLException {
        if (exception instanceof SAXException) {
            Exception exception2 = ((SAXException)exception).getException();
            if (exception2 != null) {
                if (exception2 instanceof XPathException) {
                    XPathException xPathException = (XPathException)exception2;
                    this.err.error(xPathException.errId, 1, xPathException.errParams);
                } else {
                    if (exception2 instanceof XSLException) {
                        throw (XSLException)exception2;
                    }
                    this.reportException(exception2, n);
                }
            } else {
                this.err.error1(n, 1, exception.getMessage());
            }
        } else if (!(exception instanceof XMLParseException)) {
            this.err.error1(n, 1, exception.getMessage());
        }
        try {
            this.err.flushErrorStream();
        }
        catch (IOException iOException) {
            this.err.setException(iOException);
            this.err.error1(1900, 1, iOException.getMessage());
        }
        throw new XSLException(this.err, this.err.getFirstError(), exception);
    }

    public void resetParams() throws XSLException {
        if (this.params != null) {
            this.params.clear();
        }
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
        this.parser.setBaseURL(uRL);
        this.xslBuilder.setBaseURL(uRL);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
        this.xslBuilder.setEntityResolver(entityResolver);
    }

    public final void setErrorStream(OutputStream outputStream) throws IOException {
        this.errOut = outputStream;
    }

    public void setLocale(Locale locale) {
        this.errLocale = locale;
    }

    public void setOutputEncoding(String string) {
        this.extencspecified = true;
        this.extEncoding = string;
    }

    public void setParam(String string, String string2, Object object) throws XSLException {
        if (this.params == null) {
            this.params = new Hashtable(20);
        }
        this.params.put(new NSNameImpl("", string2, string), object);
    }

    public void setXSLOutput(XSLOutput xSLOutput) {
        this.m_xslOutput = xSLOutput;
    }

    public final void showWarnings(boolean bl) {
        this.warnings = bl;
    }
}

