/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XPathException;
import oracle.xml.parser.v2.XSLExprConstants;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.util.XMLUtil;

class XSLParseString
implements XSLExprConstants {
    char[] str;
    private int length;
    int pos;
    int prevPos = 0;
    int lookahead;
    String name;
    boolean exprStart = true;
    String nameSpace = "";
    int classtype;
    XSLStylesheet xss;
    NSResolver nsr;
    static final int[] chartype = new int[256];
    static final int FWHITESPACE = 1;
    static final int FDIGIT = 2;
    static final int FLETTER = 4;
    static final int FMISCNAME = 8;
    static final int FSTARTNAME = 16;
    static Hashtable functionnames = new Hashtable(20);
    static Hashtable axisnames = new Hashtable(20);

    static {
        int n = 0;
        while (n < 256) {
            char c = (char)n;
            XSLParseString.chartype[n] = 0;
            if (Character.isLetter(c)) {
                int n2 = n;
                chartype[n2] = chartype[n2] | 4;
            }
            if (Character.isDigit(c)) {
                int n3 = n;
                chartype[n3] = chartype[n3] | 2;
            }
            ++n;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
        functionnames.put("count", new Integer(-23));
        functionnames.put("position", new Integer(-24));
        functionnames.put("last", new Integer(-25));
        functionnames.put("id", new Integer(-26));
        functionnames.put("key", new Integer(-28));
        functionnames.put("document", new Integer(-30));
        functionnames.put("local-name", new Integer(-32));
        functionnames.put("namespace-uri", new Integer(-33));
        functionnames.put("name", new Integer(-34));
        functionnames.put("generate-id", new Integer(-35));
        functionnames.put("current", new Integer(-156));
        axisnames.put("ancestor", new Integer(-40));
        axisnames.put("ancestor-or-self", new Integer(-41));
        axisnames.put("attribute", new Integer(-42));
        axisnames.put("child", new Integer(-43));
        axisnames.put("descendant", new Integer(-44));
        axisnames.put("descendant-or-self", new Integer(-45));
        axisnames.put("following", new Integer(-46));
        axisnames.put("following-sibling", new Integer(-47));
        axisnames.put("parent", new Integer(-48));
        axisnames.put("preceding", new Integer(-49));
        axisnames.put("preceding-sibling", new Integer(-50));
        axisnames.put("self", new Integer(-51));
        axisnames.put("namespace", new Integer(-52));
        functionnames.put("not", new Integer(-151));
        functionnames.put("true", new Integer(-152));
        functionnames.put("false", new Integer(-153));
        functionnames.put("boolean", new Integer(-154));
        functionnames.put("lang", new Integer(-155));
        functionnames.put("number", new Integer(-81));
        functionnames.put("floor", new Integer(-82));
        functionnames.put("ceiling", new Integer(-83));
        functionnames.put("round", new Integer(-84));
        functionnames.put("sum", new Integer(-85));
        functionnames.put("string", new Integer(-91));
        functionnames.put("starts-with", new Integer(-92));
        functionnames.put("contains", new Integer(-93));
        functionnames.put("substring-before", new Integer(-94));
        functionnames.put("substring-after", new Integer(-95));
        functionnames.put("normalize-space", new Integer(-96));
        functionnames.put("translate", new Integer(-97));
        functionnames.put("concat", new Integer(-98));
        functionnames.put("format-number", new Integer(-99));
        functionnames.put("substring", new Integer(-100));
        functionnames.put("string-length", new Integer(-101));
        functionnames.put("system-property", new Integer(-110));
        functionnames.put("function-available", new Integer(-111));
        functionnames.put("element-available", new Integer(-112));
        functionnames.put("unparsed-entity-uri", new Integer(-113));
        functionnames.put("processing-instruction", new Integer(-36));
        functionnames.put("text", new Integer(-37));
        functionnames.put("comment", new Integer(-38));
        functionnames.put("node", new Integer(-39));
    }

    XSLParseString(String string, NSResolver nSResolver, XSLStylesheet xSLStylesheet) {
        this(string.toCharArray(), 0, nSResolver, xSLStylesheet);
    }

    XSLParseString(char[] cArray, int n, NSResolver nSResolver) {
        this.str = cArray;
        this.pos = n;
        this.length = cArray.length;
        this.nsr = nSResolver;
    }

    XSLParseString(char[] cArray, int n, NSResolver nSResolver, XSLStylesheet xSLStylesheet) {
        this.str = cArray;
        this.pos = n;
        this.length = cArray.length;
        this.nsr = nSResolver;
        this.xss = xSLStylesheet;
    }

    private int findAxisId(String string) throws XPathException {
        Integer n = (Integer)axisnames.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    private int findFunctionId(String string) throws XPathException {
        Integer n = (Integer)functionnames.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    String getCurrentToken() throws XPathException {
        return new String(this.str, this.prevPos, this.pos - this.prevPos);
    }

    private String getLiteral(int n) throws XPathException {
        int n2 = this.pos;
        while (this.pos < this.length && this.str[this.pos] == ' ') {
            ++this.pos;
        }
        while (this.pos < this.length && this.str[this.pos++] != n) {
        }
        if (this.str[this.pos - 1] != n || this.pos - n2 == 0) {
            throw new XPathException(1023);
        }
        this.name = new String(this.str, n2, this.pos - n2 - 1);
        this.name = this.replaceEntityRef_1_1_8(this.name);
        return this.name;
    }

    private String getNumber() {
        int n = this.pos;
        if (Character.isDigit(this.str[this.pos])) {
            ++this.pos;
            while (this.pos < this.length && Character.isDigit(this.str[this.pos++])) {
            }
            if (!Character.isDigit(this.str[this.pos - 1])) {
                --this.pos;
            }
            if (this.pos < this.length && this.str[this.pos] == '.') {
                ++this.pos;
                while (this.pos < this.length && Character.isDigit(this.str[this.pos++])) {
                }
                if (!Character.isDigit(this.str[this.pos - 1])) {
                    --this.pos;
                }
            }
            this.classtype = -21;
        } else if (this.str[this.pos] == '.') {
            ++this.pos;
            while (this.pos < this.length && Character.isDigit(this.str[this.pos++])) {
            }
            if (!Character.isDigit(this.str[this.pos - 1])) {
                --this.pos;
            }
            this.classtype = -21;
        }
        return new String(this.str, n, this.pos - n).intern();
    }

    private String getQname() {
        int n = this.pos;
        if (XMLUtil.isFirstNameChar(this.str[this.pos])) {
            ++this.pos;
            while (this.pos < this.length && XMLUtil.isNameChar(this.str[this.pos++])) {
            }
            if (!XMLUtil.isNameChar(this.str[this.pos - 1])) {
                --this.pos;
            }
            return new String(this.str, n, this.pos - n).intern();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(char var1_1) throws XPathException {
        this.prevPos = this.pos;
        this.exprStart = false;
        if (this.pos < this.length) ** GOTO lbl6
        throw new XPathException(1019, String.valueOf(var1_1), "EOF");
lbl-1000:
        // 1 sources

        {
            ++this.pos;
lbl6:
            // 2 sources

            ** while (this.pos < this.length && this.str[this.pos] == ' ')
        }
lbl7:
        // 1 sources

        if (this.str[this.pos] == var1_1) {
            ++this.pos;
            return true;
        }
        if (this.pos >= this.length) {
            throw new XPathException(1019, String.valueOf(var1_1), "EOF");
        }
        throw new XPathException(1019, String.valueOf(var1_1), String.valueOf(this.str[this.pos]));
    }

    /*
     * Unable to fully structure code
     */
    public int nextToken() throws XPathException {
        var1_1 = "";
        var2_2 = this.lookahead;
        var3_3 = this.classtype;
        this.prevPos = this.pos;
        this.classtype = 0;
        this.nameSpace = "";
        while (this.pos < this.length && this.str[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            this.lookahead = -1;
            return -1;
        }
        switch (this.str[this.pos++]) {
            case '.': {
                if (this.pos < this.length && this.str[this.pos] == '.') {
                    this.lookahead = -3;
                    ++this.pos;
                    break;
                }
                if (this.pos < this.length && Character.isDigit(this.str[this.pos])) {
                    --this.pos;
                    this.name = this.getNumber();
                    this.lookahead = -21;
                    break;
                }
                this.lookahead = 46;
                break;
            }
            case ',': {
                this.lookahead = 44;
                break;
            }
            case '[': {
                this.lookahead = 91;
                break;
            }
            case ']': {
                this.lookahead = 93;
                break;
            }
            case '!': {
                if (this.pos < this.length && this.str[this.pos] == '=') {
                    this.lookahead = -61;
                    ++this.pos;
                    break;
                }
                throw new XPathException(1033);
            }
            case '=': {
                this.lookahead = 61;
                break;
            }
            case '<': {
                if (this.pos < this.length && this.str[this.pos] == '=') {
                    this.lookahead = -53;
                    ++this.pos;
                } else {
                    this.lookahead = 60;
                }
                this.classtype = -70;
                break;
            }
            case '>': {
                if (this.pos < this.length && this.str[this.pos] == '=') {
                    this.lookahead = -54;
                    ++this.pos;
                } else {
                    this.lookahead = 62;
                }
                this.classtype = -70;
                break;
            }
            case '+': {
                this.lookahead = 43;
                this.classtype = -71;
                break;
            }
            case '-': {
                this.lookahead = 45;
                this.classtype = -71;
                break;
            }
            case '{': {
                this.lookahead = 123;
                break;
            }
            case '}': {
                this.lookahead = 125;
                break;
            }
            case '@': {
                if (this.pos < this.length && this.str[this.pos] == '*') {
                    this.lookahead = -11;
                    this.name = "*";
                    this.nameSpace = null;
                    ++this.pos;
                    break;
                }
                this.name = this.getQname();
                if (this.name == null) {
                    throw new XPathException(1013, new String(this.str));
                }
                if (this.pos < this.length && this.str[this.pos] == ':') {
                    ++this.pos;
                    var1_1 = this.name;
                    this.nameSpace = this.nsr.resolveNamespacePrefix(var1_1);
                    if (this.nameSpace == "" || this.nameSpace == null) {
                        throw new XPathException(1008, var1_1);
                    }
                    if (this.pos < this.length && this.str[this.pos] == '*') {
                        ++this.pos;
                        this.name = "*";
                        this.lookahead = -59;
                        break;
                    }
                    this.name = this.getQname();
                    this.lookahead = -12;
                    break;
                }
                this.lookahead = -12;
                break;
            }
            case '/': {
                if (this.pos < this.length && this.str[this.pos] == '/') {
                    ++this.pos;
                    this.lookahead = -2;
                    break;
                }
                this.lookahead = 47;
                break;
            }
            case '|': {
                this.lookahead = 124;
                break;
            }
            case '*': {
                this.lookahead = 42;
                this.name = "*";
                this.nameSpace = null;
                if (this.exprStart) {
                    this.classtype = 0;
                    break;
                }
                this.classtype = -72;
                break;
            }
            case '\"': 
            case '\'': {
                this.lookahead = this.str[this.pos - 1];
                this.name = this.getLiteral(this.lookahead);
                this.classtype = -200;
                break;
            }
            case ')': {
                this.lookahead = 41;
                break;
            }
            case '(': {
                this.lookahead = 40;
                break;
            }
            case '$': {
                this.lookahead = -201;
                this.classtype = -201;
                this.name = this.getQname();
                if (this.pos >= this.length || this.str[this.pos] != ':') break;
                ++this.pos;
                var1_1 = this.name;
                this.nameSpace = this.nsr.resolveNamespacePrefix(var1_1);
                if (this.nameSpace == "" || this.nameSpace == null) {
                    throw new XPathException(1034, var1_1);
                }
                this.name = this.getQname();
                break;
            }
            default: {
                --this.pos;
                this.name = this.getQname();
                if (this.name != null) ** GOTO lbl150
                this.name = this.getNumber();
                this.lookahead = -21;
                break;
lbl-1000:
                // 1 sources

                {
                    ++this.pos;
lbl150:
                    // 2 sources

                    ** while (this.pos < this.length && this.str[this.pos] == ' ')
                }
lbl151:
                // 1 sources

                if (!this.exprStart) {
                    if (this.name.equals("and")) {
                        this.classtype = -13;
                    } else if (this.name.equals("or")) {
                        this.classtype = -14;
                    } else if (this.name.equals("div")) {
                        this.classtype = -72;
                    } else if (this.name.equals("mod")) {
                        this.classtype = -72;
                    }
                }
                if (this.classtype != 0) break;
                if (this.pos < this.length && this.str[this.pos] == '(') {
                    ++this.pos;
                    this.lookahead = this.findFunctionId(this.name);
                    if (this.lookahead == 0) {
                        throw new XPathException(1015, this.name);
                    }
                    this.classtype = -22;
                    break;
                }
                if (this.pos < this.length - 1 && this.str[this.pos] == ':' && this.str[this.pos + 1] == ':') {
                    this.pos += 2;
                    this.lookahead = this.findAxisId(this.name);
                    if (this.lookahead == 0) {
                        throw new XPathException(1035, this.name);
                    }
                    this.classtype = -60;
                    break;
                }
                this.lookahead = -9;
                if (this.pos >= this.length || this.str[this.pos] != ':') break;
                ++this.pos;
                var1_1 = this.name;
                this.nameSpace = this.nsr.resolveNamespacePrefix(var1_1);
                if (this.nameSpace == "" || this.nameSpace == null) {
                    throw new XPathException(1008, var1_1);
                }
                if (this.pos < this.length && this.str[this.pos] == '*') {
                    ++this.pos;
                    this.name = "*";
                    this.lookahead = -58;
                    break;
                }
                this.name = this.getQname();
                while (this.pos < this.length && this.str[this.pos] == ' ') {
                    ++this.pos;
                }
                if (this.pos >= this.length || this.str[this.pos] != '(') break;
                ++this.pos;
                if (!this.nameSpace.equals("http://www.oracle.com/XSL/Transform/java")) {
                    if (this.nameSpace.startsWith("http://www.oracle.com/XSL/Transform/java/")) {
                        this.nameSpace = this.nameSpace.substring("http://www.oracle.com/XSL/Transform/java/".length());
                    } else {
                        throw new XPathException(1016, "http://www.oracle.com/XSL/Transform/java/");
                    }
                }
                this.nameSpace = this.nameSpace.intern();
                this.classtype = -57;
            }
        }
        this.exprStart = this.lookahead == 91 || this.lookahead == 61 || this.lookahead == -61 || this.classtype == -70 || this.classtype == -71 || this.lookahead == 124 || this.lookahead == 47 || this.lookahead == -2 || this.classtype == -72 || this.lookahead == 40 || this.classtype == -13 || this.classtype == -14 || this.classtype == -60;
        return this.lookahead;
    }

    private String replaceEntityRef_1_1_8(String string) {
        string = this.replaceEntityRef_1_1_8(string, "&apos;", "'");
        string = this.replaceEntityRef_1_1_8(string, "&quot;", "\"");
        string = this.replaceEntityRef_1_1_8(string, "&lt;", "<");
        string = this.replaceEntityRef_1_1_8(string, "&gt;", ">");
        string = this.replaceEntityRef_1_1_8(string, "&amp;", "&");
        return string;
    }

    private String replaceEntityRef_1_1_8(String string, String string2, String string3) {
        int n = -1;
        String string4 = null;
        String string5 = null;
        n = string.indexOf(string2);
        while (n != -1) {
            int n2 = n;
            int n3 = n2 + string2.length();
            string4 = string.substring(0, n2);
            string5 = string.substring(n3);
            string = String.valueOf(string4) + string3 + string5;
            n = string.indexOf(string2);
        }
        return string;
    }
}

