/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.OutputKeys;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;

public class XSLOutput
extends XSLNode
implements XSLConstants {
    String method;
    String version;
    String encoding;
    String standalone;
    String mediaType;
    int indent;
    int omitXMLDecl;
    String doctypePublic;
    String doctypeSystem;
    Hashtable cdataSectionElements;
    String oraHref;
    String oraName;
    Hashtable outProps;
    static String HTML = "html";
    static String XML = "xml";
    static String TEXT = "text";
    static String YES = "yes";
    static String NO = "no";
    static String ORAHREF = "href";
    Properties m_props;
    Properties m_defaultProps;

    public XSLOutput() throws XSLException {
        this.elementType = 3;
        this.initialize();
    }

    XSLOutput(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
        this.initialize();
    }

    boolean checkCDATASectionElement(String string) {
        if (this.cdataSectionElements == null) {
            return false;
        }
        return this.cdataSectionElements.get(string) != null;
    }

    public String getAttribute(String string, String string2) throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            return (String)this.outProps.get(string2);
        }
        return super.getAttribute(string, string2);
    }

    public Properties getDefaultProps() {
        return this.m_defaultProps;
    }

    String getDoctypePublic() {
        return this.doctypePublic;
    }

    String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    String getEncoding() {
        if (this.encoding == "") {
            return "UTF-8";
        }
        return this.encoding;
    }

    boolean getIndent() {
        if (this.indent == -1) {
            if (this.method == XML || this.method == "") {
                this.indent = 0;
            } else if (this.method == HTML) {
                this.indent = 1;
            }
        }
        return this.indent == 1;
    }

    String getMediaType() {
        if (this.mediaType == "") {
            if (this.method == HTML) {
                this.mediaType = "text/html";
            } else if (this.method == TEXT) {
                this.mediaType = "text/plain";
            } else if (this.method != "") {
                this.mediaType = "text/xml";
            } else {
                return "text/xml";
            }
        }
        return this.mediaType;
    }

    String getMethod() {
        return this.method;
    }

    String getName() {
        return this.oraName;
    }

    boolean getOmitXMLDecl() {
        if (this.omitXMLDecl == -1) {
            this.omitXMLDecl = this.method == XML || this.method == "" ? 0 : 1;
        }
        return this.omitXMLDecl == 1;
    }

    String getOraHref() {
        return this.oraHref;
    }

    public Properties getProps() {
        return this.m_props;
    }

    String getStandalone() {
        return this.standalone;
    }

    String getVersion() {
        if (this.version == "") {
            if (this.method == HTML) {
                this.version = "4.0";
            } else if (this.method != "") {
                this.version = "1.0";
            } else {
                return "1.0";
            }
        }
        return this.version;
    }

    void initialize() {
        this.method = "";
        this.version = "";
        this.encoding = "";
        this.standalone = "";
        this.mediaType = "";
        this.doctypePublic = "";
        this.doctypeSystem = "";
        this.outProps = new Hashtable(20);
        this.omitXMLDecl = -1;
        this.indent = -1;
        this.oraName = "";
        this.m_defaultProps = new Properties();
        this.m_props = new Properties(this.m_defaultProps);
        JXUtil.setDefaultProps(this.m_defaultProps, XML);
    }

    boolean isCDATASectionElement() {
        return this.cdataSectionElements != null;
    }

    boolean isEncodingSpecified() {
        return this.encoding != "";
    }

    void merge(XSLOutput xSLOutput) throws XSLException {
        String string;
        String string2 = xSLOutput.getAttribute("", OutputKeys.METHOD);
        if (string2 != null) {
            this.method = string2.intern();
            ((Hashtable)this.m_props).put(OutputKeys.METHOD, this.method);
            JXUtil.setDefaultProps(this.m_defaultProps, this.method);
        }
        if ((string2 = xSLOutput.getAttribute("", "version")) != null) {
            this.version = string2;
            ((Hashtable)this.m_props).put("version", this.version);
        }
        if ((string2 = xSLOutput.getAttribute("", "encoding")) != null) {
            this.encoding = string2;
            ((Hashtable)this.m_props).put("encoding", this.encoding);
        }
        if ((string2 = xSLOutput.getAttribute("", "standalone")) != null) {
            this.standalone = string2;
            ((Hashtable)this.m_props).put("standalone", this.standalone);
        }
        if ((string2 = xSLOutput.getAttribute("", "media-type")) != null) {
            this.mediaType = string2;
            ((Hashtable)this.m_props).put("media-type", this.mediaType);
        }
        if ((string2 = xSLOutput.getAttribute("", "doctype-public")) != null) {
            this.doctypePublic = string2;
            ((Hashtable)this.m_props).put("doctype-public", this.doctypePublic);
        }
        if ((string2 = xSLOutput.getAttribute("", "doctype-system")) != null) {
            this.doctypeSystem = string2;
            ((Hashtable)this.m_props).put("doctype-system", this.doctypeSystem);
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            this.oraHref = xSLOutput.getAttribute("", ORAHREF);
            this.oraName = xSLOutput.getAttribute("", "name");
            if (this.oraName == null) {
                this.oraName = "";
            }
        }
        if ((string2 = xSLOutput.getAttribute("", OutputKeys.INDENT)) != null) {
            ((Hashtable)this.m_props).put(OutputKeys.INDENT, string2);
            if (string2.equals("yes")) {
                this.indent = 1;
            } else if (string2.equals("no")) {
                this.indent = 0;
            }
        }
        if ((string2 = xSLOutput.getAttribute("", OutputKeys.OMIT_XML_DECLARATION)) != null) {
            ((Hashtable)this.m_props).put(OutputKeys.OMIT_XML_DECLARATION, string2);
            if (string2.equals("yes")) {
                this.omitXMLDecl = 1;
            } else if (string2.equals("no")) {
                this.omitXMLDecl = 0;
            }
        }
        if ((string = xSLOutput.getAttribute("", "cdata-section-elements")) != null) {
            ((Hashtable)this.m_props).put("cdata-section-elements", string);
            this.processCdataSectionElement(string, xSLOutput, true);
        }
    }

    void printAttributes(PrintWriter printWriter) {
        super.printAttributes(printWriter);
        Hashtable hashtable = this.attrHash;
        this.attrHash = this.outProps;
        super.printAttributes(printWriter);
        this.attrHash = hashtable;
    }

    private void processCdataSectionElement(String string, XSLOutput xSLOutput, boolean bl) throws XSLException {
        int n = 0;
        int n2 = 0;
        do {
            String string2 = (n2 = string.indexOf(32, n)) == -1 ? string.substring(n, string.length()) : string.substring(n, n2);
            n = n2 + 1;
            String string3 = xSLOutput.resolveQname(string2).getExpandedName();
            if (this.cdataSectionElements == null) {
                this.cdataSectionElements = new Hashtable(20);
            }
            if (bl) {
                this.cdataSectionElements.put(string3, string3);
                continue;
            }
            Object v = this.cdataSectionElements.get(string3);
            if (v != null && v.toString().equals(string3)) continue;
            this.cdataSectionElements.put(string3, string3);
        } while (n2 != -1);
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            this.outProps.put(string3, string4);
        } else {
            super.setAttribute(string, string2, string3, string4);
        }
    }

    public void setMethod(String string) {
        this.method = string;
    }

    void setName(String string) {
        this.oraName = string;
    }

    void setOraHref(String string) {
        this.oraHref = string;
    }

    public void setProps(Properties properties) {
        this.m_props = properties;
        Enumeration<?> enumeration = this.m_props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = enumeration.nextElement().toString();
            if (string2.equals(OutputKeys.METHOD)) {
                this.method = this.m_props.getProperty(OutputKeys.METHOD);
                if (this.method != null) {
                    this.method = this.method.intern();
                    JXUtil.setDefaultProps(this.m_defaultProps, this.method);
                    continue;
                }
                this.method = "";
                continue;
            }
            if (string2.equals("version")) {
                this.version = this.m_props.getProperty("version");
                if (this.version != null) {
                    this.version = this.version.intern();
                    continue;
                }
                this.version = "";
                continue;
            }
            if (string2.equals("encoding")) {
                this.encoding = (String)((Hashtable)this.m_props).get("encoding");
                if (this.encoding != null) {
                    this.encoding = this.encoding.intern();
                    continue;
                }
                this.encoding = "";
                continue;
            }
            if (string2.equals("standalone")) {
                this.standalone = this.m_props.getProperty("standalone");
                if (this.standalone != null) {
                    this.standalone = this.standalone.intern();
                    continue;
                }
                this.standalone = "";
                continue;
            }
            if (string2.equals("media-type")) {
                this.mediaType = this.m_props.getProperty("media-type");
                if (this.mediaType != null) {
                    this.mediaType = this.mediaType.intern();
                    continue;
                }
                this.mediaType = "";
                continue;
            }
            if (string2.equals("doctype-public")) {
                this.doctypePublic = this.m_props.getProperty("doctype-public");
                if (this.doctypePublic != null) {
                    this.doctypePublic = this.doctypePublic.intern();
                    continue;
                }
                this.doctypePublic = "";
                continue;
            }
            if (string2.equals("doctype-system")) {
                this.doctypeSystem = this.m_props.getProperty("doctype-system");
                if (this.doctypeSystem != null) {
                    this.doctypeSystem = this.doctypeSystem.intern();
                    continue;
                }
                this.doctypeSystem = "";
                continue;
            }
            if (string2.equals(OutputKeys.INDENT)) {
                string = this.m_props.getProperty(OutputKeys.INDENT);
                if (string == null) continue;
                if ((string = string.intern()) == "yes") {
                    this.indent = 1;
                    continue;
                }
                if (string != "no") continue;
                this.indent = 0;
                continue;
            }
            if (string2.equals(OutputKeys.OMIT_XML_DECLARATION)) {
                string = this.m_props.getProperty(OutputKeys.OMIT_XML_DECLARATION);
                if (string == null) continue;
                if ((string = string.intern()) == "yes") {
                    this.omitXMLDecl = 1;
                    continue;
                }
                if (string != "no") continue;
                this.omitXMLDecl = 0;
                continue;
            }
            if (!string2.equals("cdata-section-elements")) continue;
            string = this.m_props.getProperty("cdata-section-elements");
            try {
                if (string == null) continue;
                this.processCdataSectionElement(string, this, false);
            }
            catch (XSLException xSLException) {}
        }
    }

    public void startContent() throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            if (this.getAttribute("", "name") == null) {
                this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
            }
            if (this.getAttribute("", ORAHREF) == null) {
                this.xss.err.error2(1009, 2, "href", this.getQualifiedName());
            }
        }
    }
}

