/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;

class XSLCopy
extends XSLNode
implements XSLConstants {
    XSLCopy(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 7;
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        XMLNode xMLNode = xSLTContext.getContextNode();
        boolean bl = false;
        switch (xMLNode.getNodeType()) {
            case 2: {
                XMLAttr xMLAttr = (XMLAttr)xMLNode;
                if (xMLAttr.getPrefix() == "xmlns" || xMLAttr.getLocalName() == "xmlns") break;
                xSLEventHandler.attribute(xMLAttr.getPrefix(), xMLAttr.getLocalName(), xMLAttr.getNamespace(), xMLAttr.getNodeValue());
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                Hashtable hashtable;
                if (xMLNode.getParentNode() == null) {
                    this.processAttrSets(xSLTContext);
                    this.processChildren(xSLTContext);
                    break;
                }
                XMLElement xMLElement = (XMLElement)xMLNode;
                xSLEventHandler.startElement(xMLElement.getPrefix(), xMLElement.getLocalName(), xMLElement.getNamespace());
                String string = xMLElement.getAttribute("xml:space");
                bl = string.equals("") ^ true;
                if (bl) {
                    if (string.equals("preserve")) {
                        xSLTContext.setSrcWhiteSpaceMode(true);
                    } else if (string.equals("default")) {
                        xSLTContext.setSrcWhiteSpaceMode(false);
                    } else {
                        bl = false;
                    }
                }
                this.processAttrSets(xSLTContext);
                String string2 = xMLElement.resolveNamespacePrefix("#default");
                if (string2 != null) {
                    xSLEventHandler.namespaceAttr("", string2);
                }
                if ((hashtable = xMLElement.getAllNamespaceAttrs()) != null) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        String string4 = (String)hashtable.get(string3);
                        xSLEventHandler.namespaceAttr(string3, string4);
                    }
                }
                this.processChildren(xSLTContext);
                if (bl) {
                    xSLTContext.resetSrcWhiteSpaceMode();
                }
                xSLEventHandler.endElement(xMLElement.getPrefix(), xMLElement.getLocalName(), xMLElement.getNamespace());
                break;
            }
            case 3: {
                XMLText xMLText = (XMLText)xMLNode;
                xSLEventHandler.characters(xMLText.getNodeValue(), false);
                break;
            }
            case 7: {
                xSLEventHandler.processingInstruction(xMLNode.getNodeName(), xMLNode.getNodeValue());
                break;
            }
            case 8: {
                xSLEventHandler.comment(xMLNode.getNodeValue());
                break;
            }
        }
    }
}

