/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import oracle.xml.parser.v2.DefaultXMLDocumentHandler;
import oracle.xml.parser.v2.XMLByteReader;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.parser.v2.XMLToken;
import oracle.xml.util.StringHashtable;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLTokenizer
extends DefaultXMLDocumentHandler
implements XMLConstants {
    static final int TAGSTART = 60;
    static final int TAGEND = 62;
    static final int SLASH = 47;
    static final int EQ = 61;
    static final int LPAREN = 40;
    static final int RPAREN = 41;
    static final int BANG = 33;
    static final int QMARK = 63;
    static final int DASH = 45;
    static final int PERCENT = 37;
    static final int AMP = 38;
    static final int LEFTSQB = 91;
    static final int RIGHTSQB = 93;
    static final int QUOTE = 39;
    static final int OR = 124;
    static final int ASTERISK = 42;
    static final int PLUS = 43;
    static final int HASH = 35;
    static final int COMMA = 44;
    static final int INVALIDTOKEN = 0;
    static final int EOF = -1;
    static final int WHITESPACE = -2;
    static final int WORDCHAR = -3;
    static final int NAME = -4;
    static final int TEXT = -5;
    static final int PITAGSTART = -6;
    static final int PITAGEND = -7;
    static final int DECLTAGSTART = -8;
    static final int CLOSETAGSTART = -9;
    static final int EMPTYTAGEND = -10;
    static final int COMMENT = -11;
    static final int DOCTYPE = -12;
    static final int SYSTEM = -13;
    static final int CDATATAGSTART = -14;
    static final int ELEMENT = -15;
    static final int EMPTY = -16;
    static final int ANY = -17;
    static final int PCDATA = -18;
    static final int ATTLIST = -19;
    static final int CDATA = -20;
    static final int ID = -21;
    static final int IDREF = -22;
    static final int IDREFS = -23;
    static final int ENTITY = -24;
    static final int ENTITIES = -25;
    static final int NMTOKEN = -26;
    static final int NMTOKENS = -27;
    static final int NOTATION = -28;
    static final int ENUMERATION = -29;
    static final int FIXED = -30;
    static final int REQUIRED = -31;
    static final int IMPLIED = -32;
    static final int NDATA = -33;
    static final int INCLUDETAGSTART = -34;
    static final int IGNORETAGSTART = -35;
    static final int NAMESPACE = -36;
    static final int EXTENDS = -37;
    static final int IMPLEMENTS = -38;
    static final int XML = -39;
    static final int VERSION = -40;
    static final int ENCODING = -41;
    static final int STANDALONE = -42;
    static final int CDEND = -43;
    static final int PUBLIC = -100;
    char[] sNBuf = new char[1024];
    char[] buffer = new char[8192];
    int nBuf;
    int nTok;
    boolean STag;
    boolean ETag;
    boolean EmptyElemTag;
    boolean AttValue;
    boolean AttName;
    boolean Attribute;
    boolean CharData;
    boolean Comment;
    boolean Reference;
    boolean CDSect;
    boolean PI;
    boolean PITarget;
    boolean ETagName;
    boolean STagName;
    boolean XMLDecl;
    boolean TextDecl;
    boolean AttListDecl;
    boolean elementdecl;
    boolean ElemDeclName;
    boolean EntityDecl;
    boolean EntityValue;
    boolean EntityDeclName;
    boolean NotationDecl;
    boolean DTDName;
    boolean ExternalID;
    XMLToken tokenHandler = null;
    XMLError err = new XMLError();
    XMLReader reader;
    XMLByteReader input;
    char[] inputBuf;
    int inputInx;
    boolean inTag;
    int lookahead;
    char quote;
    int token;
    int nametoken = 0;
    String name;
    String text;
    URL url;
    boolean internalSubset;
    static final Hashtable tokens;
    static final int[] chartype;
    static final boolean[] asciiNameChar;
    static final boolean[] asciiExtNameChar;
    static final boolean[] asciiWSChar;
    static StringHashtable nameHashTable;
    static final int FWHITESPACE = 1;
    static final int FDIGIT = 2;
    static final int FLETTER = 4;
    static final int FMISCNAME = 8;
    static final int FSTARTNAME = 16;
    static final char nameSpaceSeparator = ':';
    static final String namePCDATA;
    static final String nameVERSION;
    static final String nameENCODING;
    static final String nameStandalone;
    static final String nameDOCTYPE;
    static final String nameXML;
    static final String nameYes;
    static final String nameNo;
    static final String namePUBLICID;
    static final String nameXMLSpace;
    static final String nameXSLPI;
    static final String nameXMLLang;
    static final String nameDOCUMENT;
    static final String nameNameSpace;

    static {
        int n;
        tokens = new Hashtable(600);
        chartype = new int[256];
        asciiNameChar = new boolean[256];
        asciiExtNameChar = new boolean[256];
        asciiWSChar = new boolean[256];
        nameHashTable = new StringHashtable(600);
        namePCDATA = XMLTokenizer.create("PCDATA");
        nameVERSION = XMLTokenizer.create("version");
        nameENCODING = XMLTokenizer.create("encoding");
        nameStandalone = XMLTokenizer.create("standalone");
        nameDOCTYPE = XMLTokenizer.create("DOCTYPE");
        nameXML = XMLTokenizer.create("xml");
        nameYes = XMLTokenizer.create("yes");
        nameNo = XMLTokenizer.create("no");
        namePUBLICID = XMLTokenizer.create("PUBLICID");
        nameXMLSpace = XMLTokenizer.create("xml:space");
        nameXSLPI = XMLTokenizer.create("xml-stylesheet");
        nameXMLLang = XMLTokenizer.create("xml:lang");
        nameDOCUMENT = XMLTokenizer.create("#document");
        nameNameSpace = XMLTokenizer.create("xmlns");
        tokens.put("DOCTYPE", new Integer(-12));
        tokens.put("SYSTEM", new Integer(-13));
        tokens.put("PUBLIC", new Integer(-100));
        tokens.put("ENTITY", new Integer(-24));
        tokens.put("ELEMENT", new Integer(-15));
        tokens.put("EMPTY", new Integer(-16));
        tokens.put("ANY", new Integer(-17));
        tokens.put("PCDATA", new Integer(-18));
        tokens.put("ATTLIST", new Integer(-19));
        tokens.put("CDATA", new Integer(-20));
        tokens.put("ID", new Integer(-21));
        tokens.put("IDREF", new Integer(-22));
        tokens.put("IDREFS", new Integer(-23));
        tokens.put("ENTITY", new Integer(-24));
        tokens.put("ENTITIES", new Integer(-25));
        tokens.put("NMTOKEN", new Integer(-26));
        tokens.put("NMTOKENS", new Integer(-27));
        tokens.put("FIXED", new Integer(-30));
        tokens.put("REQUIRED", new Integer(-31));
        tokens.put("IMPLIED", new Integer(-32));
        tokens.put("NDATA", new Integer(-33));
        tokens.put("NOTATION", new Integer(-28));
        tokens.put("INCLUDE", new Integer(-34));
        tokens.put("IGNORE", new Integer(-35));
        tokens.put("namespace", new Integer(-36));
        tokens.put("EXTENDS", new Integer(-37));
        tokens.put("IMPLEMENTS", new Integer(-38));
        tokens.put("xml", new Integer(-39));
        tokens.put("version", new Integer(-40));
        tokens.put("encoding", new Integer(-41));
        tokens.put("standalone", new Integer(-42));
        int n2 = 0;
        while (n2 < 256) {
            n = n2;
            XMLTokenizer.chartype[n2] = 0;
            XMLTokenizer.asciiNameChar[n2] = false;
            XMLTokenizer.asciiWSChar[n2] = false;
            if (n == 32 || n == 9 || n == 13 || n == 10) {
                XMLTokenizer.chartype[n2] = 1;
                XMLTokenizer.asciiWSChar[n2] = true;
            }
            if (Character.isLetter((char)n)) {
                int n3 = n2;
                chartype[n3] = chartype[n3] | 4;
                XMLTokenizer.asciiNameChar[n2] = true;
            }
            if (Character.isDigit((char)n)) {
                int n4 = n2;
                chartype[n4] = chartype[n4] | 2;
                XMLTokenizer.asciiNameChar[n2] = true;
            }
            ++n2;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
        XMLTokenizer.asciiNameChar[46] = true;
        XMLTokenizer.asciiNameChar[45] = true;
        XMLTokenizer.asciiNameChar[95] = true;
        XMLTokenizer.asciiNameChar[183] = true;
        n = 0;
        while (n < 256) {
            XMLTokenizer.asciiExtNameChar[n] = asciiNameChar[n];
            ++n;
        }
        XMLTokenizer.asciiExtNameChar[58] = true;
    }

    public XMLTokenizer() {
        this.tokenHandler = null;
        this._initTag();
    }

    public XMLTokenizer(XMLToken xMLToken) {
        this.tokenHandler = xMLToken;
        this._initTag();
    }

    private void _init() {
        this.input = this.reader.input;
        this.inputBuf = this.input.getBuffer();
        this.inputInx = this.reader.currentPos;
        this.buffer[0] = 32;
        this.nTok = this.nBuf = 0;
        this.inTag = false;
        this.text = null;
        this.name = null;
        this.url = null;
        this.internalSubset = false;
        this.err.setLocator(this.reader);
    }

    private void _initTag() {
        this.STag = false;
        this.ETag = false;
        this.EmptyElemTag = false;
        this.AttValue = false;
        this.AttName = false;
        this.Attribute = false;
        this.CharData = false;
        this.Reference = false;
        this.CDSect = false;
        this.PI = false;
        this.PITarget = false;
        this.ETagName = false;
        this.STagName = false;
        this.XMLDecl = false;
        this.AttValue = false;
        this.AttListDecl = false;
        this.elementdecl = false;
        this.ElemDeclName = false;
        this.EntityDecl = false;
        this.EntityDeclName = false;
        this.NotationDecl = false;
        this.DTDName = false;
        this.ExternalID = false;
    }

    final void addChar() throws SAXException, IOException {
        if (this.lookahead == -1) {
            this.addError(this.err.getMessage0(193), 193, 0);
        }
        this.nextChar();
    }

    void addError(String string, int n, int n2) throws SAXException {
        this.input.setPosition(this.inputInx);
        this.reader.currentPos = this.inputInx;
        this.err.error(n, n2, string);
    }

    final void checkCDEND(boolean bl) throws SAXException, IOException {
        boolean bl2 = false;
        if (this.lookahead == 93) {
            this.addChar();
            if (this.lookahead == 93) {
                this.addChar();
                if (this.lookahead == 62) {
                    if (!bl) {
                        this.addError(this.err.getMessage1(210, "]]>"), 210, 1);
                    }
                    bl2 = true;
                    this.addChar();
                }
            }
        }
        if (!bl2 && bl) {
            this.addError(this.err.getMessage0(115), 115, 1);
        }
    }

    static String create(String string) {
        return nameHashTable.create(string);
    }

    static String create(char[] cArray, int n, int n2) {
        return nameHashTable.create(cArray, n, n2);
    }

    static final boolean isExtNameChar(char c) {
        if (c < '\u0100') {
            return asciiExtNameChar[c];
        }
        return Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.';
    }

    static final boolean isNameChar(char c) {
        if (c < '\u0100') {
            return asciiNameChar[c];
        }
        return Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.';
    }

    static final boolean isWhiteSpaceChar(char c) {
        if (c < '\u0100') {
            return asciiWSChar[c];
        }
        return Character.isWhitespace(c);
    }

    final int lookup(String string) {
        Object v = tokens.get(string);
        this.token = v != null ? (Integer)v : -4;
        return this.token;
    }

    /*
     * Unable to fully structure code
     */
    final void nextChar() throws SAXException, IOException {
        if (this.inputInx >= this.input.eofPos) {
            ++this.nBuf;
            this.lookahead = -1;
            return;
        }
        ++this.nBuf;
        while (true) {
            try {
                this.buffer[this.nBuf] = this.inputBuf[this.inputInx];
                ++this.inputInx;
                this.lookahead = this.buffer[this.nBuf];
                return;
            }
            catch (ArrayIndexOutOfBoundsException v0) {
                if (this.inputInx >= this.input.eofPos) {
                    this.lookahead = -1;
                    return;
                }
                if (this.inputInx >= this.inputBuf.length) {
                    this.inputInx = this.input.saveBuffer(this.inputInx);
                    this.inputBuf = this.input.getBuffer();
                    continue;
                }
                var1_1 = new char[this.nBuf * 2];
                var2_2 = 0;
                ** while (var2_2 < this.nBuf)
            }
lbl-1000:
            // 1 sources

            {
                var1_1[var2_2] = this.buffer[var2_2];
                ++var2_2;
                continue;
            }
lbl26:
            // 1 sources

            this.buffer = var1_1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int nextToken() throws SAXException, IOException {
        while (!((char)this.lookahead < '\u0100' ? !asciiWSChar[this.lookahead] : !Character.isWhitespace((char)this.lookahead))) {
            this.nextChar();
        }
        this.nTok = this.nBuf;
        if (this.inTag) {
            switch (this.lookahead) {
                case -1: 
                case 65535: {
                    this.token = -1;
                    return this.token;
                }
                case 62: {
                    this.token = 62;
                    this.nextChar();
                    this.inTag = false;
                    return this.token;
                }
                case 47: {
                    this.nextChar();
                    if (this.lookahead == 62) {
                        this.token = -10;
                        this.inTag = false;
                        this.nextChar();
                        return this.token;
                    } else {
                        this.token = 47;
                    }
                    return this.token;
                }
                case 63: {
                    this.nextChar();
                    if (this.lookahead == 62) {
                        this.token = -7;
                        this.inTag = false;
                        this.nextChar();
                        return this.token;
                    } else {
                        this.token = 63;
                    }
                    return this.token;
                }
                case 35: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 61: 
                case 91: 
                case 93: 
                case 124: {
                    this.token = this.lookahead;
                    this.nextChar();
                    return this.token;
                }
                case 37: {
                    this.nextChar();
                    if (this.internalSubset && XMLTokenizer.isNameChar((char)this.lookahead)) {
                        this.scanEntityRef(true);
                        return this.nextToken();
                    }
                    this.token = 37;
                    return this.token;
                }
                case 34: 
                case 39: {
                    this.quote = (char)this.lookahead;
                    this.token = 39;
                    this.nextChar();
                    return this.token;
                }
                default: {
                    if (XMLTokenizer.isExtNameChar((char)this.lookahead)) {
                        this.scanName("name");
                        return this.token;
                    }
                    this.addError(this.err.getMessage0(221), 221, 1);
                    this.nextChar();
                    return this.nextToken();
                }
            }
        }
        switch (this.lookahead) {
            case -1: 
            case 65535: {
                this.token = -1;
                return this.token;
            }
            case 60: {
                this.inTag = true;
                this.nextChar();
                switch (this.lookahead) {
                    case 63: {
                        this.token = -6;
                        this.nextChar();
                        return this.token;
                    }
                    case 33: {
                        this.token = -8;
                        this.nextChar();
                        if (this.lookahead == 45) {
                            this.nextChar();
                            if (this.lookahead == 45) {
                                this.token = -11;
                                this.nextChar();
                                return this.token;
                            }
                            this.addError(this.err.getMessage1(100, "<!--"), 100, 1);
                            this.token = -11;
                            this.nextChar();
                            return this.token;
                        }
                        if (this.lookahead != 91) return this.token;
                        this.nextChar();
                        boolean bl = false;
                        if (this.lookahead == 37) {
                            this.nextChar();
                            this.scanEntityRef(true);
                            bl = true;
                        }
                        boolean bl2 = this.skipWhiteSpaceChar();
                        this.parseKeyword(0, "CDATA or Conditional section start tag");
                        if (this.token == -34 || this.token == -35 || this.token == -20 && !bl) {
                            if (this.token == -20) {
                                if (bl2) {
                                    this.addError(this.err.getMessage1(210, " "), 210, 1);
                                }
                                this.token = -14;
                            } else {
                                this.inTag = false;
                                if (XMLTokenizer.isWhiteSpaceChar((char)this.lookahead)) {
                                    this.nextChar();
                                }
                            }
                            if (this.lookahead == 91) {
                                this.nextChar();
                                return this.token;
                            }
                            this.addError(this.err.getMessage1(100, "["), 100, 1);
                            return this.token;
                        }
                        this.addError(this.err.getMessage1(100, "<!["), 100, 0);
                        return this.token;
                    }
                    case 47: {
                        this.token = -9;
                        this.nextChar();
                        return this.token;
                    }
                    default: {
                        this.token = 60;
                        return this.token;
                    }
                }
            }
            case 93: {
                this.nextChar();
                if (this.lookahead == 93) {
                    this.nextChar();
                    if (this.lookahead == 62) {
                        this.nextChar();
                        this.token = -43;
                        return this.token;
                    }
                    --this.inputInx;
                    --this.inputInx;
                    this.lookahead = 93;
                } else {
                    --this.inputInx;
                    this.lookahead = 93;
                }
                if (this.internalSubset && this.lookahead == 93) {
                    this.nextChar();
                    this.token = 93;
                    return this.token;
                }
            }
            default: {
                this.token = -5;
                return this.token;
            }
        }
    }

    final void parseAttListDecl() throws SAXException, IOException {
        int n = this.nTok - 2;
        this.parseToken(-4, "ElementDecl name in Attribute List");
        boolean bl = false;
        while (this.lookahead != -1) {
            char c = (char)this.lookahead;
            if (c == '\'' || c == '\"') {
                bl ^= true;
            }
            if (c == '>' && !bl) {
                this.nextChar();
                this.inTag = false;
                break;
            }
            this.nextChar();
        }
        if (this.AttListDecl) {
            this.sendToken(102, n, this.nBuf);
        }
        if (this.lookahead == -1) {
            this.addError(this.err.getMessage0(193), 193, 0);
        }
    }

    final void parseAttributes() throws SAXException, IOException {
        while (this.nextToken() == -4) {
            int n = this.nTok;
            String string = this.name;
            if (string.equals(nameXMLSpace)) {
                string = nameXMLSpace;
            }
            if (this.AttName) {
                this.sendToken(5, n, this.nBuf);
            }
            this.parseToken(61, "=");
            this.parseToken(39, "string");
            int n2 = this.nTok;
            if (string.equals(nameXMLLang)) {
                this.parseToken(-4, "lang code");
                String string2 = this.name;
                this.parseToken(39, "string");
            } else {
                this.scanString(this.quote, 38, 38, 60);
            }
            if (this.AttValue) {
                this.sendToken(4, n2, this.nBuf);
            }
            if (!this.Attribute) continue;
            this.sendToken(6, n, this.nBuf);
        }
    }

    final void parseCDATA() throws SAXException, IOException {
        int n = this.nTok;
        while (this.lookahead != -1) {
            if (this.lookahead == 93) {
                this.nextChar();
                if (this.lookahead != 93) continue;
                this.nextChar();
                if (this.lookahead == 62) break;
                --this.inputInx;
                --this.nBuf;
                this.lookahead = 93;
                continue;
            }
            this.nextChar();
        }
        if (this.nextToken() != 62) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, "]]>", this.tokenString(this.token)), 200, 1);
        }
        if (this.CDSect) {
            this.sendToken(12, n, this.nBuf);
        }
    }

    final void parseCharData() throws SAXException, IOException {
        int n = 0;
        int n2 = this.nTok;
        while (this.lookahead != 60 && this.lookahead != -1) {
            if (this.lookahead == 93) {
                ++n;
            } else if (this.lookahead == 62 && n >= 2) {
                n = 0;
                this.addError(this.err.getMessage1(210, "]]>"), 210, 1);
            } else {
                n = 0;
            }
            if (this.lookahead == 38) {
                this.nextChar();
                if (this.lookahead == 35) {
                    this.scanCharRef();
                    continue;
                }
                if (XMLTokenizer.isNameChar((char)this.lookahead)) {
                    this.scanEntityRef(false);
                    continue;
                }
                this.addError(this.err.getMessage0(221), 221, 1);
                continue;
            }
            this.nextChar();
        }
        this.token = -5;
        if (this.CharData) {
            this.sendToken(9, n2, this.nBuf);
        }
    }

    final void parseComment() throws SAXException, IOException {
        int n = this.nTok;
        while (this.lookahead != -1) {
            if (this.lookahead == 45) {
                this.nextChar();
                if (this.lookahead != 45) continue;
                this.nextChar();
                if (this.lookahead == 62) break;
                this.addError(this.err.getMessage0(221), 221, 1);
                --this.inputInx;
                this.lookahead = 45;
                continue;
            }
            this.nextChar();
        }
        if (this.nextToken() != 62) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, "--", this.tokenString(this.token)), 200, 1);
        }
        if (this.Comment) {
            this.sendToken(10, n, this.nBuf);
        }
    }

    final void parseContent() throws SAXException, IOException {
        while (true) {
            switch (this.token) {
                case 60: {
                    this.parseElement();
                    break;
                }
                case -5: {
                    this.parseCharData();
                    break;
                }
                case -6: {
                    this.parsePI(false, false);
                    break;
                }
                case -11: {
                    this.parseComment();
                    break;
                }
                case -14: {
                    this.parseCDATA();
                    break;
                }
                default: {
                    return;
                }
            }
            this.nextToken();
        }
    }

    public void parseDocument() throws SAXException, IOException {
        this._init();
        this.nextChar();
        this.resetBuf();
        this.token = this.nextToken();
        this.parseProlog();
        this.parseElement();
        if (this.lookahead != -1) {
            this.nextToken();
            this.tryMisc();
            if (this.lookahead != -1) {
                this.addError(this.err.getMessage2(200, "PI or EOF", this.tokenString(this.token)), 200, 1);
            }
        }
    }

    final void parseElement() throws SAXException, IOException {
        this.resetBuf();
        int n = this.nTok;
        if (this.token != 60) {
            this.addError(this.err.getMessage2(200, "STag", this.tokenString(this.token)), 200, 1);
            if (this.token != -4) {
                return;
            }
        } else {
            this.scanName("element tag");
        }
        if (this.STagName) {
            this.sendToken(3, this.nTok, this.nBuf);
        }
        String string = this.name;
        this.parseAttributes();
        int n2 = this.nBuf;
        if (this.token == -10) {
            if (this.EmptyElemTag) {
                this.sendToken(2, n, n2);
            }
            return;
        }
        if (this.STag) {
            this.sendToken(1, n, n2);
        }
        if (this.token != 62) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, ">", this.tokenString(this.token)), 200, 1);
        }
        this.nextToken();
        this.parseContent();
        if (this.token == -9) {
            int n3 = this.nTok;
            if (this.lookahead == 47) {
                this.nextChar();
            } else {
                this.scanName("element close tag");
            }
            if (this.ETagName) {
                this.sendToken(8, n3 + 2, this.nBuf);
            }
            if (!string.equals(this.name)) {
                this.addError(this.err.getMessage1(121, string), 121, 1);
            }
            if (this.nextToken() != 62) {
                this.inTag = false;
                this.addError(this.err.getMessage1(100, ">"), 100, 1);
            }
            if (this.ETag) {
                this.sendToken(7, n3, this.nBuf);
            }
        } else {
            this.addError(this.err.getMessage2(200, "/>", this.tokenString(this.token)), 200, 1);
        }
    }

    final void parseElementDecl() throws SAXException, IOException {
        int n = this.nTok - 2;
        this.parseToken(-4, "ElemendDecl Name");
        if (this.ElemDeclName) {
            this.sendToken(104, this.nTok, this.nBuf);
        }
        String string = this.scanSimpleString(62);
        this.inTag = false;
        if (this.elementdecl) {
            this.sendToken(103, n, this.nBuf);
        }
    }

    final void parseEntityDecl() throws SAXException, IOException {
        boolean bl = false;
        int n = this.nTok - 2;
        if (this.nextToken() == 37) {
            bl = true;
            this.parseToken(-4, "Entity name");
        }
        if (this.token != -4) {
            this.addError(this.err.getMessage2(200, "entity name", this.tokenString(this.token)), 200, 1);
            this.name = XMLTokenizer.create("tmpE1");
        } else if (this.EntityDeclName) {
            this.sendToken(107, this.nTok, this.nBuf);
        }
        String string = this.tryExternalID(false);
        if (this.token == -33 && string != null && !bl) {
            this.parseToken(-4, "ndata name");
            this.nextToken();
        } else if (this.token == 39 && string == null) {
            int n2 = this.nTok;
            this.scanString(this.quote, 37, 38, 65535);
            if (this.EntityValue) {
                this.sendToken(106, n2, this.nBuf);
            }
            this.nextToken();
        } else if (string == null) {
            this.addError(this.err.getMessage1(100, this.tokenString(this.token)), 100, 0);
        }
        if (this.token != 62) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, ">", this.tokenString(this.token)), 200, 1);
        }
        if (this.EntityDecl) {
            this.sendToken(105, n, this.nBuf);
        }
    }

    final void parseIgnoreSectContent() throws SAXException, IOException {
        boolean bl = false;
        while (this.lookahead != 93) {
            block0 : switch (this.lookahead) {
                case 34: 
                case 39: {
                    int n = this.lookahead;
                    this.addChar();
                    while (this.lookahead != n) {
                        this.checkCDEND(false);
                        this.nextChar();
                    }
                    this.addChar();
                    break;
                }
                case 60: {
                    this.addChar();
                    switch (this.lookahead) {
                        case 33: {
                            this.addChar();
                            switch (this.lookahead) {
                                case 45: {
                                    this.addChar();
                                    if (this.lookahead != 45) {
                                        this.addError(this.err.getMessage1(100, "-"), 100, 1);
                                    }
                                    this.addChar();
                                    while (!bl) {
                                        if (this.lookahead == 45) {
                                            this.addChar();
                                            if (this.lookahead != 45) continue;
                                            this.addChar();
                                            if (this.lookahead == 62) {
                                                this.addChar();
                                                bl = true;
                                                continue;
                                            }
                                            this.addError(this.err.getMessage1(100, ">"), 100, 1);
                                            continue;
                                        }
                                        this.addChar();
                                    }
                                    bl = false;
                                    break block0;
                                }
                                case 91: {
                                    this.addChar();
                                    this.parseIgnoreSectContent();
                                    break block0;
                                }
                            }
                            this.addChar();
                            break block0;
                        }
                        case 63: {
                            this.addChar();
                            while (!bl) {
                                if (this.lookahead == 63) {
                                    this.addChar();
                                    if (this.lookahead != 62) continue;
                                    this.addChar();
                                    bl = true;
                                    continue;
                                }
                                this.addChar();
                            }
                            bl = false;
                            break block0;
                        }
                    }
                    this.addError(this.err.getMessage0(221), 221, 0);
                    break;
                }
                default: {
                    this.addChar();
                    break;
                }
            }
        }
        this.checkCDEND(true);
    }

    final void parseIgnoreSection() throws SAXException, IOException {
        this.parseIgnoreSectContent();
    }

    final void parseIncludeSection() throws SAXException, IOException {
        this.parseInternalSubset();
        if (this.token != -43) {
            this.addError(this.err.getMessage2(200, "]>", this.tokenString(this.token)), 200, 1);
        }
    }

    final void parseInternalSubset() throws SAXException, IOException {
        block16: while (true) {
            this.resetBuf();
            int n = this.nextToken();
            switch (n) {
                case -5: {
                    if (this.lookahead == 37) {
                        this.nextChar();
                        this.scanEntityRef(true);
                        continue block16;
                    }
                    this.addError(this.err.getMessage0(192), 192, 1);
                    this.nextChar();
                    continue block16;
                }
                case 93: {
                    if (!this.internalSubset) {
                        this.addError(this.err.getMessage2(211, this.tokenString(this.token), "DTD"), 211, 1);
                    }
                }
                case -1: {
                    return;
                }
                case -6: {
                    this.parsePI(false, false);
                    continue block16;
                }
                case -11: {
                    this.parseComment();
                    continue block16;
                }
                case -8: {
                    this.parseKeyword(0, "ENTITY|...");
                    switch (this.token) {
                        case -24: {
                            this.parseEntityDecl();
                            continue block16;
                        }
                        case -15: {
                            this.parseElementDecl();
                            continue block16;
                        }
                        case -19: {
                            this.parseAttListDecl();
                            continue block16;
                        }
                        case -28: {
                            this.parseNotation();
                            continue block16;
                        }
                    }
                    this.addError(this.err.getMessage1(210, this.name), 210, 0);
                    continue block16;
                }
                case -34: {
                    this.parseIncludeSection();
                    continue block16;
                }
                case -35: {
                    this.parseIgnoreSection();
                    continue block16;
                }
            }
            break;
        }
    }

    final void parseKeyword(int n, String string) throws SAXException, IOException {
        if (this.nextToken() == -4) {
            this.token = this.lookup(this.name);
        }
        if (n != 0 && this.token != n) {
            this.addError(this.err.getMessage2(200, this.tokenString(n, string), this.tokenString(this.token)), 200, 0);
        }
    }

    final void parseNotation() throws SAXException, IOException {
        int n = this.nTok - 2;
        this.parseToken(-4, "Notation name");
        String string = this.tryExternalID(true);
        if (string == null) {
            this.addError(this.err.getMessage0(221), 221, 1);
        }
        if (this.token != 62) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, ">", this.tokenString(this.token)), 200, 1);
        }
        if (this.NotationDecl) {
            this.sendToken(108, n, this.nBuf);
        }
    }

    final void parsePI(boolean bl, boolean bl2) throws SAXException, IOException {
        int n = this.nTok;
        if (bl) {
            this.parseKeyword(0, "XML Keyword");
        } else {
            this.nextToken();
        }
        if (this.token != -4) {
            if (bl && this.token == -39) {
                if (bl2) {
                    this.parseXMLDecl();
                } else {
                    this.parseTextDecl();
                }
                return;
            }
            this.addError(this.err.getMessage2(200, "PI name", this.tokenString(this.token)), 200, 0);
            this.name = XMLTokenizer.create("tmpP1");
        }
        if (this.PITarget) {
            this.sendToken(14, this.nTok, this.nBuf);
        }
        if (this.name.toLowerCase().startsWith("xml") && !this.name.equals(nameXSLPI)) {
            this.addError(this.err.getMessage0(109), 109, 1);
        }
        while (XMLTokenizer.isWhiteSpaceChar((char)this.lookahead)) {
            this.nextChar();
        }
        while (this.lookahead != -1) {
            if (this.lookahead == 63) {
                this.nextChar();
                if (this.lookahead != 62) continue;
                break;
            }
            this.nextChar();
        }
        if (this.nextToken() != 62) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, "<?", this.tokenString(this.token)), 200, 1);
        }
        if (this.PI) {
            this.sendToken(13, n, this.nBuf);
        }
    }

    final void parseProlog() throws SAXException, IOException {
        if (this.token == -6) {
            this.parsePI(true, false);
            this.nextToken();
        }
        this.tryMisc();
        this.tryDocTypeDecl();
        this.tryMisc();
    }

    final void parseTextDecl() throws SAXException, IOException {
        int n = this.nTok;
        this.parseKeyword(0, "Version");
        if (this.token == -40) {
            this.parseToken(61, "=");
            this.parseToken(39, "string");
            this.text = this.scanSimpleString(this.quote);
            if (!this.text.equals("1.0")) {
                this.addError(this.err.getMessage2(200, "version 1.0", this.text), 200, 1);
                this.text = "1.0";
            }
            this.parseKeyword(-41, "encoding");
        }
        if (this.token == -41) {
            this.parseToken(61, "=");
            this.parseToken(39, "string");
            this.text = this.scanSimpleString(this.quote);
            if (this.text != null) {
                try {
                    this.reader.setEncoding(this.text);
                }
                catch (IOException iOException) {
                    this.addError(this.err.getMessage1(231, this.text), 231, 0);
                }
            }
            this.nextToken();
        }
        if (this.token != -7) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, "?>", this.tokenString(this.token)), 200, 1);
        }
        if (this.TextDecl) {
            this.sendToken(16, n, this.nBuf);
        }
    }

    final void parseToken(int n, String string) throws SAXException, IOException {
        if (this.nextToken() != n) {
            this.addError(this.err.getMessage2(200, this.tokenString(n, string), this.tokenString(this.token)), 200, 0);
        }
    }

    final void parseXMLDecl() throws SAXException, IOException {
        int n = this.nTok - 2;
        this.parseKeyword(-40, nameVERSION.toString());
        this.parseToken(61, "=");
        this.parseToken(39, "string");
        this.text = this.scanSimpleString(this.quote);
        if (!this.text.equals("1.0")) {
            this.addError(this.err.getMessage2(200, "version 1.0", this.text), 200, 1);
            this.text = "1.0";
        }
        this.parseKeyword(0, "encoding or standalone");
        if (this.token == -41) {
            this.parseToken(61, "=");
            this.parseToken(39, "string");
            this.text = this.scanSimpleString(this.quote);
            if (this.text != null) {
                try {
                    this.reader.setEncoding(this.text);
                }
                catch (IOException iOException) {
                    this.addError(this.err.getMessage1(231, this.text), 231, 0);
                }
            }
            this.parseKeyword(0, nameStandalone.toString());
        }
        if (this.token == -42) {
            this.parseToken(61, "=");
            this.parseToken(39, "string");
            this.text = this.scanSimpleString(this.quote);
            if (!this.text.equals(nameYes) && !this.text.equals(nameNo)) {
                this.addError(this.err.getMessage2(200, "yes or no", this.text), 200, 1);
            }
            this.nextToken();
        }
        if (this.token != -7) {
            this.inTag = false;
            this.addError(this.err.getMessage2(200, "?>", this.tokenString(this.token)), 200, 1);
        }
        if (this.XMLDecl) {
            this.sendToken(15, n, this.nBuf);
        }
    }

    final void resetBuf() {
        int n = this.nBuf;
        this.nBuf = -1;
        int n2 = this.nTok;
        while (n2 <= n) {
            this.buffer[++this.nBuf] = this.buffer[n2];
            ++n2;
        }
        this.nTok = 0;
    }

    /*
     * Unable to fully structure code
     */
    final void scanCharRef() throws SAXException, IOException {
        block8: {
            var1_1 = 0;
            this.nextChar();
            if (this.lookahead != 120) ** GOTO lbl18
            this.nextChar();
            while (true) {
                if (this.lookahead >= 48 && this.lookahead <= 57) {
                    var1_1 = var1_1 * 16 + this.lookahead - 48;
                } else if (this.lookahead >= 97 && this.lookahead <= 102) {
                    var1_1 = var1_1 * 16 + this.lookahead - 97 + 10;
                } else {
                    if (this.lookahead < 65 || this.lookahead > 70) break block8;
                    var1_1 = var1_1 * 16 + this.lookahead - 65 + 10;
                }
                this.nextChar();
            }
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1 * 10 + this.lookahead - 48;
                this.nextChar();
lbl18:
                // 2 sources

                ** while (this.lookahead >= 48 && this.lookahead <= 57)
            }
        }
        if (var1_1 == 0 || var1_1 < 0 || var1_1 > 0x10FFFF) {
            this.addError(this.err.getMessage0(221), 221, 1);
        }
        if (this.lookahead != 59) {
            this.addError(this.err.getMessage1(100, "&#xx;"), 100, 1);
        }
        this.nextChar();
    }

    final void scanEntityRef(boolean bl) throws SAXException, IOException {
        int n = this.nBuf - 1;
        this.scanName("entity ref");
        if (this.lookahead != 59) {
            this.addError(this.err.getMessage1(100, ";"), 100, 1);
        }
        this.nextChar();
        if (this.Reference) {
            this.sendToken(11, n, this.nBuf);
        }
    }

    final void scanName(String string) throws SAXException, IOException {
        int n = 0;
        this.nTok = this.nBuf;
        if ((char)this.lookahead != ':') {
            n = this.scanSimpleName(this.sNBuf, n, string);
        }
        if ((char)this.lookahead == ':') {
            this.sNBuf[n++] = 58;
            this.nextChar();
            n = this.scanSimpleName(this.sNBuf, n, string);
        }
        this.name = XMLTokenizer.create(this.sNBuf, 0, n);
        this.token = -4;
    }

    final int scanSimpleName(char[] cArray, int n, String string) throws SAXException, IOException {
        boolean bl;
        if (this.lookahead < 256) {
            bl = (chartype[this.lookahead] & 0x14) != 0;
        } else {
            boolean bl2 = bl = Character.isLetter((char)this.lookahead) || this.lookahead == 95;
        }
        if (!(bl || this.nametoken > 0 && XMLTokenizer.isNameChar((char)this.lookahead))) {
            this.addError(this.err.getMessage1(100, string), 100, 1);
        }
        cArray[n++] = (char)this.lookahead;
        this.nextChar();
        while (!(this.lookahead < 256 ? !asciiNameChar[this.lookahead] : !Character.isLetterOrDigit((char)this.lookahead))) {
            cArray[n++] = (char)this.lookahead;
            this.nextChar();
        }
        return n;
    }

    final String scanSimpleString(int n) throws SAXException, IOException {
        int n2 = this.nBuf;
        while (this.lookahead != -1 && this.lookahead != n) {
            this.nextChar();
        }
        int n3 = this.nBuf;
        if (this.lookahead == n) {
            this.nextChar();
        } else {
            this.addError(this.err.getMessage0(193), 193, 0);
        }
        return new String(this.buffer, n2, n3 - n2);
    }

    final void scanString(int n, int n2, int n3, int n4) throws SAXException, IOException {
        int n5 = this.nBuf;
        while (this.lookahead != -1 && this.lookahead != n) {
            if (this.lookahead == n3) {
                this.nextChar();
                if (this.lookahead == 35) {
                    this.scanCharRef();
                    continue;
                }
                if (XMLTokenizer.isNameChar((char)this.lookahead)) {
                    this.scanEntityRef(false);
                    continue;
                }
                this.addError(this.err.getMessage0(221), 221, 1);
                break;
            }
            if (this.lookahead == n2) {
                this.nextChar();
                if (XMLTokenizer.isNameChar((char)this.lookahead)) {
                    if (n2 != 37) continue;
                    this.scanEntityRef(true);
                    continue;
                }
                this.addError(this.err.getMessage0(221), 221, 1);
                continue;
            }
            this.nextChar();
        }
        this.text = new String(this.buffer, n5, this.nBuf - n5);
        if (this.lookahead == n) {
            this.nextChar();
        } else {
            this.addError(this.err.getMessage0(193), 193, 0);
        }
    }

    final void sendToken(int n, int n2, int n3) {
        this.tokenHandler.token(n, new String(this.buffer, n2, n3 - n2));
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.err.setErrorHandler(errorHandler);
    }

    public void setErrorStream(OutputStream outputStream) {
        this.err.setErrorStream(outputStream);
    }

    public void setToken(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.STag = bl;
                break;
            }
            case 7: {
                this.ETag = bl;
                break;
            }
            case 2: {
                this.EmptyElemTag = bl;
                break;
            }
            case 4: {
                this.AttValue = bl;
                break;
            }
            case 5: {
                this.AttName = bl;
                break;
            }
            case 6: {
                this.Attribute = bl;
                break;
            }
            case 9: {
                this.CharData = bl;
                break;
            }
            case 10: {
                this.Comment = bl;
                break;
            }
            case 11: {
                this.Reference = bl;
                break;
            }
            case 12: {
                this.CDSect = bl;
                break;
            }
            case 13: {
                this.PI = bl;
                break;
            }
            case 14: {
                this.PITarget = bl;
                break;
            }
            case 8: {
                this.ETagName = bl;
                break;
            }
            case 3: {
                this.STagName = bl;
                break;
            }
            case 15: {
                this.XMLDecl = bl;
                break;
            }
            case 16: {
                this.TextDecl = bl;
                break;
            }
            case 102: {
                this.AttListDecl = bl;
                break;
            }
            case 103: {
                this.elementdecl = bl;
                break;
            }
            case 104: {
                this.ElemDeclName = bl;
                break;
            }
            case 105: {
                this.EntityDecl = bl;
                break;
            }
            case 106: {
                this.EntityValue = bl;
                break;
            }
            case 107: {
                this.EntityDeclName = bl;
                break;
            }
            case 108: {
                this.NotationDecl = bl;
                break;
            }
            case 101: {
                this.DTDName = bl;
                break;
            }
            case 109: {
                this.ExternalID = bl;
                break;
            }
        }
    }

    public void setTokenHandler(XMLToken xMLToken) {
        this.tokenHandler = xMLToken;
    }

    final boolean skipWhiteSpaceChar() throws SAXException, IOException {
        boolean bl = false;
        while (!(this.lookahead < 256 ? !asciiWSChar[this.lookahead] : !Character.isWhitespace((char)this.lookahead))) {
            bl = true;
            this.nextChar();
        }
        return bl;
    }

    final String tokenString(int n) {
        return this.tokenString(n, null);
    }

    final String tokenString(int n, String string) {
        switch (n) {
            case 60: {
                return "start tag(<)";
            }
            case 62: {
                return "tag end(>)";
            }
            case 47: {
                return "/";
            }
            case 61: {
                return "=";
            }
            case 40: {
                return "(";
            }
            case 41: {
                return ")";
            }
            case 33: {
                return "!";
            }
            case 63: {
                return "question mark(?)";
            }
            case 45: {
                return "-";
            }
            case 37: {
                return "percent(%)";
            }
            case 38: {
                return "&";
            }
            case 91: {
                return "[";
            }
            case 93: {
                return "]";
            }
            case 39: {
                return "quote(' or \")";
            }
            case 124: {
                return "|";
            }
            case 42: {
                return "*";
            }
            case 43: {
                return "+";
            }
            case 35: {
                return "#";
            }
            case 44: {
                return ",";
            }
            case 0: {
                return "invalidtoken";
            }
            case -1: {
                return "EOF";
            }
            case -2: {
                return "whitespace";
            }
            case -3: {
                return "word character";
            }
            case -4: {
                if (string != null) {
                    return string;
                }
                return "NAME '" + this.name + "'";
            }
            case -5: {
                return "TEXT '" + this.text + "'";
            }
            case -6: {
                return "<?";
            }
            case -7: {
                return "?>";
            }
            case -43: {
                return "]]>";
            }
            case -8: {
                return "<!";
            }
            case -9: {
                return "</";
            }
            case -10: {
                return "/>";
            }
            case -11: {
                return "<!--";
            }
            case -12: {
                return "DOCTYPE";
            }
            case -13: {
                return "SYSTEM";
            }
            case -14: {
                return "<![CDATA";
            }
            case -15: {
                return "ELEMENT";
            }
            case -16: {
                return "EMPTY";
            }
            case -17: {
                return "ANY";
            }
            case -18: {
                return "PCDATA";
            }
            case -19: {
                return "ATTLIST";
            }
            case -20: {
                return "CDATA";
            }
            case -21: {
                return "ID";
            }
            case -22: {
                return "IDREF";
            }
            case -23: {
                return "IDREFS";
            }
            case -24: {
                return "ENTITY";
            }
            case -25: {
                return "ENTITIES";
            }
            case -26: {
                return "NMTOKEN";
            }
            case -27: {
                return "NMTOKENS";
            }
            case -28: {
                return "NOTATION";
            }
            case -29: {
                return "ENUMERATION";
            }
            case -30: {
                return "FIXED";
            }
            case -31: {
                return "REQUIRED";
            }
            case -32: {
                return "IMPLIED";
            }
            case -33: {
                return "NDATA";
            }
            case -34: {
                return "INCLUDETAGSTART";
            }
            case -35: {
                return "IGNORETAGSTART";
            }
            case -36: {
                return "NAMESPACE";
            }
            case -100: {
                return "PUBLIC";
            }
        }
        return string;
    }

    public final void tokenize(InputStream inputStream) throws XMLParseException, SAXException, IOException {
        this.reader = new XMLReader(null, this.err, (EntityResolver)this, false);
        this.reader.pushXMLReader(inputStream, null, null);
        this.parseDocument();
        this.reader.close();
        this.err.flushErrors();
    }

    public final void tokenize(Reader reader) throws XMLParseException, SAXException, IOException {
        this.reader = new XMLReader(null, this.err, (EntityResolver)this, false);
        this.reader.pushXMLReader(reader, null, null);
        this.parseDocument();
        this.reader.close();
    }

    public final void tokenize(String string) throws XMLParseException, SAXException, IOException {
        this.reader = new XMLReader(null, this.err, (EntityResolver)this, false);
        this.reader.pushXMLReader(new InputSource(string));
        this.parseDocument();
        this.reader.close();
        this.err.flushErrors();
    }

    public final void tokenize(URL uRL) throws XMLParseException, SAXException, IOException {
        this.reader = new XMLReader(null, this.err, (EntityResolver)this, false);
        this.reader.pushXMLReader(uRL, uRL.toString(), null);
        this.parseDocument();
        this.reader.close();
        this.err.flushErrors();
    }

    public final void tokenize(InputSource inputSource) throws XMLParseException, SAXException, IOException {
        this.reader = new XMLReader(null, this.err, (EntityResolver)this, false);
        this.reader.pushXMLReader(inputSource);
        this.parseDocument();
        this.reader.close();
        this.err.flushErrors();
    }

    final void tryDocTypeDecl() throws SAXException, IOException {
        if (this.token == -8) {
            this.resetBuf();
            this.parseKeyword(-12, "Doctype");
            this.parseToken(-4, "Doctype name");
            if (this.DTDName) {
                this.sendToken(101, this.nTok, this.nBuf);
            }
            String string = this.tryExternalID(false);
            if (this.token == 91) {
                this.inTag = false;
                this.internalSubset = true;
                this.parseInternalSubset();
                if (this.token != 93) {
                    this.addError(this.err.getMessage1(100, "]"), 100, 1);
                }
                this.inTag = true;
                this.internalSubset = false;
                this.nextToken();
            }
            if (this.token != 62) {
                this.inTag = false;
                this.addError(this.err.getMessage2(200, ">", this.tokenString(this.token)), 200, 1);
            }
            this.nextToken();
        }
    }

    final String tryExternalID(boolean bl) throws SAXException, IOException {
        String string = null;
        String string2 = null;
        int n = this.nBuf;
        this.parseKeyword(0, "ExternalID");
        switch (this.token) {
            case -100: {
                this.parseKeyword(0, "String");
                if (this.token == 39) {
                    string2 = this.scanSimpleString(this.quote);
                } else {
                    this.addError(this.err.getMessage2(200, "'", this.tokenString(this.token)), 200, 0);
                }
            }
            case -13: {
                this.parseKeyword(0, "QUOTE");
                if (this.token != 39) {
                    if (bl) {
                        return string2;
                    }
                    this.addError(this.err.getMessage1(100, "Expected System ID"), 100, 0);
                } else {
                    string = this.scanSimpleString(this.quote);
                }
                if (this.ExternalID) {
                    this.sendToken(109, n, this.nBuf);
                }
                this.parseKeyword(0, "NDATA");
                break;
            }
        }
        return string;
    }

    final void tryMisc() throws SAXException, IOException {
        while (this.lookahead != -1) {
            switch (this.token) {
                case -6: {
                    this.parsePI(false, false);
                    break;
                }
                case -11: {
                    this.parseComment();
                    break;
                }
                default: {
                    return;
                }
            }
            this.nextToken();
        }
    }
}

