/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.CharData;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLText
extends CharData
implements Text,
Serializable,
Externalizable,
CXMLConstants {
    private char[] textchars;
    private int textpos;
    static final int WHITESPACE_NODE = 65536;

    public XMLText() {
    }

    public XMLText(String string) {
        this.text = string;
    }

    XMLText(char[] cArray, int n, int n2) {
        this.textchars = new char[n2];
        this.addText(cArray, n, n2);
    }

    public void addText(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        if (this.isWhiteSpaceNode()) {
            n4 = n + n2;
            n3 = n;
            while (n3 < n4) {
                if (!XMLUtil.isWhiteSpaceChar(cArray[n3])) {
                    this.resetNodeFlag(65536);
                    break;
                }
                ++n3;
            }
        }
        if ((n4 = this.textpos) + n2 > this.textchars.length) {
            n3 = 2 * this.textchars.length;
            if (n3 < n4 + n2) {
                n3 = n4 + n2;
            }
            char[] cArray2 = this.textchars;
            this.textchars = new char[n3];
            System.arraycopy(cArray2, 0, this.textchars, 0, n4);
        }
        System.arraycopy(cArray, n, this.textchars, n4, n2);
        this.textpos += n2;
    }

    boolean checkTypeNSName(int n, String string, String string2) {
        return n == 3;
    }

    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeValue() throws DOMException {
        if (this.text == null) {
            this.text = new String(this.textchars, 0, this.textpos);
        }
        return this.text;
    }

    private void getTextChars() {
        if (this.text != null) {
            this.textpos = this.text.length();
            this.textchars = new char[this.textpos];
            this.text.getChars(0, this.textpos, this.textchars, 0);
            this.text = null;
        }
        boolean bl = true;
        int n = 0;
        while (n < this.textpos) {
            if (!XMLUtil.isWhiteSpaceChar(this.textchars[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            this.setNodeFlag(65536);
        }
    }

    public boolean isWhiteSpaceNode() {
        this.getTextChars();
        return (this.flags & 0x10000) == 65536;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        this.getTextChars();
        if (this.isNodeFlag(65536) && ((XMLNode)this.getParentNode()).isNodeFlag(131072)) {
            return;
        }
        int n = this.textpos;
        int n2 = 0;
        while (n2 < n) {
            if (this.textchars[n2] == '&') {
                xMLOutputStream.writeChars("&amp;");
            } else if (this.textchars[n2] == '<') {
                xMLOutputStream.writeChars("&lt;");
            } else if (n2 > 1 && this.textchars[n2] == '>') {
                if (bl || this.textchars[n2 - 1] == ']' && this.textchars[n2 - 2] == ']') {
                    xMLOutputStream.writeChars("&gt;");
                } else {
                    xMLOutputStream.write(62);
                }
            } else {
                xMLOutputStream.write(this.textchars[n2]);
            }
            ++n2;
        }
        xMLOutputStream.flush();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = xMLObjectInput.readByte();
        if (by != 23) {
            throw new IOException("Error in reading serialized stream corresponding to Text node.");
        }
        String string = xMLObjectInput.readUTF();
        String string2 = string.equals("null") ? "" : string;
        this.setNodeValue(string2);
    }

    public void reportSAXEvents(ContentHandler contentHandler) throws SAXException {
        String string = this.getData();
        this.getDOMLocator().setCurrentNode(this);
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    public Text splitText(int n) throws DOMException {
        this.checkReadOnly();
        String string = this.getNodeValue();
        try {
            this.setData(string.substring(0, n));
            XMLText xMLText = new XMLText(string.substring(n, string.length()));
            this.parent.replaceChild(xMLText, this);
            xMLText.getParentNode().insertBefore(this, xMLText);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new XMLDOMException(1, this.getXMLError());
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(23);
        if (this.getNodeValue() != null && this.getNodeValue() != "") {
            if (this.getNodeValue() != null && this.getNodeValue() != "") {
                xMLObjectOutput.writeUTF(this.getNodeValue());
            } else {
                xMLObjectOutput.writeUTF("null");
            }
        }
    }
}

