/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public class XMLNotation
extends XMLNode
implements Notation,
CXMLConstants,
Externalizable {
    String url;
    String pubid;
    String tag;
    int ntype;

    public XMLNotation() {
    }

    public XMLNotation(String string) {
        this.tag = string;
    }

    public Node cloneNode(boolean bl) {
        return this.clone_Node(bl, this.ownerDocument);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        XMLNotation xMLNotation = new XMLNotation(this.tag);
        xMLNotation.url = this.url;
        xMLNotation.pubid = this.pubid;
        xMLNotation.ntype = this.ntype;
        xMLNotation.ownerDocument = xMLDocument;
        return xMLNotation;
    }

    public String getNodeName() {
        return this.tag;
    }

    public short getNodeType() {
        return 12;
    }

    public String getPublicId() {
        return this.pubid;
    }

    public String getSystemId() {
        return this.url;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(64)) {
            xMLOutputStream.writeChars("<!NOTATION ");
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " ");
            if (this.pubid != null) {
                xMLOutputStream.writeChars(" PUBLIC ");
                xMLOutputStream.writeQuotedString(this.pubid);
                xMLOutputStream.writeChars(" ");
                if (this.url != null) {
                    xMLOutputStream.writeQuotedString(this.url);
                }
            } else {
                xMLOutputStream.writeChars(" SYSTEM ");
                xMLOutputStream.writeQuotedString(this.url);
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = xMLObjectInput.readByte();
        if (by != 18) {
            throw new IOException("Error in reading serialized stream corresponding to notation node");
        }
        this.tag = xMLObjectInput.readUTF();
        this.url = xMLObjectInput.readUTF();
        if (this.url.equals("null")) {
            this.url = null;
        }
        this.pubid = xMLObjectInput.readUTF();
        if (this.pubid.equals("null")) {
            this.pubid = null;
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(64);
        }
    }

    public void setPublicId(String string) {
        this.pubid = string;
    }

    public void setSystemId(String string) {
        this.url = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(18);
        xMLObjectOutput.writeUTF(this.tag);
        if (this.url != null) {
            xMLObjectOutput.writeUTF(this.url);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if (this.pubid != null) {
            xMLObjectOutput.writeUTF(this.pubid);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        xMLObjectOutput.writeBoolean(this.isNodeFlag(64));
    }
}

