/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.CDATASection;

public class XMLCDATA
extends XMLText
implements CDATASection,
Externalizable,
CXMLConstants {
    public XMLCDATA() {
    }

    public XMLCDATA(String string) {
        super(string);
    }

    public String getNodeName() {
        return "#cdata-section";
    }

    public short getNodeType() {
        return 4;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        xMLOutputStream.writeIndent();
        xMLOutputStream.writeChars("<![CDATA[");
        xMLOutputStream.writeChars(this.getNodeValue());
        xMLOutputStream.writeChars("]]>");
        xMLOutputStream.writeNewLine();
        xMLOutputStream.flush();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = xMLObjectInput.readByte();
        if (by != 21) {
            throw new IOException("Error in reading serialized stream correspondig to CDATA node");
        }
        String string = xMLObjectInput.readUTF();
        this.text = string.equals("null") ? "" : string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(21);
        if (this.text != null && this.text != "") {
            xMLObjectOutput.writeUTF(this.text);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
    }
}

