/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.util.ArrayPool;

class XMLByteReader {
    static final int DEFAULT_SAVE = 32;
    static final int LITTLE_ENDIAN = 1;
    static final int BIG_ENDIAN = 2;
    static final int OCTET_2143 = 3;
    static final int OCTET_3412 = 4;
    char[] charBuffer;
    int charPos;
    int endPos;
    int eofPos;
    byte[] byteBuffer;
    int byteIndex;
    int endIndex;
    int eofIndex;
    int[] lineNumbers;
    int lineNumSize = 1024;
    int lastLine;
    int cumLine;
    int curLine;
    int first = 0;
    int second = 1;
    int third = 2;
    int fourth = 3;
    InputStream in;
    boolean closeInput;
    XMLEntity en;
    String sysId;
    String pubId;
    XMLError err;
    boolean bufferFreed;
    int BUFSIZE;
    private static final byte[] newLine;
    static final int DEFAULT_BUFSIZE = 16388;
    static final int INFINITY = Integer.MAX_VALUE;

    static {
        byte[] byArray = new byte[256];
        byArray[10] = 1;
        byArray[13] = 1;
        byArray[255] = 3;
        newLine = byArray;
    }

    XMLByteReader() {
        this(16388);
    }

    XMLByteReader(int n) {
        this.BUFSIZE = n;
        if (this.BUFSIZE == 16388) {
            this.charBuffer = ArrayPool.allocCharArrDefault();
            this.byteBuffer = ArrayPool.allocByteArrDefault();
        } else {
            this.charBuffer = new char[this.BUFSIZE];
            this.byteBuffer = new byte[this.BUFSIZE];
        }
        this.lineNumbers = new int[this.lineNumSize];
        this.reset();
    }

    XMLByteReader(InputStream inputStream, String string, String string2) {
        this();
        this.in = inputStream;
        this.sysId = string;
        this.pubId = string2;
    }

    void close() throws IOException {
        if (this.in != null && this.closeInput) {
            this.in.close();
        }
        if (!this.bufferFreed && this.BUFSIZE == 16388) {
            ArrayPool.freeCharArrDefault(this.charBuffer);
            ArrayPool.freeByteArrDefault(this.byteBuffer);
            this.bufferFreed = true;
        }
    }

    void fillBuffer() throws IOException {
        while (true) {
            try {
                block8: while (true) {
                    byte by = this.byteBuffer[this.byteIndex];
                    switch (newLine[by & 0xFF]) {
                        default: {
                            continue block8;
                        }
                        case 0: {
                            this.charBuffer[this.endPos] = (char)by;
                            ++this.endPos;
                            ++this.byteIndex;
                            continue block8;
                        }
                        case 1: {
                            this.charBuffer[this.endPos] = 10;
                            this.setLineNumber(this.endPos);
                            ++this.endPos;
                            ++this.byteIndex;
                            if (by != 13 || this.byteBuffer[this.byteIndex] != 10) continue block8;
                            ++this.byteIndex;
                            continue block8;
                        }
                        case 3: 
                    }
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return;
                    }
                    this.charBuffer[this.endPos] = (char)by;
                    ++this.endPos;
                    ++this.byteIndex;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return;
            }
            break;
        }
    }

    void fillByteBuffer() throws IOException {
        int n = 0;
        int n2 = this.BUFSIZE;
        if (this.byteIndex != this.endIndex) {
            System.arraycopy(this.byteBuffer, this.byteIndex, this.byteBuffer, 0, this.endIndex - this.byteIndex);
        }
        this.endIndex -= this.byteIndex;
        this.byteIndex = 0;
        for (n2 = this.BUFSIZE - this.endIndex; n2 != 0; n2 -= n) {
            n = this.in.read(this.byteBuffer, this.endIndex, n2);
            if (n != -1) {
                this.endIndex += n;
                continue;
            }
            if (this.endIndex < this.BUFSIZE) {
                this.byteBuffer[this.endIndex] = -1;
            }
            this.eofIndex = this.endIndex;
            break;
        }
    }

    char[] getBuffer() {
        return this.charBuffer;
    }

    int getColumnNumber() {
        this.getLineNumber();
        return this.charPos - this.lineNumbers[this.lastLine - 1];
    }

    int getLineNumber() {
        int n = this.lastLine;
        while (n < this.curLine) {
            if (this.charPos <= this.lineNumbers[n]) {
                this.lastLine = n;
                return this.cumLine + n;
            }
            ++n;
        }
        this.lastLine = this.curLine;
        return this.cumLine + this.curLine;
    }

    int getPosition() {
        return this.charPos;
    }

    void growBuffer() throws IOException {
        char[] cArray = new char[this.BUFSIZE * 2];
        System.arraycopy(this.charBuffer, 0, cArray, 0, this.endPos);
        byte[] byArray = new byte[this.BUFSIZE * 2];
        System.arraycopy(this.byteBuffer, 0, byArray, 0, this.endIndex);
        if (!this.bufferFreed && this.BUFSIZE == 16388) {
            ArrayPool.freeCharArrDefault(this.charBuffer);
            ArrayPool.freeByteArrDefault(this.byteBuffer);
            this.bufferFreed = true;
        }
        this.BUFSIZE *= 2;
        this.charBuffer = cArray;
        this.byteBuffer = byArray;
        if (this.eofIndex < this.BUFSIZE) {
            this.byteBuffer[this.eofIndex] = -1;
        } else {
            this.fillByteBuffer();
        }
        this.fillBuffer();
    }

    boolean isEOF() {
        return this.eofPos != Integer.MAX_VALUE;
    }

    void pushBytes(int[] nArray, int n, int n2) {
        while (n2 > n) {
            this.byteBuffer[--this.byteIndex] = (byte)nArray[--n2];
        }
    }

    int pushChar(char c) {
        this.charBuffer[--this.charPos] = c;
        return this.charPos;
    }

    int pushChars(char[] cArray, int n, int n2) {
        while (n2 > n) {
            this.charBuffer[--this.charPos] = cArray[--n2];
        }
        return this.charPos;
    }

    void reset() {
        this.bufferFreed = false;
        this.charPos = this.BUFSIZE;
        this.endPos = this.BUFSIZE;
        this.byteIndex = this.BUFSIZE;
        this.endIndex = this.BUFSIZE;
        this.eofPos = Integer.MAX_VALUE;
        this.eofIndex = Integer.MAX_VALUE;
        this.lineNumbers[0] = this.BUFSIZE - 1;
        this.lastLine = 0;
        this.cumLine = 0;
        this.curLine = 1;
    }

    void resetLineNumber(int n) {
        int n2 = this.BUFSIZE - n;
        if (n2 != 0) {
            System.arraycopy(this.charBuffer, n, this.charBuffer, 0, n2);
        }
        int n3 = this.curLine - 1;
        int n4 = this.curLine - 1;
        while (n4 >= 0) {
            if (n > this.lineNumbers[n4]) {
                n3 = n4;
                break;
            }
            --n4;
        }
        int n5 = n3;
        int n6 = 0;
        while (n5 < this.curLine) {
            this.lineNumbers[n6] = this.lineNumbers[n5] - n;
            ++n5;
            ++n6;
        }
        this.curLine -= n3;
        this.cumLine += n3;
        this.lastLine = 0;
    }

    int saveBuffer(int n) throws IOException {
        if (n == 0) {
            this.growBuffer();
            return n;
        }
        int n2 = n;
        if (n == this.BUFSIZE) {
            n2 = this.BUFSIZE - 32;
        }
        this.resetLineNumber(n2);
        this.charPos = n - n2;
        this.endPos -= n2;
        this.fillBuffer();
        return this.charPos;
    }

    void setByteOrder(int n) {
    }

    void setCloseInput(boolean bl) {
        this.closeInput = bl;
    }

    void setEOF(int n) {
        this.eofPos = n;
        if (n < this.BUFSIZE) {
            this.charBuffer[n] = 65535;
        }
    }

    void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    void setLineNumber(int n) {
        try {
            this.lineNumbers[this.curLine++] = n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] nArray = this.lineNumbers;
            this.lineNumbers = new int[this.lineNumSize * 2];
            System.arraycopy(nArray, 0, this.lineNumbers, 0, this.lineNumSize);
            this.lineNumSize *= 2;
            this.lineNumbers[this.curLine++] = n;
        }
    }

    void setPosition(int n) {
        this.charPos = n;
    }
}

