/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLCodeSpace;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLAttr
extends XMLNSNode
implements Attr,
NSName,
Externalizable,
CXMLConstants {
    String text;
    static final int SPECIFIED_ATTR = 65536;
    static final int ATTR_IN_USE = 131072;

    public XMLAttr() {
    }

    public XMLAttr(String string, String string2) {
        this(string, "", "", string2);
    }

    public XMLAttr(String string, String string2, String string3, String string4) {
        super(string);
        string = string.intern();
        if (string3 != null) {
            string3 = string3.intern();
        }
        this.name = string;
        this.prefix = string2;
        this.namespace = string3;
        if (string2 != "") {
            this.tag = String.valueOf(string2) + ":" + string;
            this.tag = this.tag.intern();
        } else {
            this.tag = this.name;
        }
        this.text = string4;
    }

    public XMLAttr(String string, String string2, String string3, String string4, String string5) {
        super(string3);
        string = string.intern();
        if (string4 != null) {
            string4 = string4.intern();
        }
        this.name = string;
        this.prefix = string2;
        this.namespace = string4;
        this.text = string5;
    }

    public XMLNode addText(String string) {
        this.text = this.text.concat(string);
        return this;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 3: 
            case 5: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    boolean checkNamespace(String string, String string2) {
        if (string2 == null) {
            return string.equals("*") || string == this.name;
        }
        return (string.equals("*") || string == this.name) && string2.equals(this.namespace);
    }

    boolean checkTypeNSName(int n, String string, String string2) {
        return !(n != 2 || string != null && string != this.namespace || string2 != null && string2 != this.name);
    }

    public Node cloneNode(boolean bl) {
        return this.clone_Node(bl, this.ownerDocument);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        XMLAttr xMLAttr = (XMLAttr)super.clone_Node(bl, xMLDocument);
        xMLAttr.text = this.text;
        xMLAttr.resetNodeFlag(131072);
        return xMLAttr;
    }

    public String getExpandedName() {
        String string = this.namespace != null && !this.namespace.equals("") ? String.valueOf(this.namespace) + ":" + this.name : this.name;
        return string;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getName() {
        return this.tag;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public XMLAttr getNextAttribute() {
        return (XMLAttr)super.getNextSibling();
    }

    public Node getNextSibling() {
        return null;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return (XMLElement)this.parent;
    }

    public Node getParentNode() {
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public String getQualifiedName() {
        return this.tag;
    }

    public boolean getSpecified() {
        return this.isNodeFlag(65536);
    }

    XMLElement getSrcRoot() {
        if (this.parent != null) {
            return this.parent.getSrcRoot();
        }
        return null;
    }

    public String getValue() {
        if (this.hasChildNodes()) {
            if (this.text != null) {
                return String.valueOf(this.text) + " " + this.getText();
            }
            return this.getText();
        }
        return this.text;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (!this.isNodeFlag(65536)) {
            return;
        }
        xMLOutputStream.writeChars(" ");
        xMLOutputStream.writeChars(this.tag);
        xMLOutputStream.writeChars("=");
        xMLOutputStream.write(34);
        if (this.text != null) {
            int n = this.text.length();
            char[] cArray = new char[n];
            this.text.getChars(0, n, cArray, 0);
            int n2 = 0;
            while (n2 < n) {
                if (cArray[n2] == '&') {
                    xMLOutputStream.writeChars("&amp;");
                } else if (cArray[n2] == '<') {
                    xMLOutputStream.writeChars("&lt;");
                } else if (cArray[n2] == '\"') {
                    xMLOutputStream.writeChars("&quot;");
                } else {
                    xMLOutputStream.write(cArray[n2]);
                }
                ++n2;
            }
        }
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            xMLNode.print(xMLOutputStream, bl);
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        xMLOutputStream.write(34);
        xMLOutputStream.flush();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        boolean bl;
        int n;
        byte by;
        int n2;
        CXMLCodeSpace cXMLCodeSpace = cXMLContext.getNSCodeSpace();
        CXMLCodeSpace cXMLCodeSpace2 = cXMLContext.getElemCodeSpace();
        CXMLCodeSpace cXMLCodeSpace3 = cXMLContext.getPrefixCodeSpace();
        CXMLCodeSpace cXMLCodeSpace4 = cXMLContext.getAttrCodeSpace();
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n3 = xMLObjectInput.readByte();
        if (n3 != 25 && n3 != 24) {
            throw new IOException("Error in serialization of Attribute node");
        }
        if (n3 == 25) {
            string = CXMLConstants.names.create(xMLObjectInput.readUTF());
            bl2 = xMLObjectInput.readBoolean();
            bl3 = xMLObjectInput.readBoolean();
        } else if (n3 == 24) {
            n3 = xMLObjectInput.readByte();
            if ((n3 & 0x80) == 128) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                n2 = n3;
                by = xMLObjectInput.readByte();
                n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
            } else if ((n3 & 0xC0) == 192) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                n2 = xMLObjectInput.readByte();
                by = xMLObjectInput.readByte();
                n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
            } else {
                n = n3;
            }
            string = CXMLConstants.names.create(cXMLCodeSpace4.getElementFromToken(n));
        }
        this.name = string;
        if (bl2) {
            n3 = xMLObjectInput.readByte();
            if (n3 == 27) {
                string2 = CXMLConstants.names.create(xMLObjectInput.readUTF());
                bl = cXMLCodeSpace.addToken(string2);
            } else {
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = xMLObjectInput.readByte();
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                string2 = CXMLConstants.names.create(cXMLCodeSpace.getElementFromToken(n));
            }
            this.namespace = string2;
        }
        if (bl3) {
            n3 = xMLObjectInput.readByte();
            if (n3 == 26) {
                string3 = CXMLConstants.names.create(xMLObjectInput.readUTF());
                bl = cXMLCodeSpace3.addToken(string3);
            } else {
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = xMLObjectInput.readByte();
                    by = xMLObjectInput.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                string3 = CXMLConstants.names.create(cXMLCodeSpace3.getElementFromToken(n));
            }
            this.prefix = string3;
        }
        if (this.prefix != "") {
            this.tag = String.valueOf(this.prefix) + ":" + this.name;
            this.tag = this.tag.intern();
        } else {
            this.tag = this.name;
        }
        string4 = string3 != "" ? String.valueOf(string3) + ":" + string : string;
        bl = cXMLCodeSpace4.addToken(string);
        String string5 = CXMLConstants.names.create(xMLObjectInput.readUTF());
        this.text = string5.equals("null") ? "" : string5;
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(65536);
        }
    }

    public void setNodeValue(String string) throws DOMException {
        this.checkReadOnly();
        if ((this.ownerDocument.flags & 0x10000) == 65536) {
            this.fireDOMMutationEvent("DOMAttrModified", this, null, this.text, string, this.getNodeName(), true, false, (short)1);
        }
        this.text = string;
        this.setNodeFlag(65536);
    }

    public void setValue(String string) throws DOMException {
        this.setNodeValue(string);
    }

    Node traverseUp(XMLNode xMLNode, boolean bl) {
        if (this == xMLNode) {
            return null;
        }
        XMLNode xMLNode2 = (XMLNode)((Object)this.getOwnerElement());
        XMLNode xMLNode3 = (XMLNode)xMLNode2.getFirstChild();
        if (xMLNode3 != null) {
            return xMLNode3;
        }
        if (xMLNode2 == xMLNode) {
            return null;
        }
        xMLNode3 = (XMLNode)xMLNode2.getNextSibling();
        if (xMLNode3 != null) {
            return xMLNode3;
        }
        return xMLNode2.traverseUp(xMLNode, bl);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        byte by;
        int n;
        int n2;
        CXMLCodeSpace cXMLCodeSpace = cXMLContext.getNSCodeSpace();
        CXMLCodeSpace cXMLCodeSpace2 = cXMLContext.getElemCodeSpace();
        CXMLCodeSpace cXMLCodeSpace3 = cXMLContext.getPrefixCodeSpace();
        CXMLCodeSpace cXMLCodeSpace4 = cXMLContext.getAttrCodeSpace();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.namespace != null && this.namespace != "") {
            bl = true;
            bl3 = cXMLCodeSpace.addToken(this.namespace);
        }
        if (this.prefix != null && this.prefix != "") {
            bl2 = true;
            bl4 = cXMLCodeSpace3.addToken(this.prefix);
        }
        if (bl5 = cXMLCodeSpace4.addToken(this.name)) {
            xMLObjectOutput.writeByte(25);
            xMLObjectOutput.writeUTF(this.name);
            if (bl) {
                xMLObjectOutput.writeBoolean(true);
            } else {
                xMLObjectOutput.writeBoolean(false);
            }
            if (bl2) {
                xMLObjectOutput.writeBoolean(true);
            } else {
                xMLObjectOutput.writeBoolean(false);
            }
        } else {
            xMLObjectOutput.writeByte(24);
            n2 = cXMLCodeSpace4.getTokenLength(this.name, bl, bl2);
            n = 0;
            while (n < n2) {
                by = cXMLCodeSpace4.getToken(this.name, n, bl, bl2);
                xMLObjectOutput.writeByte(by);
                ++n;
            }
        }
        if (bl3) {
            xMLObjectOutput.writeByte(27);
            xMLObjectOutput.writeUTF(this.namespace);
        } else if (this.namespace != null && this.namespace != "") {
            n2 = cXMLCodeSpace.getTokenLength(this.namespace);
            n = 0;
            while (n < n2) {
                by = cXMLCodeSpace.getToken(this.namespace, n);
                xMLObjectOutput.writeByte(by);
                ++n;
            }
        }
        if (bl4) {
            xMLObjectOutput.writeByte(26);
            xMLObjectOutput.writeUTF(this.prefix);
        } else if (this.prefix != null && this.prefix != "") {
            n2 = cXMLCodeSpace3.getTokenLength(this.prefix);
            n = 0;
            while (n < n2) {
                by = cXMLCodeSpace3.getToken(this.prefix, n);
                xMLObjectOutput.writeByte(by);
                ++n;
            }
        }
        if (this.text != null) {
            xMLObjectOutput.writeUTF(this.text);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        xMLObjectOutput.writeBoolean(this.isNodeFlag(65536));
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            xMLNode.writeExternal(xMLObjectOutput, cXMLContext);
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
    }
}

