/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.Node;

public class AttrDecl
extends XMLNode
implements XMLConstants,
CXMLConstants,
Externalizable {
    String tag;
    int atttype;
    int attpres;
    String def;
    Vector values;
    ElementDecl ed;
    public static final int CDATA = 0;
    public static final int ID = 1;
    public static final int IDREF = 2;
    public static final int IDREFS = 3;
    public static final int ENTITY = 4;
    public static final int ENTITIES = 5;
    public static final int NMTOKEN = 6;
    public static final int NMTOKENS = 7;
    public static final int NOTATION = 8;
    public static final int ENUMERATION = 9;
    public static final int DEFAULT = 0;
    public static final int REQUIRED = 1;
    public static final int IMPLIED = 2;
    public static final int FIXED = 3;

    public AttrDecl() {
    }

    AttrDecl(String string, int n) {
        this.atttype = n;
        this.tag = string;
    }

    String attPresToString() {
        switch (this.attpres) {
            case 2: {
                return "#IMPLIED";
            }
            case 1: {
                return "#REQUIRED";
            }
            case 3: {
                return "#FIXED";
            }
        }
        return "";
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        AttrDecl attrDecl = (AttrDecl)super.clone_Node(bl, xMLDocument);
        attrDecl.attpres = this.attpres;
        attrDecl.def = this.def;
        attrDecl.values = this.values;
        attrDecl.ownerDocument = xMLDocument;
        return attrDecl;
    }

    public int getAttrPresence() {
        return this.attpres;
    }

    public int getAttrType() {
        return this.atttype;
    }

    public String getDefaultValue() {
        return this.def;
    }

    public Vector getEnumerationValues() {
        return this.values;
    }

    public String getNodeName() {
        return this.tag;
    }

    public short getNodeType() {
        return 14;
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(64)) {
            xMLOutputStream.writeChars("<!ATTLIST ");
            xMLOutputStream.writeChars(String.valueOf(this.ed.tag) + " ");
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " ");
            if (this.atttype != 9) {
                xMLOutputStream.writeChars(String.valueOf(AttrDecl.typeToString(this.atttype)) + " ");
            }
            if (this.atttype == 9 || this.atttype == 8) {
                int n = this.values.size();
                xMLOutputStream.write(40);
                xMLOutputStream.writeChars((String)this.values.elementAt(0));
                int n2 = 1;
                while (n2 < n) {
                    xMLOutputStream.write(124);
                    xMLOutputStream.writeChars((String)this.values.elementAt(n2));
                    ++n2;
                }
                xMLOutputStream.write(41);
                xMLOutputStream.write(32);
            }
            if (this.attpres != 0) {
                xMLOutputStream.writeChars(this.attPresToString());
                xMLOutputStream.write(32);
            }
            if (this.def != null) {
                xMLOutputStream.writeQuotedString(this.def);
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        int n;
        byte by = xMLObjectInput.readByte();
        if (by != 32) {
            throw new IOException("Error in reading serialized stream corresponding to AttrDecl");
        }
        this.tag = xMLObjectInput.readUTF();
        this.atttype = xMLObjectInput.readInt();
        this.attpres = xMLObjectInput.readInt();
        this.def = xMLObjectInput.readUTF();
        if (this.def.equals("null")) {
            this.def = null;
        }
        if ((n = xMLObjectInput.readShort()) != 0) {
            this.values = new Vector(n);
            int n2 = 0;
            while (n2 < n) {
                this.values.addElement(xMLObjectInput.readUTF());
                ++n2;
            }
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(64);
        }
    }

    public static String typeToString(int n) {
        switch (n) {
            case 1: {
                return "ID";
            }
            case 2: {
                return "IDREF";
            }
            case 3: {
                return "IDREFS";
            }
            case 4: {
                return "ENTITY";
            }
            case 5: {
                return "ENTITIES";
            }
            case 6: {
                return "NMTOKEN";
            }
            case 7: {
                return "NMTOKENS";
            }
            case 8: {
                return "NOTATION";
            }
            case 0: {
                return "CDATA";
            }
        }
        return "";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(32);
        xMLObjectOutput.writeUTF(this.tag);
        xMLObjectOutput.writeInt(this.atttype);
        xMLObjectOutput.writeInt(this.attpres);
        if (this.def != null) {
            xMLObjectOutput.writeUTF(this.def);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if (this.values != null) {
            int n = this.values.size();
            xMLObjectOutput.writeShort(n);
            int n2 = 0;
            while (n2 < n) {
                xMLObjectOutput.writeUTF((String)this.values.elementAt(n2));
                ++n2;
            }
        } else {
            xMLObjectOutput.writeShort(0);
        }
        xMLObjectOutput.writeBoolean(this.isNodeFlag(64));
    }
}

