/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDRegexProgram;

class XSDRegexCompiler {
    int[] brans;
    char[] program;
    int patLen;
    int progLen;
    int pos;
    String pattern;
    int branch;
    int piece;
    int atom;
    int[] exprs;
    int minOccr;
    int maxOccr;
    int psize = 128;
    char[] bufAtom;
    int bufLen;
    int bsize;
    static final char BRANCH = '|';
    static final char CHARS = 'A';
    static final char CHARCLASS = '[';
    static final char STARTEXPR = '(';
    static final char ENDEXPR = ')';
    static final char GOTO = 'G';
    static final char NULL = 'N';
    static final char END = 'E';
    static final char ESCAPE = '\\';

    XSDRegexCompiler() {
    }

    CharRanges charClass() throws XSDException {
        boolean bl = false;
        boolean bl2 = false;
        CharRanges charRanges = new CharRanges();
        if (this.pos == this.patLen || this.pattern.charAt(this.pos) == ']') {
            this.error(2102, "empty character class");
        }
        int n = -1;
        if (this.pattern.charAt(this.pos) == '^') {
            bl2 = true;
            ++this.pos;
        }
        block19: while (this.pos < this.patLen) {
            block20: while (true) {
                char c = this.pattern.charAt(this.pos);
                switch (c) {
                    case ']': {
                        if (n >= 0) {
                            charRanges.addChar(n);
                        }
                        if (bl2) {
                            charRanges.reverse();
                        }
                        return charRanges;
                    }
                    case '[': {
                        ++this.pos;
                        CharRanges charRanges2 = this.charClass();
                        if (bl) {
                            charRanges.subtract(charRanges2);
                            bl = false;
                        } else {
                            charRanges.merge(charRanges2);
                        }
                        n = -1;
                        break block20;
                    }
                    case '-': {
                        if (bl) {
                            this.error(2102, "Invalid character");
                            break block20;
                        }
                        bl = true;
                        break block20;
                    }
                    case '^': {
                        this.error(2102, "illegal character");
                        break block20;
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.escape();
                        switch (c) {
                            case '\ufffd': {
                                char c2 = this.pattern.charAt(this.pos - 1);
                                switch (c2) {
                                    case 'c': {
                                        charRanges.addRange(48, 57);
                                        charRanges.addRange(97, 122);
                                        charRanges.addRange(65, 90);
                                        charRanges.addChar(46);
                                        charRanges.addChar(45);
                                        charRanges.addChar(95);
                                        charRanges.addChar(58);
                                        continue block19;
                                    }
                                    case 's': {
                                        charRanges.addChar(9);
                                        charRanges.addChar(10);
                                        charRanges.addChar(13);
                                        charRanges.addChar(32);
                                        continue block19;
                                    }
                                    case 'i': {
                                        charRanges.addRange(48, 57);
                                        charRanges.addRange(97, 122);
                                        charRanges.addRange(65, 90);
                                        continue block19;
                                    }
                                    case 'd': {
                                        charRanges.addRange(48, 57);
                                        continue block19;
                                    }
                                    case 'w': {
                                        charRanges.addRange(0, 65535);
                                        continue block19;
                                    }
                                    default: {
                                        this.error(2102, "Invalid character escape");
                                        continue block19;
                                    }
                                    case 'C': 
                                    case 'D': 
                                    case 'I': 
                                    case 'S': 
                                    case 'W': {
                                        if (this.pos < this.patLen) continue block20;
                                    }
                                }
                            }
                            case '\uffff': {
                                if (this.pattern.charAt(this.pos++) == '{') continue block19;
                                this.error(2102, "Invalid character property");
                                continue block19;
                            }
                            default: {
                                if (bl) {
                                    if (n >= 0) {
                                        charRanges.addRange(n, c);
                                        n = -1;
                                        bl = false;
                                        break;
                                    }
                                    this.error(2102, "Missing range start char");
                                    break;
                                }
                                if (n >= 0) {
                                    charRanges.addChar(n);
                                }
                                n = c;
                            }
                        }
                    }
                    default: {
                        if (bl) {
                            if (n >= 0) {
                                charRanges.addRange(n, c);
                                n = -1;
                                bl = false;
                                break block20;
                            }
                            this.error(2102, "Missing range start char");
                            break block20;
                        }
                        if (n >= 0) {
                            charRanges.addChar(n);
                        }
                        n = c;
                    }
                }
                break;
            }
            ++this.pos;
        }
        this.error(2102, "Unfinished character range");
        return null;
    }

    XSDRegexProgram compile(String string) throws XSDException {
        this.pattern = string;
        this.minOccr = 0;
        this.maxOccr = 0;
        this.brans = new int[16];
        this.exprs = new int[16];
        int n = 0;
        this.patLen = this.pattern.length();
        this.program = new char[this.psize];
        this.pos = 0;
        this.progLen = 0;
        boolean bl = true;
        this.atom = -1;
        this.piece = -1;
        this.branch = this.instruction('|', 0);
        int n2 = -1;
        block18: while (this.pos < this.patLen) {
            char c = this.pattern.charAt(this.pos++);
            block0 : switch (c) {
                case '|': {
                    if (this.piece < 0 && this.atom < 0) {
                        this.error(2101, "Empty branch");
                    }
                    this.piece = -1;
                    this.atom = -1;
                    bl = true;
                    n2 = this.instruction('|', 0);
                    this.connect(this.branch, n2);
                    this.branch = n2;
                    break;
                }
                case '(': {
                    if (n >= 10) {
                        this.error(2101, "Too many levels of sub-expression");
                    }
                    ++n;
                    n2 = this.instruction('(', 0);
                    if (this.atom >= 0) {
                        this.piece = this.atom;
                    }
                    this.connect(this.piece, n2);
                    this.exprs[n] = n2;
                    this.brans[n] = this.branch;
                    this.branch = this.instruction('|', n);
                    this.connect(n2, this.branch);
                    this.atom = -1;
                    this.piece = -1;
                    bl = true;
                    break;
                }
                case ')': {
                    if (n == 0) {
                        this.error(2101, "unmatched bracket");
                    }
                    bl = true;
                    n2 = this.instruction(')', n);
                    this.connect(this.piece, n2);
                    this.connect(this.branch, n2);
                    this.linkBranch(this.exprs[n], n2);
                    this.atom = this.exprs[n];
                    this.piece = -1;
                    this.branch = this.brans[n];
                    --n;
                    break;
                }
                case '[': {
                    if (this.atom >= 0) {
                        this.piece = this.atom;
                    }
                    this.atom = this.instruction('[', 0);
                    this.connect(this.piece, this.atom);
                    CharRanges charRanges = this.charClass();
                    if (this.progLen + charRanges.len + 3 > this.psize) {
                        this.increase(this.progLen + charRanges.len + 3);
                    }
                    this.program[this.atom + 1] = (char)charRanges.len;
                    int n3 = 0;
                    while (n3 < charRanges.len) {
                        this.program[this.progLen++] = (char)charRanges.lwrRange[n3];
                        this.program[this.progLen++] = (char)charRanges.uprRange[n3];
                        ++n3;
                    }
                    continue block18;
                }
                case ']': {
                    bl = true;
                    break;
                }
                case '*': {
                    if (this.atom < 0) {
                        this.error(2101, "Quantifier without atom");
                    }
                    this.insert('|', 0, this.atom);
                    this.connect(this.atom + 3, this.instruction('|', 0));
                    this.connect(this.atom + 3, this.instruction('G', 0));
                    this.connect(this.atom + 3, this.atom);
                    this.connect(this.atom, this.instruction('|', 0));
                    this.connect(this.atom, this.instruction('N', 0));
                    bl = true;
                    this.piece = this.atom;
                    this.atom = -1;
                    break;
                }
                case '+': {
                    if (this.atom < 0) {
                        this.error(2101, "Quantifier without atom");
                    }
                    int n4 = this.instruction('|', 0);
                    this.connect(this.atom, n4);
                    this.connect(this.instruction('G', 0), this.atom);
                    this.connect(n4, this.instruction('|', 0));
                    this.connect(this.atom, this.instruction('N', 0));
                    bl = true;
                    this.piece = this.atom;
                    this.atom = -1;
                    break;
                }
                case '?': {
                    if (this.atom < 0) {
                        this.error(2101, "Quantifier without atom");
                    }
                    this.insert('|', 0, this.atom);
                    this.connect(this.atom, this.instruction('|', 0));
                    int n5 = this.instruction('N', 0);
                    this.connect(this.atom, n5);
                    this.connect(this.atom + 3, n5);
                    this.piece = this.atom;
                    this.atom = -1;
                    bl = true;
                    break;
                }
                case '{': {
                    if (this.atom < 0) {
                        this.error(2101, "Quantifier without atom");
                    }
                    this.minMaxOccr();
                    int n6 = this.maxOccr - this.minOccr;
                    this.saveAtom(this.atom);
                    int n4 = n6;
                    while (n4 > 0) {
                        this.insert('|', 0, this.atom);
                        this.connect(this.atom, this.instruction('|', 0));
                        n2 = this.instruction('N', 0);
                        this.connect(this.atom, n2);
                        this.connect(this.atom + 3, n2);
                        if (n4 > 1) {
                            this.atom = this.progLen;
                            this.copyAtom();
                            this.connect(n2, this.atom);
                        }
                        --n4;
                    }
                    n4 = n6 > 0 ? this.minOccr : this.minOccr - 1;
                    while (n4 > 0) {
                        n2 = this.progLen;
                        this.copyAtom();
                        this.connect(this.atom, n2);
                        this.atom = n2;
                        --n4;
                    }
                    this.piece = this.atom;
                    break;
                }
                case '}': {
                    this.error(2101, "Unexpected character");
                    return null;
                }
                case '.': {
                    this.piece = this.atom;
                    this.atom = this.instruction('\\', 0);
                    this.connect(this.piece, this.atom);
                    this.program[this.atom + 1] = 46;
                    bl = true;
                    break;
                }
                case '\\': {
                    if (this.pos >= this.patLen) {
                        this.error(2101, "Unecpected pattern end");
                    }
                    int n3 = this.pattern.charAt(this.pos);
                    c = this.escape();
                    switch (c) {
                        case '\ufffd': {
                            if (this.atom >= 0) {
                                this.piece = this.atom;
                            }
                            this.atom = this.instruction('\\', 0);
                            this.connect(this.piece, this.atom);
                            this.program[this.atom + 1] = n3;
                            bl = true;
                            break block0;
                        }
                        case '\uffff': {
                            this.error(2101, "Invalid character escape");
                            return null;
                        }
                    }
                    if (this.pos < this.patLen && this.quantifier((char)n3)) {
                        bl = true;
                    }
                    if (bl) {
                        if (this.atom >= 0) {
                            this.piece = this.atom;
                        }
                        this.atom = this.instruction('A', 0);
                        this.connect(this.piece, this.atom);
                        bl = false;
                    }
                    this.program[this.progLen++] = c;
                    int n7 = this.atom + 1;
                    this.program[n7] = (char)(this.program[n7] + '\u0001');
                    break;
                }
                default: {
                    if (this.pos < this.patLen && this.quantifier(this.pattern.charAt(this.pos))) {
                        bl = true;
                    }
                    if (bl) {
                        if (this.atom >= 0) {
                            this.piece = this.atom;
                        }
                        this.atom = this.instruction('A', 0);
                        this.connect(this.piece, this.atom);
                        bl = false;
                    }
                    this.program[this.progLen++] = c;
                    int n8 = this.atom + 1;
                    this.program[n8] = (char)(this.program[n8] + '\u0001');
                }
            }
        }
        n2 = this.instruction('E', 0);
        if (this.atom >= 0) {
            this.piece = this.atom;
        }
        this.connect(this.piece, n2);
        this.connect(this.branch, n2);
        this.linkBranch(0, n2);
        if (n == 0) {
            return new XSDRegexProgram(this.program, this.progLen);
        }
        this.error(2101, "Unmatched parenthesis");
        return null;
    }

    /*
     * Unable to fully structure code
     */
    void connect(int var1_1, int var2_2) {
        if (var1_1 >= 0 && var2_2 >= 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 += var3_3;
lbl4:
            // 2 sources

            ** while ((var3_3 = this.program[var1_1 + 2]) != '\u0000')
        }
lbl5:
        // 1 sources

        this.program[var1_1 + 2] = (char)(var2_2 - var1_1);
    }

    void copyAtom() {
        if (this.psize < this.progLen + this.bufLen) {
            this.increase(this.progLen + this.bufLen);
        }
        System.arraycopy(this.bufAtom, 0, this.program, this.progLen, this.bufLen);
        this.progLen += this.bufLen;
    }

    private void error(int n, String string) throws XSDException {
        throw new XSDException(n, string);
    }

    char escape() throws XSDException {
        if (this.pos >= this.patLen) {
            this.error(2101, "Invalid character escape");
        }
        char c = this.pattern.charAt(this.pos++);
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return c;
            }
            case 'C': 
            case 'D': 
            case 'I': 
            case 'S': 
            case 'W': 
            case 'c': 
            case 'd': 
            case 'i': 
            case 's': 
            case 'w': {
                return '\ufffd';
            }
            case 'P': 
            case 'p': {
                return '\uffff';
            }
        }
        this.error(2101, "invalid character escape");
        return c;
    }

    void increase(int n) {
        char[] cArray = new char[n + this.psize];
        System.arraycopy(this.program, 0, cArray, 0, this.psize);
        this.program = cArray;
        this.psize += n;
    }

    void insert(char c, int n, int n2) {
        if (this.psize < this.progLen + 3) {
            this.increase(this.progLen + 3);
        }
        System.arraycopy(this.program, n2, this.program, n2 + 3, this.progLen - n2);
        this.program[n2] = c;
        this.program[n2 + 1] = (char)n;
        this.program[n2 + 2] = '\u0000';
        this.progLen += 3;
    }

    int instruction(char c, int n) {
        if (this.psize < this.progLen + 3) {
            this.increase(this.progLen + 3);
        }
        this.program[this.progLen++] = c;
        this.program[this.progLen++] = (char)n;
        ++this.progLen;
        return this.progLen - 3;
    }

    void linkBranch(int n, int n2) {
        int n3 = 65535;
        int n4 = n;
        while (n3 != 0) {
            if (this.program[n4] == '|') {
                this.connect(n4 + 3, n2);
            }
            n3 = this.program[n4 + 2];
            n4 += n3;
        }
    }

    void minMaxOccr() throws XSDException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pos < this.patLen && Character.isDigit(this.pattern.charAt(this.pos))) {
            stringBuffer.append(this.pattern.charAt(this.pos++));
        }
        try {
            this.minOccr = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.error(2101, "Minimal occurance not a number");
        }
        if (this.pos < this.patLen && this.pattern.charAt(this.pos) == '}') {
            ++this.pos;
            this.maxOccr = this.minOccr;
            return;
        }
        if (this.pos >= this.patLen || this.pattern.charAt(this.pos++) != ',') {
            this.error(2101, "Expected a comma.");
        }
        if (this.pos >= this.patLen) {
            this.error(2101, "Expected a digit or }.");
        }
        if (this.pattern.charAt(this.pos) == '}') {
            ++this.pos;
            this.maxOccr = -1;
            return;
        }
        stringBuffer.setLength(0);
        while (this.pos < this.patLen && Character.isDigit(this.pattern.charAt(this.pos))) {
            stringBuffer.append(this.pattern.charAt(this.pos++));
        }
        try {
            this.maxOccr = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.error(2101, "Not a valid number.");
        }
        if (this.minOccr > this.maxOccr) {
            this.error(2101, "Bad Range of occurance.");
        }
        if (this.pos >= this.patLen || this.pattern.charAt(this.pos++) != '}') {
            this.error(2101, "Expected a closing brace.");
        }
    }

    boolean quantifier(char c) {
        switch (c) {
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    void saveAtom(int n) {
        this.bufLen = this.progLen - n;
        if (this.bufAtom == null || this.bsize < this.bufLen) {
            this.bufAtom = new char[this.bufLen];
        }
        System.arraycopy(this.program, n, this.bufAtom, 0, this.bufLen);
        this.bsize = this.bufLen;
    }

    class CharRanges {
        int size = 16;
        int len = 0;
        int[] lwrRange = new int[this.size];
        int[] uprRange = new int[this.size];

        CharRanges() {
        }

        void addChar(int n) {
            int n2 = 0;
            while (n2 < this.len) {
                if (this.lwrRange[n2] <= n && this.uprRange[n2] >= n) {
                    return;
                }
                if (this.lwrRange[n2] - 1 == n) {
                    this.lwrRange[n2] = n;
                    return;
                }
                if (this.uprRange[n2] + 1 == n) {
                    this.uprRange[n2] = n;
                    return;
                }
                ++n2;
            }
            this.lwrRange[this.len] = this.uprRange[this.len] = n;
            ++this.len;
        }

        void addRange(int n, int n2) {
            int n3 = 0;
            while (n3 < this.len) {
                if (n >= this.lwrRange[n3] && n2 <= this.uprRange[n3]) {
                    return;
                }
                if (n <= this.lwrRange[n3] && n2 >= this.uprRange[n3]) {
                    this.deleteRange(n3);
                    continue;
                }
                if (n >= this.lwrRange[n3] && n <= this.uprRange[n3]) {
                    this.deleteRange(n3);
                    n = this.lwrRange[n3];
                    continue;
                }
                if (n2 >= this.lwrRange[n3] && n2 <= this.uprRange[n3]) {
                    this.deleteRange(n);
                    n2 = this.uprRange[n3];
                    continue;
                }
                ++n3;
            }
            if (this.len >= this.size) {
                this.size *= 2;
                int[] nArray = new int[this.size];
                int[] nArray2 = new int[this.size];
                System.arraycopy(this.lwrRange, 0, nArray, 0, this.len);
                System.arraycopy(this.uprRange, 0, nArray2, 0, this.len);
                this.lwrRange = nArray;
                this.uprRange = nArray2;
            }
            this.lwrRange[this.len] = n;
            this.uprRange[this.len] = n2;
            ++this.len;
        }

        /*
         * Unable to fully structure code
         */
        void deleteRange(int var1_1) {
            if (this.len != 0 && var1_1 < this.len) ** GOTO lbl6
            return;
lbl-1000:
            // 1 sources

            {
                if (var1_1 - 1 < 0) continue;
                this.lwrRange[var1_1 - 1] = this.lwrRange[var1_1];
                this.uprRange[var1_1 - 1] = this.uprRange[var1_1];
lbl6:
                // 3 sources

                ** while (var1_1++ < this.len)
            }
lbl7:
            // 1 sources

            --this.len;
        }

        void merge(CharRanges charRanges) {
            int n = 0;
            while (n < charRanges.len) {
                this.addRange(charRanges.lwrRange[n], this.uprRange[n]);
                ++n;
            }
        }

        void removeRange(int n, int n2) {
            int n3 = 0;
            while (n3 < this.len) {
                if (this.lwrRange[n3] >= n) {
                    if (this.uprRange[n3] <= n2) {
                        this.deleteRange(n3);
                    } else {
                        this.lwrRange[n3] = n2 + 1;
                    }
                } else {
                    if (this.uprRange[n3] >= n2) {
                        int n4 = this.uprRange[n3];
                        this.uprRange[n3] = n - 1;
                        if (n4 > n2) {
                            this.addRange(n2 + 1, n4);
                        }
                        return;
                    }
                    this.uprRange[n3] = n - 1;
                }
                ++n3;
            }
        }

        void reverse() {
            int[] nArray = this.lwrRange;
            int[] nArray2 = this.uprRange;
            int n = this.len;
            this.lwrRange = new int[this.size];
            this.uprRange = new int[this.size];
            this.len = 1;
            this.lwrRange[0] = 0;
            this.uprRange[0] = 65535;
            int n2 = 0;
            while (n2 < n) {
                this.removeRange(nArray[n2], nArray2[n2]);
                ++n2;
            }
        }

        void subtract(CharRanges charRanges) {
            int n = 0;
            while (n < charRanges.len) {
                this.removeRange(charRanges.lwrRange[n], charRanges.uprRange[n]);
                ++n;
            }
        }
    }
}

