/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Hashtable;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDComponent;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.util.FastVector;

public class XSDNode
implements XSDComponent,
XSDConstantValues {
    String name;
    String targetNS;
    String id;
    int nodeType;
    XSDNode parent;
    XSDAnnotation annotation;
    boolean isClean;
    XMLElement domNode;
    private static final String _indent = "                                                                     ";

    XSDNode() {
        this.init();
    }

    XSDNode(String string, String string2) {
        this.init();
        this.targetNS = string;
        this.name = string2;
    }

    void addAnnotationAttr(XMLAttr xMLAttr) {
        if (xMLAttr.getPrefix().equals("xmlns") || xMLAttr.getNamespace().equals("") && xMLAttr.getName().equals("xmlns")) {
            return;
        }
        if (this.annotation == null) {
            this.annotation = new XSDAnnotation();
        }
        this.annotation.addAttribute(xMLAttr);
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) throws Exception {
        this.isClean = true;
        return true;
    }

    void buildPaths(Hashtable hashtable, int n) {
    }

    public boolean equals(Object object) {
        if (object instanceof XSDNode) {
            XSDNode xSDNode = (XSDNode)object;
            if (this.name == null || this.targetNS == null) {
                return super.equals(object);
            }
            if (this.name.equals(xSDNode.name) && this.targetNS.equals(xSDNode.targetNS)) {
                return true;
            }
        }
        return super.equals(object);
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    XSDNode getMatchingNode(XMLSchema xMLSchema, String string, String string2) throws XSDException {
        throw new XSDException(1900, "getMatchingNode");
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.targetNS;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public String getTargetNS() {
        if (this.parent != null) {
            return this.parent.getTargetNS();
        }
        return null;
    }

    int getWidth() {
        return 1;
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }

    static String indent(int n) {
        return _indent.substring(0, n);
    }

    private void init() {
        this.nodeType = 0;
        this.targetNS = "";
        this.name = null;
        this.id = null;
        this.isClean = true;
    }

    boolean isDerivedFrom(XSDNode xSDNode) {
        return true;
    }

    public boolean isNodeType(int n) {
        return this.nodeType == n;
    }

    boolean isTopLevel() {
        return this.parent instanceof XMLSchemaNode;
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        this.isClean = false;
        return 0;
    }

    void print() {
        switch (this.nodeType) {
            case 1: {
                System.out.print("complexType");
                break;
            }
            case 2: {
                System.out.print("simpleType");
                break;
            }
            case 3: {
                System.out.print("element");
                break;
            }
            case 4: {
                System.out.print("attribute");
                break;
            }
            case 5: {
                System.out.print("group");
                break;
            }
            case 6: {
                System.out.print("attributeGroup");
                break;
            }
            case 0: {
                System.out.print("any");
                break;
            }
            case 22: {
                System.out.print("unique");
                break;
            }
            case 23: {
                System.out.print("key");
                break;
            }
            case 24: {
                System.out.print("keyref");
                break;
            }
        }
    }

    void print(int n) {
        this.printSTag(n);
    }

    void printETag(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.print("</");
        this.print();
        System.out.println(">");
    }

    void printEmptySTag(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.println("/>");
    }

    void printSTag(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.print("<");
        this.print();
        System.out.println();
        if (this.name != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "name = " + this.name);
        }
        if (this.id != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "id = " + this.id);
        }
    }

    void printSTagEnd(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.println(">");
    }

    void setID(String string) {
        this.id = string.intern();
    }

    void setNSName(String string, String string2) {
        this.targetNS = string;
        this.name = string2;
    }

    void setName(String string) {
        this.name = string.intern();
    }
}

