/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Vector;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDPatternImpl;
import oracle.xml.parser.schema.XSDTypeConstants;

public class XSDConstrainingFacet
implements XSDTypeConstants {
    int iFacet;
    int intValue;
    String name;
    String strValue;
    String lexical;
    boolean isFixed;
    XSDDataValue atomValue;
    Vector patterns;
    Vector enumeration;

    XSDConstrainingFacet(int n) {
        this.iFacet = n;
        this.name = XSDTypeConstants.sFacets[n];
    }

    void addEnumeration(XSDDataValue xSDDataValue) throws XSDException {
        if (this.iFacet != 10) {
            throw new XSDException(2900, "");
        }
        if (this.enumeration == null) {
            this.enumeration = new Vector();
        }
        this.enumeration.addElement(xSDDataValue);
    }

    int compareTo(XSDConstrainingFacet xSDConstrainingFacet) throws XSDException {
        switch (this.iFacet) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (xSDConstrainingFacet.atomValue == null || this.atomValue == null) {
                    throw new XSDException(2900, "");
                }
                return this.atomValue.compareTo(xSDConstrainingFacet.atomValue);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.intValue - xSDConstrainingFacet.intValue;
            }
        }
        return 0;
    }

    public int getFacetId() {
        return this.iFacet;
    }

    public Vector getLexicalEnumeration() {
        if (this.iFacet != 10 || this.enumeration == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = this.enumeration.size();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(((XSDDataValue)this.enumeration.elementAt(n2)).getLexicalValue());
            ++n2;
        }
        return vector;
    }

    public String getLexicalValue() {
        return this.lexical;
    }

    public String getName() {
        return this.name;
    }

    boolean includeEnum(XSDDataValue xSDDataValue) throws XSDException {
        if (this.iFacet != 10 || this.enumeration == null) {
            throw new XSDException(2900, "");
        }
        int n = this.enumeration.size();
        int n2 = 0;
        while (n2 < n) {
            if (xSDDataValue.compareTo((XSDDataValue)this.enumeration.elementAt(n2)) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isFixed(boolean bl) {
        return bl;
    }

    void mergePattern(XSDConstrainingFacet xSDConstrainingFacet) throws Exception {
        if (xSDConstrainingFacet.iFacet != 11 || this.iFacet != 11) {
            throw new XSDException(2900, "");
        }
        if (this.patterns == null) {
            this.patterns = new Vector();
        }
        if (xSDConstrainingFacet.patterns == null) {
            return;
        }
        Vector vector = xSDConstrainingFacet.patterns;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.patterns.addElement(vector.elementAt(n2));
            ++n2;
        }
    }

    String print() {
        if (this.lexical != null) {
            return this.lexical;
        }
        return "";
    }

    public void setFixed(boolean bl) {
        this.isFixed = bl;
    }

    void setValue(String string, int n) throws Exception {
        this.lexical = string;
        switch (this.iFacet) {
            case 11: {
                if (this.patterns == null) {
                    this.patterns = new Vector();
                }
                this.patterns.addElement(new XSDPatternImpl(string));
                return;
            }
            case 10: {
                if (this.enumeration == null) {
                    this.enumeration = new Vector();
                }
                this.enumeration.addElement(new XSDDataValue(n, string));
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.atomValue = new XSDDataValue(n, string);
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.intValue = Integer.parseInt(string);
                return;
            }
            case 12: {
                String string2 = string.intern();
                if (string2 != "preserve" && string2 != "replace" && string2 != "collapse") {
                    throw new XSDException(2205, string2, this.name);
                }
                return;
            }
        }
    }

    public void validateFacet(XSDDataValue xSDDataValue) throws XSDException {
        String string = xSDDataValue.getLexicalValue();
        switch (this.iFacet) {
            case 11: {
                if (this.patterns == null) {
                    return;
                }
                int n = this.patterns.size();
                int n2 = 0;
                while (n2 < n) {
                    XSDPatternImpl xSDPatternImpl = (XSDPatternImpl)this.patterns.elementAt(n2);
                    if (!xSDPatternImpl.matchPattern(string)) {
                        throw new XSDException(2202, string, "", this.name);
                    }
                    ++n2;
                }
                return;
            }
            case 10: {
                if (this.enumeration != null) {
                    int n = this.enumeration.size();
                    int n3 = 0;
                    while (n3 < n) {
                        XSDDataValue xSDDataValue2 = (XSDDataValue)this.enumeration.elementAt(n3);
                        if (xSDDataValue2.compareTo(xSDDataValue) == 0) {
                            return;
                        }
                        ++n3;
                    }
                }
                throw new XSDException(2202, string, "", this.name);
            }
            case 1: {
                if (xSDDataValue.compareTo(this.atomValue) < 0) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 2: {
                if (xSDDataValue.compareTo(this.atomValue) <= 0) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 3: {
                if (xSDDataValue.compareTo(this.atomValue) > 0) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 4: {
                if (xSDDataValue.compareTo(this.atomValue) >= 0) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 5: {
                if (xSDDataValue.getPrecision() > this.intValue) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 6: {
                if (xSDDataValue.getScale() > this.intValue) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 7: {
                if (xSDDataValue.getLength() != this.intValue) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 8: {
                if (xSDDataValue.getLength() > this.intValue) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 9: {
                if (xSDDataValue.getLength() < this.intValue) {
                    throw new XSDException(2202, string, "", this.name);
                }
                return;
            }
            case 12: {
                return;
            }
        }
    }

    void validateLength(int n) throws XSDException {
        switch (this.iFacet) {
            case 9: {
                if (n < this.intValue) {
                    throw new XSDException(2208, "");
                }
                return;
            }
            case 8: {
                if (n > this.intValue) {
                    throw new XSDException(2208, "");
                }
                return;
            }
            case 7: {
                if (n != this.intValue) {
                    throw new XSDException(2208, "");
                }
                return;
            }
        }
        throw new XSDException(2900, "");
    }
}

