/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;

public class XSDAttribute
extends XSDNode {
    int qualified;
    XSDSimpleType simpleType;
    String refNamespace;
    String refLocalname;
    int refState;
    String defaultVal;
    String fixedVal;
    int minOccurs;
    int maxOccurs;

    XSDAttribute() {
        this.init();
    }

    public String getDefaultVal() {
        return this.defaultVal;
    }

    public String getFixedVal() {
        return this.fixedVal;
    }

    public String getName() {
        if (this.refState == 0 && this.refLocalname != null) {
            return this.refLocalname;
        }
        return this.name;
    }

    public String getRefLocalname() {
        return this.refLocalname;
    }

    public String getRefNamespace() {
        return this.refNamespace;
    }

    public int getRefState() {
        return this.refState;
    }

    public String getTargetNS() {
        if (this.refState == 0 && this.refNamespace != null) {
            return this.refNamespace;
        }
        if (this.qualified == 1) {
            return this.parent.getTargetNS();
        }
        return "";
    }

    public XSDNode getType() {
        return this.simpleType;
    }

    private void init() {
        this.nodeType = 4;
        this.minOccurs = 0;
        this.maxOccurs = 1;
        this.defaultVal = null;
        this.fixedVal = null;
        this.simpleType = XSDSimpleType.urType;
        this.qualified = 1;
        this.refState = 2;
    }

    public boolean isRequired() {
        return this.minOccurs == 1;
    }

    void print(int n) {
        boolean bl = false;
        this.printSTag(n);
        if (this.defaultVal != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "default =" + this.defaultVal);
        }
        if (this.fixedVal != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "fixed = " + this.fixedVal);
        }
        switch (this.qualified) {
            case 0: {
                System.out.println(String.valueOf(XSDNode.indent(n)) + "form = " + "unqualified");
                break;
            }
            case 1: {
                System.out.println(String.valueOf(XSDNode.indent(n)) + "form = " + "qualified");
                break;
            }
        }
        System.out.println(String.valueOf(XSDNode.indent(n)) + "minOccurs = " + this.minOccurs);
        System.out.println(String.valueOf(XSDNode.indent(n)) + "maxOccurs = " + this.maxOccurs);
        switch (this.refState) {
            case 2: 
            case 3: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(String.valueOf(XSDNode.indent(n)) + "type = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
            case 0: 
            case 1: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(String.valueOf(XSDNode.indent(n)) + "ref = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
        }
        this.printSTagEnd(n);
        if (!bl) {
            this.simpleType.print(n + 3);
        }
        this.printETag(n);
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDAttribute xSDAttribute = (XSDAttribute)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDAttribute != null) {
            if (xSDAttribute.refState == 3) {
                xSDAttribute.resolveTypeReference(xMLSchema);
            }
            if (xSDAttribute.refState == 3) {
                return;
            }
            this.setType(xSDAttribute.getType());
            this.name = xSDAttribute.name;
            if (this.defaultVal == null && this.fixedVal == null) {
                this.defaultVal = xSDAttribute.defaultVal;
                this.fixedVal = xSDAttribute.fixedVal;
            }
            this.refState = 0;
        }
    }

    void resolveTypeReference(XMLSchema xMLSchema) throws XSDException {
        XSDNode xSDNode = xMLSchema.getType(this.refNamespace, this.refLocalname, 1);
        if (xSDNode == null) {
            xSDNode = xMLSchema.getType(this.refNamespace, this.refLocalname, 2);
        }
        if (xSDNode != null) {
            this.setSimpleType((XSDSimpleType)xSDNode);
        }
    }

    void setDefault(String string) {
        this.defaultVal = string.intern();
    }

    void setFixed(String string) {
        this.fixedVal = string;
    }

    void setForm(String string) {
        this.qualified = string.equals("qualified") ? 1 : 0;
    }

    void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        this.refState = 1;
    }

    void setSimpleType(XSDSimpleType xSDSimpleType) {
        this.simpleType = xSDSimpleType;
        this.refState = 2;
    }

    void setType(XSDNode xSDNode) {
        this.setSimpleType((XSDSimpleType)xSDNode);
    }

    void setTypeRef(String string, String string2) {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        this.refState = 3;
    }
}

