/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDNotation;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.util.FastVector;

public class XMLSchemaNode
extends XSDNode {
    private Hashtable typeDefinitionSet;
    private Hashtable elemSet;
    private Hashtable groupSet;
    private Hashtable attributeSet;
    private Hashtable attrGroupSet;
    private Hashtable notationSet;
    String schemaLocation;

    public XMLSchemaNode() {
        this.init(10);
    }

    XMLSchemaNode(int n) {
        this.init(n);
    }

    boolean addComponent(XSDNode xSDNode) {
        xSDNode.parent = this;
        xSDNode.targetNS = this.targetNS;
        boolean bl = false;
        switch (xSDNode.nodeType) {
            case 4: {
                if (this.attributeSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.attributeSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 3: {
                if (this.elemSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.elemSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 1: 
            case 2: {
                if (this.typeDefinitionSet.containsKey(xSDNode.name)) {
                    bl = true;
                    if (this.targetNS == "http://www.w3.org/2001/XMLSchema" || this.targetNS == "http://www.w3.org/2000/10/XMLSchema") break;
                }
                this.typeDefinitionSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 6: {
                if (this.attrGroupSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.attrGroupSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 5: {
                if (this.groupSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.groupSet.put(xSDNode.name, xSDNode);
                break;
            }
            case 25: {
                if (this.notationSet.containsKey(xSDNode.name)) {
                    bl = true;
                }
                this.notationSet.put(xSDNode.name, xSDNode);
                break;
            }
        }
        if (this.targetNS == "http://www.w3.org/2001/XMLSchema" || this.targetNS == "http://www.w3.org/2000/10/XMLSchema") {
            return false;
        }
        return bl;
    }

    void buildSchemaPathTable() throws Exception {
        Enumeration enumeration = this.elemSet.elements();
        while (enumeration.hasMoreElements()) {
            ((XSDElement)enumeration.nextElement()).buildPathTable(null, null, 0);
        }
        enumeration = this.typeDefinitionSet.elements();
        while (enumeration.hasMoreElements()) {
            XSDNode xSDNode = (XSDNode)enumeration.nextElement();
            if (!(xSDNode instanceof XSDComplexType)) continue;
            ((XSDComplexType)xSDNode).getGroup().buildPathTable(null, null, 0);
        }
    }

    XSDAttrGroup getAttrGroup(String string) {
        return (XSDAttrGroup)this.attrGroupSet.get(string);
    }

    XSDAttribute getAttribute(String string) {
        return (XSDAttribute)this.attributeSet.get(string);
    }

    public XSDAttribute[] getAttributeDeclarations() {
        XSDAttribute[] xSDAttributeArray = new XSDAttribute[this.attributeSet.size()];
        int n = 0;
        Enumeration enumeration = this.attributeSet.elements();
        while (enumeration.hasMoreElements()) {
            xSDAttributeArray[n] = (XSDAttribute)enumeration.nextElement();
            ++n;
        }
        return xSDAttributeArray;
    }

    public XSDNode[] getAttributeSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.attributeSet.size()];
        int n = 0;
        Enumeration enumeration = this.attributeSet.elements();
        while (enumeration.hasMoreElements()) {
            xSDNodeArray[n] = new XSDElement((XSDAttribute)enumeration.nextElement());
            ++n;
        }
        return xSDNodeArray;
    }

    int getAttributeSetSize() {
        return this.attributeSet.size();
    }

    public XSDNode[] getComplexTypeSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.typeDefinitionSet.size()];
        int n = 0;
        Enumeration enumeration = this.typeDefinitionSet.elements();
        while (enumeration.hasMoreElements()) {
            XSDNode xSDNode = (XSDNode)enumeration.nextElement();
            if (!xSDNode.isNodeType(1)) continue;
            xSDNodeArray[n++] = xSDNode;
        }
        XSDNode[] xSDNodeArray2 = new XSDNode[n];
        System.arraycopy(xSDNodeArray, 0, xSDNodeArray2, 0, n);
        return xSDNodeArray2;
    }

    public Hashtable getComplexTypeTable() {
        Hashtable<String, XSDNode> hashtable = new Hashtable<String, XSDNode>();
        Enumeration enumeration = this.typeDefinitionSet.elements();
        while (enumeration.hasMoreElements()) {
            XSDNode xSDNode = (XSDNode)enumeration.nextElement();
            if (!xSDNode.isNodeType(1)) continue;
            hashtable.put(xSDNode.getName(), xSDNode);
        }
        return hashtable;
    }

    XSDNode getComponent(String string, int n) {
        switch (n) {
            case 4: {
                return (XSDNode)this.attributeSet.get(string);
            }
            case 3: {
                return (XSDNode)this.elemSet.get(string);
            }
            case 1: 
            case 2: {
                XSDNode xSDNode = (XSDNode)this.typeDefinitionSet.get(string);
                if (xSDNode != null && xSDNode.isNodeType(n)) {
                    return xSDNode;
                }
                return null;
            }
            case 6: {
                return (XSDNode)this.attrGroupSet.get(string);
            }
            case 5: {
                return (XSDNode)this.groupSet.get(string);
            }
            case 25: {
                return (XSDNode)this.notationSet.get(string);
            }
        }
        return null;
    }

    XSDElement getElement(String string) {
        return (XSDElement)this.elemSet.get(string);
    }

    public XSDNode[] getElementSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.elemSet.size()];
        int n = 0;
        Enumeration enumeration = this.elemSet.elements();
        while (enumeration.hasMoreElements()) {
            xSDNodeArray[n] = (XSDNode)enumeration.nextElement();
            ++n;
        }
        return xSDNodeArray;
    }

    int getElementSetSize() {
        return this.elemSet.size();
    }

    int getGroupSetSize() {
        return this.groupSet.size();
    }

    int getNotationSetSize() {
        return this.notationSet.size();
    }

    public XSDNode[] getSimpleTypeSet() {
        XSDNode[] xSDNodeArray = new XSDNode[this.typeDefinitionSet.size()];
        int n = 0;
        Enumeration enumeration = this.typeDefinitionSet.elements();
        while (enumeration.hasMoreElements()) {
            XSDNode xSDNode = (XSDNode)enumeration.nextElement();
            if (!xSDNode.isNodeType(2)) continue;
            xSDNodeArray[n++] = xSDNode;
        }
        XSDNode[] xSDNodeArray2 = new XSDNode[n];
        System.arraycopy(xSDNodeArray, 0, xSDNodeArray2, 0, n);
        return xSDNodeArray2;
    }

    public Hashtable getSimpleTypeTable() {
        Hashtable<String, XSDNode> hashtable = new Hashtable<String, XSDNode>();
        Enumeration enumeration = this.typeDefinitionSet.elements();
        while (enumeration.hasMoreElements()) {
            XSDNode xSDNode = (XSDNode)enumeration.nextElement();
            if (!xSDNode.isNodeType(2)) continue;
            hashtable.put(xSDNode.getName(), xSDNode);
        }
        return hashtable;
    }

    public String getTargetNS() {
        return this.targetNS;
    }

    XSDNode getType(String string) {
        string = string.intern();
        return (XSDNode)this.typeDefinitionSet.get(string);
    }

    XSDNode getType(String string, int n) {
        XSDNode xSDNode = (XSDNode)this.typeDefinitionSet.get(string = string.intern());
        if (xSDNode != null && xSDNode.isNodeType(n)) {
            return xSDNode;
        }
        return null;
    }

    public Hashtable getTypeDefinitionTable() {
        return this.typeDefinitionSet;
    }

    private void init(int n) {
        this.typeDefinitionSet = new Hashtable(n);
        this.groupSet = new Hashtable(n);
        this.elemSet = new Hashtable(n);
        this.attrGroupSet = new Hashtable(n);
        this.attributeSet = new Hashtable(n);
        this.notationSet = new Hashtable(n);
        this.targetNS = "";
    }

    void postProcessSchema(FastVector fastVector, Hashtable hashtable) throws Exception {
        XSDNode xSDNode;
        Enumeration enumeration = this.elemSet.elements();
        while (enumeration.hasMoreElements()) {
            ((XSDElement)enumeration.nextElement()).postProcess(fastVector, hashtable);
        }
        enumeration = this.typeDefinitionSet.elements();
        while (enumeration.hasMoreElements()) {
            xSDNode = (XSDNode)enumeration.nextElement();
            if (!(xSDNode instanceof XSDComplexType)) continue;
            ((XSDComplexType)xSDNode).getGroup().postProcess(fastVector, hashtable);
        }
        while (fastVector.size() > 0) {
            xSDNode = ((XSDElement)fastVector.popElement()).getType();
            if (!(xSDNode instanceof XSDComplexType)) continue;
            ((XSDComplexType)xSDNode).getGroup().postProcess(fastVector, hashtable);
        }
    }

    void print() {
        System.out.println(" === Start XMLSchemaNode === ");
        System.out.println("Target NameSpace =" + this.targetNS);
        System.out.println("SchemaLocation =" + this.schemaLocation);
        Enumeration enumeration = this.typeDefinitionSet.elements();
        while (enumeration.hasMoreElements()) {
            XSDNode xSDNode = (XSDNode)enumeration.nextElement();
            if (xSDNode.isNodeType(1)) {
                ((XSDComplexType)xSDNode).print(0);
                continue;
            }
            ((XSDSimpleType)xSDNode).print(0);
        }
        enumeration = this.elemSet.elements();
        while (enumeration.hasMoreElements()) {
            ((XSDElement)enumeration.nextElement()).print(0);
        }
        enumeration = this.groupSet.elements();
        while (enumeration.hasMoreElements()) {
            ((XSDGroup)enumeration.nextElement()).print(0);
        }
        enumeration = this.attributeSet.elements();
        while (enumeration.hasMoreElements()) {
            ((XSDAttribute)enumeration.nextElement()).print(0);
        }
        enumeration = this.attrGroupSet.elements();
        while (enumeration.hasMoreElements()) {
            ((XSDAttrGroup)enumeration.nextElement()).print(0);
        }
        enumeration = this.notationSet.elements();
        while (enumeration.hasMoreElements()) {
            ((XSDNotation)enumeration.nextElement()).print(0);
        }
        System.out.println(" === End XMLSchemaNode === ");
    }

    XSDNode removeComponent(String string, int n) {
        switch (n) {
            case 4: {
                return (XSDNode)this.attributeSet.remove(string);
            }
            case 3: {
                return (XSDNode)this.elemSet.remove(string);
            }
            case 1: 
            case 2: {
                XSDNode xSDNode = (XSDNode)this.typeDefinitionSet.remove(string);
                if (xSDNode != null && xSDNode.isNodeType(n)) {
                    return xSDNode;
                }
                return null;
            }
            case 6: {
                return (XSDNode)this.attrGroupSet.remove(string);
            }
            case 5: {
                return (XSDNode)this.groupSet.remove(string);
            }
            case 25: {
                return (XSDNode)this.notationSet.remove(string);
            }
        }
        return null;
    }

    void setTargetNS(String string) {
        this.targetNS = string.intern();
    }
}

