/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.util.FastVector;

public class XMLSchema
extends XSDNode {
    private Hashtable schemaNodeTable;
    private Hashtable schemas;
    private String schemaNS;
    private boolean isPathTableBuilt;
    String schemaTargetNS;

    public XMLSchema() throws XSDException {
        this.init(100);
    }

    XMLSchema(int n) throws XSDException {
        this.init(n);
    }

    public void buildSchemaPathTable() throws Exception {
        Enumeration enumeration = this.schemaNodeTable.elements();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
            xMLSchemaNode.buildSchemaPathTable();
        }
        this.isPathTableBuilt = true;
    }

    public String[] getAllTargetNS() {
        int n = 0;
        String[] stringArray = new String[this.schemaNodeTable.size()];
        Enumeration enumeration = this.schemaNodeTable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    XSDAttribute getAttribute(String string, String string2) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getAttribute(string2);
    }

    XSDNode getComponent(String string, String string2, int n) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getComponent(string2, n);
    }

    XSDElement getElement(String string, String string2) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getElement(string2);
    }

    public XMLSchemaNode getSchemaByTargetNS(String string) {
        return (XMLSchemaNode)this.schemaNodeTable.get(string);
    }

    String getSchemaNS() {
        return this.schemaNS;
    }

    public String getSchemaTargetNS() {
        return this.schemaTargetNS;
    }

    XSDNode getType(String string, String string2) {
        XMLSchemaNode xMLSchemaNode;
        if (string.intern() == this.schemaNS) {
            if (string2.intern() == "anyType") {
                return XSDComplexType.urType;
            }
            if (string2.intern() == "anySimpleType") {
                return XSDSimpleType.urType;
            }
        }
        if ((xMLSchemaNode = this.getSchemaByTargetNS(string)) == null) {
            return null;
        }
        return xMLSchemaNode.getType(string2);
    }

    XSDNode getType(String string, String string2, int n) {
        XMLSchemaNode xMLSchemaNode;
        if (string.intern() == this.schemaNS) {
            if (string2.intern() == "anyType") {
                return XSDComplexType.urType;
            }
            if (string2.intern() == "anySimpleType") {
                return XSDSimpleType.urType;
            }
        }
        if ((xMLSchemaNode = this.getSchemaByTargetNS(string)) == null) {
            return null;
        }
        return xMLSchemaNode.getType(string2, n);
    }

    public Hashtable getXMLSchemaNodeTable() {
        return this.schemaNodeTable;
    }

    public String[] getXMLSchemaURLS() {
        String[] stringArray = new String[this.schemas.size()];
        int n = 0;
        Enumeration enumeration = this.schemas.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    private void init(int n) throws XSDException {
        this.schemaNodeTable = new Hashtable(n);
        this.schemas = new Hashtable(n);
        XMLSchemaNode xMLSchemaNode = new XMLSchemaNode(50);
        this.setXMLSchemaNode("http://www.w3.org/2000/10/XMLSchema", xMLSchemaNode);
        XSDSimpleType.init(xMLSchemaNode.getTypeDefinitionTable());
        xMLSchemaNode = new XMLSchemaNode(50);
        this.setXMLSchemaNode("http://www.w3.org/2001/XMLSchema", xMLSchemaNode);
        XSDSimpleType.init(xMLSchemaNode.getTypeDefinitionTable());
        XSDComplexType.init();
    }

    boolean isPathTableBuilt() {
        return this.isPathTableBuilt;
    }

    void mergeXMLSchema(XMLSchema xMLSchema) {
        Enumeration enumeration = xMLSchema.getXMLSchemaNodeTable().elements();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
            this.setXMLSchemaNode(xMLSchemaNode.getTargetNS(), xMLSchemaNode);
        }
    }

    boolean newSchema(String string) {
        if (this.schemas.get(string) != null) {
            return false;
        }
        this.schemas.put(string, string);
        return true;
    }

    void postProcessSchema() throws Exception {
        FastVector fastVector = new FastVector();
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.schemaNodeTable.elements();
        while (enumeration.hasMoreElements()) {
            ((XMLSchemaNode)enumeration.nextElement()).postProcessSchema(fastVector, hashtable);
        }
        this.isPathTableBuilt = false;
    }

    public void printSchema() {
        Enumeration enumeration = this.schemaNodeTable.elements();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
            if (xMLSchemaNode.getTargetNS() == "http://www.w3.org/1999/XMLSchema" || xMLSchemaNode.getTargetNS() == "http://www.w3.org/2000/10/XMLSchema" || xMLSchemaNode.getTargetNS() == "http://www.w3.org/2001/XMLSchema") continue;
            xMLSchemaNode.print();
        }
    }

    public void printSchema(boolean bl) {
        if (bl) {
            Enumeration enumeration = this.schemaNodeTable.elements();
            while (enumeration.hasMoreElements()) {
                XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
                xMLSchemaNode.print();
            }
        } else {
            this.printSchema();
        }
    }

    void setSchemaNS(String string) {
        this.schemaNS = string;
    }

    boolean setXMLSchemaNode(String string, XMLSchemaNode xMLSchemaNode) {
        xMLSchemaNode.setTargetNS(string);
        return this.schemaNodeTable.put(string, xMLSchemaNode) != null;
    }
}

