/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.io;

import java.io.IOException;
import java.io.ObjectOutput;
import oracle.xml.util.ArrayPool;

public class XMLObjectOutput {
    ObjectOutput oos;
    byte[] buf;
    int pos;

    public XMLObjectOutput(int n) {
        this.buf = new byte[n];
        this.pos = 0;
    }

    public XMLObjectOutput(ObjectOutput objectOutput) {
        this.oos = objectOutput;
        this.buf = ArrayPool.allocByteArrDefault();
        this.pos = 0;
    }

    public void close() throws IOException {
        if (this.oos != null) {
            this.flushBuffer();
            this.oos.close();
        }
    }

    private void ensureCapacity(int n) throws IOException {
        if (this.pos + n <= this.buf.length) {
            return;
        }
        if (this.oos != null) {
            this.flushBuffer();
            return;
        }
        int n2 = 2 * this.buf.length;
        if (n2 < this.pos + n) {
            n2 = this.pos + n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
        this.buf = byArray;
    }

    public void flush() throws IOException {
        if (this.oos != null) {
            this.flushBuffer();
            this.oos.flush();
        }
    }

    private void flushBuffer() throws IOException {
        this.oos.write(this.buf, 0, this.pos);
        this.pos = 0;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int n) {
        this.pos = n;
    }

    public void write(int n) throws IOException {
        this.ensureCapacity(1);
        this.buf[this.pos++] = (byte)n;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.ensureCapacity(1);
        this.buf[this.pos++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.ensureCapacity(1);
        this.buf[this.pos++] = (byte)n;
    }

    public void writeChar(int n) throws IOException {
        this.ensureCapacity(2);
        this.buf[this.pos++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(n & 0xFF);
    }

    public void writeInt(int n) throws IOException {
        this.ensureCapacity(4);
        this.buf[this.pos++] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.pos++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.pos++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(n & 0xFF);
    }

    public void writeShort(int n) throws IOException {
        this.ensureCapacity(2);
        this.buf[this.pos++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(n & 0xFF);
    }

    public void writeUTF(String string) throws IOException {
        int n = string.length();
        this.ensureCapacity(n * 2 + 2);
        char[] cArray = new char[n];
        int n2 = this.pos;
        string.getChars(0, n, cArray, 0);
        this.pos += 2;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (c >= '\u0001' && c <= '\u007f') {
                this.buf[this.pos++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buf[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.pos++] = (byte)(0x80 | c & 0x3F);
            } else {
                this.buf[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buf[this.pos++] = (byte)(0x80 | c & 0x3F);
            }
            ++n3;
        }
        int n4 = this.pos - n2 - 2;
        this.buf[n2] = (byte)(n4 >>> 8 & 0xFF);
        this.buf[n2 + 1] = (byte)(n4 & 0xFF);
    }
}

