/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import oracle.xml.comp.CXMLCodeSpace;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNotation;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.util.HashInt;
import oracle.xml.util.NodeContext;

class CXMLNodeContext
implements NodeContext,
CXMLConstants {
    HashInt nodeOffsets;
    CXMLContext cxmlContext;
    XMLObjectInput ois;
    static final int CHAR_TK = 1;
    static final int BYTE_TK = 2;
    static final int INT_TK = 3;
    static final int TOKEN_TK = 4;
    static final int BOOL_TK = 5;
    static final int STR_TK = 6;
    static final int NSTR_TK = 7;
    static final int ATTR_TK = 8;
    static final int CHLD_TK = 9;
    static final int DOC_ORDERED = 0x100000;
    static final int FIRST_CHILD = 2;
    static final int LAST_CHILD = 4;
    static final int NEXT_NODE = 16;
    static final int[][] skipSpec = new int[][]{new int[1], {3, 4, 8, 9}, {3, 4, 6, 5}, {1, 6}, {1, 6}, {2, 6, 9}, {9, 6, 6, 6, 6, 6, 1, 5, 5, 5}, {3, 6, 6, 5}, {2, 6, 5}, {10, 1, 1, 1, 1, 2, 6, 6, 6, 6, 9}, new int[1], {5, 6, 5, 6, 6, 9}, {4, 6, 6, 6, 5}, {6, 6, 6, 5, 5, 5, 9}, {6, 6, 3, 3, 3, 6, 7, 5}, {3, 6, 6, 6}};

    public CXMLNodeContext(CXMLContext cXMLContext, XMLObjectInput xMLObjectInput) {
        this.ois = xMLObjectInput;
        this.cxmlContext = cXMLContext;
        this.nodeOffsets = new HashInt(513);
    }

    public XMLDocument getDocument() {
        try {
            XMLDocument xMLDocument = new XMLDocument();
            xMLDocument.setNodeContext(this);
            xMLDocument.readExternal(this.ois, this.cxmlContext);
            xMLDocument.setNodeFlag(6);
            xMLDocument.setNodeFlag(0x100000);
            this.nodeOffsets.putInt(xMLDocument.hashCode(), this.ois.getPosition());
            return xMLDocument;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public XMLNode getFirstChild(XMLNode xMLNode) {
        try {
            if (xMLNode instanceof XMLElement) {
                this.ois.setPosition(this.nodeOffsets.getInt(xMLNode.hashCode()));
                byte by = this.ois.peekByte();
                if (by == 22) {
                    this.ois.readByte();
                    return null;
                }
                XMLNode xMLNode2 = this.getNodeFromByte(by);
                xMLNode2.setNodeFlag(16);
                xMLNode2.readExternal(this.ois, this.cxmlContext);
                if (xMLNode2 instanceof DTD) {
                    xMLNode2.readChildNodes(this.ois, this.cxmlContext);
                }
                this.nodeOffsets.putInt(xMLNode2.hashCode(), this.ois.getPosition());
                return xMLNode2;
            }
            throw new RuntimeException();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public XMLNode getLastChild(XMLNode xMLNode) {
        XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild();
        if (xMLNode2 == null) {
            return null;
        }
        XMLNode xMLNode3 = xMLNode2;
        XMLNode xMLNode4 = (XMLNode)xMLNode2.getNextSibling();
        while (xMLNode4 != null) {
            xMLNode3 = xMLNode4;
            xMLNode4 = (XMLNode)xMLNode4.getNextSibling();
        }
        return xMLNode3;
    }

    public XMLNode getNextNode(XMLNode xMLNode) {
        try {
            byte by;
            this.ois.setPosition(this.nodeOffsets.getInt(xMLNode.hashCode()));
            if (xMLNode instanceof XMLElement) {
                this.skipToken(9, true);
            }
            if ((by = this.ois.peekByte()) == 22) {
                this.ois.readByte();
                return null;
            }
            XMLNode xMLNode2 = this.getNodeFromByte(by);
            xMLNode2.setNodeFlag(16);
            xMLNode2.readExternal(this.ois, this.cxmlContext);
            this.nodeOffsets.putInt(xMLNode2.hashCode(), this.ois.getPosition());
            return xMLNode2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private XMLNode getNodeFromByte(byte by) {
        XMLNode xMLNode;
        switch (by) {
            case 15: {
                xMLNode = new XMLElement();
                xMLNode.setNodeFlag(6);
                break;
            }
            case 24: {
                xMLNode = new XMLAttr();
                break;
            }
            case 23: {
                xMLNode = new XMLText();
                break;
            }
            case 21: {
                xMLNode = new XMLCDATA();
                break;
            }
            case 20: {
                xMLNode = new XMLPI();
                break;
            }
            case 29: {
                xMLNode = new XMLComment();
                break;
            }
            case 17: {
                xMLNode = new XMLEntity();
                break;
            }
            case 30: {
                xMLNode = new XMLEntityReference();
                xMLNode.setNodeFlag(6);
                break;
            }
            case 32: {
                xMLNode = new AttrDecl();
                break;
            }
            case 19: {
                xMLNode = new ElementDecl();
                break;
            }
            case 18: {
                xMLNode = new XMLNotation();
                break;
            }
            case 31: {
                xMLNode = new DTD();
                break;
            }
            case 16: {
                xMLNode = new XMLDeclPI();
                break;
            }
            default: {
                throw new RuntimeException("The byte is " + by);
            }
        }
        return xMLNode;
    }

    private int getNodeTypeFromByte(int n) {
        switch (n) {
            case 15: 
            case 28: {
                return 1;
            }
            case 24: 
            case 25: {
                return 2;
            }
            case 23: {
                return 3;
            }
            case 21: {
                return 4;
            }
            case 20: {
                return 7;
            }
            case 29: {
                return 8;
            }
            case 17: {
                return 6;
            }
            case 30: {
                return 5;
            }
            case 32: {
                return 14;
            }
            case 19: {
                return 13;
            }
            case 18: {
                return 12;
            }
            case 31: {
                return 10;
            }
            case 16: {
                return 15;
            }
        }
        throw new RuntimeException("The byte is " + n);
    }

    public XMLNode getParentNode(XMLNode xMLNode) {
        throw new RuntimeException("NodeContext.getParentNode not implemented");
    }

    public XMLNode getPrevNode(XMLNode xMLNode) {
        throw new RuntimeException("NodeContext.getPrevNode not implemented");
    }

    private void skipNode(byte by, boolean bl) throws Exception {
        int n = this.getNodeTypeFromByte(by);
        int n2 = skipSpec[n][0];
        int n3 = 1;
        while (n3 <= n2) {
            this.skipToken(skipSpec[n][n3], bl);
            ++n3;
        }
    }

    private void skipToken(int n, boolean bl) throws Exception {
        switch (n) {
            case 1: {
                this.ois.skipChar();
                return;
            }
            case 2: {
                this.ois.skipByte();
                return;
            }
            case 3: {
                this.ois.skipInt();
                return;
            }
            case 4: {
                byte by = this.ois.readByte();
                if ((by & 0xFF) < 128) {
                    return;
                }
                boolean bl2 = CXMLCodeSpace.isNamespacePresent(by);
                boolean bl3 = CXMLCodeSpace.isPrefixPresent(by);
                this.ois.readByte();
                if ((by & 0xC0) == 192) {
                    this.ois.readByte();
                }
                if (bl2 && ((by = this.ois.readByte()) & 0xC0) == 192) {
                    this.ois.readByte();
                }
                if (bl3 && ((by = this.ois.readByte()) & 0xC0) == 192) {
                    this.ois.readByte();
                }
                return;
            }
            case 5: {
                this.ois.skipBoolean();
                return;
            }
            case 6: {
                this.ois.skipUTF();
                return;
            }
            case 7: {
                int n2 = this.ois.readByte();
                int n3 = 0;
                while (n3 < n2) {
                    this.ois.skipUTF();
                    ++n3;
                }
                return;
            }
            case 8: {
                if (this.ois.peekByte() == 24) {
                    n = this.ois.readByte();
                    while (n != 22) {
                        int n4 = this.getNodeTypeFromByte(n);
                        int n5 = skipSpec[n4][0];
                        int n6 = 1;
                        while (n6 <= n5) {
                            this.skipToken(skipSpec[n4][n6], bl);
                            ++n6;
                        }
                        n = this.ois.readByte();
                    }
                }
                return;
            }
            case 9: {
                if (bl) {
                    byte by = this.ois.readByte();
                    while (by != 22) {
                        this.skipNode(by, bl);
                        by = this.ois.readByte();
                    }
                }
                return;
            }
        }
        throw new RuntimeException();
    }
}

