/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SAXParserFactory {
    private static final String defaultPropName = "javax.xml.parsers.SAXParserFactory";
    private boolean validating = false;
    private boolean namespaceAware = false;
    private static String foundFactory = null;
    private static boolean debug = false;

    protected SAXParserFactory() {
    }

    public static SAXParserFactory newInstance() {
        String factoryImplName = SAXParserFactory.findFactory(defaultPropName, "oracle.xml.jaxp.JXSAXParserFactory");
        if (factoryImplName == null) {
            throw new FactoryConfigurationError("No default implementation found");
        }
        SAXParserFactory factoryImpl = null;
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            factoryImpl = (SAXParserFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new FactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract SAXParser newSAXParser() throws SAXException, ParserConfigurationException;

    public void setNamespaceAware(boolean awareness) {
        this.namespaceAware = awareness;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public abstract void setFeature(String var1, boolean var2) throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException;

    public abstract boolean getFeature(String var1) throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException;

    private static String findFactory(String factoryId, String defaultFactory) {
        block17: {
            block16: {
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    foundFactory = System.getProperty(factoryId);
                    if (foundFactory != null) {
                        if (debug) {
                            System.err.println(String.valueOf("JAXP: found system property").concat(String.valueOf(foundFactory)));
                        }
                        String string = foundFactory;
                        return string;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(String.valueOf(String.valueOf(String.valueOf(javah).concat(String.valueOf(File.separator))).concat(String.valueOf("lib"))).concat(String.valueOf(File.separator))).concat(String.valueOf("jaxp.properties"));
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println(String.valueOf("JAXP: found java.home property ").concat(String.valueOf(foundFactory)));
                        }
                        if (foundFactory != null) {
                            String string = foundFactory;
                            return string;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block16;
                    ex.printStackTrace();
                }
            }
            String serviceId = String.valueOf("META-INF/services/").concat(String.valueOf(factoryId));
            try {
                ClassLoader cl = Class.forName(defaultPropName).getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println(String.valueOf("JAXP: found  ").concat(String.valueOf(serviceId)));
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println(String.valueOf("JAXP: loaded from services: ").concat(String.valueOf(foundFactory)));
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        String string = foundFactory;
                        return string;
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block17;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

