/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

public abstract class DocumentBuilderFactory {
    private static final String defaultPropName = "javax.xml.parsers.DocumentBuilderFactory";
    private boolean validating = false;
    private boolean namespaceAware = false;
    private boolean whitespace = false;
    private boolean expandEntityRef = true;
    private boolean ignoreComments = false;
    private boolean coalescing = false;
    private static String foundFactory = null;
    private static boolean debug = false;

    protected DocumentBuilderFactory() {
    }

    public static DocumentBuilderFactory newInstance() {
        DocumentBuilderFactory factoryImpl;
        String factoryImplName = DocumentBuilderFactory.findFactory(defaultPropName, "oracle.xml.jaxp.JXDocumentBuilderFactory");
        if (factoryImplName == null) {
            throw new FactoryConfigurationError("No default implementation found");
        }
        try {
            Class<?> clazz = Class.forName(factoryImplName);
            factoryImpl = (DocumentBuilderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new FactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract DocumentBuilder newDocumentBuilder() throws ParserConfigurationException;

    public void setNamespaceAware(boolean awareness) {
        this.namespaceAware = awareness;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setIgnoringElementContentWhitespace(boolean whitespace) {
        this.whitespace = whitespace;
    }

    public void setIgnoreElementContentWhitespace(boolean whitespace) {
        this.whitespace = whitespace;
    }

    public void setExpandEntityReferences(boolean expandEntityRef) {
        this.expandEntityRef = expandEntityRef;
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.whitespace;
    }

    public boolean isIgnoreElementContentWhitespace() {
        return this.whitespace;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityRef;
    }

    public boolean isIgnoringComments() {
        return this.ignoreComments;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    private static String findFactory(String factoryId, String defaultFactory) {
        block17: {
            block16: {
                try {
                    String systemProp = System.getProperty(factoryId);
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println(String.valueOf("JAXP: found system property").concat(String.valueOf(systemProp)));
                        }
                        String string = systemProp;
                        return string;
                    }
                }
                catch (SecurityException systemProp) {
                    // empty catch block
                }
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(String.valueOf(String.valueOf(String.valueOf(javah).concat(String.valueOf(File.separator))).concat(String.valueOf("lib"))).concat(String.valueOf(File.separator))).concat(String.valueOf("jaxp.properties"));
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println(String.valueOf("JAXP: found java.home property ").concat(String.valueOf(foundFactory)));
                        }
                        if (foundFactory != null) {
                            String string = foundFactory;
                            return string;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block16;
                    ex.printStackTrace();
                }
            }
            String serviceId = String.valueOf("META-INF/services/").concat(String.valueOf(factoryId));
            try {
                ClassLoader cl = Class.forName(defaultPropName).getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println(String.valueOf("JAXP: found  ").concat(String.valueOf(serviceId)));
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println(String.valueOf("JAXP: loaded from services: ").concat(String.valueOf(foundFactory)));
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        String string = foundFactory;
                        return string;
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block17;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

