/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.osgi.deployment.AbstractRegistry;
import org.apache.axis2.osgi.deployment.BundleClassLoader;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;
import org.apache.axis2.osgi.deployment.Registry;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRegistry
extends AbstractRegistry<AxisModule> {
    private static Log log = LogFactory.getLog(ModuleRegistry.class);
    private Registry serviceRegistry;

    public ModuleRegistry(BundleContext context, ConfigurationContext configCtx, Registry serviceRegistry) {
        super(context, configCtx);
        this.serviceRegistry = serviceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Bundle bundle) {
        this.lock.lock();
        try {
            this.addModules(bundle);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegister(Bundle bundle, boolean uninstall) {
        block13: {
            this.lock.lock();
            try {
                List moduleList = (List)this.resolvedBundles.get(bundle);
                if (moduleList == null) break block13;
                ArrayList<Long> stopBundleList = new ArrayList<Long>();
                for (AxisModule module : moduleList) {
                    AxisConfiguration axisConfig = this.configCtx.getAxisConfiguration();
                    Iterator<AxisServiceGroup> iterator = axisConfig.getServiceGroups();
                    while (iterator.hasNext()) {
                        Long value;
                        AxisServiceGroup axisServiceGroup = iterator.next();
                        if (!axisServiceGroup.isEngaged(module) || (value = (Long)axisServiceGroup.getParameterValue(OSGiAxis2Constants.OSGi_BUNDLE_ID)) == null) continue;
                        stopBundleList.add(value);
                    }
                    HashMap<String, AxisService> serviceMap = axisConfig.getServices();
                    Collection<AxisService> values = serviceMap.values();
                    for (AxisService value1 : values) {
                        Long value;
                        AxisService axisService = value1;
                        if (axisService.isEngaged(module) && (value = (Long)axisService.getParameterValue(OSGiAxis2Constants.OSGi_BUNDLE_ID)) != null && !stopBundleList.contains(value)) {
                            stopBundleList.add(value);
                        }
                        Iterator<AxisOperation> iterator1 = axisService.getOperations();
                        while (iterator1.hasNext()) {
                            Long value2;
                            AxisOperation axisOperation = iterator1.next();
                            if (!axisOperation.isEngaged(module) || (value2 = (Long)axisOperation.getParameterValue(OSGiAxis2Constants.OSGi_BUNDLE_ID)) == null || stopBundleList.contains(value2)) continue;
                            stopBundleList.add(value2);
                        }
                    }
                    Module moduleInterface = module.getModule();
                    if (moduleInterface != null) {
                        try {
                            moduleInterface.shutdown(this.configCtx);
                        }
                        catch (AxisFault e) {
                            String msg = "Error while shutting down the module : " + module.getName() + " : " + module.getVersion() + " moduel in Bundle - " + bundle.getSymbolicName();
                            log.error((Object)msg, (Throwable)e);
                        }
                    }
                    axisConfig.removeModule(module.getName(), module.getVersion());
                    if (this.resolvedBundles.containsKey(bundle)) {
                        this.resolvedBundles.remove(bundle);
                    }
                    log.info((Object)("[Axis2/OSGi] Stopping :" + module.getName() + " : " + module.getVersion() + " moduel in Bundle - " + bundle.getSymbolicName()));
                }
                for (Long bundleId : stopBundleList) {
                    Bundle unRegBundle = this.context.getBundle(bundleId.longValue());
                    if (unRegBundle == null) continue;
                    this.serviceRegistry.unRegister(unRegBundle, false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void addModules(Bundle bundle) {
        if (!this.resolvedBundles.containsKey(bundle)) {
            Enumeration enumeration = bundle.findEntries("META-INF", "*module.xml", false);
            ArrayList<AxisModule> moduleList = null;
            if (enumeration != null) {
                moduleList = new ArrayList<AxisModule>();
            }
            while (enumeration != null && enumeration.hasMoreElements()) {
                try {
                    String bundleVersion;
                    URL url = (URL)enumeration.nextElement();
                    AxisModule axismodule = new AxisModule();
                    BundleClassLoader loader = new BundleClassLoader(bundle, Registry.class.getClassLoader());
                    axismodule.setModuleClassLoader(loader);
                    AxisConfiguration axisConfig = this.configCtx.getAxisConfiguration();
                    ModuleBuilder builder = new ModuleBuilder(url.openStream(), axismodule, axisConfig);
                    Dictionary headers = bundle.getHeaders();
                    String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
                    if (bundleSymbolicName != null && bundleSymbolicName.length() != 0) {
                        axismodule.setName(bundleSymbolicName);
                    }
                    if ((bundleVersion = (String)headers.get("Bundle-Version")) != null && bundleVersion.length() != 0) {
                        String moduleVersion = "SNAPSHOT";
                        String[] versionSplit = bundleVersion.split("\\.");
                        if (versionSplit.length == 3) {
                            moduleVersion = versionSplit[0] + "." + versionSplit[1] + versionSplit[2];
                        } else if (versionSplit.length == 2) {
                            moduleVersion = versionSplit[0] + "." + versionSplit[1];
                        } else if (versionSplit.length == 1) {
                            moduleVersion = versionSplit[0];
                        }
                        axismodule.setVersion(moduleVersion);
                    }
                    builder.populateModule();
                    axismodule.setParent(axisConfig);
                    AxisModule module = axisConfig.getModule(axismodule.getName());
                    if (module == null) {
                        DeploymentEngine.addNewModule(axismodule, axisConfig);
                        Module moduleObj = axismodule.getModule();
                        if (moduleObj != null) {
                            moduleObj.init(this.configCtx, axismodule);
                        }
                        moduleList.add(axismodule);
                        log.info((Object)("[Axis2/OSGi] Starting any modules in Bundle - " + bundle.getSymbolicName() + " - Module Name : " + axismodule.getName() + " - Module Version : " + axismodule.getVersion()));
                    } else {
                        log.info((Object)("[ModuleRegistry] Module : " + axismodule.getName() + " is already available."));
                    }
                    Utils.calculateDefaultModuleVersion(axisConfig.getModules(), axisConfig);
                    this.serviceRegistry.resolve();
                }
                catch (IOException e) {
                    String msg = "Error while reading module.xml";
                    log.error((Object)msg, (Throwable)e);
                }
            }
            if (moduleList != null && moduleList.size() > 0) {
                this.resolvedBundles.put(bundle, moduleList);
            }
        }
    }

    @Override
    public void remove(Bundle bundle) {
        this.unRegister(bundle, true);
    }
}

