/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.InvalidAttributeValueException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.xdb.XDBError;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContext;

public class XDBResource {
    private static final String NAME_COMPONENT_SEPARATOR = "/";
    private int m_resCState;
    private String m_path;
    private Hashtable m_env;
    private static String CSTATE_NOT_INITIALIZED = "CSTATE_NOT_INITIALIZED";

    public XDBResource(Hashtable hashtable) throws NamingException {
        this.m_resCState = 0;
        this.m_path = (String)hashtable.get("java.naming.provider.url");
        long[] lArray = new long[1];
        long l = this.loadCState(this.m_path, lArray);
        if (l == 0L) {
            this.m_resCState = (int)lArray[0];
        }
    }

    public XDBResource(Hashtable hashtable, String string) throws NamingException {
        this.m_path = string;
        long[] lArray = new long[1];
        long l = this.loadCState(this.m_path, lArray);
        if (l == 0L) {
            this.m_resCState = (int)lArray[0];
        }
    }

    public XDBResource(Hashtable hashtable, String string, int n) throws NamingException {
        this.m_path = string;
        this.m_resCState = n;
    }

    private void checkCState() throws InvalidAttributeValueException {
        if (this.m_resCState == 0) {
            throw new InvalidAttributeValueException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
        }
    }

    public String getAuthor() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getAuthorNative(this.m_resCState);
    }

    private native String getAuthorNative(long var1);

    public String getComment() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getCommentNative(this.m_resCState);
    }

    private native String getCommentNative(long var1);

    public Object getContent() throws InvalidAttributeValueException {
        long l = 0L;
        Object object = null;
        this.checkCState();
        if (this.isDirNative(this.m_resCState)) {
            object = new XDBContext(this.m_env, this.m_path, this.m_resCState);
        } else {
            l = this.getContentNative(this.m_resCState);
            XDBDocument xDBDocument = new XDBDocument(null, l);
            String[] stringArray = new String[1];
            String string = XDBContext.getSchemaNameNative(xDBDocument.toCState(), stringArray);
            if (string == null) {
                object = xDBDocument;
            } else {
                try {
                    XMLTypeBean xMLTypeBean = (XMLTypeBean)DbmsJava.classForNameAndSchema((String)string, (String)stringArray[0].toUpperCase()).newInstance();
                    xMLTypeBean.setOwner(xDBDocument);
                    xMLTypeBean.setKidNum(0L);
                    xMLTypeBean.setXobCstate(((XDBNode)((Object)xDBDocument.getDocumentElement())).toCState());
                    object = xMLTypeBean;
                }
                catch (Exception exception) {
                    object = xDBDocument;
                }
            }
        }
        return object;
    }

    private native long getContentNative(long var1);

    public String getContentType() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getContentTypeNative(this.m_resCState);
    }

    private native String getContentTypeNative(long var1);

    public Date getCreateDate() throws InvalidAttributeValueException {
        this.checkCState();
        DateFormat dateFormat = DateFormat.getDateInstance();
        try {
            Date date = dateFormat.parse(this.getCreateDateNative(this.m_resCState));
            return date;
        }
        catch (ParseException parseException) {
            throw new InvalidAttributeValueException();
        }
    }

    private native String getCreateDateNative(long var1);

    public String getDisplayName() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getDisplayNameNative(this.m_resCState);
    }

    private native String getDisplayNameNative(long var1);

    public String getLanguage() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getLanguageNative(this.m_resCState);
    }

    private native String getLanguageNative(long var1);

    public Date getLastModDate() throws InvalidAttributeValueException {
        this.checkCState();
        DateFormat dateFormat = DateFormat.getDateInstance();
        try {
            Date date = dateFormat.parse(this.getLastModDateNative(this.m_resCState));
            return date;
        }
        catch (ParseException parseException) {
            throw new InvalidAttributeValueException();
        }
    }

    private native String getLastModDateNative(long var1);

    public long getOwnerId() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getOwnerIdNative(this.m_resCState);
    }

    private native long getOwnerIdNative(long var1);

    private native boolean isDirNative(long var1);

    private native long loadCState(String var1, long[] var2);

    public void setACL(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setACLNative(this.m_resCState, string, false);
    }

    private native long setACLNative(long var1, String var3, boolean var4);

    public void setAuthor(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setAuthorNative(this.m_resCState, string);
    }

    private native void setAuthorNative(long var1, String var3);

    public void setComment(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setCommentNative(this.m_resCState, string);
    }

    private native void setCommentNative(long var1, String var3);

    public void setContent(Object object) throws InvalidAttributeValueException, OperationNotSupportedException {
        long l = 0L;
        this.checkCState();
        if (object instanceof XMLTypeBean) {
            l = ((XMLTypeBean)object).m_owner.toCState();
        } else if (object instanceof XDBDocument) {
            l = ((XDBDocument)object).toCState();
        } else {
            if (object instanceof XDBContext) {
                return;
            }
            throw new OperationNotSupportedException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
        }
        this.setContentNative(this.m_resCState, l);
    }

    private native long setContentNative(long var1, long var3);

    public void setContentType(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setContentTypeNative(this.m_resCState, string);
    }

    private native void setContentTypeNative(long var1, String var3);

    public void setCreateDate(Date date) throws InvalidAttributeValueException {
        this.checkCState();
        DateFormat dateFormat = DateFormat.getDateInstance();
        this.setCreateDateNative(this.m_resCState, dateFormat.format(date));
    }

    private native void setCreateDateNative(long var1, String var3);

    public void setDisplayName(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setDisplayNameNative(this.m_resCState, string);
    }

    private native void setDisplayNameNative(long var1, String var3);

    public void setInheritedACL(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setACLNative(this.m_resCState, string, true);
    }

    public void setLanguage(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setLanguageNative(this.m_resCState, string);
    }

    private native void setLanguageNative(long var1, String var3);

    public void setLastModDate(Date date) throws InvalidAttributeValueException {
        this.checkCState();
        DateFormat dateFormat = DateFormat.getDateInstance();
        this.setLastModDateNative(this.m_resCState, dateFormat.format(date));
    }

    private native void setLastModDateNative(long var1, String var3);

    public void setOwnerId(long l) throws InvalidAttributeValueException {
        this.checkCState();
        this.setOwnerIdNative(this.m_resCState, l);
    }

    private native void setOwnerIdNative(long var1, long var3);
}

