/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.xdb.XDBError;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContextFactory;
import oracle.xdb.spi.XDBNameParser;
import oracle.xdb.spi.XDBNamingEnumeration;
import oracle.xdb.spi.XDBResource;

public class XDBContext
implements Context {
    private static final String NAME_COMPONENT_SEPARATOR = "/";
    public static final long RES_OBJ = 1L;
    public static final int OBJ_CONTAINER = 0;
    public static final int OBJ_DOCUMENT = 1;
    private static final char NAME_ABSOLUTE_PREFIX = '/';
    public Hashtable m_env;
    public long m_cstate;
    public String m_path;
    private static final int NO_ERROR = 0;
    private static final int NOT_CONTAINER_ERROR = 1;
    private static final int NOT_FOUND_ERROR = 2;
    private static final int NOT_DONE = 3;
    private static final int INVALID_HANDLE = 4;
    private static final int ENTRY_EXISTS_ERROR = 5;
    private static final int OTHER_ERROR = 6;
    private static final int INV_RESHDL_OR_PATH_ERR = 31001;
    private static final int NOT_CONT_ERR = 31002;
    private static final int ENTRY_EXISTS_ERR = 31003;
    private static final int DBBLKSIZE_TOO_SMALL_ERR = 31004;
    private static final int PATHNAME_TOO_LONG_ERR = 31005;
    private static final int PATH_SEGMENT_TOO_LONG_ERR = 31006;
    private static final int DEL_NONEMPTY_CONT_ERR = 31007;
    private static final int XDB_SPI_UNBIND_CONTEXT_ERR = 1;
    private static final int XDB_SPI_ENUM_EMPTY_ERR = 3;
    protected static XDBNameParser s_parser = new XDBNameParser();

    public XDBContext(Hashtable hashtable) {
        long[] lArray = new long[2];
        this.m_env = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.m_path = (String)hashtable.get("java.naming.provider.url");
        if (this.m_path == null) {
            this.m_path = NAME_COMPONENT_SEPARATOR;
        }
        lArray[0] = this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE ? 1L : 0L;
        long l = this.lookupNative(this.m_path, lArray);
        this.m_cstate = l == 0L ? lArray[1] : 0L;
    }

    public XDBContext(Hashtable hashtable, String string) {
        this.m_env = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.m_path = string;
        long[] lArray = new long[2];
        if (this.m_path == null) {
            this.m_path = NAME_COMPONENT_SEPARATOR;
        }
        lArray[0] = this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE ? 1L : 0L;
        long l = this.lookupNative(this.m_path, lArray);
        this.m_cstate = l == 0L ? lArray[1] : 0L;
    }

    public XDBContext(Hashtable hashtable, String string, long l) {
        this.m_env = hashtable != null ? (Hashtable)hashtable.clone() : null;
        this.m_path = string;
        if (this.m_path == null) {
            this.m_path = NAME_COMPONENT_SEPARATOR;
        }
        this.m_cstate = l;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        Object var3_3 = null;
        if (string == null || object == null) {
            throw new NamingException(XDBError.getMsg("XDB_INVALID_PARAM"));
        }
        if (this.m_env != null) {
            var3_3 = this.m_env.get(string);
            this.m_env.put(string, object);
        }
        return var3_3;
    }

    public void bind(String string, Object object) throws NamingException {
        long l = 0L;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        if (object instanceof XMLTypeBean) {
            l = ((XMLTypeBean)object).m_owner.toCState();
        } else if (object instanceof XDBDocument) {
            l = ((XDBDocument)object).toCState();
        } else if (object instanceof XDBContext) {
            l = ((XDBContext)object).toCState();
        } else if (object instanceof XDBResource) {
            bl = true;
        } else {
            throw new OperationNotSupportedException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
        }
        long l2 = this.bindNative(this.makeAbsoluteName(string, this.m_path), l, bl);
        if (l2 != 0L) {
            this.throwException(l2, string);
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.bind(name.toString(), object);
    }

    private native long bindNative(String var1, long var2, boolean var4);

    public void close() {
        if (this.m_cstate != 0L) {
            this.closeNative(this.m_cstate);
        }
        this.m_env = null;
    }

    private native long closeNative(long var1);

    public String composeName(String string, String string2) {
        return String.valueOf(string2) + NAME_COMPONENT_SEPARATOR + string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    private native long createSubNative(String var1);

    public Context createSubcontext(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        long l = this.createSubNative(string2);
        if (l != 0L) {
            this.throwException(l, string);
        } else if ((String)this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) != XDBContextFactory.RETURN_TYPE_RESOURCE) {
            return new XDBContext(this.m_env, string2);
        }
        return null;
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.createSubcontext(name.toString());
    }

    private native long destroySubNative(String var1);

    public void destroySubcontext(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        long l = this.destroySubNative(this.makeAbsoluteName(string, this.m_path));
        if (l != 0L) {
            this.throwException(l, string);
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.destroySubcontext(name.toString());
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.m_env == null) {
            return new Hashtable();
        }
        return (Hashtable)this.m_env.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return this.m_path;
    }

    public NameParser getNameParser(String string) throws NamingException {
        return s_parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public static native String getSchemaNameNative(long var0, String[] var2);

    public static native long getServerEnv();

    public NamingEnumeration list(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        long[] lArray = new long[1];
        long l = this.listNative(this.makeAbsoluteName(string, this.m_path), lArray);
        if (l == 0L) {
            return new XDBNamingEnumeration(this.m_env, XDBNamingEnumeration.NAMING_TYPE_NAMEPAIR, this.makeAbsoluteName(string, this.m_path), lArray[0]);
        }
        this.throwException(l, string);
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        long[] lArray = new long[1];
        long l = this.listNative(this.makeAbsoluteName(string, this.m_path), lArray);
        if (l == 0L) {
            return new XDBNamingEnumeration(this.m_env, XDBNamingEnumeration.NAMING_TYPE_BINDING, this.makeAbsoluteName(string, this.m_path), lArray[0]);
        }
        this.throwException(l, string);
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.listBindings(name.toString());
    }

    private native long listNative(String var1, long[] var2);

    public Object lookup(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String string2 = this.makeAbsoluteName(string, this.m_path);
        long[] lArray = new long[2];
        lArray[0] = this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE ? 1L : 0L;
        long l = this.lookupNative(string2, lArray);
        if (l == 0L) {
            if (this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE) {
                return new XDBResource(this.m_env, string, (int)lArray[1]);
            }
            if (lArray[0] == 0L) {
                return new XDBContext(this.m_env, string, lArray[1]);
            }
            XDBDocument xDBDocument = new XDBDocument(null, lArray[1]);
            String[] stringArray = new String[1];
            String string3 = XDBContext.getSchemaNameNative(xDBDocument.toCState(), stringArray);
            if (string3 == null) {
                return xDBDocument;
            }
            try {
                Object t = DbmsJava.classForNameAndSchema((String)string3, (String)stringArray[0].toUpperCase()).newInstance();
                XMLTypeBean xMLTypeBean = (XMLTypeBean)t;
                xMLTypeBean.setOwner(xDBDocument);
                xMLTypeBean.setKidNum(0L);
                xMLTypeBean.setXobCstate(((XDBNode)((Object)xDBDocument.getDocumentElement())).toCState());
                return xMLTypeBean;
            }
            catch (Exception exception) {
                return xDBDocument;
            }
        }
        this.throwException(l, string);
        return null;
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.lookup(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    private native long lookupNative(String var1, long[] var2);

    private String makeAbsoluteName(String string, String string2) throws NamingException {
        if (string.charAt(0) == '/') {
            return string;
        }
        return this.composeName(string, string2);
    }

    public void rebind(String string, Object object) throws NamingException {
        try {
            this.unbind(string);
        }
        catch (Exception exception) {}
        this.bind(string, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.rebind(name.toString(), object);
    }

    public Object removeFromEnvironment(String string) {
        if (this.m_env == null) {
            return null;
        }
        return this.m_env.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        long l = this.renameNative(this.makeAbsoluteName(string, this.m_path), this.makeAbsoluteName(string2, this.m_path));
        if (l != 0L) {
            this.throwException(l, string);
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name == null || name2 == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.rename(name.toString(), name2.toString());
    }

    private native long renameNative(String var1, String var2);

    private void throwException(long l, String string) throws NameNotFoundException, NotContextException, NameAlreadyBoundException, NamingException, ContextNotEmptyException, NoSuchElementException, RuntimeException {
        switch ((int)l) {
            case 2: 
            case 31001: {
                throw new NameNotFoundException(string);
            }
            case 31002: {
                throw new NotContextException(string);
            }
            case 31003: {
                throw new NameAlreadyBoundException(string);
            }
            case 31005: {
                throw new NamingException(String.valueOf(string) + " " + XDBError.getMsg("PATH_TOO_LONG"));
            }
            case 31006: {
                throw new NamingException(String.valueOf(string) + " " + XDBError.getMsg("PATH_ELEM_TOO_LONG"));
            }
            case 31007: {
                throw new ContextNotEmptyException(string);
            }
            case 1: {
                throw new NamingException(String.valueOf(string) + " " + XDBError.getMsg("CANT_UNBIND_SUBCONTEXT"));
            }
            case 3: {
                throw new NoSuchElementException(XDBError.getMsg("END_OF_ENUM"));
            }
        }
        throw new RuntimeException(string);
    }

    public long toCState() {
        return this.m_cstate;
    }

    public void unbind(String string) throws NamingException {
        if (string == null || string.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        long l = this.unbindNative(this.makeAbsoluteName(string, this.m_path));
        if (l != 0L) {
            this.throwException(l, string);
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    private native long unbindNative(String var1);
}

