/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import oracle.xdb.servlet.XDBStream;

public class XDBServletResponse
extends ServletOutputStream
implements HttpServletResponse,
XDBStream {
    private static final boolean DEBUG = false;
    private Locale loc_ = Locale.getDefault();
    private Hashtable headers_ = new Hashtable();
    private byte[] localbuf_;
    private PrintWriter writer_;
    private int statusCode_ = 200;
    private int offset_;
    private boolean committed_ = false;
    private int length_ = -1;
    private String charEncoding_ = "ISO-8859-1";
    private boolean flushing_writer_ = false;
    static final String[] dayNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] monthNames = new String[]{" Jan ", " Feb ", " Mar ", " Apr ", " May ", " Jun ", " Jul ", " Aug ", " Sep ", " Oct ", " Nov ", " Dec "};

    public final void addCookie(Cookie cookie) {
        Vector vector;
        Object v = this.headers_.get("Set-Cookie");
        String string = XDBServletResponse.cookieToString(cookie);
        if (string == null) {
            return;
        }
        if (v == null || v instanceof String) {
            vector = new Vector();
            this.headers_.put("Set-Cookie", vector);
        } else if (v instanceof Vector) {
            vector = (Vector)v;
        } else {
            throw new RuntimeException("Value of Set-Cookie header must be Vector/String");
        }
        if (v != null && v instanceof String) {
            vector.add((String)v);
        }
        vector.add(string);
    }

    public final void addDateHeader(String string, long l) {
        this.addHeader(string, XDBServletResponse.dateToString(l));
    }

    public final void addHeader(String string, String string2) {
        String string3 = this.headers_.put(string, string2);
        if (string3 != null) {
            Vector<String> vector = new Vector<String>();
            if (string3 instanceof Collection) {
                vector.addAll((Collection)((Object)string3));
            } else {
                vector.add(string3);
            }
            vector.add(string2);
            this.headers_.put(string, vector);
        }
    }

    public final void addIntHeader(String string, int n) {
        this.addHeader(string, Integer.toString(n));
    }

    public void close() throws IOException {
        if (!this.committed_) {
            this.writeHeaders();
        }
        if (this.localbuf_ != null && this.offset_ > 0) {
            this.write_data(this.localbuf_, 0, this.offset_);
            this.offset_ = 0;
        }
        this.close_stream();
    }

    native void close_stream();

    public final boolean containsHeader(String string) {
        return this.headers_.get(string) != null;
    }

    private static String cookieToString(Cookie cookie) {
        if (cookie.getName() == null || cookie.getValue() == null) {
            return null;
        }
        String string = String.valueOf(cookie.getName()) + "=" + cookie.getValue();
        if (cookie.getComment() != null) {
            string = String.valueOf(string) + "; Comment=" + cookie.getComment();
        }
        if (cookie.getDomain() != null) {
            string = String.valueOf(string) + "; Domain=" + cookie.getDomain();
        }
        if (cookie.getMaxAge() >= 0) {
            string = String.valueOf(string) + "; Max-Age=" + cookie.getMaxAge();
        }
        if (cookie.getPath() != null) {
            string = String.valueOf(string) + "; Path=" + cookie.getPath();
        }
        if (cookie.getSecure()) {
            string = String.valueOf(string) + "; Secure";
        }
        string = String.valueOf(string) + "; Version=" + cookie.getVersion();
        return string;
    }

    private static String dateToString(long l) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone, Locale.US);
        StringBuffer stringBuffer = new StringBuffer();
        gregorianCalendar.setTime(new Date(l));
        stringBuffer.append(dayNames[gregorianCalendar.get(7) - 1]);
        stringBuffer.append(", ");
        stringBuffer.append(gregorianCalendar.get(5));
        stringBuffer.append(monthNames[gregorianCalendar.get(2)]);
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append(" ");
        stringBuffer.append(gregorianCalendar.get(11));
        stringBuffer.append(":");
        stringBuffer.append(gregorianCalendar.get(12));
        stringBuffer.append(":");
        stringBuffer.append(gregorianCalendar.get(13));
        stringBuffer.append(" GMT");
        return stringBuffer.toString();
    }

    public final String encodeRedirectURL(String string) {
        return string;
    }

    public final String encodeRedirectUrl(String string) {
        return string;
    }

    public final String encodeURL(String string) {
        return string;
    }

    public final String encodeUrl(String string) {
        return string;
    }

    private native void endOfHeaders(int var1);

    public void flush() throws IOException {
        if (this.flushing_writer_) {
            return;
        }
        if (!this.committed_) {
            this.writeHeaders();
        }
        if (this.localbuf_ != null && this.offset_ > 0) {
            this.write_data(this.localbuf_, 0, this.offset_);
            this.offset_ = 0;
        }
        this.flush_data();
    }

    public void flushBuffer() throws IOException {
        this.flush();
    }

    native void flush_data();

    public final int getBufferSize() {
        if (this.localbuf_ == null) {
            return 0;
        }
        return this.localbuf_.length;
    }

    public final String getCharacterEncoding() {
        return this.charEncoding_;
    }

    public final Locale getLocale() {
        return this.loc_;
    }

    public final ServletOutputStream getOutputStream() {
        return this;
    }

    public final PrintWriter getWriter() throws IOException {
        if (this.writer_ == null) {
            this.writer_ = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this), this.charEncoding_));
        }
        return this.writer_;
    }

    private final native String get_req_abspath();

    private final native String get_uri_prefix();

    public boolean isCommitted() {
        return this.committed_;
    }

    public final void print(String string) throws IOException {
        if (this.writer_ == null) {
            this.writer_ = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this), this.charEncoding_));
        }
        this.writer_.print(string);
        this.flushing_writer_ = true;
        this.writer_.flush();
        this.flushing_writer_ = false;
    }

    public void println(String string) throws IOException {
        if (this.writer_ == null) {
            this.writer_ = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this), this.charEncoding_));
        }
        this.writer_.println(string);
        this.flushing_writer_ = true;
        this.writer_.flush();
        this.flushing_writer_ = false;
    }

    public final void reset() {
        this.headers_.clear();
        this.offset_ = 0;
        this.statusCode_ = 200;
    }

    public final void sendError(int n) {
        this.sendError(n, null);
    }

    public final void sendError(int n, String string) {
        if (this.committed_) {
            throw new IllegalStateException("Servlet response already commited");
        }
        this.send_error(n, string);
        this.committed_ = true;
        this.offset_ = 0;
    }

    public final void sendRedirect(String string) throws IOException {
        String string2 = string;
        if (this.committed_) {
            throw new IllegalStateException("Cannot redirect after response is committed");
        }
        this.headers_.clear();
        this.localbuf_ = null;
        if (string.indexOf("://") == -1) {
            String string3 = this.get_uri_prefix();
            if (!string.startsWith(System.getProperty("file.separator"))) {
                string2 = String.valueOf(this.get_req_abspath()) + string2;
            }
            if (string3 != null) {
                string2 = String.valueOf(string3) + string2;
            }
        }
        this.setStatus(307);
        this.setHeader("Location", string2);
        this.writeHeaders();
    }

    private final native void send_error(int var1, String var2);

    public final void setBufferSize(int n) {
        if (this.localbuf_ != null || this.committed_) {
            throw new IllegalStateException("Content already written to output");
        }
        this.localbuf_ = new byte[n];
    }

    public final void setContentLength(int n) {
        this.headers_.put("Content-Length", Integer.toString(n));
        this.length_ = n;
    }

    public final void setContentType(String string) {
        this.headers_.put("Content-Type", string);
    }

    public final void setDateHeader(String string, long l) {
        this.headers_.put(string, XDBServletResponse.dateToString(l));
    }

    public final void setHeader(String string, String string2) {
        this.headers_.put(string, string2);
    }

    public final void setIntHeader(String string, int n) {
        this.headers_.put(string, Integer.toString(n));
    }

    public final void setLocale(Locale locale) {
        this.loc_ = locale;
    }

    public final void setStatus(int n) {
        this.statusCode_ = n;
    }

    public final void setStatus(int n, String string) {
        this.setStatus(n);
    }

    public final void write(int n) throws IOException {
        if (this.localbuf_ != null) {
            if (this.offset_ == this.localbuf_.length) {
                if (!this.committed_) {
                    this.writeHeaders();
                }
                this.write_data(this.localbuf_, 0, this.localbuf_.length);
                this.offset_ = 0;
            }
            this.localbuf_[this.offset_++] = (byte)n;
            return;
        }
        byte[] byArray = new byte[]{(byte)n};
        this.write_data(byArray, 0, 1);
    }

    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            Thread.dumpStack();
            return;
        }
        if (this.localbuf_ != null) {
            int n3 = this.localbuf_.length - this.offset_;
            int n4 = n2 - n3;
            if (n4 < 0) {
                System.arraycopy(byArray, n, this.localbuf_, this.offset_, n2);
                this.offset_ += n2;
                return;
            }
            System.arraycopy(byArray, n, this.localbuf_, this.offset_, n3);
            this.offset_ = this.localbuf_.length;
            n += n4;
            n2 -= n4;
            if (!this.committed_) {
                this.writeHeaders();
            }
            this.write_data(this.localbuf_, 0, this.localbuf_.length);
            this.offset_ = 0;
        }
        if (!this.committed_) {
            this.writeHeaders();
        }
        this.write_data(byArray, n, n2);
    }

    private void writeHeaders() throws IOException {
        Enumeration enumeration = this.headers_.keys();
        Enumeration enumeration2 = this.headers_.elements();
        this.write_status(this.statusCode_);
        this.committed_ = true;
        if (enumeration.hasMoreElements()) {
            boolean bl;
            do {
                String string = (String)enumeration.nextElement();
                Object v = enumeration2.nextElement();
                bl = enumeration.hasMoreElements();
                if (v instanceof Vector) {
                    Object[] objectArray = ((Vector)v).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        this.write_header(!bl && n2 == n - 1, this.length_, string, (String)objectArray[n2]);
                        ++n2;
                    }
                } else {
                    this.write_header(bl ^ true, this.length_, string, v.toString());
                }
            } while (bl);
        } else {
            this.endOfHeaders(this.length_);
        }
    }

    public final void writeXMLNative(long l, String string, short s) throws IOException {
        if (!this.committed_) {
            this.writeHeaders();
        }
        this.write_xml(l, string, s);
    }

    native void write_data(byte[] var1, int var2, int var3);

    native void write_header(boolean var1, int var2, String var3, String var4);

    native void write_status(int var1);

    private native void write_xml(long var1, String var3, short var4);
}

