/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.servlet.XDBStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XDBNode
implements Node {
    public XDBDocument m_owner;
    public long m_xobcstate;
    short m_type;
    Connection m_conn;
    boolean m_closed = false;

    XDBNode(XDBDocument xDBDocument, long l) {
        this.m_owner = xDBDocument;
        this.m_xobcstate = l;
        this.m_type = 0;
    }

    XDBNode(XDBDocument xDBDocument, long l, short s) {
        this.m_owner = xDBDocument;
        this.m_xobcstate = l;
        this.m_type = s;
    }

    public Node appendChild(Node node) throws DOMException {
        return null;
    }

    public Node cloneNode(boolean bl) {
        return null;
    }

    public void close() {
        this.freeNode();
    }

    private synchronized native void closeNodeNative(long var1, long var3);

    public boolean equals(Object object) {
        if (object instanceof XDBNode) {
            return this.m_xobcstate == ((XDBNode)object).m_xobcstate;
        }
        return false;
    }

    public void finalize() throws Throwable {
    }

    private void freeNode() {
        if (this.m_type == 9 || this.m_type == 11) {
            ((XDBDocument)this).close();
        } else {
            if (this.m_closed) {
                return;
            }
            this.closeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
            this.m_closed = true;
        }
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public NodeList getChildNodes() {
        if (this.isClosed()) {
            return null;
        }
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public String getLocalName() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2) {
            return this.getLocalNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    private synchronized native String getLocalNameNative(long var1, long var3);

    private synchronized native String getNSUriNative(long var1, long var3);

    public String getNamespaceURI() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2) {
            return this.getNSUriNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        if (this.isClosed()) {
            return null;
        }
        return this.getNodeNameNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native String getNodeNameNative(long var1, long var3);

    public short getNodeType() {
        if (this.isClosed()) {
            return 0;
        }
        return this.m_type;
    }

    public String getNodeValue() {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 8 || this.m_type == 3 || this.m_type == 7) {
            return this.getNodeValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    private synchronized native String getNodeValueNative(long var1, long var3);

    private synchronized native long getOwnerDocNative(long var1, long var3);

    public Document getOwnerDocument() {
        return this.m_owner;
    }

    public Node getParentNode() {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 9 || this.m_type == 11 || this.m_type == 12 || this.m_type == 6) {
            return null;
        }
        long l = this.getParentNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        if (l != 0L) {
            return new XDBElement(this.m_owner, l);
        }
        return null;
    }

    private synchronized native long getParentNodeNative(long var1, long var3);

    public String getPrefix() {
        if (this.isClosed()) {
            return null;
        }
        if (this.m_type == 2) {
            return this.getPrefixNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        }
        return null;
    }

    private synchronized native String getPrefixNative(long var1, long var3);

    public Node getPreviousSibling() {
        return null;
    }

    public Node getSchemaNode() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getSchemaNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        long l2 = this.getOwnerDocNative(XDBDocument.getGP(this.m_owner.m_conn), l);
        return new XDBElement(new XDBDocument(this.m_owner.m_conn, l2), l);
    }

    private synchronized native long getSchemaNodeNative(long var1, long var3);

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return null;
    }

    protected boolean isClosed() {
        return this.m_closed || this.m_owner.isClosed();
    }

    public boolean isSupported(String string, String string2) {
        return true;
    }

    public void normalize() {
    }

    public Node removeChild(Node node) throws DOMException {
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2 || this.m_type == 8 || this.m_type == 3 || this.m_type == 7) {
            this.setNodeValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string);
        }
    }

    private synchronized native void setNodeValueNative(long var1, long var3, String var5);

    public void setPrefix(String string) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (this.m_type == 2) {
            this.setPrefixNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string);
        }
    }

    private synchronized native void setPrefixNative(long var1, long var3, String var5);

    public long toCState() {
        return this.m_xobcstate;
    }

    public String toString() {
        if (this.isClosed()) {
            return null;
        }
        return this.toStringNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private synchronized native String toStringNative(long var1, long var3);

    public void write(OutputStream outputStream, String string, short s) throws IOException {
        if (!(outputStream instanceof XDBStream)) {
            throw new RuntimeException("Stream type " + outputStream.getClass() + " not supported");
        }
        ((XDBStream)((Object)outputStream)).writeXMLNative(this.m_xobcstate, string, s);
    }
}

