/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBComment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNamedNodeMap;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBNodeList;
import oracle.xdb.dom.XDBProcInst;
import oracle.xdb.dom.XDBText;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDBElement
extends XDBNode
implements Element {
    public XDBDocument m_owner;

    public XDBElement(XDBDocument xDBDocument, long l) {
        super(xDBDocument, l, (short)1);
        this.m_owner = xDBDocument;
    }

    public Node appendChild(Node node) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.appendChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState());
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long appendChildNative(long var1, long var3, long var5);

    private native long getAttrNodeNative(long var1, long var3, String var5, String var6);

    private native String getAttrValueNative(long var1, long var3, String var5, String var6);

    public String getAttribute(String string) {
        if (this.isClosed()) {
            return null;
        }
        return this.getAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, string);
    }

    private native long getAttributeMapNative(long var1, long var3);

    public String getAttributeNS(String string, String string2) {
        if (this.isClosed()) {
            return null;
        }
        return this.getAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string, string2);
    }

    public Attr getAttributeNode(String string) {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, string);
        if (l != 0L) {
            return new XDBAttribute(this.m_owner, this, l);
        }
        return null;
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.getAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string, string2);
        if (l != 0L) {
            return new XDBAttribute(this.m_owner, this, l);
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getAttributeMapNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return new XDBNamedNodeMap(this.m_owner, l);
    }

    public NodeList getChildNodes() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getChildNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return new XDBNodeList(l, this.m_owner);
    }

    private native long getChildNodesNative(long var1, long var3);

    private native long getChildTypeNative(long var1, long var3);

    public NodeList getElementsByTagName(String string) {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getElementsNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, string);
        return new XDBNodeList(l, this.m_owner);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getElementsNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string, string2);
        return new XDBNodeList(l, this.m_owner);
    }

    private native long getElementsNative(long var1, long var3, String var5, String var6);

    public Node getFirstChild() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getFirstChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long getFirstChildNative(long var1, long var3);

    public Node getLastChild() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getLastChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long getLastChildNative(long var1, long var3);

    public Node getNextSibling() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getNextSiblingNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long getNextSiblingNative(long var1, long var3);

    private Node getNodeFromCState(XDBDocument xDBDocument, long l) {
        XDBNode xDBNode;
        if (l == 0L) {
            return null;
        }
        long l2 = this.getChildTypeNative(XDBDocument.getGP(xDBDocument.m_conn), l);
        switch ((int)l2) {
            case 1: {
                xDBNode = new XDBElement(xDBDocument, l);
                break;
            }
            case 2: {
                xDBNode = new XDBAttribute(xDBDocument, l);
                break;
            }
            case 3: {
                xDBNode = new XDBText(xDBDocument, l);
                break;
            }
            case 7: {
                xDBNode = new XDBProcInst(xDBDocument, l);
                break;
            }
            case 8: {
                xDBNode = new XDBComment(xDBDocument, l);
                break;
            }
            default: {
                xDBNode = null;
            }
        }
        return xDBNode;
    }

    public Node getPreviousSibling() {
        if (this.isClosed()) {
            return null;
        }
        long l = this.getPreviousSiblingNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long getPreviousSiblingNative(long var1, long var3);

    public String getTagName() {
        if (this.isClosed()) {
            return null;
        }
        return super.getNodeName();
    }

    private native boolean hasAttrNative(long var1, long var3, String var5, String var6);

    public boolean hasAttribute(String string) {
        if (this.isClosed()) {
            return false;
        }
        return this.hasAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, string);
    }

    public boolean hasAttributeNS(String string, String string2) {
        if (this.isClosed()) {
            return false;
        }
        return this.hasAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string, string2);
    }

    public boolean hasAttributes() {
        if (this.isClosed()) {
            return false;
        }
        return this.hasAttributesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private native boolean hasAttributesNative(long var1, long var3);

    public boolean hasChildNodes() {
        if (this.isClosed()) {
            return false;
        }
        return this.hasChildNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate);
    }

    private native boolean hasChildNodesNative(long var1, long var3);

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.insertBeforeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState(), ((XDBNode)node2).toCState());
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long insertBeforeNative(long var1, long var3, long var5, long var7);

    private native void removeAttrNative(long var1, long var3, String var5, String var6);

    private native void removeAttrNodeNative(long var1, long var3, long var5);

    public void removeAttribute(String string) {
        if (this.isClosed()) {
            return;
        }
        this.removeAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, string);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        this.removeAttrNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string, string2);
    }

    public Attr removeAttributeNode(Attr attr) {
        if (this.isClosed()) {
            return null;
        }
        XDBAttribute xDBAttribute = (XDBAttribute)attr;
        this.removeAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, xDBAttribute.toCState());
        return attr;
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.removeChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState());
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long removeChildNative(long var1, long var3, long var5);

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long l = this.replaceChildNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, ((XDBNode)node).toCState(), ((XDBNode)node2).toCState());
        return this.getNodeFromCState(this.m_owner, l);
    }

    private native long replaceChildNative(long var1, long var3, long var5, long var7);

    private native void setAttrNodeNative(long var1, long var3, long var5);

    private native void setAttrValueNative(long var1, long var3, String var5, String var6, String var7);

    public void setAttribute(String string, String string2) {
        if (this.isClosed()) {
            return;
        }
        this.setAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, null, string, string2);
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        this.setAttrValueNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, string, string2, string3);
    }

    public Attr setAttributeNode(Attr attr) {
        if (this.isClosed()) {
            return null;
        }
        XDBAttribute xDBAttribute = (XDBAttribute)attr;
        this.setAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, xDBAttribute.toCState());
        return attr;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (this.isClosed()) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBAttribute xDBAttribute = (XDBAttribute)attr;
        this.setAttrNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_xobcstate, xDBAttribute.toCState());
        return attr;
    }
}

