/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci8.OCIDBAccess;
import oracle.jdbc.oracore.Util;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.xdb.RealInputStream;
import oracle.xdb.XDBError;
import oracle.xdb.XMLTypeFactory;
import oracle.xdb.dom.XDBDocument;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLType
extends OPAQUE
implements ORAData {
    public static final int _SQL_TYPECODE = 2007;
    public static final String _SQL_TYPENAME = "SYS.XMLTYPE";
    boolean m_isThin;
    String m_stringval = null;
    CLOB m_clobval = null;
    long m_cstate = 0L;
    OracleConnection m_local_conn;
    Document m_dom = null;
    CharacterSet m_charSet = CharacterSet.make((int)-1);
    private boolean m_isClosed = false;
    private static boolean m_libLoaded = false;
    private static final XMLTypeFactory xmlfactory = new XMLTypeFactory();
    static final int XMLTYPE_VERSION = 1;
    static final int XMLTYPE_LOB = 1;
    static final int XMLTYPE_STR = 4;
    static final int XMLTYPE_PTR = 8;

    public XMLType() throws SQLException {
        super(null, null, (Object)new byte[1]);
    }

    private XMLType(Connection connection, long l) throws SQLException {
        super(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)new byte[1]);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.conversion.getDbCharSet());
        this.m_cstate = l;
    }

    public XMLType(OpaqueDescriptor opaqueDescriptor, Connection connection, Object object) throws SQLException {
        super(opaqueDescriptor, connection, object == null ? (Object)new byte[1] : object);
        this.initConn(connection);
        this.m_charSet = CharacterSet.make((int)this.m_local_conn.conversion.getDbCharSet());
        if (object == null) {
            return;
        }
        byte[] byArray = (byte[])object;
        int n = 0;
        if (this.m_isThin) {
            this.processThin(byArray, n);
        } else {
            try {
                this.processCState(this.m_local_conn, byArray, n);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.m_isThin = true;
                this.processThin(byArray, 0);
                this.m_cstate = 0L;
            }
        }
    }

    private synchronized native long WriteToSegStreamNative(long var1, long var3, byte[] var5, int var6, int var7);

    private static int bytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 24;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 16;
        n2 += XMLType.unsignedByteToInt(byArray[n++]) << 8;
        return n2 += XMLType.unsignedByteToInt(byArray[n++]);
    }

    public void close() {
        this.freeXMLType();
    }

    private synchronized native void closeNative(long var1, long var3, long var5);

    public static XMLType createXML(Connection connection, InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[1024];
        OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection);
        XMLType xMLType = new XMLType(opaqueDescriptor, connection, null);
        if (xMLType.m_isThin) {
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    xMLType.m_stringval = String.valueOf(xMLType.m_stringval) + new String(byArray);
                }
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
        }
        try {
            OCIDBAccess oCIDBAccess = (OCIDBAccess)((OracleConnection)connection).getDBAccess();
            Properties properties = oCIDBAccess.getDBAccessProperties();
            long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            long l2 = 0L;
            try {
                int n;
                int n2 = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    l2 = xMLType.WriteToSegStreamNative(XMLType.getErrHandle(connection), l2, byArray, n2, n);
                    n2 += byArray.length;
                }
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
            xMLType.m_cstate = xMLType.createXMLTypeFromStreamNative(l, XMLType.getErrHandle(connection), l2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            xMLType.m_isThin = true;
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    xMLType.m_stringval = String.valueOf(xMLType.m_stringval) + new String(byArray);
                }
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
        }
        return xMLType;
    }

    public static XMLType createXML(Connection connection, String string) throws SQLException {
        OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection);
        XMLType xMLType = new XMLType(opaqueDescriptor, connection, null);
        if (xMLType.m_isThin) {
            xMLType.m_stringval = string;
        } else {
            try {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)((OracleConnection)connection).getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                xMLType.m_cstate = xMLType.createXMLTypeFromStringNative(l, XMLType.getErrHandle(connection), string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                xMLType.m_isThin = true;
                xMLType.m_stringval = string;
            }
        }
        return xMLType;
    }

    public static XMLType createXML(Connection connection, CLOB cLOB) throws SQLException {
        OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection);
        XMLType xMLType = new XMLType(opaqueDescriptor, connection, null);
        if (xMLType.m_isThin) {
            xMLType.m_clobval = cLOB;
        } else {
            try {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)((OracleConnection)connection).getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                xMLType.m_cstate = xMLType.createXMLTypeFromLobNative(l, XMLType.getErrHandle(connection), cLOB.getLocator());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                xMLType.m_isThin = true;
                xMLType.m_clobval = cLOB;
            }
        }
        return xMLType;
    }

    public static XMLType createXML(Connection connection, Document document) throws SQLException {
        if (document instanceof XDBDocument) {
            OCIDBAccess oCIDBAccess = (OCIDBAccess)((OracleConnection)connection).getDBAccess();
            Properties properties = oCIDBAccess.getDBAccessProperties();
            long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
            long l3 = XMLType.getXMLTypeFromXobd(l, l2, ((XDBDocument)document).toCState());
            XMLType xMLType = new XMLType(connection, l3);
            xMLType.m_local_conn = (OracleConnection)connection;
            xMLType.m_charSet = CharacterSet.make((int)xMLType.m_local_conn.conversion.getDbCharSet());
            if (xMLType.m_local_conn.getProtocolType().equals("thin")) {
                xMLType.m_isThin = true;
            }
            return xMLType;
        }
        if (document instanceof XMLDocument) {
            Object object;
            CLOB cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)1);
            try {
                object = new PrintWriter(cLOB.getCharacterOutputStream());
                ((XMLDocument)document).print(object);
            }
            catch (IOException iOException) {
                throw new SQLException();
            }
            object = XMLType.createXML(connection, cLOB);
            ((XMLType)((Object)object)).m_local_conn = (OracleConnection)connection;
            ((XMLType)((Object)object)).m_charSet = CharacterSet.make((int)((XMLType)((Object)object)).m_local_conn.conversion.getDbCharSet());
            if (((XMLType)((Object)object)).m_local_conn.getProtocolType().equals("thin")) {
                ((XMLType)((Object)object)).m_isThin = true;
            }
            return object;
        }
        return null;
    }

    public static XMLType createXML(OPAQUE oPAQUE) throws SQLException {
        String string = oPAQUE.getSQLTypeName();
        if (string.compareTo(_SQL_TYPENAME) != 0) {
            return null;
        }
        return new XMLType(oPAQUE.getDescriptor(), oPAQUE.getJavaSqlConnection(), oPAQUE.getBytesValue());
    }

    private synchronized native long createXMLTypeFromLobNative(long var1, long var3, byte[] var5);

    private synchronized native long createXMLTypeFromStreamNative(long var1, long var3, long var5);

    private synchronized native long createXMLTypeFromStringNative(long var1, long var3, String var5);

    public boolean existsNode(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_isThin) {
            throw new SQLException();
        }
        boolean bl = this.existsNodeNative(XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, string, string2);
        return bl;
    }

    private synchronized native boolean existsNodeNative(long var1, long var3, String var5, String var6);

    public XMLType extract(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_isThin) {
            throw new SQLException();
        }
        long l = this.extractNative(XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, string, string2);
        if (l != 0L) {
            return new XMLType((Connection)this.m_local_conn, l);
        }
        return null;
    }

    private synchronized native long extractNative(long var1, long var3, String var5, String var6);

    public void finalize() {
    }

    private void freeXMLType() {
        if (this.m_isClosed) {
            return;
        }
        if (!this.m_isThin) {
            if (this.m_dom != null) {
                ((XDBDocument)this.m_dom).close();
            }
            try {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
                this.closeNative(l, l2, this.m_cstate);
                this.m_cstate = 0L;
            }
            catch (SQLException sQLException) {
                this.m_cstate = 0L;
            }
        }
        this.m_isClosed = true;
    }

    private byte[] getBytesLob() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 1);
            byteArrayOutputStream.write(this.m_clobval.getLocator());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] getBytesPtr(OracleConnection oracleConnection) throws SQLException {
        OCIDBAccess oCIDBAccess = (OCIDBAccess)oracleConnection.getDBAccess();
        Properties properties = oCIDBAccess.getDBAccessProperties();
        long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
        long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
        byte[] byArray = this.pickleXMLTypeNative(l, l2, this.m_cstate);
        return byArray;
    }

    private byte[] getBytesString() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writePreamble(byteArrayOutputStream, 1, 4);
            byteArrayOutputStream.write(this.m_charSet.convert(this.m_stringval));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getBytesValue() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_clobval != null) {
            return this.getBytesLob();
        }
        if (this.m_stringval != null) {
            return this.getBytesString();
        }
        if (!this.m_isThin) {
            return this.getBytesPtr(this.m_local_conn);
        }
        return null;
    }

    public CLOB getClobVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)1);
            if (this.m_isThin) {
                try {
                    ((XMLDocument)this.m_dom).print(cLOB.getAsciiOutputStream());
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
            } else {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                this.printToClobNative(l, XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, cLOB.getLocator());
            }
            return cLOB;
        }
        if (this.m_clobval != null) {
            return this.m_clobval;
        }
        if (this.m_stringval != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)1);
            cLOB.putString(1L, this.m_stringval);
            return cLOB;
        }
        if (this.m_cstate != 0L) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)1);
            OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
            Properties properties = oCIDBAccess.getDBAccessProperties();
            long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            this.printToClobNative(l, XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, cLOB.getLocator());
            return cLOB;
        }
        return null;
    }

    public Document getDOM() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            return this.m_dom;
        }
        if (this.m_isThin) {
            DOMParser dOMParser = new DOMParser();
            if (this.m_stringval != null) {
                try {
                    dOMParser.parse(this.m_stringval);
                }
                catch (XMLParseException xMLParseException) {
                    throw new SQLException();
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                catch (SAXException sAXException) {
                    throw new SQLException();
                }
                this.m_dom = dOMParser.getDocument();
            } else if (this.m_clobval != null) {
                try {
                    dOMParser.parse(this.m_clobval.getAsciiStream());
                }
                catch (XMLParseException xMLParseException) {
                    throw new SQLException();
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
                catch (SAXException sAXException) {
                    throw new SQLException();
                }
                this.m_dom = dOMParser.getDocument();
            }
        } else {
            OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
            Properties properties = oCIDBAccess.getDBAccessProperties();
            long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
            long l3 = this.getXobdFromXMLType(l, l2, this.m_cstate);
            this.m_dom = new XDBDocument(this, (Connection)this.m_local_conn, l3);
        }
        return this.m_dom;
    }

    private static long getErrHandle(Connection connection) throws SQLException {
        OCIDBAccess oCIDBAccess = (OCIDBAccess)((OracleConnection)connection).getDBAccess();
        Properties properties = oCIDBAccess.getDBAccessProperties();
        long l = Long.parseLong(properties.getProperty("OCIErrHandle"));
        return l;
    }

    public InputStream getInputStream() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        long l = this.getInputStreamNative(XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate);
        return new RealInputStream(XMLType.getErrHandle((Connection)this.m_local_conn), l);
    }

    private synchronized native long getInputStreamNative(long var1, long var3);

    public static ORADataFactory getORADataFactory() {
        return xmlfactory;
    }

    public String getStringVal() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_dom != null) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)1);
            if (this.m_isThin) {
                try {
                    ((XMLDocument)this.m_dom).print(cLOB.getAsciiOutputStream());
                }
                catch (IOException iOException) {
                    throw new SQLException();
                }
            } else {
                OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
                Properties properties = oCIDBAccess.getDBAccessProperties();
                long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                this.printToClobNative(l, XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, cLOB.getLocator());
            }
            return cLOB.getSubString(1L, (int)cLOB.length());
        }
        if (this.m_stringval != null) {
            return this.m_stringval;
        }
        if (this.m_clobval != null) {
            return this.m_clobval.getSubString(1L, (int)this.m_clobval.length());
        }
        if (this.m_cstate != 0L) {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_local_conn, (boolean)true, (int)1);
            byte[] byArray = cLOB.getLocator();
            OCIDBAccess oCIDBAccess = (OCIDBAccess)this.m_local_conn.getDBAccess();
            Properties properties = oCIDBAccess.getDBAccessProperties();
            long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            this.printToClobNative(l, XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, cLOB.getLocator());
            return cLOB.getSubString(1L, (int)cLOB.length());
        }
        return null;
    }

    private static synchronized native long getXMLTypeFromXobd(long var0, long var2, long var4);

    private native long getXMLTypeNative(long var1, long var3, byte[] var5);

    private synchronized native long getXobdFromXMLType(long var1, long var3, long var5);

    private void initConn(Connection connection) {
        block5: {
            this.m_local_conn = (OracleConnection)connection;
            if (this.m_local_conn.getProtocolType().equals("thin")) {
                this.m_isThin = true;
            } else {
                this.m_isThin = false;
                try {
                    if (m_libLoaded) break block5;
                    String string = System.getProperty("os.name");
                    if (string.toUpperCase().startsWith("WINDOWS")) {
                        System.loadLibrary("orageneric9");
                        m_libLoaded = true;
                        break block5;
                    }
                    m_libLoaded = true;
                }
                catch (Exception exception) {
                    this.m_isThin = true;
                }
            }
        }
    }

    private void int2Byte(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)((n &= 0xFFFFFF) >> 16);
        byArray[2] = (byte)((n &= 0xFFFF) >> 8);
        byArray[3] = (byte)(n &= 0xFF);
    }

    public boolean isFragment() throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_isThin) {
            throw new SQLException();
        }
        boolean bl = this.isFragmentNative(XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate);
        return bl;
    }

    private synchronized native boolean isFragmentNative(long var1, long var3);

    public boolean isSchemaValid(String string, String string2) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_isThin) {
            throw new SQLException();
        }
        boolean bl = this.isSchemaValidNative(XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, string, string2);
        return bl;
    }

    private synchronized native boolean isSchemaValidNative(long var1, long var3, String var5, String var6);

    private synchronized native byte[] pickleXMLTypeNative(long var1, long var3, long var5);

    private synchronized native void printToClobNative(long var1, long var3, long var5, byte[] var7);

    private void processCState(OracleConnection oracleConnection, byte[] byArray, int n) throws SQLException {
        OCIDBAccess oCIDBAccess = (OCIDBAccess)oracleConnection.getDBAccess();
        Properties properties = oCIDBAccess.getDBAccessProperties();
        long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
        long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
        this.m_cstate = this.getXMLTypeNative(l, l2, byArray);
    }

    private void processLob(byte[] byArray, int n) throws SQLException {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.m_clobval = new CLOB((oracle.jdbc.OracleConnection)this.m_local_conn, byArray2);
    }

    private void processString(byte[] byArray, int n) throws SQLException {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.m_stringval = this.m_charSet.toString(byArray2, 0, byArray2.length);
    }

    private void processThin(byte[] byArray, int n) throws SQLException {
        short s = Util.getUnsignedByte((byte)byArray[n]);
        ++n;
        if (s != 1) {
            throw new SQLException("error occurred in XMLtype conversion" + s);
        }
        int n2 = XMLType.bytesToInt(byArray, n);
        n += 4;
        if ((n2 & 1) == 1) {
            this.processLob(byArray, n);
        } else if ((n2 & 4) == 4) {
            this.processString(byArray, n);
        } else {
            throw new SQLException("Only LOB or thin Storage is supported in Thin XMLType");
        }
    }

    public byte[] toBytes() throws SQLException {
        return ((OPAQUE)this.toDatum((Connection)this.m_local_conn)).toBytes();
    }

    public Datum toDatum(Connection connection) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (!this.m_isThin) {
            byte[] byArray = this.getBytesPtr((OracleConnection)connection);
            OPAQUE oPAQUE = new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)byArray);
            return oPAQUE;
        }
        return new OPAQUE(OpaqueDescriptor.createDescriptor((String)_SQL_TYPENAME, (Connection)connection), connection, (Object)this.getBytesValue());
    }

    public XMLType transform(XMLType xMLType, String string) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        if (this.m_isThin || xMLType == null) {
            throw new SQLException();
        }
        long l = this.transformNative(XMLType.getErrHandle((Connection)this.m_local_conn), this.m_cstate, xMLType.m_cstate, string);
        if (l != 0L) {
            return new XMLType((Connection)this.m_local_conn, l);
        }
        return null;
    }

    private synchronized native long transformNative(long var1, long var3, long var5, String var7);

    private static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private void writePreamble(ByteArrayOutputStream byteArrayOutputStream, int n, int n2) throws IOException {
        byteArrayOutputStream.write(1);
        byte[] byArray = new byte[4];
        this.int2Byte(n2, byArray);
        byteArrayOutputStream.write(byArray);
    }

    public void writeToOutputStream(OutputStream outputStream) throws SQLException {
        if (this.m_isClosed) {
            throw new SQLException(XDBError.getMsg("CLOSED_OBJECT"));
        }
        InputStream inputStream = this.getInputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, n, n2);
                n += n2;
            }
        }
        catch (IOException iOException) {
            throw new SQLException();
        }
    }
}

