/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlExternalFunctionBase;
import com.sleepycat.dbxml.XmlInputStream;
import com.sleepycat.dbxml.XmlManager;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlTransaction;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;

public class XmlResolver {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected XmlResolver(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(XmlResolver obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            dbxml_javaJNI.delete_XmlResolver(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    public void swigReleaseOwnership() throws XmlException {
        this.swigCMemOwn = false;
        dbxml_javaJNI.XmlResolver_change_ownership(this, this.swigCPtr, false);
    }

    public void swigTakeOwnership() throws XmlException {
        this.swigCMemOwn = true;
        dbxml_javaJNI.XmlResolver_change_ownership(this, this.swigCPtr, true);
    }

    protected XmlResolver() {
        this(dbxml_javaJNI.new_XmlResolver(), true);
        dbxml_javaJNI.XmlResolver_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    public boolean resolveDocument(XmlTransaction txn, XmlManager mgr, String uri, XmlValue reslt) throws XmlException {
        return this.getClass() == XmlResolver.class ? dbxml_javaJNI.XmlResolver_resolveDocument(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, uri, reslt) : dbxml_javaJNI.XmlResolver_resolveDocumentSwigExplicitXmlResolver(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, uri, reslt);
    }

    public boolean resolveCollection(XmlTransaction txn, XmlManager mgr, String uri, XmlResults reslt) throws XmlException {
        return this.getClass() == XmlResolver.class ? dbxml_javaJNI.XmlResolver_resolveCollection(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, uri, XmlResults.getCPtr(reslt), reslt) : dbxml_javaJNI.XmlResolver_resolveCollectionSwigExplicitXmlResolver(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, uri, XmlResults.getCPtr(reslt), reslt);
    }

    public XmlInputStream resolveSchema(XmlTransaction txn, XmlManager mgr, String schemaLocation, String nameSpace) throws XmlException {
        long cPtr = this.getClass() == XmlResolver.class ? dbxml_javaJNI.XmlResolver_resolveSchema(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, schemaLocation, nameSpace) : dbxml_javaJNI.XmlResolver_resolveSchemaSwigExplicitXmlResolver(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, schemaLocation, nameSpace);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, true);
    }

    public XmlInputStream resolveEntity(XmlTransaction txn, XmlManager mgr, String systemId, String publicId) throws XmlException {
        long cPtr = this.getClass() == XmlResolver.class ? dbxml_javaJNI.XmlResolver_resolveEntity(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, systemId, publicId) : dbxml_javaJNI.XmlResolver_resolveEntitySwigExplicitXmlResolver(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, systemId, publicId);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, true);
    }

    public boolean resolveModuleLocation(XmlTransaction txn, XmlManager mgr, String nameSpace, XmlResults reslt) throws XmlException {
        return this.getClass() == XmlResolver.class ? dbxml_javaJNI.XmlResolver_resolveModuleLocation(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, nameSpace, XmlResults.getCPtr(reslt), reslt) : dbxml_javaJNI.XmlResolver_resolveModuleLocationSwigExplicitXmlResolver(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, nameSpace, XmlResults.getCPtr(reslt), reslt);
    }

    public XmlInputStream resolveModule(XmlTransaction txn, XmlManager mgr, String moduleLocation, String nameSpace) throws XmlException {
        long cPtr = this.getClass() == XmlResolver.class ? dbxml_javaJNI.XmlResolver_resolveModule(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, moduleLocation, nameSpace) : dbxml_javaJNI.XmlResolver_resolveModuleSwigExplicitXmlResolver(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, moduleLocation, nameSpace);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, true);
    }

    public XmlExternalFunctionBase resolveExternalFunction(XmlTransaction txn, XmlManager mgr, String uri, String name, int numberOfArgs) throws XmlException {
        long cPtr = this.getClass() == XmlResolver.class ? dbxml_javaJNI.XmlResolver_resolveExternalFunction(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, uri, name, numberOfArgs) : dbxml_javaJNI.XmlResolver_resolveExternalFunctionSwigExplicitXmlResolver(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, XmlManager.getCPtr(mgr), mgr, uri, name, numberOfArgs);
        return cPtr == 0L ? null : new XmlExternalFunctionBase(cPtr, true);
    }
}

