/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.HelperFunctions;
import com.sleepycat.dbxml.XmlDebugListener;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlManager;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class XmlQueryContext {
    public static final int LiveValues = 0;
    public static final int Eager = 0;
    public static final int Lazy = 1;
    protected XmlManager mgr;
    protected HashMap<String, XmlValue[]> variables;
    protected HashMap<String, String> namespaces;
    protected String baseURI;
    protected int evaluationType;
    protected String defaultCollection;
    protected int queryInterruptSec;
    protected String defaultCollectionURI;
    protected Interrupter interrupt;
    protected XmlDebugListener debugListener;

    protected XmlQueryContext(int rt, int et) {
        this.evaluationType = et;
        this.interrupt = new Interrupter();
    }

    public XmlQueryContext(XmlQueryContext o) throws XmlException {
        this.baseURI = o.baseURI;
        this.evaluationType = o.evaluationType;
        this.defaultCollection = o.defaultCollection;
        this.queryInterruptSec = o.queryInterruptSec;
        if (o.namespaces != null) {
            this.namespaces = new HashMap<String, String>(o.namespaces);
        }
        if (o.variables != null) {
            this.variables = new HashMap<String, XmlValue[]>(o.variables);
        }
        this.interrupt = new Interrupter();
        this.mgr = o.mgr;
    }

    @Deprecated
    public void delete() {
    }

    public void setVariableValue(String name, XmlValue value) throws XmlException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value.getType() == 40) {
            throw new XmlException(14, "XmlQueryContext::setVariableValue value cannot be binary");
        }
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        XmlValue[] val = new XmlValue[]{value};
        this.variables.put(name, val);
    }

    public void setVariableValue(String name, XmlResults value) throws XmlException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        if (value.getEvaluationType() == 1) {
            Vector<XmlValue> valueVector = new Vector<XmlValue>();
            while (value.hasNext()) {
                XmlValue val = value.next();
                valueVector.add(val);
            }
            XmlValue[] values = valueVector.toArray(new XmlValue[0]);
            this.variables.put(name, values);
            return;
        }
        value.reset();
        XmlValue[] values = new XmlValue[value.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = value.next();
        }
        this.variables.put(name, values);
    }

    public XmlValue getVariableValue(String name) throws XmlException {
        if (this.variables == null) {
            return new XmlValue();
        }
        XmlValue[] value = this.variables.get(name);
        if (value == null || value.length == 0) {
            return new XmlValue();
        }
        if (value.length > 1) {
            throw new XmlException(14, "Variable has more than one value assigned to it");
        }
        return value[0];
    }

    public XmlResults getVariableValues(String name) throws XmlException {
        if (this.variables == null) {
            return null;
        }
        XmlValue[] res = this.variables.get(name);
        if (res != null) {
            XmlResults result = this.mgr.createResults();
            for (int i = 0; i < res.length; ++i) {
                result.add(res[i]);
            }
            return result;
        }
        return null;
    }

    public void setNamespace(String prefix, String uri) throws XmlException {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (prefix == null) {
            prefix = "";
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        this.namespaces.put(prefix, uri);
    }

    public String getNamespace(String prefix) throws XmlException {
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equalsIgnoreCase("dbxml")) {
            return "http://www.sleepycat.com/2002/dbxml";
        }
        if (this.namespaces == null) {
            return "";
        }
        String uri = this.namespaces.get(prefix);
        if (uri == null) {
            return "";
        }
        return uri;
    }

    public void removeNamespace(String prefix) throws XmlException {
        if (this.namespaces != null) {
            this.namespaces.remove(prefix);
        }
    }

    public void clearNamespaces() throws XmlException {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
    }

    public void setBaseURI(String baseURI) throws XmlException {
        HelperFunctions.verifyBaseURI(this.mgr, baseURI);
        this.baseURI = baseURI;
    }

    public String getBaseURI() throws XmlException {
        if (this.baseURI == null) {
            return "dbxml:/";
        }
        return this.baseURI;
    }

    public void setReturnType(int type) throws XmlException {
    }

    public int getReturnType() throws XmlException {
        return 0;
    }

    public void setEvaluationType(int type) throws XmlException {
        this.evaluationType = type;
    }

    public int getEvaluationType() throws XmlException {
        return this.evaluationType;
    }

    public void setDefaultCollection(String uri) throws XmlException {
        this.defaultCollection = HelperFunctions.verifyDefaultCollection(this.mgr, uri, this.baseURI);
        this.defaultCollectionURI = uri;
    }

    public String getDefaultCollection() throws XmlException {
        if (this.defaultCollection == null) {
            return "";
        }
        return this.defaultCollection;
    }

    public void setDebugListener(XmlDebugListener listener) throws XmlException {
        this.debugListener = listener;
    }

    public XmlDebugListener getDebugListener() throws XmlException {
        return this.debugListener;
    }

    protected long getDebugListenerCPtr() {
        return XmlDebugListener.getCPtr(this.debugListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptQuery() throws XmlException {
        Interrupter interrupter = this.interrupt;
        synchronized (interrupter) {
            if (this.interrupt.cPtr != 0L) {
                dbxml_javaJNI.interruptQuery(this.interrupt.cPtr);
            }
        }
    }

    public void setQueryTimeoutSeconds(int secs) throws XmlException {
        this.queryInterruptSec = secs;
    }

    public int getQueryTimeoutSeconds() throws XmlException {
        return this.queryInterruptSec;
    }

    protected static XmlQueryContext copy(XmlQueryContext o) throws XmlException {
        return new XmlQueryContext(o);
    }

    protected long getManagerPtr() {
        return XmlManager.getCPtr(this.mgr);
    }

    protected Object[] pack() {
        Vector<Object> data = new Vector<Object>();
        data.add(this.baseURI);
        data.add(this.defaultCollectionURI);
        if (this.namespaces != null) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                data.add(entry.getKey());
                data.add(entry.getValue());
            }
        }
        data.add(null);
        if (this.variables != null) {
            for (Map.Entry<String, XmlValue[]> entry : this.variables.entrySet()) {
                data.add(entry.getKey());
                XmlValue[] res = entry.getValue();
                data.add(res);
            }
        }
        return data.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCPtr(long ptr) {
        Interrupter interrupter = this.interrupt;
        synchronized (interrupter) {
            this.interrupt.cPtr = ptr;
        }
    }

    class Interrupter {
        public long cPtr;

        Interrupter() {
        }
    }
}

