/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.db.VerifyConfig;
import com.sleepycat.db.XmlHelper;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.dbxml.NativeXmlInputStream;
import com.sleepycat.dbxml.XmlCompression;
import com.sleepycat.dbxml.XmlContainer;
import com.sleepycat.dbxml.XmlContainerConfig;
import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlDocumentConfig;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlIndexLookup;
import com.sleepycat.dbxml.XmlInputStream;
import com.sleepycat.dbxml.XmlManagerConfig;
import com.sleepycat.dbxml.XmlQueryContext;
import com.sleepycat.dbxml.XmlQueryExpression;
import com.sleepycat.dbxml.XmlResolver;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlTransaction;
import com.sleepycat.dbxml.XmlUpdateContext;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;

public class XmlManager {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Environment dbenv;
    private XmlContainerConfig defaultConfig = new XmlContainerConfig();
    private boolean threaded = true;
    private boolean adopted = false;
    private XmlManagerConfig config = null;
    private LinkedList<XmlCompression> compressionStore;
    private LinkedList<XmlResolver> resolverStore;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 4;
    public static final int LEVEL_ERROR = 8;
    public static final int LEVEL_ALL = -1;
    public static final int CATEGORY_NONE = 0;
    public static final int CATEGORY_INDEXER = 1;
    public static final int CATEGORY_QUERY = 2;
    public static final int CATEGORY_OPTIMIZER = 4;
    public static final int CATEGORY_DICTIONARY = 8;
    public static final int CATEGORY_CONTAINER = 16;
    public static final int CATEGORY_NODESTORE = 32;
    public static final int CATEGORY_MANAGER = 64;
    public static final int CATEGORY_ALL = -1;
    public static final String metaDataNamespace_uri = "http://www.sleepycat.com/2002/dbxml";
    public static final String metaDataNamespace_prefix = "dbxml";
    public static final String metaDataName_name = "name";
    public static final String metaDataName_root = "root";

    protected XmlManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(XmlManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public void delete() {
        this.closeInternal();
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            dbxml_javaJNI.delete_XmlManager(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public XmlManager(Environment dbenv, XmlManagerConfig config) throws XmlException {
        this(dbxml_javaJNI.new_XmlManager(XmlHelper.getDbEnv(dbenv), config == null ? 0 : config.makeFlags()), true);
        this.dbenv = dbenv;
        this.config = config;
        if (config != null && config.getAdoptEnvironment()) {
            this.adopted = true;
        }
        try {
            this.threaded = (XmlHelper.getDbEnv(dbenv).get_open_flags() & 0x10) != 0;
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
    }

    public XmlManager(XmlManagerConfig config) throws XmlException, FileNotFoundException {
        DbEnv newEnv = null;
        try {
            newEnv = new DbEnv(0);
            newEnv.set_cachesize(0x4000000L, 1);
            newEnv.set_errpfx("BDB XML");
            newEnv.open(null, 8721, 0);
            this.dbenv = XmlHelper.makeNewEnvironment(newEnv);
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        this.adopted = true;
        this.config = config;
        int flags = config == null ? 0 : config.makeFlags();
        this.swigCPtr = dbxml_javaJNI.new_XmlManager(newEnv, flags);
        this.swigCMemOwn = true;
    }

    public XmlManager() throws XmlException, FileNotFoundException {
        this(null);
    }

    public Environment getEnvironment() throws XmlException {
        return this.dbenv;
    }

    public XmlManagerConfig getManagerConfig() throws XmlException {
        return this.config;
    }

    public synchronized void setDefaultContainerConfig(XmlContainerConfig config) throws XmlException {
        this.defaultConfig = config;
    }

    public XmlContainerConfig getDefaultContainerConfig() throws XmlException {
        return this.defaultConfig;
    }

    public XmlUpdateContext createUpdateContext() throws XmlException {
        return new XmlUpdateContext(this);
    }

    public XmlQueryContext createQueryContext() throws XmlException {
        XmlQueryContext xqc = new XmlQueryContext(0, 0);
        xqc.mgr = this;
        return xqc;
    }

    public XmlQueryContext createQueryContext(int rt, int et) throws XmlException {
        XmlQueryContext xqc = new XmlQueryContext(rt, et);
        xqc.mgr = this;
        return xqc;
    }

    public XmlQueryContext createQueryContext(int rt) throws XmlException {
        XmlQueryContext xqc = new XmlQueryContext(rt, 0);
        xqc.mgr = this;
        return xqc;
    }

    public XmlInputStream createInputStream(InputStream is) throws XmlException {
        return new NativeXmlInputStream(is);
    }

    public XmlContainer createContainer(String name) throws XmlException {
        return this.createContainer(name, this.defaultConfig);
    }

    public XmlContainer createContainer(XmlTransaction txn, String name) throws XmlException {
        return this.createContainer(txn, name, this.defaultConfig);
    }

    public XmlContainer openContainer(String name) throws XmlException {
        return this.openContainer(name, this.defaultConfig);
    }

    public XmlContainer openContainer(XmlTransaction txn, String name) throws XmlException {
        return this.openContainer(txn, name, this.defaultConfig);
    }

    private void setContainerConfig(XmlContainerConfig config, XmlContainer cont) {
        cont.setManager(this);
        int[] data = new int[8];
        String compName = cont.getContainerConfigData(data);
        config = new XmlContainerConfig(data);
        config.setCompression(compName);
        cont.setContainerConfig(config);
    }

    public XmlContainer createContainer(String name, XmlContainerConfig config) throws XmlException {
        XmlContainer cont = this.createContainerInternal(name, config);
        this.setContainerConfig(config, cont);
        return cont;
    }

    public XmlContainer createContainer(XmlTransaction txn, String name, XmlContainerConfig config) throws XmlException {
        XmlContainer cont = this.createContainerInternal(txn, name, config);
        this.setContainerConfig(config, cont);
        return cont;
    }

    public XmlContainer openContainer(String name, XmlContainerConfig config) throws XmlException {
        XmlContainer cont = this.openContainerInternal(name, config);
        this.setContainerConfig(config, cont);
        return cont;
    }

    public XmlContainer openContainer(XmlTransaction txn, String name, XmlContainerConfig config) throws XmlException {
        XmlContainer cont = this.openContainerInternal(txn, name, config);
        this.setContainerConfig(config, cont);
        return cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCompression(String name) {
        XmlContainerConfig xmlContainerConfig = this.defaultConfig;
        synchronized (xmlContainerConfig) {
            this.defaultConfig.setCompression(name);
        }
    }

    public String getDefaultCompression() {
        return this.defaultConfig.getCompression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultContainerType(int type) {
        XmlContainerConfig xmlContainerConfig = this.defaultConfig;
        synchronized (xmlContainerConfig) {
            this.defaultConfig.setContainerType(type);
        }
    }

    public int getDefaultContainerType() {
        return this.defaultConfig.getContainerType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultPageSize(int pageSize) throws XmlException {
        XmlContainerConfig xmlContainerConfig = this.defaultConfig;
        synchronized (xmlContainerConfig) {
            this.defaultConfig.setPageSize(pageSize);
        }
    }

    public int getDefaultPageSize() throws XmlException {
        return this.defaultConfig.getPageSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultSequenceIncrement(int incr) throws XmlException {
        XmlContainerConfig xmlContainerConfig = this.defaultConfig;
        synchronized (xmlContainerConfig) {
            this.defaultConfig.setSequenceIncrement(incr);
        }
    }

    public int getDefaultSequenceIncrement() throws XmlException {
        return this.defaultConfig.getSequenceIncrement();
    }

    public XmlTransaction createTransaction(Transaction toUse) throws XmlException {
        XmlTransaction txn = this.createTransaction(XmlHelper.getDbTxn(toUse));
        txn.setTransaction(toUse);
        return txn;
    }

    public XmlTransaction createTransaction(Transaction parent, TransactionConfig config) throws XmlException {
        Transaction newTxn = null;
        try {
            newTxn = this.dbenv.beginTransaction(parent, config);
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        return this.createTransaction(newTxn);
    }

    public XmlTransaction createTransaction() throws XmlException {
        return this.createTransaction(null, null);
    }

    public XmlIndexLookup createIndexLookup(XmlContainer cont, String uri, String name, String index, XmlValue value, int op) throws XmlException {
        XmlIndexLookup lookup = this.createIndexLookupInternal(cont, uri, name, index, value, op);
        lookup.container = cont;
        lookup.lowBoundValue = value;
        return lookup;
    }

    public XmlIndexLookup createIndexLookup(XmlContainer cont, String uri, String name, String index, XmlValue value) throws XmlException {
        XmlIndexLookup lookup = this.createIndexLookupInternal(cont, uri, name, index, value);
        lookup.container = cont;
        lookup.lowBoundValue = value;
        return lookup;
    }

    public XmlIndexLookup createIndexLookup(XmlContainer cont, String uri, String name, String index) throws XmlException {
        XmlIndexLookup lookup = this.createIndexLookupInternal(cont, uri, name, index);
        lookup.container = cont;
        return lookup;
    }

    public XmlDocument createDocument() throws XmlException {
        XmlDocument doc = this.createDocumentInternal();
        doc.setManager(this);
        return doc;
    }

    public XmlResults query(String query, XmlQueryContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.query(query, context, flags);
    }

    public XmlResults query(XmlTransaction txn, String query, XmlQueryContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.query(txn, query, context, flags);
    }

    public void reindexContainer(String name, XmlUpdateContext context, XmlContainerConfig config) throws XmlException {
        this.reindexContainer(name, config);
    }

    public void reindexContainer(XmlTransaction txn, String name, XmlUpdateContext context, XmlContainerConfig config) throws XmlException {
        this.reindexContainer(txn, name, config);
    }

    public void loadContainer(String name, String filename, XmlUpdateContext uc) throws XmlException {
        this.loadContainer(name, filename);
    }

    public void verifyContainer(String name, String filename, VerifyConfig config) throws XmlException {
        int flags = 0;
        if (config.getAggressive()) {
            flags |= 1;
        }
        if (config.getSalvage()) {
            flags |= 0x40;
        }
        if (config.getPrintable()) {
            flags |= 8;
        }
        if (config.getOrderCheckOnly()) {
            flags |= 4;
        }
        if (config.getNoOrderCheck()) {
            flags |= 2;
        }
        this.verifyContainer(name, filename, flags);
    }

    public void upgradeContainer(String name, XmlUpdateContext uc) throws XmlException {
        this.upgradeContainer(name);
    }

    public void compactContainer(String name, XmlUpdateContext uc) throws XmlException {
        this.compactContainer(name);
    }

    public void compactContainer(XmlTransaction txn, String name, XmlUpdateContext uc) throws XmlException {
        this.compactContainer(txn, name);
    }

    public void truncateContainer(String name, XmlUpdateContext uc) throws XmlException {
        this.truncateContainer(name);
    }

    public void truncateContainer(XmlTransaction txn, String name, XmlUpdateContext uc) throws XmlException {
        this.truncateContainer(txn, name);
    }

    private synchronized void setResolver(XmlResolver resolver) {
        if (this.resolverStore == null) {
            this.resolverStore = new LinkedList();
        }
        this.resolverStore.add(resolver);
    }

    public void registerResolver(XmlResolver resolver) throws XmlException {
        this.setResolver(resolver);
        this.registerResolverInternal(resolver);
    }

    private synchronized void setCompression(XmlCompression compression) {
        if (this.compressionStore == null) {
            this.compressionStore = new LinkedList();
        }
        this.compressionStore.add(compression);
    }

    public void registerCompression(String name, XmlCompression compression) throws XmlException {
        this.setCompression(compression);
        this.registerCompressionInternal(name, compression);
    }

    protected void closeInternal() {
        if (this.adopted) {
            try {
                this.dbenv.close();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        this.adopted = false;
        this.dbenv = null;
        this.config = null;
    }

    public void close() throws XmlException {
        this.delete();
    }

    public XmlManager(DbEnv dbEnv, int flags) throws XmlException {
        this(dbxml_javaJNI.new_XmlManager(dbEnv, flags), true);
    }

    public String getHome() throws XmlException {
        return dbxml_javaJNI.XmlManager_getHome(this.swigCPtr, this);
    }

    public int getImplicitTimezone() throws XmlException {
        return dbxml_javaJNI.XmlManager_getImplicitTimezone(this.swigCPtr, this);
    }

    public void setImplicitTimezone(int tz) throws XmlException {
        dbxml_javaJNI.XmlManager_setImplicitTimezone(this.swigCPtr, this, tz);
    }

    public int existsContainer(String name) throws XmlException {
        return dbxml_javaJNI.XmlManager_existsContainer(this.swigCPtr, this, name);
    }

    public void removeContainer(String name) throws XmlException {
        dbxml_javaJNI.XmlManager_removeContainer__SWIG_0(this.swigCPtr, this, name);
    }

    public void removeContainer(XmlTransaction txn, String name) throws XmlException {
        dbxml_javaJNI.XmlManager_removeContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name);
    }

    public void renameContainer(String oldName, String newName) throws XmlException {
        dbxml_javaJNI.XmlManager_renameContainer__SWIG_0(this.swigCPtr, this, oldName, newName);
    }

    public void renameContainer(XmlTransaction txn, String oldName, String newName) throws XmlException {
        dbxml_javaJNI.XmlManager_renameContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, oldName, newName);
    }

    public XmlInputStream createStdInInputStream() throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createStdInInputStream(this.swigCPtr, this);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createLocalFileInputStream(String filename) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createLocalFileInputStream(this.swigCPtr, this, filename);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createMemBufInputStream(String bytes, long count, String id, boolean adopt) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createMemBufInputStream__SWIG_0(this.swigCPtr, this, bytes, count, id, adopt);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createMemBufInputStream(String bytes, long count, String id) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createMemBufInputStream__SWIG_1(this.swigCPtr, this, bytes, count, id);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createMemBufInputStream(String bytes, long count, boolean copyBuffer) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createMemBufInputStream__SWIG_2(this.swigCPtr, this, bytes, count, copyBuffer);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createURLInputStream(String baseId, String systemId, String publicId) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createURLInputStream__SWIG_0(this.swigCPtr, this, baseId, systemId, publicId);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createURLInputStream(String baseId, String systemId) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createURLInputStream__SWIG_1(this.swigCPtr, this, baseId, systemId);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public void dumpContainer(String name, String filename) throws XmlException {
        dbxml_javaJNI.XmlManager_dumpContainer(this.swigCPtr, this, name, filename);
    }

    protected void verifyContainer(String name, String filename, int flags) {
        dbxml_javaJNI.XmlManager_verifyContainer__SWIG_0(this.swigCPtr, this, name, filename, flags);
    }

    public void verifyContainer(String name, String filename) throws XmlException {
        dbxml_javaJNI.XmlManager_verifyContainer__SWIG_1(this.swigCPtr, this, name, filename);
    }

    public XmlQueryExpression prepare(String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_prepare__SWIG_0(this.swigCPtr, this, query, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context);
        return cPtr == 0L ? null : new XmlQueryExpression(cPtr, true);
    }

    public XmlQueryExpression prepare(XmlTransaction txn, String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_prepare__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, query, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context);
        return cPtr == 0L ? null : new XmlQueryExpression(cPtr, true);
    }

    protected XmlResults query(String query, XmlQueryContext context, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_0(this.swigCPtr, this, query, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults query(XmlTransaction txn, String query, XmlQueryContext context, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, query, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults query(String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_2(this.swigCPtr, this, query, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults query(XmlTransaction txn, String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, query, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults createResults() throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createResults(this.swigCPtr, this);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlTransaction createTransaction(DbTxn toAdopt) {
        long cPtr = dbxml_javaJNI.XmlManager_createTransaction(this.swigCPtr, this, toAdopt);
        return cPtr == 0L ? null : new XmlTransaction(cPtr, true);
    }

    protected XmlIndexLookup createIndexLookupInternal(XmlContainer cont, String uri, String name, String index, XmlValue value, int op) {
        long cPtr = dbxml_javaJNI.XmlManager_createIndexLookupInternal__SWIG_0(this.swigCPtr, this, XmlContainer.getCPtr(cont), cont, uri, name, index, value, op);
        return cPtr == 0L ? null : new XmlIndexLookup(cPtr, true);
    }

    protected XmlIndexLookup createIndexLookupInternal(XmlContainer cont, String uri, String name, String index, XmlValue value) {
        long cPtr = dbxml_javaJNI.XmlManager_createIndexLookupInternal__SWIG_1(this.swigCPtr, this, XmlContainer.getCPtr(cont), cont, uri, name, index, value);
        return cPtr == 0L ? null : new XmlIndexLookup(cPtr, true);
    }

    protected XmlIndexLookup createIndexLookupInternal(XmlContainer cont, String uri, String name, String index) {
        long cPtr = dbxml_javaJNI.XmlManager_createIndexLookupInternal__SWIG_2(this.swigCPtr, this, XmlContainer.getCPtr(cont), cont, uri, name, index);
        return cPtr == 0L ? null : new XmlIndexLookup(cPtr, true);
    }

    public static void setLogLevel(int level, boolean enabled) throws XmlException {
        dbxml_javaJNI.XmlManager_setLogLevel(level, enabled);
    }

    public static void setLogCategory(int category, boolean enabled) throws XmlException {
        dbxml_javaJNI.XmlManager_setLogCategory(category, enabled);
    }

    public static int get_version_major() {
        return dbxml_javaJNI.XmlManager_get_version_major();
    }

    public static int get_version_minor() {
        return dbxml_javaJNI.XmlManager_get_version_minor();
    }

    public static int get_version_patch() {
        return dbxml_javaJNI.XmlManager_get_version_patch();
    }

    public static String get_version_string() {
        return dbxml_javaJNI.XmlManager_get_version_string();
    }

    public XmlContainer createContainerInternal(String name, XmlContainerConfig config) throws XmlException {
        return new XmlContainer(dbxml_javaJNI.XmlManager_createContainerInternal__SWIG_0(this.swigCPtr, this, name, config.pack(), config.getCompression()), true);
    }

    public XmlContainer createContainerInternal(XmlTransaction txn, String name, XmlContainerConfig config) throws XmlException {
        return new XmlContainer(dbxml_javaJNI.XmlManager_createContainerInternal__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, config.pack(), config.getCompression()), true);
    }

    public XmlContainer openContainerInternal(String name, XmlContainerConfig config) throws XmlException {
        return new XmlContainer(dbxml_javaJNI.XmlManager_openContainerInternal__SWIG_0(this.swigCPtr, this, name, config.pack(), config.getCompression()), true);
    }

    public XmlContainer openContainerInternal(XmlTransaction txn, String name, XmlContainerConfig config) throws XmlException {
        return new XmlContainer(dbxml_javaJNI.XmlManager_openContainerInternal__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, config.pack(), config.getCompression()), true);
    }

    public XmlDocument createDocumentInternal() throws XmlException {
        return dbxml_javaJNI.XmlManager_createDocumentInternal(this.swigCPtr, this);
    }

    public void upgradeContainer(String name) throws XmlException {
        dbxml_javaJNI.XmlManager_upgradeContainer(this.swigCPtr, this, name);
    }

    public void compactContainer(String name) throws XmlException {
        dbxml_javaJNI.XmlManager_compactContainer__SWIG_0(this.swigCPtr, this, name);
    }

    public void compactContainer(XmlTransaction txn, String name) throws XmlException {
        dbxml_javaJNI.XmlManager_compactContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name);
    }

    public void truncateContainer(String name) throws XmlException {
        dbxml_javaJNI.XmlManager_truncateContainer__SWIG_0(this.swigCPtr, this, name);
    }

    public void truncateContainer(XmlTransaction txn, String name) throws XmlException {
        dbxml_javaJNI.XmlManager_truncateContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name);
    }

    public void reindexContainer(String name, XmlContainerConfig flags) throws XmlException {
        dbxml_javaJNI.XmlManager_reindexContainer__SWIG_0(this.swigCPtr, this, name, flags.pack(), flags.getCompression());
    }

    public void reindexContainer(XmlTransaction txn, String name, XmlContainerConfig flags) throws XmlException {
        dbxml_javaJNI.XmlManager_reindexContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags.pack(), flags.getCompression());
    }

    public void loadContainer(String name, String filename) throws XmlException {
        dbxml_javaJNI.XmlManager_loadContainer(this.swigCPtr, this, name, filename);
    }

    public void registerCompressionInternal(String name, XmlCompression compression) throws XmlException {
        dbxml_javaJNI.XmlManager_registerCompressionInternal(this.swigCPtr, this, name, XmlCompression.getCPtr(compression), compression);
    }

    public void registerResolverInternal(XmlResolver resolver) throws XmlException {
        dbxml_javaJNI.XmlManager_registerResolverInternal(this.swigCPtr, this, XmlResolver.getCPtr(resolver), resolver);
    }
}

