/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlInputStream;
import java.io.IOException;
import java.io.InputStream;

class XmlInputStreamWrap
extends InputStream {
    private XmlInputStream xis_;

    XmlInputStreamWrap(XmlInputStream xis) {
        this.xis_ = xis;
    }

    public void close() throws IOException {
        if (this.xis_ != null) {
            this.xis_.delete();
        }
        this.xis_ = null;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        try {
            byte[] b = new byte[1];
            long n = this.xis_.readBytes(b, 1L);
            if (n == 0L) {
                return -1;
            }
            return b[0];
        }
        catch (XmlException e) {
            throw new IOException("XmlException in XmlInputStreamWrap.read()");
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            long ret = this.xis_.readBytes(b, b.length);
            if (ret == 0L) {
                return -1;
            }
            return (int)ret;
        }
        catch (XmlException e) {
            throw new IOException("XmlException in XmlInputStreamWrap.read()");
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            long ret = 0L;
            if (off == 0) {
                ret = this.xis_.readBytes(b, len);
            } else {
                byte[] tb = new byte[len];
                int tlen = (int)this.xis_.readBytes(tb, len);
                if (tlen != 0) {
                    System.arraycopy(tb, 0, b, off, tlen);
                }
                ret = tlen;
            }
            if (ret == 0L) {
                return -1;
            }
            return (int)ret;
        }
        catch (XmlException e) {
            throw new IOException("XmlException in XmlInputStreamWrap.read()");
        }
    }
}

