/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.dbxml.XmlContainer;
import com.sleepycat.dbxml.XmlDocumentConfig;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlQueryContext;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlTransaction;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;

public class XmlIndexLookup {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    protected XmlContainer container;
    protected XmlValue lowBoundValue = new XmlValue();
    protected XmlValue highBoundValue = new XmlValue();
    public static final int NONE = 0;
    public static final int EQ = 1;
    public static final int GT = 2;
    public static final int GTE = 3;
    public static final int LT = 4;
    public static final int LTE = 5;

    protected XmlIndexLookup(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(XmlIndexLookup obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            dbxml_javaJNI.delete_XmlIndexLookup(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public XmlIndexLookup(XmlIndexLookup o) throws XmlException {
        this(dbxml_javaJNI.XmlIndexLookup_copy(XmlIndexLookup.getCPtr(o), o), true);
        this.lowBoundValue = o.lowBoundValue;
        this.highBoundValue = o.highBoundValue;
    }

    public XmlContainer getContainer() throws XmlException {
        return this.container;
    }

    public void setContainer(XmlContainer container) throws XmlException {
        this.container = container;
        this.setContainerInternal(container);
    }

    public XmlResults execute(XmlQueryContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.execute(context, flags);
    }

    public XmlResults execute(XmlTransaction txn, XmlQueryContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.execute(txn, context, flags);
    }

    public XmlValue getLowBoundValue() throws XmlException {
        return this.lowBoundValue;
    }

    public XmlValue getHighBoundValue() throws XmlException {
        return this.highBoundValue;
    }

    public void setHighBound(XmlValue value, int op) throws XmlException {
        this.setHighBoundInternal(value, op);
        this.highBoundValue = value;
    }

    public void setLowBound(XmlValue value, int op) throws XmlException {
        this.setLowBoundInternal(value, op);
        this.lowBoundValue = value;
    }

    public boolean isNull() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_isNull(this.swigCPtr, this);
    }

    public String getIndex() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_getIndex(this.swigCPtr, this);
    }

    public void setIndex(String index) throws XmlException {
        dbxml_javaJNI.XmlIndexLookup_setIndex(this.swigCPtr, this, index);
    }

    public String getNodeURI() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_getNodeURI(this.swigCPtr, this);
    }

    public String getNodeName() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_getNodeName(this.swigCPtr, this);
    }

    public void setNode(String uri, String name) throws XmlException {
        dbxml_javaJNI.XmlIndexLookup_setNode(this.swigCPtr, this, uri, name);
    }

    public String getParentURI() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_getParentURI(this.swigCPtr, this);
    }

    public String getParentName() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_getParentName(this.swigCPtr, this);
    }

    public void setParent(String uri, String name) throws XmlException {
        dbxml_javaJNI.XmlIndexLookup_setParent(this.swigCPtr, this, uri, name);
    }

    public int getLowBoundOperation() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_getLowBoundOperation(this.swigCPtr, this);
    }

    protected void setLowBoundInternal(XmlValue value, int op) {
        dbxml_javaJNI.XmlIndexLookup_setLowBoundInternal(this.swigCPtr, this, value, op);
    }

    public int getHighBoundOperation() throws XmlException {
        return dbxml_javaJNI.XmlIndexLookup_getHighBoundOperation(this.swigCPtr, this);
    }

    protected void setHighBoundInternal(XmlValue value, int op) {
        dbxml_javaJNI.XmlIndexLookup_setHighBoundInternal(this.swigCPtr, this, value, op);
    }

    public void setContainerInternal(XmlContainer container) throws XmlException {
        dbxml_javaJNI.XmlIndexLookup_setContainerInternal(this.swigCPtr, this, XmlContainer.getCPtr(container), container);
    }

    protected XmlResults execute(XmlQueryContext context, int flags) {
        long cPtr = dbxml_javaJNI.XmlIndexLookup_execute__SWIG_0(this.swigCPtr, this, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults execute(XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlIndexLookup_execute__SWIG_1(this.swigCPtr, this, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults execute(XmlTransaction txn, XmlQueryContext context, int flags) {
        long cPtr = dbxml_javaJNI.XmlIndexLookup_execute__SWIG_2(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults execute(XmlTransaction txn, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlIndexLookup_execute__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, context.getManagerPtr(), context.getDebugListenerCPtr(), context.evaluationType, context.queryInterruptSec, context.pack(), context);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected static XmlIndexLookup copy(XmlIndexLookup o) {
        long cPtr = dbxml_javaJNI.XmlIndexLookup_copy(XmlIndexLookup.getCPtr(o), o);
        return cPtr == 0L ? null : new XmlIndexLookup(cPtr, true);
    }
}

