/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.db.DatabaseException;

public class XmlException
extends DatabaseException {
    public static final int CONTAINER_CLOSED = 2;
    public static final int CONTAINER_EXISTS = 12;
    public static final int CONTAINER_OPEN = 1;
    public static final int DATABASE_ERROR = 5;
    public static final int DOCUMENT_NOT_FOUND = 11;
    public static final int INDEXER_PARSER_ERROR = 4;
    public static final int INTERNAL_ERROR = 0;
    public static final int INVALID_VALUE = 14;
    public static final int NULL_POINTER = 3;
    public static final int VERSION_MISMATCH = 15;
    public static final int LAZY_EVALUATION = 10;
    public static final int UNKNOWN_INDEX = 13;
    public static final int QUERY_EVALUATION_ERROR = 8;
    public static final int QUERY_PARSER_ERROR = 6;
    public static final int EVENT_ERROR = 16;
    public static final int CONTAINER_NOT_FOUND = 17;
    public static final int TRANSACTION_ERROR = 18;
    public static final int UNIQUE_ERROR = 19;
    public static final int NO_MEMORY_ERROR = 20;
    public static final int OPERATION_TIMEOUT = 21;
    public static final int OPERATION_INTERRUPTED = 22;
    static final String[] xml_strerror = new String[]{"INTERNAL_ERROR", "CONTAINER_OPEN", "CONTAINER_CLOSED", "NULL_POINTER", "INDEXER_PARSER_ERROR", "DATABASE_ERROR", "QUERY_PARSER_ERROR", "UNUSED1", "QUERY_EVALUATION_ERROR", "UNUSED2", "LAZY_EVALUATION", "DOCUMENT_NOT_FOUND", "CONTAINER_EXISTS", "UNKNOWN_INDEX", "INVALID_VALUE", "VERSION_MISMATCH", "EVENT_ERROR", "CONTAINER_NOT_FOUND", "TRANSACTION_ERROR", "UNIQUE_ERROR", "NO_MEMORY_ERROR", "OPERATION_TIMEOUT", "OPERATION_INTERRUPTED"};
    private DatabaseException dbexc;
    private int errcode;
    private int qLine;
    private int qColumn;

    public XmlException(int errcode, String description) {
        super(description, 0);
        this.errcode = errcode;
        this.dbexc = this.dbexc;
        this.qLine = 0;
        this.qColumn = 0;
    }

    public XmlException(int errcode, String description, DatabaseException dbexc, int dberr, int queryLine, int queryColumn) {
        super(description, dberr);
        this.errcode = errcode;
        this.dbexc = dbexc;
        this.qLine = queryLine;
        this.qColumn = queryColumn;
    }

    public XmlException(int errcode, String description, DatabaseException dbexc, int dberr) {
        super(description, dberr);
        this.errcode = errcode;
        this.dbexc = dbexc;
        this.qLine = 0;
        this.qColumn = 0;
    }

    public DatabaseException getDatabaseException() {
        return this.dbexc;
    }

    public int getErrorCode() {
        return this.errcode;
    }

    public String toString() {
        return super.toString() + ", errcode = " + xml_strerror[this.errcode];
    }

    public int getDbError() {
        if (this.dbexc != null) {
            return this.dbexc.getErrno();
        }
        return 0;
    }

    public int getQueryLine() {
        return this.qLine;
    }

    public int getQueryColumn() {
        return this.qColumn;
    }
}

