/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.db.DatabaseConfig;

public class XmlContainerConfig
extends DatabaseConfig {
    public static final XmlContainerConfig DEFAULT = new XmlContainerConfig();
    public static final String DEFAULT_COMPRESSSION = "DEFAULT";
    public static final String NO_COMPRESSSION = "NONE";
    public static final int UseDefault = 0;
    public static final int On = 1;
    public static final int Off = 2;
    private String compression = "DEFAULT";
    private int indexNodesFlag = 0;
    private int statisticsFlag = 0;
    private boolean isThreaded = false;
    private int nodeContainer = 1;
    private boolean allowValidation = false;
    private int sequenceIncr = 5;

    public XmlContainerConfig() {
        this.setMode(0);
    }

    public String getCompression() {
        return this.compression;
    }

    public XmlContainerConfig setCompression(String compressionName) {
        this.compression = compressionName;
        return this;
    }

    @Deprecated
    public boolean getIndexNodes() {
        if (this.indexNodesFlag == 2) {
            return false;
        }
        if (this.indexNodesFlag == 1) {
            return true;
        }
        return this.nodeContainer == 1;
    }

    public int getIndexNodesFlag() {
        return this.indexNodesFlag;
    }

    @Deprecated
    public XmlContainerConfig setIndexNodes(boolean value) {
        this.indexNodesFlag = value ? 1 : 2;
        return this;
    }

    public XmlContainerConfig setIndexNodes(int value) {
        this.indexNodesFlag = value;
        return this;
    }

    @Deprecated
    public boolean getStatisticsEnabled() {
        return this.statisticsFlag != 2;
    }

    public int getStatisticsEnabledFlag() {
        return this.statisticsFlag;
    }

    @Deprecated
    public XmlContainerConfig setStatisticsEnabled(boolean value) {
        this.statisticsFlag = value ? 1 : 2;
        return this;
    }

    public XmlContainerConfig setStatisticsEnabled(int value) {
        this.statisticsFlag = value;
        return this;
    }

    @Deprecated
    public boolean getNodeContainer() {
        return this.nodeContainer == 1;
    }

    public int getContainerType() {
        return this.nodeContainer;
    }

    @Deprecated
    public XmlContainerConfig setNodeContainer(boolean value) {
        this.nodeContainer = value ? 1 : 0;
        return this;
    }

    public XmlContainerConfig setContainerType(int value) {
        this.nodeContainer = value;
        return this;
    }

    public boolean getAllowValidation() {
        return this.allowValidation;
    }

    public XmlContainerConfig setAllowValidation(boolean value) {
        this.allowValidation = value;
        return this;
    }

    public void setSequenceIncrement(int incr) {
        this.sequenceIncr = incr;
    }

    public int getSequenceIncrement() {
        return this.sequenceIncr;
    }

    protected XmlContainerConfig(int[] data) {
        this.setMode(data[0]);
        this.setContainerType(data[1]);
        this.setXmlFlags(data[2]);
        this.setDbOpenFlags(data[3]);
        this.setPageSize(data[4]);
        this.setSequenceIncrement(data[5]);
        this.setDbSetFlags(data[6]);
        this.setSeqFlags(data[7]);
    }

    protected int[] pack() {
        int[] data = new int[]{(int)this.getMode(), this.nodeContainer, this.getXmlFlags(), this.getDbOpenFlags(), this.getPageSize(), this.sequenceIncr, this.getDbSetFlags(), this.getSeqFlags()};
        return data;
    }

    protected void setThreaded(boolean value) {
        this.isThreaded = value;
    }

    private void setXmlFlags(int xmlFlags) {
        this.indexNodesFlag = (xmlFlags & 0x1000000) != 0 ? 1 : ((xmlFlags & 0x10000) != 0 ? 2 : 0);
        this.statisticsFlag = (xmlFlags & 0x2000000) != 0 ? 1 : ((xmlFlags & 0x4000000) != 0 ? 2 : 0);
        this.setTransactional((xmlFlags & 0x200000) != 0);
        this.setAllowValidation((xmlFlags & 0x100000) != 0);
        this.setChecksum((xmlFlags & 0x400000) != 0);
        if ((xmlFlags & 0x800000) != 0) {
            this.setEncrypted("");
        } else {
            this.setEncrypted(null);
        }
    }

    private void setDbOpenFlags(int dbFlags) {
        this.setAllowCreate((dbFlags & 1) != 0);
        this.setExclusiveCreate((dbFlags & 0x40) != 0);
        this.setNoMMap((dbFlags & 8) != 0);
        this.setReadOnly((dbFlags & 0x400) != 0);
        this.setMultiversion((dbFlags & 4) != 0);
        this.setReadUncommitted((dbFlags & 0x200) != 0);
        this.isThreaded = (dbFlags & 0x10) != 0;
    }

    private void setDbSetFlags(int dbFlags) {
        if ((dbFlags & 0x800000) != 0) {
            this.setEncrypted("");
        } else {
            this.setEncrypted(null);
        }
        this.setChecksum((dbFlags & 0x400000) != 0);
        this.setTransactionNotDurable((dbFlags & 2) != 0);
    }

    private void setSeqFlags(int dbFlags) {
        this.setAllowCreate((dbFlags & 1) != 0);
        this.setExclusiveCreate((dbFlags & 0x40) != 0);
        this.isThreaded = (dbFlags & 0x10) != 0;
    }

    private int getXmlFlags() {
        int flags = 0;
        if (this.indexNodesFlag == 1) {
            flags |= 0x1000000;
        } else if (this.indexNodesFlag == 2) {
            flags |= 0x10000;
        }
        if (this.statisticsFlag == 1) {
            flags |= 0x2000000;
        } else if (this.statisticsFlag == 2) {
            flags |= 0x4000000;
        }
        if (this.getTransactional()) {
            flags |= 0x200000;
        }
        if (this.getAllowValidation()) {
            flags |= 0x100000;
        }
        if (this.getChecksum()) {
            flags |= 0x400000;
        }
        if (this.getEncrypted()) {
            flags |= 0x800000;
        }
        return flags;
    }

    private int getDbOpenFlags() {
        int flags = 0;
        if (this.getAllowCreate()) {
            flags |= 1;
        }
        if (this.getExclusiveCreate()) {
            flags |= 0x40;
        }
        if (this.getNoMMap()) {
            flags |= 8;
        }
        if (this.getReadOnly()) {
            flags |= 0x400;
        }
        if (this.getMultiversion()) {
            flags |= 4;
        }
        if (this.getReadUncommitted()) {
            flags |= 0x200;
        }
        if (this.isThreaded) {
            flags |= 0x10;
        }
        return flags;
    }

    private int getDbSetFlags() {
        int flags = 0;
        if (this.getChecksum()) {
            flags |= 0x400000;
        }
        if (this.getEncrypted()) {
            flags |= 0x800000;
        }
        if (this.getTransactionNotDurable()) {
            flags |= 2;
        }
        return flags;
    }

    private int getSeqFlags() {
        int flags = 0;
        if (this.getAllowCreate()) {
            flags |= 1;
        }
        if (this.getExclusiveCreate()) {
            flags |= 0x40;
        }
        if (this.isThreaded) {
            flags |= 0x10;
        }
        return flags;
    }
}

