/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.BtreeCompressor;
import com.sleepycat.db.BtreePrefixCalculator;
import com.sleepycat.db.CompactStats;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.ForeignKeyNullifier;
import com.sleepycat.db.ForeignMultiKeyNullifier;
import com.sleepycat.db.Hasher;
import com.sleepycat.db.KeyRange;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.PartitionHandler;
import com.sleepycat.db.RecordNumberAppender;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbMpoolFile;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.Dbc;
import com.sleepycat.db.internal.db_java;
import com.sleepycat.db.internal.db_javaJNI;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashSet;

public class Db {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    static final int GIGABYTE = 0x40000000;
    private long db_ref;
    private DbEnv dbenv;
    private boolean private_dbenv;
    public Database wrapper;
    private RecordNumberAppender append_recno_handler;
    private Comparator bt_compare_handler;
    private BtreeCompressor bt_compress_handler;
    private BtreeCompressor bt_decompress_handler;
    private BtreePrefixCalculator bt_prefix_handler;
    private Comparator dup_compare_handler;
    private FeedbackHandler db_feedback_handler;
    private Comparator h_compare_handler;
    private Hasher h_hash_handler;
    private PartitionHandler partition_handler;
    private SecondaryKeyCreator seckey_create_handler;
    private SecondaryMultiKeyCreator secmultikey_create_handler;
    private ForeignKeyNullifier foreignkey_nullify_handler;
    private ForeignMultiKeyNullifier foreignmultikey_nullify_handler;

    protected Db(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Db obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
    }

    private void initialize(DbEnv dbenv) {
        if (dbenv == null) {
            this.private_dbenv = true;
            dbenv = db_java.getDbEnv0(this);
            dbenv.initialize();
        }
        this.dbenv = dbenv;
        this.db_ref = db_java.initDbRef0(this, this);
    }

    private void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.db_ref);
        this.db_ref = 0L;
        if (this.private_dbenv) {
            this.dbenv.cleanup();
        }
        this.dbenv = null;
    }

    public boolean getPrivateDbEnv() throws DatabaseException {
        return this.private_dbenv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int flags) throws DatabaseException {
        try {
            this.close0(flags);
        }
        finally {
            this.cleanup();
        }
    }

    public DbEnv get_env() throws DatabaseException {
        return this.dbenv;
    }

    private final void handle_append_recno(DatabaseEntry data, int recno) throws DatabaseException {
        this.append_recno_handler.appendRecordNumber(this.wrapper, data, recno);
    }

    public RecordNumberAppender get_append_recno() throws DatabaseException {
        return this.append_recno_handler;
    }

    private final int handle_bt_compare(byte[] arr1, byte[] arr2) {
        return this.bt_compare_handler.compare(arr1, arr2);
    }

    private final int handle_bt_compress(DatabaseEntry dbt1, DatabaseEntry dbt2, DatabaseEntry dbt3, DatabaseEntry dbt4, DatabaseEntry dbt5) {
        return this.bt_compress_handler.compress(this.wrapper, dbt1, dbt2, dbt3, dbt4, dbt5) ? 0 : -30999;
    }

    private final int handle_bt_decompress(DatabaseEntry dbt1, DatabaseEntry dbt2, DatabaseEntry dbt3, DatabaseEntry dbt4, DatabaseEntry dbt5) {
        return this.bt_compress_handler.decompress(this.wrapper, dbt1, dbt2, dbt3, dbt4, dbt5) ? 0 : -30999;
    }

    public Comparator get_bt_compare() throws DatabaseException {
        return this.bt_compare_handler;
    }

    public BtreeCompressor get_bt_compress() throws DatabaseException {
        return this.bt_compress_handler;
    }

    public BtreeCompressor get_bt_decompress() throws DatabaseException {
        return this.bt_decompress_handler;
    }

    private final int handle_bt_prefix(DatabaseEntry dbt1, DatabaseEntry dbt2) {
        return this.bt_prefix_handler.prefix(this.wrapper, dbt1, dbt2);
    }

    public BtreePrefixCalculator get_bt_prefix() throws DatabaseException {
        return this.bt_prefix_handler;
    }

    private final void handle_db_feedback(int opcode, int percent) {
        if (opcode == 1) {
            this.db_feedback_handler.upgradeFeedback(this.wrapper, percent);
        } else if (opcode == 2) {
            this.db_feedback_handler.upgradeFeedback(this.wrapper, percent);
        }
    }

    public FeedbackHandler get_feedback() throws DatabaseException {
        return this.db_feedback_handler;
    }

    private final int handle_h_compare(byte[] arr1, byte[] arr2) {
        return this.h_compare_handler.compare(arr1, arr2);
    }

    public Comparator get_h_compare() throws DatabaseException {
        return this.h_compare_handler;
    }

    private final int handle_dup_compare(byte[] arr1, byte[] arr2) {
        return this.dup_compare_handler.compare(arr1, arr2);
    }

    public Comparator get_dup_compare() throws DatabaseException {
        return this.dup_compare_handler;
    }

    private final int handle_h_hash(byte[] data, int len) {
        return this.h_hash_handler.hash(this.wrapper, data, len);
    }

    public Hasher get_h_hash() throws DatabaseException {
        return this.h_hash_handler;
    }

    private final boolean handle_foreignkey_nullify(DatabaseEntry key, DatabaseEntry data, DatabaseEntry seckey) throws DatabaseException {
        if (this.foreignmultikey_nullify_handler != null) {
            return this.foreignmultikey_nullify_handler.nullifyForeignKey((SecondaryDatabase)this.wrapper, key, data, seckey);
        }
        return this.foreignkey_nullify_handler.nullifyForeignKey((SecondaryDatabase)this.wrapper, data);
    }

    private final DatabaseEntry[] handle_seckey_create(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        if (this.secmultikey_create_handler != null) {
            HashSet keySet = new HashSet();
            this.secmultikey_create_handler.createSecondaryKeys((SecondaryDatabase)this.wrapper, key, data, keySet);
            if (!keySet.isEmpty()) {
                return keySet.toArray(new DatabaseEntry[keySet.size()]);
            }
        } else {
            DatabaseEntry result = new DatabaseEntry();
            if (this.seckey_create_handler.createSecondaryKey((SecondaryDatabase)this.wrapper, key, data, result)) {
                DatabaseEntry[] results = new DatabaseEntry[]{result};
                return results;
            }
        }
        return null;
    }

    public SecondaryKeyCreator get_seckey_create() throws DatabaseException {
        return this.seckey_create_handler;
    }

    public SecondaryMultiKeyCreator get_secmultikey_create() throws DatabaseException {
        return this.secmultikey_create_handler;
    }

    public void set_secmultikey_create(SecondaryMultiKeyCreator secmultikey_create_handler) {
        this.secmultikey_create_handler = secmultikey_create_handler;
    }

    public void set_foreignmultikey_nullifier(ForeignMultiKeyNullifier nullify) {
        this.foreignmultikey_nullify_handler = nullify;
    }

    private final int handle_partition(DatabaseEntry dbt1) {
        return this.partition_handler.partition(this.wrapper, dbt1);
    }

    public PartitionHandler get_partition_callback() throws DatabaseException {
        return this.partition_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String file, String database, int flags) throws DatabaseException, FileNotFoundException {
        try {
            this.remove0(file, database, flags);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rename(String file, String database, String newname, int flags) throws DatabaseException, FileNotFoundException {
        try {
            this.rename0(file, database, newname, flags);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verify(String file, String database, OutputStream outfile, int flags) throws DatabaseException, FileNotFoundException {
        try {
            boolean bl = this.verify0(file, database, outfile, flags);
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    public ErrorHandler get_errcall() {
        return this.dbenv.get_errcall();
    }

    public void set_errcall(ErrorHandler db_errcall_fcn) {
        this.dbenv.set_errcall(db_errcall_fcn);
    }

    public OutputStream get_error_stream() {
        return this.dbenv.get_error_stream();
    }

    public void set_error_stream(OutputStream stream) {
        this.dbenv.set_error_stream(stream);
    }

    public void set_errpfx(String errpfx) {
        this.dbenv.set_errpfx(errpfx);
    }

    public String get_errpfx() {
        return this.dbenv.get_errpfx();
    }

    public OutputStream get_message_stream() {
        return this.dbenv.get_message_stream();
    }

    public void set_message_stream(OutputStream stream) {
        this.dbenv.set_message_stream(stream);
    }

    public MessageHandler get_msgcall() {
        return this.dbenv.get_msgcall();
    }

    public void set_msgcall(MessageHandler db_msgcall_fcn) {
        this.dbenv.set_msgcall(db_msgcall_fcn);
    }

    public void set_paniccall(PanicHandler db_panic_fcn) throws DatabaseException {
        this.dbenv.set_paniccall(db_panic_fcn);
    }

    public PanicHandler get_paniccall() throws DatabaseException {
        return this.dbenv.get_paniccall();
    }

    public Db(DbEnv dbenv, int flags) throws DatabaseException {
        this(db_javaJNI.new_Db(DbEnv.getCPtr(dbenv), dbenv, flags), true);
        this.initialize(dbenv);
    }

    public void associate(DbTxn txnid, Db secondary, SecondaryKeyCreator callback, int flags) throws DatabaseException {
        db_javaJNI.Db_associate(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, Db.getCPtr(secondary), secondary, (secondary.seckey_create_handler = callback) != null || secondary.secmultikey_create_handler != null, flags);
    }

    public void associate_foreign(Db primary, ForeignKeyNullifier callback, int flags) throws DatabaseException {
        db_javaJNI.Db_associate_foreign(this.swigCPtr, this, Db.getCPtr(primary), primary, (primary.foreignkey_nullify_handler = callback) != null || primary.foreignmultikey_nullify_handler != null, flags);
    }

    public void compact(DbTxn txnid, DatabaseEntry start, DatabaseEntry stop, CompactStats c_data, int flags, DatabaseEntry end) throws DatabaseException {
        db_javaJNI.Db_compact(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, start, stop, c_data, flags, end);
    }

    int close0(int flags) {
        return db_javaJNI.Db_close0(this.swigCPtr, this, flags);
    }

    public Dbc cursor(DbTxn txnid, int flags) throws DatabaseException {
        long cPtr = db_javaJNI.Db_cursor(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, flags);
        return cPtr == 0L ? null : new Dbc(cPtr, false);
    }

    public int del(DbTxn txnid, DatabaseEntry key, int flags) throws DatabaseException {
        return db_javaJNI.Db_del(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, key, flags);
    }

    public void err(int error, String message) {
        db_javaJNI.Db_err(this.swigCPtr, this, error, message);
    }

    public void errx(String message) {
        db_javaJNI.Db_errx(this.swigCPtr, this, message);
    }

    public int exists(DbTxn txnid, DatabaseEntry key, int flags) throws DatabaseException {
        return db_javaJNI.Db_exists(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, key, flags);
    }

    public int get(DbTxn txnid, DatabaseEntry key, DatabaseEntry data, int flags) throws DatabaseException {
        return db_javaJNI.Db_get(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, key, data, flags);
    }

    public boolean get_byteswapped() throws DatabaseException {
        return db_javaJNI.Db_get_byteswapped(this.swigCPtr, this);
    }

    public long get_cachesize() throws DatabaseException {
        return db_javaJNI.Db_get_cachesize(this.swigCPtr, this);
    }

    public int get_cachesize_ncache() throws DatabaseException {
        return db_javaJNI.Db_get_cachesize_ncache(this.swigCPtr, this);
    }

    public String get_create_dir() throws DatabaseException {
        return db_javaJNI.Db_get_create_dir(this.swigCPtr, this);
    }

    public String get_filename() throws DatabaseException {
        return db_javaJNI.Db_get_filename(this.swigCPtr, this);
    }

    public String get_dbname() throws DatabaseException {
        return db_javaJNI.Db_get_dbname(this.swigCPtr, this);
    }

    public int get_encrypt_flags() throws DatabaseException {
        return db_javaJNI.Db_get_encrypt_flags(this.swigCPtr, this);
    }

    public int get_flags() throws DatabaseException {
        return db_javaJNI.Db_get_flags(this.swigCPtr, this);
    }

    public int get_lorder() throws DatabaseException {
        return db_javaJNI.Db_get_lorder(this.swigCPtr, this);
    }

    public DbMpoolFile get_mpf() throws DatabaseException {
        long cPtr = db_javaJNI.Db_get_mpf(this.swigCPtr, this);
        return cPtr == 0L ? null : new DbMpoolFile(cPtr, false);
    }

    public int get_open_flags() throws DatabaseException {
        return db_javaJNI.Db_get_open_flags(this.swigCPtr, this);
    }

    public int get_pagesize() throws DatabaseException {
        return db_javaJNI.Db_get_pagesize(this.swigCPtr, this);
    }

    public int get_bt_minkey() throws DatabaseException {
        return db_javaJNI.Db_get_bt_minkey(this.swigCPtr, this);
    }

    public int get_h_ffactor() throws DatabaseException {
        return db_javaJNI.Db_get_h_ffactor(this.swigCPtr, this);
    }

    public int get_h_nelem() throws DatabaseException {
        return db_javaJNI.Db_get_h_nelem(this.swigCPtr, this);
    }

    public int get_re_delim() throws DatabaseException {
        return db_javaJNI.Db_get_re_delim(this.swigCPtr, this);
    }

    public int get_priority() throws DatabaseException {
        return db_javaJNI.Db_get_priority(this.swigCPtr, this);
    }

    public String[] get_partition_dirs() throws DatabaseException {
        return db_javaJNI.Db_get_partition_dirs(this.swigCPtr, this);
    }

    public DatabaseEntry get_partition_keys() throws DatabaseException {
        return db_javaJNI.Db_get_partition_keys(this.swigCPtr, this);
    }

    public int get_partition_parts() throws DatabaseException {
        return db_javaJNI.Db_get_partition_parts(this.swigCPtr, this);
    }

    public int get_re_len() throws DatabaseException {
        return db_javaJNI.Db_get_re_len(this.swigCPtr, this);
    }

    public int get_re_pad() throws DatabaseException {
        return db_javaJNI.Db_get_re_pad(this.swigCPtr, this);
    }

    public String get_re_source() throws DatabaseException {
        return db_javaJNI.Db_get_re_source(this.swigCPtr, this);
    }

    public int get_q_extentsize() throws DatabaseException {
        return db_javaJNI.Db_get_q_extentsize(this.swigCPtr, this);
    }

    public boolean get_multiple() throws DatabaseException {
        return db_javaJNI.Db_get_multiple(this.swigCPtr, this);
    }

    public boolean get_transactional() throws DatabaseException {
        return db_javaJNI.Db_get_transactional(this.swigCPtr, this);
    }

    public int get_type() throws DatabaseException {
        return db_javaJNI.Db_get_type(this.swigCPtr, this);
    }

    public Dbc join(Dbc[] curslist, int flags) throws DatabaseException {
        long cPtr = db_javaJNI.Db_join(this.swigCPtr, this, curslist, flags);
        return cPtr == 0L ? null : new Dbc(cPtr, true);
    }

    public void key_range(DbTxn txnid, DatabaseEntry key, KeyRange key_range, int flags) throws DatabaseException {
        db_javaJNI.Db_key_range(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, key, key_range, flags);
    }

    public void open(DbTxn txnid, String file, String database, int type, int flags, int mode) throws DatabaseException, FileNotFoundException {
        db_javaJNI.Db_open(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, file, database, type, flags, mode);
    }

    public int pget(DbTxn txnid, DatabaseEntry key, DatabaseEntry pkey, DatabaseEntry data, int flags) throws DatabaseException {
        return db_javaJNI.Db_pget(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, key, pkey, data, flags);
    }

    public int put(DbTxn txnid, DatabaseEntry key, DatabaseEntry db_put_data, int flags) throws DatabaseException {
        return db_javaJNI.Db_put(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, key, db_put_data, flags);
    }

    void remove0(String file, String database, int flags) {
        db_javaJNI.Db_remove0(this.swigCPtr, this, file, database, flags);
    }

    void rename0(String file, String database, String newname, int flags) {
        db_javaJNI.Db_rename0(this.swigCPtr, this, file, database, newname, flags);
    }

    public void set_append_recno(RecordNumberAppender db_append_recno_fcn) throws DatabaseException {
        this.append_recno_handler = db_append_recno_fcn;
        db_javaJNI.Db_set_append_recno(this.swigCPtr, this, this.append_recno_handler != null);
    }

    public void set_bt_compare(Comparator bt_compare_fcn) throws DatabaseException {
        this.bt_compare_handler = bt_compare_fcn;
        db_javaJNI.Db_set_bt_compare(this.swigCPtr, this, this.bt_compare_handler != null);
    }

    public void set_bt_minkey(int bt_minkey) throws DatabaseException {
        db_javaJNI.Db_set_bt_minkey(this.swigCPtr, this, bt_minkey);
    }

    public void set_bt_compress(BtreeCompressor bt_compress_fcn, BtreeCompressor bt_decompress_fcn) throws DatabaseException {
        this.bt_compress_handler = bt_compress_fcn;
        boolean bl = this.bt_compress_handler != null;
        this.bt_decompress_handler = bt_decompress_fcn;
        db_javaJNI.Db_set_bt_compress(this.swigCPtr, this, bl, this.bt_decompress_handler != null);
    }

    public void set_bt_prefix(BtreePrefixCalculator bt_prefix_fcn) throws DatabaseException {
        this.bt_prefix_handler = bt_prefix_fcn;
        db_javaJNI.Db_set_bt_prefix(this.swigCPtr, this, this.bt_prefix_handler != null);
    }

    public void set_cachesize(long bytes, int ncache) throws DatabaseException {
        db_javaJNI.Db_set_cachesize(this.swigCPtr, this, bytes, ncache);
    }

    public void set_create_dir(String dir) throws DatabaseException {
        db_javaJNI.Db_set_create_dir(this.swigCPtr, this, dir);
    }

    public void set_dup_compare(Comparator dup_compare_fcn) throws DatabaseException {
        this.dup_compare_handler = dup_compare_fcn;
        db_javaJNI.Db_set_dup_compare(this.swigCPtr, this, this.dup_compare_handler != null);
    }

    public void set_encrypt(String passwd, int flags) throws DatabaseException {
        db_javaJNI.Db_set_encrypt(this.swigCPtr, this, passwd, flags);
    }

    public void set_feedback(FeedbackHandler db_feedback_fcn) throws DatabaseException {
        this.db_feedback_handler = db_feedback_fcn;
        db_javaJNI.Db_set_feedback(this.swigCPtr, this, this.db_feedback_handler != null);
    }

    public void set_flags(int flags) throws DatabaseException {
        db_javaJNI.Db_set_flags(this.swigCPtr, this, flags);
    }

    public void set_h_compare(Comparator h_compare_fcn) throws DatabaseException {
        this.h_compare_handler = h_compare_fcn;
        db_javaJNI.Db_set_h_compare(this.swigCPtr, this, this.h_compare_handler != null);
    }

    public void set_h_ffactor(int h_ffactor) throws DatabaseException {
        db_javaJNI.Db_set_h_ffactor(this.swigCPtr, this, h_ffactor);
    }

    public void set_h_hash(Hasher h_hash_fcn) throws DatabaseException {
        this.h_hash_handler = h_hash_fcn;
        db_javaJNI.Db_set_h_hash(this.swigCPtr, this, this.h_hash_handler != null);
    }

    public void set_h_nelem(int h_nelem) throws DatabaseException {
        db_javaJNI.Db_set_h_nelem(this.swigCPtr, this, h_nelem);
    }

    public void set_lorder(int lorder) throws DatabaseException {
        db_javaJNI.Db_set_lorder(this.swigCPtr, this, lorder);
    }

    public void set_pagesize(long pagesize) throws DatabaseException {
        db_javaJNI.Db_set_pagesize(this.swigCPtr, this, pagesize);
    }

    public void set_partition(int parts, DatabaseEntry keys, PartitionHandler db_partition_fcn) throws DatabaseException {
        this.partition_handler = db_partition_fcn;
        db_javaJNI.Db_set_partition(this.swigCPtr, this, parts, keys, this.partition_handler != null);
    }

    public void set_partition_dirs(String[] dirp) throws DatabaseException {
        db_javaJNI.Db_set_partition_dirs(this.swigCPtr, this, dirp);
    }

    public void set_priority(int priority) throws DatabaseException {
        db_javaJNI.Db_set_priority(this.swigCPtr, this, priority);
    }

    public void set_re_delim(int re_delim) throws DatabaseException {
        db_javaJNI.Db_set_re_delim(this.swigCPtr, this, re_delim);
    }

    public void set_re_len(int re_len) throws DatabaseException {
        db_javaJNI.Db_set_re_len(this.swigCPtr, this, re_len);
    }

    public void set_re_pad(int re_pad) throws DatabaseException {
        db_javaJNI.Db_set_re_pad(this.swigCPtr, this, re_pad);
    }

    public void set_re_source(String source) throws DatabaseException {
        db_javaJNI.Db_set_re_source(this.swigCPtr, this, source);
    }

    public void set_q_extentsize(int extentsize) throws DatabaseException {
        db_javaJNI.Db_set_q_extentsize(this.swigCPtr, this, extentsize);
    }

    public void sort_multiple(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        db_javaJNI.Db_sort_multiple(this.swigCPtr, this, key, data);
    }

    public Object stat(DbTxn txnid, int flags) throws DatabaseException {
        return db_javaJNI.Db_stat(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, flags);
    }

    public void sync(int flags) throws DatabaseException {
        db_javaJNI.Db_sync(this.swigCPtr, this, flags);
    }

    public int truncate(DbTxn txnid, int flags) throws DatabaseException {
        return db_javaJNI.Db_truncate(this.swigCPtr, this, DbTxn.getCPtr(txnid), txnid, flags);
    }

    public void upgrade(String file, int flags) throws DatabaseException {
        db_javaJNI.Db_upgrade(this.swigCPtr, this, file, flags);
    }

    boolean verify0(String file, String database, OutputStream outfile, int flags) {
        return db_javaJNI.Db_verify0(this.swigCPtr, this, file, database, outfile, flags);
    }
}

