/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;

public class TransactionConfig
implements Cloneable {
    public static final TransactionConfig DEFAULT = new TransactionConfig();
    private boolean readUncommitted = false;
    private boolean readCommitted = false;
    private boolean noSync = false;
    private boolean noWait = false;
    private boolean snapshot = false;
    private boolean sync = false;
    private boolean writeNoSync = false;
    private boolean wait = false;

    static TransactionConfig checkNull(TransactionConfig config) {
        return config == null ? DEFAULT : config;
    }

    public void setReadCommitted(boolean readCommitted) {
        this.readCommitted = readCommitted;
    }

    public boolean getReadCommitted() {
        return this.readCommitted;
    }

    public void setDegree2(boolean degree2) {
        this.setReadCommitted(degree2);
    }

    public boolean getDegree2() {
        return this.getReadCommitted();
    }

    public void setReadUncommitted(boolean readUncommitted) {
        this.readUncommitted = readUncommitted;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public void setDirtyRead(boolean dirtyRead) {
        this.setReadUncommitted(dirtyRead);
    }

    public boolean getDirtyRead() {
        return this.getReadUncommitted();
    }

    public void setNoSync(boolean noSync) {
        this.noSync = noSync;
    }

    public boolean getNoSync() {
        return this.noSync;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public boolean getSnapshot() {
        return this.snapshot;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean getSync() {
        return this.sync;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void setWriteNoSync(boolean writeNoSync) {
        this.writeNoSync = writeNoSync;
    }

    public boolean getWriteNoSync() {
        return this.writeNoSync;
    }

    DbTxn beginTransaction(DbEnv dbenv, DbTxn parent) throws DatabaseException {
        int flags = 0;
        flags |= this.readCommitted ? 1024 : 0;
        flags |= this.readUncommitted ? 512 : 0;
        flags |= this.noSync ? 1 : 0;
        flags |= this.noWait ? 16 : 0;
        flags |= this.snapshot ? 2 : 0;
        flags |= this.sync ? 4 : 0;
        flags |= this.wait ? 8 : 0;
        return dbenv.txn_begin(parent, flags |= this.writeNoSync ? 32 : 0);
    }
}

