/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbSequence;
import com.sleepycat.db.internal.DbTxn;

public class SequenceConfig
implements Cloneable {
    public static final SequenceConfig DEFAULT = new SequenceConfig();
    private int cacheSize = 0;
    private long rangeMin = Long.MIN_VALUE;
    private long rangeMax = Long.MAX_VALUE;
    private long initialValue = 0L;
    private boolean allowCreate = false;
    private boolean decrement = false;
    private boolean exclusiveCreate = false;
    private boolean autoCommitNoSync = false;
    private boolean wrap = false;

    static SequenceConfig checkNull(SequenceConfig config) {
        return config == null ? DEFAULT : config;
    }

    public SequenceConfig() {
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setDecrement(boolean decrement) {
        this.decrement = decrement;
    }

    public boolean getDecrement() {
        return this.decrement;
    }

    public void setExclusiveCreate(boolean exclusiveCreate) {
        this.exclusiveCreate = exclusiveCreate;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public void setInitialValue(long initialValue) {
        this.initialValue = initialValue;
    }

    public long getInitialValue() {
        return this.initialValue;
    }

    public void setAutoCommitNoSync(boolean autoCommitNoSync) {
        this.autoCommitNoSync = autoCommitNoSync;
    }

    public boolean getAutoCommitNoSync() {
        return this.autoCommitNoSync;
    }

    public void setRange(long min, long max) {
        this.rangeMin = min;
        this.rangeMax = max;
    }

    public long getRangeMin() {
        return this.rangeMin;
    }

    public long getRangeMax() {
        return this.rangeMax;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public boolean getWrap() {
        return this.wrap;
    }

    DbSequence createSequence(Db db) throws DatabaseException {
        int createFlags = 0;
        return new DbSequence(db, createFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbSequence openSequence(Db db, DbTxn txn, DatabaseEntry key) throws DatabaseException {
        DbSequence seq = this.createSequence(db);
        boolean threaded = (db.get_open_flags() & 0x10) != 0;
        int openFlags = 0;
        openFlags |= this.allowCreate ? 1 : 0;
        openFlags |= this.exclusiveCreate ? 64 : 0;
        openFlags |= threaded ? 16 : 0;
        if (db.get_transactional() && txn == null) {
            openFlags |= 0x100;
        }
        this.configureSequence(seq, DEFAULT);
        boolean succeeded = false;
        try {
            seq.open(txn, key, openFlags);
            succeeded = true;
            DbSequence dbSequence = seq;
            return dbSequence;
        }
        finally {
            if (!succeeded) {
                try {
                    seq.close(0);
                }
                catch (Throwable t) {}
            }
        }
    }

    void configureSequence(DbSequence seq, SequenceConfig oldConfig) throws DatabaseException {
        int seqFlags = 0;
        seqFlags |= this.decrement ? 1 : 2;
        if ((seqFlags |= this.wrap ? 8 : 0) != 0) {
            seq.set_flags(seqFlags);
        }
        if (this.rangeMin != oldConfig.rangeMin || this.rangeMax != oldConfig.rangeMax) {
            seq.set_range(this.rangeMin, this.rangeMax);
        }
        if (this.initialValue != oldConfig.initialValue) {
            seq.initial_value(this.initialValue);
        }
        if (this.cacheSize != oldConfig.cacheSize) {
            seq.set_cachesize(this.cacheSize);
        }
    }

    SequenceConfig(DbSequence seq) throws DatabaseException {
        boolean openFlags = false;
        this.allowCreate = false;
        this.exclusiveCreate = false;
        int seqFlags = seq.get_flags();
        this.decrement = (seqFlags & 1) != 0;
        this.wrap = (seqFlags & 8) != 0;
        long initialValue = 0L;
        this.cacheSize = seq.get_cachesize();
        this.rangeMin = seq.get_range_min();
        this.rangeMax = seq.get_range_max();
    }
}

