/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.internal.Dbc;

public class SecondaryCursor
extends Cursor {
    SecondaryCursor(SecondaryDatabase database, Dbc dbc, CursorConfig config) throws DatabaseException {
        super(database, dbc, config);
    }

    public SecondaryDatabase getSecondaryDatabase() {
        return (SecondaryDatabase)super.getDatabase();
    }

    public Cursor dup(boolean samePosition) throws DatabaseException {
        return this.dupSecondary(samePosition);
    }

    public SecondaryCursor dupSecondary(boolean samePosition) throws DatabaseException {
        return new SecondaryCursor(this.getSecondaryDatabase(), this.dbc.dup(samePosition ? 23 : 0), this.config);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 6 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 7 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0xF | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0x10 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0x11 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0x12 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0x18 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        Dbc dup1 = this.dbc.dup(23);
        try {
            int errCode = dup1.get(DatabaseEntry.IGNORE, DatabaseEntry.IGNORE, 0x18 | LockMode.getFlag(lockMode));
            if (errCode == 0) {
                Dbc dup2 = dup1.dup(23);
                try {
                    errCode = dup2.get(DatabaseEntry.IGNORE, DatabaseEntry.IGNORE, 0x11 | LockMode.getFlag(lockMode));
                }
                finally {
                    dup2.close();
                }
            }
            if (errCode == 0) {
                errCode = dup1.pget(key, pKey, data, 6 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag()));
            }
            if (errCode == 0) {
                Dbc tdbc = this.dbc;
                this.dbc = dup1;
                dup1 = tdbc;
            }
            OperationStatus operationStatus = OperationStatus.fromInt(errCode);
            return operationStatus;
        }
        finally {
            dup1.close();
        }
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0x1A | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getRecordNumber(DatabaseEntry secondaryRecno, DatabaseEntry primaryRecno, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(DatabaseEntry.IGNORE, secondaryRecno, primaryRecno, 0xB | LockMode.getFlag(lockMode)));
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0x1B | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0x1C | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 8 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(key, pKey, data, 0xA | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(DatabaseEntry secondaryRecno, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.pget(secondaryRecno, pKey, data, 0x1D | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }
}

